
/*****************************************************************
                            PROPER.C
        From the Data Based Advisor, December '87 issue
                 Author: R. Russell Freeland
******************************************************************

This is a demo program that illustrates the use of Turbo C functions
from Clipper and/or Quicksilver. It capitalizes the first letter of
each word in a string (character) variable, which essentially
duplicates the Quicksilver PROPER() function, but is portable.

Variables used:
len      = length of passed string
sepflag  = whether or not the last letter examined was a separator

thischar = pointer to letter being examined

Note that there are no static uninitialized variables. If there were,
it could cause a problem since these variables are declared in segment
BSS and are assumed to be dynamically initialized at runtime by the
Turbo startup.

As I am a novice C programmer, I suspect there are easier ways to
do this; however, it gets the job done.

*****************************************************************/

#include <stdio.h>
#include <string.h>
proper(argv)
char *argv;


{
   short len;
   short sepflag;
   char *thischar;
   static char digits[] = "0123456789";
   static char inword[] =
    "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

   sepflag = 1;
   len = _strlen(argv);
   for (thischar = argv; thischar-argv <= len; thischar++) {
         if (_strchr(inword,*thischar) && sepflag) {
               sepflag = 0;
               if (!_strchr(digits,*thischar))
               *thischar& = 0X05f;
         }
         else if (!_strchr(inword,*thischar)) sepflag = 1;
   }
}
