USE (m.FileName) ALIAS Menu IN SELECT( 1 ) 

SELECT Menu

INDEX ON LevelName + ItemNum  TO Prodoc

USE (m.FileName) ORDER ProDoc ;
	AGAIN ALIAS Items IN SELECT( 1 ) 

DO WriteMenu

DO WriteMBar

DO WritePops

IF m.LineNumber <> 1
	=SS_NewPage()
ENDIF

USE IN Menu
USE IN Items

************************ End of Main Body *******************

*******************
PROCEDURE WriteMenu
*******************
* Record with Menu description
SELECT Menu
GO TOP

DO CASE
	CASE Location = 0
		m.LocateString = "REPLACE"
	CASE Location = 1
		m.LocateString = "APPEND"
	CASE Location = 2
		m.LocateString = "BEFORE " + Name
	CASE Location = 3
		m.LocateString = "AFTER " + Name
ENDCASE
	
m.Text = "Location: " + m.LocateString + SPACE( 5 )
			
\<<m.Text>>

IF m.Postscript
	=SS_FontBold()
	=SS_Say( m.Text )	
	=SS_FontNorm()
ENDIF


=WriteProc( "Setup", m.FileName + " Setup" )
=WriteProc( "Cleanup", m.FileName + " Cleanup" )
=WriteProc( "Procedure", m.FileName + " Default Procedure" )

*******************
PROCEDURE WriteMBar
*******************

SELECT Menu
LOCATE FOR ObjType = 2 AND ObjCode = 1

m.Text = "Menu Bar: " + Name + "  " + Lstr( Numitems ) + ;
	IIF( NumItems = 1, " Pad", " Pads"  )

\
\<<m.Text>>
	
IF m.Postscript
	IF m.LineNumber + 2 + NumItems > m.PageLength  
		=SS_NewPage()
	ELSE
		=SS_Say( " " )
	ENDIF
	=SS_FontBold()
	=SS_Say( m.Text )	
	=SS_FontNorm()
ENDIF

=WriteItems( "PAD", "HEADING" )
		
=WriteProc( "Procedure", "Menu Bar Default Procedure" )

=WriteItems( "PAD","PROCEDURE" )

********************
PROCEDURE WriteItems
********************
PARAMETERS PadOrBar, HeadOrProc

IF HeadOrProc = "HEADING"
	m.ColumnHead = PADR( "Prompt", 20 ) + "Action"  

	\<<m.ColumnHead>>
	
	IF m.Postscript
		=SS_FontBold()
		=SS_Say( m.ColumnHead )
		=SS_FontNorm()
	ENDIF
ENDIF

SELECT Items

SET FILTER TO Items.LevelName = Menu.LevelName ;
	AND VAL( ItemNum ) > 0
	
GO TOP
SCAN
	IF m.HeadOrProc = "HEADING"

		DO CASE
			CASE ObjCode = 67
				m.Action = "Command: " 
		
			CASE ObjCode = 77
				m.Action = "Submenu" 
			
			CASE ObjCode = 78
				m.Action = IIF( PadOrBar = "PAD", ;
							"Pad Name: ", "Bar #: " ) ;
							+ LTRIM( Name )
				
			CASE ObjCode = 80
				m.Action = "Procedure" 
		ENDCASE
		
		IF m.Action = "Command" AND NOT EMPTY( Command )
		
			IF 	LEN( TRIM( Command ) ) <= 35
				m.Action = m.Action + TRIM( Command )
			ELSE
				m.Action = m.Action + "(see below)"
			ENDIF
		ENDIF

		m.Text = PADR( Prompt, 20, " " ) + m.Action  
				
		\<<m.Text>>		

		IF m.Postscript
			=SS_Say( m.Text )
		ENDIF
					 
	ELSE
		
		=WriteProc( "Comment", Prompt + " - COMMENT" )
		IF LEN( TRIM( Command ) ) > 35
			=WriteProc( "Command", Prompt + " - COMMAND" )
		ENDIF
		=WriteProc( "SkipFor", Prompt + " - SKIP FOR" )
		=Writeproc( "Procedure", Prompt + " - PROCEDURE" )
	ENDIF
ENDSCAN

SELECT Menu

*******************
PROCEDURE WritePops
*******************
SELECT Menu

* Print all the menu popups
SET FILTER TO ObjType = 2 AND ObjCode = 0
GO TOP

SCAN
	m.Text = "Popup: " + Name + " " + ;
		Lstr( Numitems ) + 	IIF( NumItems = 1, " Bar", " Bars"  )
	\
	\<<m.Text>>

	IF m.Postscript
		IF m.LineNumber + 2 + NumItems > m.PageLength  
			=SS_NewPage()
		ELSE
			=SS_Say( " " )
		ENDIF
		=SS_FontBold()
		=SS_Say( m.Text )	
		=SS_FontNorm()
	ENDIF

	=WriteItems( "BAR", "HEADING" )
		
	=WriteProc( "Procedure", "Popup " + Name ;
		+ " Default Procedure" )

	=WriteItems( "BAR","PROCEDURE" )

ENDSCAN

*******************
PROCEDURE WriteProc
*******************
PARAMETERS ProcMemo, Title 	

IF EMPTY( &ProcMemo )
	RETURN
ENDIF

\
\<<REPL( "*", 40 )>>
\*** <<m.Title>>  	
\<<REPL( "*", 40 )>>

IF m.Postscript
	IF m.LineNumber > m.PageLength - 6
		=SS_NewPage()
	ELSE
		=SS_Say( " " )
	ENDIF

	=SS_FontBold()
	=SS_Say( m.Title )	
	=SS_FontNorm()
ENDIF

_mline = 0
m.Counter = 1
m.MLineTotal = MEMLINES( &ProcMemo )
DO WHILE m.Counter <= m.MLineTotal 

	m.Text = MLINE( &ProcMemo, 1, _MLINE )
	\<<Text>>	
	m.Counter = m.Counter + 1

	IF m.Postscript 
	
		=SS_SAY( m.Text )
		
		IF m.LineNumber > m.PageLength 
		
			=SS_NewPage()

		ENDIF
	ENDIF
ENDDO