EXTERNAL ARRAY FillArray

SET TALK OFF
SET SAFETY OFF
SET DELETED ON
SET MEMOWIDTH TO 80

m.Postscript = .f.
m.BookPage = 1
m.PageLength = 45
m.LineLength = 65
m.Portrait = 1
m.Landscape = 2
m.Orientation = m.Landscape 
m.lastpage = .f.
m.numseconds = 40

DECLARE FileList[ 1 ]

DO ProDoc.Spr WITH FileList, m.Postscript, m.BookPage, m.Orientation

IF FileList[ 1 ] = "No Files"
	RETURN
ENDIF

IF m.Postscript
 
	m.FontNorm = 9
	m.FontBold = 10
	m.FontHeader = 14
	m.hFontSize = 12
	m.pFontSize = 13.5
	m.lFontSize = 9

	M.CurrFont = m.FontNorm
	IF m.Orientation = m.Portrait
		m.CurrFontS = m.pFontSize
	ELSE
		m.CurrFontS = m.lFontSize
	ENDIF	 

	m.BookSide = "A"
	m.FilePage = 1
	
	CREATE TABLE Sym_File (Stuff M )
	USE

***********************************************
* Library of PostScript functions for X-Base

	SET PROCEDURE TO Symscrip

* by Symbiotic Information Systems
***********************************************

                                
	=SS_Setup( m.Orientation )
	=SS_FontSet( m.CurrFont, m.CurrFontS )
ELSE

	SET TEXTMERGE TO ProDoc.Doc
ENDIF

SET TEXTMERGE ON

DEFINE WINDOW Show FROM 5,0 TO 15,79 TITLE " Processing "
ACTIVATE WINDOW Show

m.TotalFiles = ALEN( FileList )

DECLARE TocList[ m.TotalFiles, 2 ]

FOR m.CurrentFile = 1 TO m.TotalFiles
	
	m.FileName = TRIM( FileList[ m.CurrentFile ] )
	m.Extension = RIGHT( m.FileName, 3 )
	\
	\
	\<<REPL( "*", 60 )>>
	\<<m.FileName>>
	\<<REPL( "*", 60 )>>

	m.FilePage = 1
	m.LineNumber = 1

	IF m.Postscript	
		=SS_FileHeader()
		
		TocList[ m.CurrentFile, 1 ] = m.Filename
		TocList[ m.CurrentFile, 2 ] = Lstr( m.BookPage ) + m.BookSide
	ENDIF
	
	WAIT "Documenting: " + m.FileName WINDOW NOWAIT
	
	DO CASE
		CASE m.Extension = "MNX"
			DO ProDocM
			
		CASE INLIST( m.Extension, "PRG", "MPR", "SPR" )

			IF m.Postscript
				m.FullFontS = m.CurrFontS
				m.CurrFontS = m.CurrFontS * .92
				=SS_FontSet( m.CurrFont, m.CurrFontS )
			ENDIF

			DO ProDocTx
			
			IF m.Postscript
				m.CurrFontS = m.FullFontS
				=SS_FontSet( m.CurrFont, m.CurrFontS )
			ENDIF

		CASE m.Extension = "PJX"
			DO ProDocPj 

		CASE m.Extension = "SCX"
			DO ProDocS 
	ENDCASE			

NEXT

IF m.Postscript 
	IF m.Orientation = m.Landscape AND m.BookSide = "B" 

		=SS_PageBreak()
	ENDIF

	DO SS_Toc	
ENDIF

RELEASE WINDOW Show

IF m.Postscript
	WAIT "Printing Postscript File" WINDOW NOWAIT
	=SS_Print( "lpt1" )
ELSE
	SET TEXTMERGE TO
ENDIF

CLOSE DATABASES
DELETE FILE Sym_File.Dbf
DELETE FILE Sym_File.Fpt
IF FILE( "Prodoc.Idx" )
	DELETE FILE Prodoc.Idx
ENDIF
IF FILE( "Prodoc.Dbf" )
	DELETE FILE PRODOC.DBF
	DELETE FILE PRODOC.FPT

ENDIF
SET PROCEDURE TO
RELEASE ALL
WAIT CLEAR
SET SAFETY ON
SET DELETED OFF

*******************************************************
************   GENERAL SUPPORT FUNCTIONS   **********
*******************************************************

* Initialize every element in an array to a single value
* Return the number of elements processed
*
* =AFill( @<array name>[, <expr>] )
*
FUNCTION AFill
PARAMETERS FillArray, FillValue
PRIVATE ALL

* If a FillValue isn't provided use a space as a default
IF PARAMETERS() = 1
	m.FillValue = " "
ENDIF

* Get the number of elements in a 1D or 2D array
m.Length = ALEN( FillArray )

* Pass through every element in a 1D or 2D array
FOR i = 1 TO m.Length
	FillArray[ i ] = m.FillValue
NEXT

RETURN m.Length

*********************
* Accept a number and return a left justified string
FUNCTION Lstr
PARAMETERS Number
RETURN LTRIM( STR( m.Number, 19 ) )

*******************************************************
********   SYMSCRIPT 2.0 SUPPORT FUNCTIONS   **********
*******************************************************
*
* Note:
* Any function with "S_" is a direct call to SymScript
*
* Any function with "SS_" is a "higher level" group of
* SymScript functions.
*
*******************************************************

*******************************************************
Procedure SS_Setup

parameters ws_orientation

=s_startp(25,'',.f.)        && Printer/program initialization

public sym_x,sym_y,sym_inc,sym_m_o,sym_mfs,sym_mfn

if ws_orientation = m.Landscape
   =s_setori(-90)           && Change page oriention -90 degrees
   =s_xyorig(-792,0,0)      && Move 0,0 coordinate to bottom left
   sym_y = 530
   sym_x = 27
else
   sym_y = 705
   sym_x = 45
endif

sym_inc = 13
sym_m_o = ws_orientation
sym_mfn = 0
sym_mfs = 12

*******************************************************
Procedure SS_Say

parameters ws_text

IF empty( ws_text ) and m.linenumber = 1
	return
endif

IF "\" $ ws_text

	ws_text	= STRTRAN( ws_text, "\", "\\" )

ENDIF
IF "(" $ ws_text

	ws_text	= STRTRAN( ws_text, "(", "\(" )

ENDIF
IF ")" $ ws_text

	ws_text	= STRTRAN( ws_text, ")", "\)" )

ENDIF

=s_say(sym_x,sym_y,0,ws_text,'l')    && Display text on paper
sym_y = sym_y - sym_inc

m.LineNumber = m.LineNumber + 1

*******************************************************
PROCEDURE SS_NewPage

m.FileString = UPPER( SUBSTR( m.FileName, 1, 1 ) ) + ;
	LOWER( SUBSTR( m.FileName, 2 ) ) + ;
	" Page - " + LTRIM( STR( m.FilePage, 5 ) )

m.BookString = IIF( m.BookPage > 0, ;
	Lstr( m.BookPage ), "" )

IF m.Orientation = m.Landscape
	
	IF m.BookSide = "A"
		=SS_Headers( m.FileString, m.BookString, "L" )
		=SS_SideBreak()
		m.BookSide = "B"
	ELSE
		=SS_Headers( m.FileString, m.BookString, "R" )
		=SS_PageBreak()
		m.BookPage = m.BookPage + 1
		m.BookSide = "A"
	ENDIF

ELSE
	IF m.BookSide = "A"
		=SS_Headers( m.FileString, m.BookString, "L" )
		m.BookSide = "B"

	ELSE
		=SS_Headers( m.FileString, m.BookString, "R" )	
		m.BookPage = m.BookPage + 1
		m.BookSide = "A"
	ENDIF
	=SS_PageBreak()
ENDIF	

m.FilePage = m.FilePage + 1
m.LineNumber = 1

*******************************************************
Procedure SS_SideBreak

if sym_m_o = m.Landscape
   sym_x = 415
   sym_y = 530
endif

*******************************************************
Procedure SS_PageBreak

=s_print2('',2)             && Issue a logical page eject
if sym_m_o = m.Landscape
   =s_setori(-90)           && Change page orientation -90 degrees
   =s_xyorig(-792,0,0)      && Move 0,0 coordinate to bottom left
   sym_y = 530
   sym_x = 27
else
   sym_y = 705
   sym_x = 45
endif
=SS_FontSet( m.CurrFont, m.CurrFontS )

*******************************************************
Procedure SS_Print

parameters ws_print_dest

=s_print2(ws_print_dest,0)   && Output print-job to printer

*******************************************************
Procedure SS_Headers

parameters ws_text1,ws_text2,ws_l_or_r

=SS_FontSet( m.FontHeader, m.hFontSize )

if sym_m_o = m.Landscape
  if ws_l_or_r = 'R'
  
  * 'B' side of page in landscape
  
  * Draw verticle and horizontal lines, including shading
   =s_line(25,72,770,72,0,.3,100)
   =s_line(25,70,770,70,0,3,5)
   =s_line(25,68,770,68,0,.3,100)      
   =s_line(390,70,390,569,0,5,5)         
   =s_line(387,73,387,569,0,.3,100)   
   =s_line(393,73,393,569,0,.3,100)         

  * Lower left-hand corner box and text
   =s_box(635,42,135,19,0,.1,100,2)
   =s_say(754,47,0,ws_text1,'r')

  * "book number" in reverse text in bottom center
   =s_fonset(30,24)   
   =s_revsay(383,40,0,ws_text2,6,0,100)   

  * Circle containing letter on top of page
   =s_circle(725,560,10,0,360,100,1,1,0)      
   =s_graysc(0)
   =s_fonset(3,13)
   =s_say(725,555,0,'B','c')         

  * Reset back to master font
   =s_fonset(sym_mfn,sym_mfs)
   =s_graysc(100)
  else
  
  * Same as above code for the 'A' side in landscape
   =s_line(25,72,770,72,0,.3,100)
   =s_line(25,70,770,70,0,3,5)
   =s_line(25,68,770,68,0,.3,100)      
   =s_line(390,70,390,569,0,5,5)      
   =s_line(387,73,387,569,0,.3,100)   
   =s_line(393,73,393,569,0,.3,100)         
   =s_box(25,42,135,19,0,.1,100,2)
   =s_say(30,47,0,ws_text1,'l')
   =s_fonset(30,24)   
   =s_revsay(383,40,0,ws_text2,6,0,100)   
   =s_circle(345,560,10,0,360,100,1,1,0)
   =s_graysc(0)
   =s_fonset(3,13)
   =s_say(345,555,0,'A','c')   
   =s_fonset(sym_mfn,sym_mfs)
   =s_graysc(100)
  endif
else

  * Drawlines and shading for portrait more
   =s_line(45,732,572,732,0,.3,100)
   =s_line(45,730,572,730,0,1,5)
   =s_line(45,728,572,728,0,.3,100)      
   =s_fonset(3,13)   
   if upper(ws_l_or_r) = 'L'
   
     * 'A' page-type in portrait mode
     
     * Draw circle with letter
      =s_circle(561,752,10,0,360,100,1,1,0)
      =s_graysc(0)
      =s_say(561,747,0,'A','c')   
      =s_graysc(100)      
      
     * Display box with program/screen/etc. name
      =s_box(45,742,137,19,0,.1,100,2)
      =s_fonset(30,24)   
      
     * Display "book number" in reverse text
      =s_revsay(300,742,0,ws_text2,4,0,100)   
      
     * Reset back to master font
      =s_fonset(sym_mfn,sym_mfs)
      =s_say(49,747,0,ws_text1,'l')
   else
   
     * 'B' Page-type in portrait mode
        
      =s_circle(53,752,10,0,360,100,1,1,0)
      =s_graysc(0)
      =s_say(53,747,0,'B','c')   
      =s_graysc(100)            
      =s_box(435,742,137,19,0,.1,100,2)
      =s_fonset(30,24)   
      =s_revsay(300,742,0,ws_text2,4,0,100)   
      =s_fonset(sym_mfn,sym_mfs)      
      =s_say(555,747,0,ws_text1,'r')
   endif   
endif   

=SS_FontSet( m.CurrFont, m.CurrFontS )

*******************************************************
PROCEDURE SS_FontBold
IF m.Orientation = m.Landscape
	=SS_FontSet( m.FontBold, m.lFontSize )
ELSE
	=SS_FontSet( m.FontBold, m.pFontSize )
ENDIF

*******************************************************
PROCEDURE SS_FontNorm
IF m.Orientation = m.Landscape
	=SS_FontSet( m.FontNorm, m.lFontSize )
ELSE
	=SS_FontSet( m.FontNorm, m.pFontSize )
ENDIF
*******************************************************
Procedure SS_FontSet

parameters ws_fn,ws_fs

=s_fonset(ws_fn,ws_fs)		&& Set the font and point size

sym_mfn = ws_fn
sym_mfs = ws_fs

sym_inc = ws_fs+1


**********************
PROCEDURE SS_FileHeader

=SS_FontSet( m.FontHeader, m.CurrFontS * 1.5 )

=SS_Say( m.Filename )
	
=SS_FontSet( m.FontNorm, m.CurrFontS )

m.LineNumber = m.LineNumber + 2


****************
PROCEDURE SS_TOC
****************
m.FileName = "Contents"
m.FilePage = 1
m.BookPage = 0
m.BookSide = "A"
	
=SS_FontSet( m.FontHeader, m.CurrFontS * 2 )
=SS_Say( "Table of Contents" )
	
=SS_FontSet( m.FontNorm, m.CurrFontS )

m.LineNumber = m.LineNumber + 4

FOR i = 1 TO m.TotalFiles
	=SS_Say( SPACE( 10 ) + PADR( TocList[ i, 1 ], 20 ) + TocList[ i, 2 ] )
	IF m.LineNumber > m.PageLength
	 	=SS_NewPage()
	ENDIF
NEXT

IF m.LineNumber > 1 

		=SS_NewPage()	
ENDIF

IF m.Orientation = m.Landscape AND m.BookSide = "B"
	=SS_PageBreak()
ENDIF
	
***************************************************
* Following are SymScript 2.0 "higher level" 
* function descriptions:
***************************************************
*
* SS_Setup( orientation )
*      0 = portrait
*      1 = landscape
*
*
* SS_Say( Text )
*      * must be in character form
*      * "Y" variable control is handled with a public 
*        variable called "SYM_Y"
*      * "Y" increment (or decrement) is based on the 
*        selected font size + 1
*
* SS_SideBreak()
*      * resets "X" control to the right side of the page in 
*        landscape orientation
*      * no effect when working in portrait
*
* SS_Print( device or filename )
*      * device may be LPT 1-4 or COM 1-4
*      * file name must not include an extension, ".SYM" will be added
*
* SS_Headers( file name/page number region, book number, left/right code )
*      * all must be characters
*      * the last selected font will be used for file 
*        name/page number region
*      * left code (specified by 'L') will put the 'A' 
*        side in portrait orientation
*      * right code (specified by 'R') will put a mirror 
*        'B' side in portrait
*      * left/right code is ignored in landscape (both 
*        sides are automatically done).
*      * Appropriate lines and boxes are drawn
*
* SS_FontSet( font code, font size )
*      * for font codes, please see SymScript 2.0 documentation
*      * font sizes range from .00001 to 9999 (may be determined 
*        by your printer)
*      * text decrement is determined by the font size + 1
*
* SS_TOC()
*      * Display "Table of Contents" at double the active font size
*      * Displays actual contents in active font size
*
* SS_FileHeader()
*      * Display program/screen/etc. file name in 150% size of 
*        active font
*
* SS_FontBold()
*      * Active active font to bold
*
* SS_FontNorm()
*      * Active active font to normal
*
* Public Variables:
*      sym_x      - controls "X" location
*      sym_y      - controls "Y" location, starting at 550 
*                   (675 in port.) and moves down
*      sym_inc    - decrement for "Y" control
*      sym_m_o    - orientation specified (0 or 1)
*      sym_mfs    - presently selected fonts size
*      sym_mfn    - presently selected font code number
*
***************************************************************