//  Function to set the printer port, turn it on and turn off the
//  console prior to enabling the production of printed reports,
//  without displaying the output to the console device.

//  Accepts an optional parameter which opens an output file to enable
//  spooling of the output to that file for subsequent printing or
//  reprinting of that file.

//  Typically, include a call to this function prior to commencement
//  of printing your output to set the devices, and open the output
//  spooler file.

//  Useage of this function is:-
//         PrintOn( <nPrtDevice>, <cSpoolFile> )
//  Returns NIL

//  Prepared by Gary Stark,
//              Majure Pty Ltd
//              PO Box 259
//              Bondi     NSW      2026
//              AUSTRALIA
//
//              Ph  (61-2) 369 2826
//              Fax (61-2) 369 2827

Static acPrtDev  := { "LPT1", "LPT2", "LPT3" }
Static cCurrPrt  := "LPT1"


Function PrintOn( nPrtDev, cSpoolFile )

// Set the printer to a default of LPT1 if no device passed to the function
   nPrtDev    := Iif( nPrtDev==NIL, 1, Max( Min( 1, nPrtDev), 3) )
   cCurrPrt   := acPrtDev[nPrtDev]

// Set the spoolfile name to "" if no filename requested
// (i.e. no spoolfile requested)
   cSpoolFile := Iif(cSpoolFile == NIL, "", cSpoolFile)

   Set printer to &cCurrPrt
   Set Printer ON
   Set Console OFF

   If !Empty(cSpoolFile)
      Set Alternate to &cSpoolFile
      Set Alternate ON
   End

Return NIL



Function Printoff

//  This function reverses and closes the operations / devices / files
//  opened or commenced with the Printon() function.

//  Returns NIL

    Set printer OFF
    Set Console ON
    Set Alternate to
    Set Alternate OFF

Return NIL


