***********************************************
*  PROCEDURE:  PRINMEMO
*  using CLIPPER memo functions
*
*  written by: ARTHUR PERLEY
*              (201) 877-8285 (w)
*        date: 11/11/87
*
*  Use for PRINTING memo fields
*  esp. more than one page
*
*  Syntax: DO prinmemo WITH m_memo,title
*
*  Return: This function writes a memo field
*          to an ASCII file - stores the file
*          as records in a temporary .dbf and
*          prints the .dbf.
*
*   Notes: Create the MEMO.dbf file thusly,
*          Field     Type      Length
*          MEMO        C         80
*          Store the memo field and page header
*          to character string memvars
*          e.g. STORE memo TO memovar
*               STORE page_heading TO title
***********************************************
*
PROCEDURE prinmemo
 *
PARA m_memo,title
PRIV ctr
 *
 * Create "COMMENTS.TXT" text file
 *
SET ALTERNATE TO comments
 *
 * Strip formatting characters, replace "hard_fix" & "soft_fix"
 * formatting characters with CR + LF
 *
STORE MEMOTRAN(m_memo,CHR(13)+CHR(10),CHR(13)+CHR(10)) TO m_memo
 *
 * Write string to ASCII file
 *
MEMOWRIT("comments.txt",m_memo)
 *
 * Use MEMO.dbf and store ASCII file TYPE SDF
 * This stores each line of the memo field to ONE record in MEMO.dbf
 *
USE MEMO
APPEND FROM comments SDF
GO TOP
 *
 * Print MEMO.dbf 55 lines to a page - endless number of pages
 * possible for really windy memos
 * Centers title on 80 column page
 * Uses left margin of 5
 *
CTR=1
SET DEVICE TO PRINTER
@ 01,(80-(LEN(title)/2)) SAY title
DO WHILE .NOT. EOF()
    @ prow()+1,05 SAY MEMO
  IF prow()<55
    SKIP
  ELSE
    SKIP
    EJECT
    ctr=ctr+1
    @ 01,(80-(LEN(title)/2)) SAY title
    @ 01,70 SAY "Page "+LTRIM(STR(ctr))
  ENDI
ENDD
EJECT
SET DEVICE TO SCREEN
 *
 * Deletes ASCII file and ZAPs MEMO.dbf to save precious disk space
 *
ERASE comments.txt
ZAP
RETURN