/* PRGFMT */
  /*
  -- PRG Outline formatting program.
  -- cl prgfmt.c \lib\setargv -link /NOE
  */
  #include <stdlib.h>
  #include <ctype.h>
  #include <string.h>
  #include <stdio.h>
  #include <io.h>

  enum indent { Home, In, InTwo, OutOut, Out, InOut, Comment, Other};
  enum indent LinIndent(char *);
  void restru(FILE *, FILE *,int,int);
  char *NewName(char *,char *, char *);

  main(int argc,char *argv[]) {
    int i, Indent=2, Format = 0;
    char *AnArg, Extension[10], TmpName[15];
    static char *Templ = "rsXXXXXX";
    FILE *In, *Out;
    Extension[0] = '\0';
    if (argc == 1) {
      printf("PRGFMT [ [-i<Indent>] [-e<Extension>] [-o<Format>] "
      "filespec ] ...\nPRGFMT -h for help\n");
      exit(0);
      }
    for (i=1;i<argc;i++) {
      AnArg = argv[i];
      if ((*AnArg=='-') || (*AnArg=='/')) {
        AnArg++;
        switch (toupper(*AnArg)) {
          case 'I':
            Indent = atoi(++AnArg);
            printf("Indent %d\n",Indent);
            break;
          case 'E':
            strcpy(Extension,++AnArg);
            printf("Extension %s\n",Extension);
            break;
          case 'O':
            AnArg++;
            switch (toupper(*AnArg)) {
              case 'O':
                Format = 0;
                printf("Format: OutLine\n");
                break;
              case 'S':
                Format = 1;
                printf("Format: Standard\n");
                break;
              }
            break;
          case 'H':
            if (i == 1) {
              printf(
                "PRGFMT\t--\tPRG file Reformat Utility\t--\tV1.0\n\n"
                "SYNTAX: PRGFMT [[-e<Extension>] [-i<Indent>] [-o<format>] [<InputFilespec>]]...\n"
                "\nOPTIONS:-e = Extension for output files - default: Same as input.\n"
                "\t-i = number of spaces to Indent - default:  -i2\n"
                "\t-o = Output format (o)utline/(s)tandard - default:  -oo\n\n"
                "\tOptions apply to the InputFilespec[s] that follow\n"
                "\tAll files are written to the current directory\n\n"
                );
              printf(
                "EXAMPLE: PRGFMT -i0 -epro \\*.prg -i3 -os -e A:*.PRG\n"
                "\tReformat all root prg's without indenting to extension .pro,\n"
                "\treformat all prg's on A: to standard format, indent 3, with\n"
                "\tdefault extensions.\n\n"
                );
              printf(
                "PRGFMT leaves RS?????? files if it cannot rename them to the output name.\n\n"
                "This program is provided AS IS without any warranties, expressed or implied,\n"
                "including, but not limited to, fitness for a particular purpose.\n\n"
                "\tHigher Logic, Inc., 800 S. Broadway, Baltimore, MD  21231\n"
                "\t\t(301) 522-7400   TIB,CIN"
                );
              exit(0);
              }
            break;
          }
        } else {
        if ((In = fopen(AnArg,"r")) &&
          (Out = fopen(mktemp(strcpy(TmpName,Templ)),"w")) ) {
          printf("%s\n",AnArg);
          restru(In,Out,Indent,Format);
          fclose(In);
          fclose(Out);
          rename(TmpName,NewName("",AnArg,Extension));
          }
        }
      }
    }

  void restru(FILE *InFile, FILE *OutFile, int Indent, int Standard) {
    int CurrIndent = 0;
    int NextIndent;
    char line[BUFSIZ], OutLine[BUFSIZ], *lstart;
    while (lstart = fgets(line,sizeof(line),InFile)) {
      while (isspace(*lstart)) lstart++;
      if (strlen(lstart)) {
        NextIndent = CurrIndent;
        switch (LinIndent(lstart)) {
          case Home:
            CurrIndent = 0;
            NextIndent = Indent;
            break;
          case In:
            NextIndent += Indent;
            break;
          case InTwo:
            NextIndent += 2*Indent;
            break;
          case OutOut:
            CurrIndent -= Indent;
          case Out:
            NextIndent = CurrIndent - Indent;
            if (Standard) CurrIndent = NextIndent;
            break;
          case InOut:
            CurrIndent -= Indent;
            break;
          }
        CurrIndent = (int)max(0,CurrIndent);
        memset(OutLine,' ',sizeof(OutLine));
        OutLine[CurrIndent] = '\0';
        fputs(strncat(OutLine,lstart,sizeof(OutLine)-CurrIndent),OutFile);
        CurrIndent = NextIndent;
        }
      }
    return;
    }

  enum indent LinIndent(char *line) {
    typedef struct {
      char *Term;
      enum indent Tab;
      int MinLen;
      } LnTab;
    static LnTab dbTerms[] = {
      {"do while" , In     , 7},
      {"for"      , In     , 3},
      {"if"       , In     , 2},
      {"do case"  , InTwo  , 7},
      {"function" , Home   , 4},
      {"procedure", Home   , 4},
      {"endcase"  , OutOut , 4},
      {"endif"    , Out    , 3},
      {"enddo"    , Out    , 3},
      {"next"     , Out    , 4},
      {"case"     , InOut  , 4},
      {"otherwise", InOut  , 4},
      {"*"        , Comment, 1},
      {"&&"       , Comment, 2},
      {"note"     , Comment, 4},
      {NULL       , Other  , 0}
      };
    LnTab *ATerm;
    char comp[15], *Token, *TermC;
    strlwr(strncpy(memset(comp,'\0',sizeof(comp)),line,sizeof(comp)-1));
    Token = strtok(comp," \n");
    if (!strcmp(Token,"do")) {
      strtok(NULL," \n");
      comp[2]=' ';
      }
    for (ATerm = dbTerms;ATerm->Term;ATerm++) {
      for (Token=comp,TermC=ATerm->Term;(*TermC) && (*Token == *TermC);
        TermC++,Token++);
      if (!(*Token || (strlen(comp) < ATerm->MinLen)))
        return(ATerm->Tab);
      }
    return(Other);
    }

  char *NewName(char *Path,char *OldN, char *Extn) {
    static char FName[BUFSIZ];
    char *At;
    strcpy(FName,Path);
    if ((At=strrchr(OldN,'\\')) || (At=strrchr(OldN,':')))
      At++;
      else
      At = OldN;
    strcat(FName,At);
    if (strlen(Extn)) {
      if (At = strrchr(FName,'.'))
        *(++At) = '\0';
        else
        strcat(FName,".");
      strcat(FName,Extn);
      }
    return(FName);
    }

