**********************************************************
*																											 	 *
*     Profiler.prg minus unchanged initializer      	 	 *
*     With changes to provide printout of statistics	 	 *
*     Doug Brance																			 	 *
*     SVC																							 	 *
*     10-10-90																				 	 *
*     I prefer upper case keywords										 	 *
*     All other cahnges indicated by `SVC' in comment	 	 *
*																											 	 *
**********************************************************

																											 
FUNCTION BLPRFPRG													 && called on every overlay call

	PRIVATE call, pointer, free

	call = BLICURNME()											 && get name of called routine
	pointer = ASCAN(bl_proc,call)						 && see if we already have it

	IF pointer = 0													 && if not, stuff it into arrays
		AINS(bl_proc,1)
		AINS(bl_size,1)
		AINS(bl_call,1)
		AINS(bl_disk,1)
		pointer = 1
		bl_count = bl_count + 1								 && increment array element counter
	ENDIF

	bl_proc[pointer] = call									 && store statistics for later
	bl_size[pointer] = blicursiz()					 && viewing via hot-key pop-up
	bl_call[pointer] = blicurcal()
	bl_disk[pointer] = blicurdsk()

	free=MEMORY(0)
	IF free>bl_himem												 && record highest & lowest
		bl_himem=free													 && memory excursions
	ELSEIF free<bl_lomem
		bl_lomem=free
	ENDIF

RETURN(.T.)

*** Display function for viewing statistics via hot-key ***

FUNCTION OVL_STAT

	PRIVATE spot, choice,eol, eop						 && SVC added eol, eop
	eol=CHR(13)+CHR(10)											 && SVC end of line
	eop=CHR(12)															 && SVC end of page
	spot=SAVESCREEN(04,17,21,64)						 && save screen area to be used

	DO WHILE .T.
																					 && paint screen
		@ 04,17,21,64 BOX "Ŀ "
		@ 05,22 SAY "      RUNTIME OVERLAY ANALYSIS"
		@ 06,22 SAY ""

		* SVC STAT_SCREEN() below provides output to both screen and printer

		STAT_SCREEN()
       																				&& SVC F10 to print

		@ 20,22 SAY "F2 Detail      F3 Chart      F10 Print"	

		choice=INKEY(0)												 && wait for keypress

		IF choice=-1.OR.choice=-9							 && SVC choice=-9 F10 to print

		PRIVATE count, spot2, bl_stats[bl_count]

			FOR count = 1 TO bl_count
				bl_stats[count] = LEFT(bl_proc[count]+SPACE(10),10) + ;
				TRAN(bl_size[count],"   ###,###") + ;
				TRAN(bl_call[count],"   ###,###") + ;
				TRAN(bl_disk[count],"   ###,###") + ;
				TRAN(IF(bl_call[count]=0, 0, ;
				100*(1-bl_disk[count]/bl_call[count])),"    ###.#%")
			NEXT

		ENDIF

		DO CASE

			CASE choice = -1										 && use ACHOICE to display a scrolling window
																					 && of statistics by called procedures

																					 && display array of statistics
				spot2 = SAVESCREEN(02,10,22,64)
				@ 02,10,22,64 BOX "Ŀ "
				@ 03,12 SAY "Procedure       Size     Calls     Loads   Service"
				@ 04,12 SAY ""
				choice=ACHOICE(05,12,21,62,bl_stats)
				RESTSCREEN(02,10,22,64,spot2)

			CASE choice = -2										 && display bar chart

				SAVE SCREEN
				CLEAR

				PRIVATE bl_bar1[bl_count], bl_bar2[bl_count]

				PRIVATE count, max_calls, bar, sorted

				max_calls=0												 && get max number of calls
				FOR count = 1 TO bl_count
					max_calls=MAX(max_calls,bl_call[count])
				NEXT

																					 && build array for display

				bar=177														 && ASCII code for bar symbol
				FOR count = 1 TO bl_count

					bar = IF(bar=176,177,176)			 && alternate bars

					bl_bar1[count] = LEFT(bl_proc[count]+space(11),11) + ;
					REPLICATE(CHR(bar),INT(1+64*bl_call[count]/max_calls)) ;
					+ STR(bl_call[count],4)

																					 && make copy for sorting - note
																					 && inverse key for descending sort

					bl_bar2[count] = str(10000-bl_call[count],4)+bl_bar1[count]

				NEXT

				ASORT(bl_bar2)										 && sort by calls in descending order

																					 && trim sort key from string
				FOR count = 1 TO bl_count
					bl_bar2[count] = substr(bl_bar2[count],5,len(bl_bar2[count])-4)
				NEXT

				SET KEY -2 TO bl_toggle						 && stuff achoice toggle sequence
				sorted = .F.

				@ 00,00 SAY "Procedure  Number of Calls"
				@ 01,00 SAY REPLICATE(CHR(196),80)

				DO WHILE .T.											 && display window

					IF sorted												 && display appropriate array
						@ 00,54 SAY "Press F3 for Natural Order"
						ACHOICE(02,00,23,79,bl_bar2)
					ELSE
						@ 00,54 SAY " Press F3 for Sorted Order"
						ACHOICE(02,00,23,79,bl_bar1)
					ENDIF

					IF INKEY(.1) = 84								 && toggle between sorted/natural
						sorted = ! sorted							 && note: use inkey() to pop extra
					ENDIF														 && character stuffed by F3, wait
																					 && 1/10 second if no extra key,
					IF LASTKEY() = 27								 && and exit if ESC was pressed
						EXIT
					ENDIF

				ENDDO

				SET KEY -2 TO											 && clear F3 setting
				RESTORE SCREEN

			CASE choice = -9										 && SVC F10 print stats

				PRIVATE mrgn, page_1, stat_headr	 && SVC addition

				mrgn=SPACE(15)										 && SVC margin
				page_1=.T.												 && SVC page 1 flag

				* SVC header (stat_headr) below is printed at top of each page

				stat_headr=eol+mrgn;							 && SVC header
				+"Procedure       Size     Calls     Loads   Service"+eol+eol

				SET CONSOLE OFF										 && SVC dont srew up display
				SET DEVICE TO PRINT								 && SVC send @ SAY's to printer

				* SVC title below is printed on page 1 only

				@ 05,17 SAY "RUNTIME OVERLAY ANALYSIS AS OF "+TIME()+" "+DTOC(DATE())

				STAT_SCREEN()											 && SVC general stats
				SET DEVICE TO SCREEN							 && SVC turn screen back on
				SET PRINT ON											 && SVC handles ? printing
				?? eol														 && SVC print blank line
				?? stat_headr											 && SVC print header

				FOR count = 1 TO bl_count					 && SVC step through array
					?? mrgn+bl_stats[count]+eol			 && SVC print margin
					          											 && SVC print stat line
					* page 1 has room for general stats + 39 lines

					IF (count-39)%55=0.AND.!page_1 	       && SVC 55 lines/page
						?? eop+REPLICATE(eol,4)+stat_headr 	 && SVC eject and start
					ENDIF																	 && SVC pages 3 and up

					IF page_1 .AND. count=39							 && SVC page 1 full
						page_1=.F.										 			 && SVC turn flag off
						?? eop+REPLICATE(eol,4)+stat_headr 	 && SVC eject and start
					ENDIF														 			 && SVC page 2

					* page break below will never happen as long as	 && SVC 
					* bl_stats etc. have only [50] elements       	 && SVC 
					* you may never need this, but if a printout     && SVC 
					* ever fills page one you'll need to enlarge     && SVC 
					* the arrays anyway										           && SVC 

				NEXT															 && SVC 
				?? eop														 && SVC eject when finished
				SET PRINT OFF											 && SVC output to screen
				SET CONSOLE ON										 && SVC restore display

			OTHERWISE														 && any other key exits profile
				EXIT

		ENDCASE

	ENDDO

	RESTSCREEN(04,17,21,64,spot)
RETURN(.T.)

PROCEDURE BL_TOGGLE												 && esc from achoice, stuff "T"
	KEYBOARD CHR(27)+"T"										 && to toggle display of arrays
RETURN

* SVC STAT_SCREEN() below provides output to both screen and printer

FUNCTION STAT_SCREEN											 && SVC changed to function

	@ 07,22 SAY "Highest Free Pool Memory:      "+TRAN(bl_himem*1024,"###,###")
	@ 08,22 SAY "Current Free Pool Memory:      "+TRAN(MEMORY(0)*1024,"###,###")
	@ 09,22 SAY "Lowest Free Pool Memory:       "+TRAN(bl_lomem*1024,"###,###")
	@ 10,22 SAY "Blinker Memory Pack Frequency: "+TRAN(BLIMEMPAK(),"###,###")
	@ 11,22 SAY "Blinker Overlay Pool OpSize:   "+TRAN(BLIOVLOPS(),"###,###")
	@ 12,22 SAY "Current Overlay Pool Size:     "+TRAN(BLIOVLSIZ(),"###,###")
	@ 13,22 SAY "Total Proc Size Since Startup: "+TRAN(BLITOTSIZ(),"###,###")
	@ 14,22 SAY "Total Procedures Loaded:       "+TRAN(BLITOTLOD(),"###,###")
	@ 15,22 SAY "Procedures Currently Active:   "+TRAN(BLITOTACT(),"###,###")
	@ 16,22 SAY "Total Calls Since Startup:     "+TRAN(BLITOTCAL(),"###,###")
	@ 17,22 SAY "Total Disk Loads Since Startup:"+TRAN(BLITOTDSK(),"###,###")
	@ 18,22 SAY "% Serviced from Overlay Pool:  "+ ;
	TRAN(IF(BLITOTCAL()=0,0,100*(1-BLITOTDSK()/BLITOTCAL()))," ###.#%")
RETURN (.T.)															 && SVC return value not used

