*:*********************************************************************
*:
*: Procedure file: PRB_CALC.PRG                           Release 1.1
*:
*:         Author: Phil Barnett
*:      Copyright (c) 1992, Phil Barnett
*:
*:                 Phil Barnett
*:                 1105 Binion Road
*:                 Apopka, Fl 32703
*:                 (407) 884-5192
*:
*:  Last modified: 07/17/93     03:20       Updated to 1.1 version.
*:
*:  Released to the Public Domain. 07/17/93
*:
*:*********************************************************************

/*

This calculator provides a pop-up function that uses a simulated paper
tape to show it's calculations. Data that is in the static arrays remains
available while the program remains running. 

If you wish the calculator to retain its last run, you can save the
static variables at shutdown and restore them at startup. It would require
a library like FLEXFILE to do this, as many variables are arrays.

Version 1.1 adds:
  
  1. Calculator Buttons flash as you enter keystrokes.
  
  2. PRB_CALC now has a memory feature. It's functions are:
  
     M+  Memory Plus
     M-  Memory Minus
     M*  Memory Times
     M/  Memory Divide by
     MC  Memory Clear
     MR  Memory Recall
     
  3. Pressing C once clears the tape, a second C clears memory.
  
---

To create a test program for the PRB_CALC.PRG Calculator Function.

Compile:

CLIPPER PRB_CALC /M /N /DTEST_IT

Link:

RTLINK FI PRB_CALC

---

To create the function PRB_CALC.OBJ for linking into other programs, 

Compile

CLIPPER PRB_CALC /M /N

*/

static t,l,b,r,scr_hold
static view_point := 1
static tape := {}
static tape_point := 1
static laststroke := " "
static dec_mode := .F.
static answer := ""
static shift := "0"
static mem_shift := "0"
static lastop := " "
static tape_line := 12
static VIEW:= .F.
static keyhit := " "
static top_tape
static nul_tape
static ccol := 0
static calc_move := ""
static max_disp := "9999999999.9999"

#ifdef TEST_IT

*!*********************************************************************
*!
*!       Function: TESTCALC()
*!
*!*********************************************************************
function TESTCALC()

calc_disp( '999999999.99' ) //this line is optional, but allows display control

set key -9 to calculator()

clear screen

dispbox( 1, 0, 13, 79 )

testvar1 := space( 30 )
testvar2 := space( 30 )
testvar3 := space( 30 )

@  3, 10 say 'Press <F-10> to pop the calculator'
@  5, 10 say 'Calculate a number and press X'
@  7, 10 say 'The result will keyboard into the field you came from.'
@  9, 10 say 'Left and rights arrows move Calculator across screen.'
@ 11, 10 say 'Up and down arrows scroll tape if it goes off top of screen.'

@ 16,  0 say 'This is test field 1' get testvar1
@ 18,  5 say 'This is test field 2' get testvar2
@ 20, 10 say 'This is test field 3' get testvar3

read

return NIL

#endif

*!*****************************************************************************
*!
*!       Function: CALCULATOR()
*!
*!*****************************************************************************
FUNCTION calculator

local calc_disp,lastchar,temp_var,save_calc
local x,view_start,oldhelp,over

local oldrow   := ROW()
local oldcol   := COL()
local inscreen := savescreen(0,0,24,79)
local incolor  := setcolor('GR+/GB')
local incursor := setcursor(0)

top_tape := ""+replicate("",22)+""
nul_tape := ""+SPACE(22)+""        

dispcalc()

IF !empty(calc_move)
  restscreen(tape_line,ccol+1,13,ccol+24,calc_move)
ENDIF

DO WHILE !lastkey() = 27
  IF VAL(mem_shift) <> 0
    setcolor('GR+/R')
    @ 14,19+ccol SAY "M"
  ELSE
    setcolor('GR+/GB')
    @ 14,19+ccol SAY ""
  ENDIF
  setcolor('N/W')
  calc_disp := IIF(keyhit="=",shift,answer)
  over := alltrim(TRANSFORM(VAL(calc_disp),"9"+max_disp))
  calc_disp := TRANSFORM(VAL(calc_disp),max_disp)
  IF !dec_mode
    lastchar := RIGHT(calc_disp,1)
    DO WHILE lastchar = "0" .OR. lastchar = "*"
      calc_disp := LEFT(calc_disp,len(calc_disp)-1)
      lastchar := RIGHT(calc_disp,1)
    ENDDO
  ELSE
    temp_var := AT(".",answer)
    calc_disp := LEFT(calc_disp,11+len(answer)-temp_var)
  ENDIF
  IF shift == "*" .OR. AT(".",over) == 12 .OR. shift == "%"
    IF shift = "%"
      calc_disp := "   INFINITY"
      tape_scrol(@tape_line,@tape)
    ELSE
      calc_disp := "   OVERFLOW"
    ENDIF
    @ 13,1+ccol SAY nul_tape
    shift = "0"
    lastop = " "
  ENDIF
  calc_disp := LEFT(calc_disp+SPACE(16),16)
  IF keyhit == "="
    @ 13,1+ccol SAY "  "+replicate("",15)+SPACE(5)+""
    tape_scrol(@tape_line,@tape)
  ENDIF
  
  IF VAL(calc_disp) < 0
    setcolor('R/W')
  ENDIF
  
  @ 13,1+ccol SAY "  "+calc_disp+" "+lastop+"  "
  
  IF keyhit == "="
    tape_scrol(@tape_line,@tape)
    @ 13,1+ccol SAY nul_tape
  ENDIF
  
  IF keyhit $ "1234567890./*-+=C"
    calc_delay()
    getscreen(1)
  ENDIF
  
  keyhit := UPPER(CHR(INKEY(0)))
  
  IF lastkey() = 13
    keyhit := "="
  ENDIF
  
  setcolor('GR+/R')
  DO CASE
  CASE keyhit == "1"
    putscreen(20,3+ccol,20,5+ccol)
    @ 20,3+ccol SAY " 1 "
  CASE keyhit == "2"
    putscreen(20,8+ccol,20,10+ccol)
    @ 20,8+ccol SAY " 2 "
  CASE keyhit == "3"
    putscreen(20,13+ccol,20,15+ccol)
    @ 20,13+ccol SAY " 3 "
    
  CASE keyhit == "4"
    putscreen(18,3+ccol,18,5+ccol)
    @ 18,3+ccol SAY " 4 "
  CASE keyhit == "5"
    putscreen(18,8+ccol,18,10+ccol)
    @ 18,8+ccol SAY " 5 "
  CASE keyhit == "6"
    putscreen(18,13+ccol,18,15+ccol)
    @ 18,13+ccol SAY " 6 "
    
  CASE keyhit == "7"
    putscreen(16,3+ccol,16,5+ccol)
    @ 16,3+ccol SAY " 7 "
  CASE keyhit == "8"
    putscreen(16,8+ccol,16,10+ccol)
    @ 16,8+ccol SAY " 8 "
  CASE keyhit == "9"
    putscreen(16,13+ccol,16,15+ccol)
    @ 16,13+ccol SAY " 9 "
    
  CASE keyhit == "0"
    putscreen(22,3+ccol,22,5+ccol)
    @ 22,3+ccol SAY " 0 "
  CASE keyhit == "."
    putscreen(22,8+ccol,22,10+ccol)
    @ 22,8+ccol SAY " . "
  CASE keyhit == "="
    putscreen(23,21+ccol,23,23+ccol)
    @ 23,21+ccol SAY " = "
    
  CASE keyhit == "+"
    putscreen(17,21+ccol,17,23+ccol)
    @ 17,21+ccol SAY " + "
  CASE keyhit == "-"
    putscreen(15,21+ccol,15,23+ccol)
    @ 15,21+ccol SAY " - "
  CASE keyhit == "*"
    putscreen(19,21+ccol,19,23+ccol)
    @ 19,21+ccol SAY " * "
  CASE keyhit == "/"
    putscreen(21,21+ccol,21,23+ccol)
    @ 21,21+ccol SAY " / "
    
  CASE keyhit == "C"
    putscreen(22,13+ccol,22,15+ccol)
    @ 22,13+ccol SAY " C "
    
  ENDCASE
  
  setcolor('N/W')
  
  IF VIEW
    IF keyhit # CHR(24) .AND. keyhit # CHR(5)
      restscreen(0,0,12,79,view_start)
      view_point := tape_point
      VIEW := .F.
    ENDIF
  ENDIF
  DO CASE
  CASE keyhit == "M"
    keyhit := UPPER(CHR(INKEY(0)))
    DO CASE
    CASE keyhit == "+"
      mem_shift := STR(VAL(mem_shift) + VAL(shift))
    CASE keyhit == "-"
      mem_shift := STR(VAL(mem_shift) - VAL(shift))
    CASE keyhit == "*"
      mem_shift := STR(VAL(mem_shift) * VAL(shift))
    CASE keyhit == "/"
      mem_shift := STR(VAL(mem_shift) / VAL(shift))
    CASE keyhit == "R"
      IF lastop == "="
        lastop := " "
      ENDIF
      laststroke := "N"
      answer := mem_shift
      IF "." $ answer
        dec_mode := .T.
      ENDIF
    CASE keyhit == "C"
      mem_shift := "0"
    ENDCASE
    LOOP
  CASE keyhit $ "0123456789."
    laststroke := "N"
    IF lastop = "="
      lastop := " "
    ENDIF
    IF keyhit = "."
      IF !dec_mode
        answer += keyhit
        dec_mode := .T.
      ENDIF
    ELSE
      temp_var := AT(".",answer)
      x := len(answer)
      IF (!dec_mode .AND. x = 10) .OR. (dec_mode .AND. x-temp_var = 4)
        LOOP
      ENDIF
      answer += keyhit
    ENDIF
  CASE keyhit $ "^+-*/="
    setcolor(IIF(keyhit = "-","R/W","N/W"))
    IF laststroke = "O"
      lastop := keyhit
      LOOP
    ENDIF
    laststroke := "O"
    IF keyhit $ "^+-*/"
      IF lastop = "="
        lastop := keyhit
        LOOP
      ENDIF
    ENDIF
    IF !empty(lastop) .AND. !empty(shift)
      DO CASE
      CASE lastop = "^"
        shift := STR(VAL(shift)^VAL(answer),21,9)
      CASE lastop = "-"
        shift := STR(VAL(shift)-VAL(answer),21,9)
      CASE lastop = "+"
        shift := STR(VAL(shift)+VAL(answer),21,9)
      CASE lastop = "*"
        shift := STR(VAL(shift)*VAL(answer),21,9)
      CASE lastop = "/"
        IF VAL(answer) = 0
          shift:="%"
          LOOP
        ENDIF
        shift := STR(VAL(shift)/VAL(answer),21,9)
      ENDCASE
    ELSE
      shift := answer
    ENDIF
    lastop := keyhit
    dec_mode := .F.
    answer := ""
    tape_scrol(@tape_line,@tape)
  CASE keyhit = "C"
    calc_delay()
    restscreen(0,0,24,79,inscreen)
    tape := {}
    tape_point := 1
    dispcalc()
    laststroke := " "
    dec_mode := .F.
    IF answer == "" .AND. shift == "0"
      mem_shift := "0"
    ENDIF
    answer := ""
    shift := "0"
    lastop := " "
    tape_line := 12
  CASE keyhit = CHR(24) && up
    IF tape_line > 0 .OR. view_point = tape_point
      LOOP
    ENDIF
    IF !VIEW
      view_start := savescreen(0,0,12,79)
      VIEW := .T.
    ENDIF
    scroll(0,ccol+1,12,ccol+24,1)
    setcolor(IIF(AT("-",tape[view_point])>0,"R/W","N/W"))
    @ 12,ccol+1 SAY tape[view_point]
    view_point ++
  CASE keyhit = CHR(5) && down
    IF tape_line > 0 .OR. view_point-14 < 1
      LOOP
    ENDIF
    IF !VIEW
      view_start := savescreen(0,0,12,79)
      VIEW := .T.
    ENDIF
    scroll(0,ccol+1,12,ccol+24,-1)
    setcolor(IIF(AT("-",tape[view_point-14])>0,"R/W","N/W"))
    @ 0,ccol+1 SAY tape[view_point-14]
    view_point --
  CASE keyhit = CHR(19) .OR. keyhit = CHR(4)
    calc_move := savescreen(tape_line,ccol+1,13,ccol+24)
    ccol := IIF(keyhit=CHR(19),0,54)
    restscreen(0,0,24,79,inscreen)
    dispcalc()
    restscreen(tape_line,ccol+1,13,ccol+24,calc_move)
  CASE keyhit = "X"
    calc_disp := alltrim(calc_disp)
    IF !dec_mode
      lastchar := RIGHT(calc_disp,1)
      DO WHILE lastchar = "0" .OR. lastchar = "."
        calc_disp := LEFT(calc_disp,len(calc_disp)-1)
        IF lastchar = "."
          EXIT
        ENDIF
        lastchar := RIGHT(calc_disp,1)
      ENDDO
    ENDIF
    x := len(calc_disp)
    temp_var := AT(".",calc_disp)
    IF VAL(calc_disp) <> 0
      keyboard(CHR(25) + alltrim(TRANSFORM(VAL(calc_disp),IIF(temp_var=0,"9999999999",max_disp))))
    ENDIF
    EXIT
  CASE lastkey() = 8
    IF laststroke = "N"
      x := len(answer)
      IF RIGHT(answer,1) = "."
        dec_mode := .F.
        answer := LEFT(answer,x-1)
        x --
      ENDIF
      IF x>0
        answer := LEFT(answer,x-1)
      ENDIF
    ENDIF
  ENDCASE
ENDDO

calc_move := savescreen(tape_line,ccol+1,13,ccol+24)

setcursor(incursor)
setcolor(incolor)
restscreen(0,0,24,79,inscreen)
setpos(oldrow,oldcol)
RETURN nil

*!*****************************************************************************
*!
*!       Function: DISPCALC()
*!
*!*****************************************************************************
static FUNCTION dispcalc

local temp_var

setcolor('GR+/GB')

@ 12,0+ccol CLEAR TO 24,25+ccol
@ 12,0+ccol TO 24,25+ccol DOUBLE

temp_var := "    Ķ"

@  14,0+ccol SAY "͹"
@  15,19+ccol SAY "  -"
@  16,4+ccol SAY "7    8    9"+temp_var
@  17,19+ccol SAY "  +"
@  18,4+ccol SAY "4    5    6"+temp_var
@  19,19+ccol SAY "  *"
@  20,4+ccol SAY "1    2    3"+temp_var
@  21,19+ccol SAY "  /"
@  22,4+ccol SAY "0    .    C"+temp_var
@ 23,19+ccol SAY "  ="
@ 24,19+ccol SAY ""

setcolor('N/W')

@ 12,1+ccol SAY top_tape
@ 13,1+ccol SAY nul_tape

RETURN nil

*!*****************************************************************************
*!
*!       Function: TAPE_SCROL()
*!
*!*****************************************************************************
static FUNCTION tape_scrol(ttape_line,tape)

tape_save(@tape)

IF ttape_line > 0
  ttape_line --
ENDIF
scroll(tape_line,ccol+1,13,ccol+24,1)

RETURN nil

*!*****************************************************************************
*!
*!       Function: TAPE_SAVE()
*!
*!*****************************************************************************
static FUNCTION tape_save(tape)

local i,temp_var,flag

IF !TYPE("flag") = "C"
  temp_var := savescreen(13,ccol+1,13,ccol+24)
  flag := ""
  FOR i := 1 TO 48 STEP 2
    flag += SUBSTR(temp_var,i,1)
  NEXT
ENDIF
aadd(tape,flag)
tape_point ++
view_point := tape_point

RETURN nil

*!*****************************************************************************
*!
*!       Function: CALC_DISP()
*!
*!*****************************************************************************
FUNCTION calc_disp(numstring) // provides a way to set up the calc display

IF valtype(numstring) = "C"
  max_disp := numstring
ENDIF

RETURN max_disp

*!*****************************************************************************
*!
*!       Function: CALC_TAPE()
*!
*!*****************************************************************************
FUNCTION calc_tape() // Call this to retrieve the tape array.

RETURN tape

*!*****************************************************************************
*!
*!       Function: CALC_DELAY()
*!
*!*****************************************************************************
static FUNCTION calc_delay

local waitfor

waitfor := seconds() + .2
DO WHILE empty(nextkey()) .AND. waitfor > seconds()
ENDDO

RETURN nil

*!*****************************************************************************
*!
*!       Function: PUTSCREEN()
*!
*!*****************************************************************************
static function putscreen(tt,ll,bb,rr)

t := tt
l := ll
b := bb
r := rr

scr_hold := savescreen(t,l,b,r)

return NIL

*!*****************************************************************************
*!
*!       Function: GETSCREEN()
*!
*!*****************************************************************************
static function getscreen()

restscreen(t,l,b,r,scr_hold)
scr_hold := ''

return NIL

*: EOF: PRB_CALC.PRG
