/*****************************************************************************
** program  : PPDEMO.PRG
** author   : PK Spence - CompuServe ID# 76314,612
** date     : Sun  02-24-1991
** comments : File for demonstrating the PushScreen(), PopScreen() and
**            ReturnToMaster() functions. No doubt, this is a bit of
**            an overkill for a demo. But, what the hell, it gave me
**            something to do for awhile. The aforementioned functions
**            appear at the end of this file and are commented. The
**            array ScreenArray[] is declared as 'static' in this demo.
**            If you place your commonly called functions or procedures,
**            (who uses procedures anymore??), in a separate .prg file,
**            this array can be declared within that file. However you do
**            it, this array must be within scope of all three functions
**            since they all make use of it one way or another.
**
**            If anyone makes changes, improvements, etc., please EMail them
**            to me on CompuServe. ID# 76314,612
******************************************************************************/

// dynamic array for stuffing screen snapshots, initialized to zero elements.
// this array becomes a 'stack' in which screen snapshots are pushed or popped
// in a LIFO; Last In, First Out sequence.
static ScreenArray[0]


FUNCTION Main()

  local mChoice := 1                           // menu choice variable

  set color to 'W+/N,GR+/R,N,,W+/N'
  set key -9 to ReturnToMaster                 // PF10 key = ReturnToMaster()
  set message to maxrow()-2 center             // messages 2-lines from bottom
  set wrap on                                  // allow menu-bar to wrap

  cls                                          // clear screen
  @ maxrow()-1,61 say ' F10 - Main Menu '
  do while .T.
    setcursor(0)                               // turn cursor off
    @ maxrow()-2, 0 clear to maxrow()-2,79     // erase previous prompt message
    @  0, 0 to  2,79 Double                    // draw double-line box
    @  1, 2 prompt ' Fruit/Vegtables ' message 'Select Fruit/Vegtables Menu'
    @  1,37 prompt ' Meats '           message 'Select Meats Menu'
    @  1,72 prompt ' Exit '            message 'Exit Demo'
    menu to mChoice
    do case
    case mChoice = 0
      if LogOut()
        exit
      endif

    case mChoice = 1
      FruitVeggies()

    case mChoice = 2
      Meats()

    case mChoice = 3
      if LogOut()
        exit
      endif

    endcase

  enddo
  clear all
  @ maxrow()-1, 0 say ''

return nil
// EOFunc Main()



FUNCTION FruitVeggies()
  local mChoice := 1

  PushScreen(2,1,6,16,.T.,.T.)
  do while .T.
    @ maxrow()-2, 0 clear to maxrow()-2,79     // erase previous prompt message
    @  3, 2 prompt ' 1> Fruit     ' message 'Select Fruit Menu'
    @  4, 2 prompt ' 2> Vegtables ' message 'Select Vegtables Menu'
    @  5, 2 prompt ' 3- Exit      ' message 'Return to previous menu'
    menu to mChoice
    do case
    case mChoice = 0
      exit

    case mChoice = 1
      Fruit()

    case mChoice = 2
      Veggies()

    case mChoice = 3
      exit

    endcase

  enddo
  PopScreen()

return nil
// EOFunc FruitVeggies()



FUNCTION Fruit()
  local mChoice := 1       ,;                  // menu choice variable
        TopRow  := row()+1 ,;                  // top row for box
        LeftCol := col()+4                     // left column for box

  PushScreen(TopRow,LeftCol,TopRow+5,LeftCol+13,.T.,.T.)
  do while .T.
    @ maxrow()-2, 0 clear to maxrow()-2,79     // erase previous prompt message
    @ TopRow+1, LeftCol+1 prompt ' 1> Apples  ' message 'Select Apples Menu'
    @ TopRow+2, LeftCol+1 prompt ' 2> Oranges ' message 'Select Oranges Menu'
    @ TopRow+3, LeftCol+1 prompt ' 3> Berries ' message 'Select Berries Menu'
    @ TopRow+4, LeftCol+1 prompt ' 4- Exit    ' message 'Return to previous menu'
    menu to mChoice
    do case
    case mChoice = 0
      exit

    case mChoice = 1
      Apples()

    case mChoice = 2
      Oranges()

    case mChoice = 3
      Berries()

    case mChoice = 4
      exit

    endcase

  enddo
  PopScreen()

return nil
// EOFunc Fruit()



FUNCTION Apples()
  local mChoice := 1       ,;                  // menu choice variable
        TopRow  := row()+1 ,;                  // top row for box
        LeftCol := col()+4                     // left column for box

  PushScreen(TopRow,LeftCol,TopRow+7,LeftCol+19,.T.,.T.)
  do while .T.
    @ maxrow()-2, 0 clear to maxrow()-2,79     // erase previous prompt message
    @ TopRow+1, LeftCol+1 prompt ' 1- Rome          ' message 'Select Rome Apples'
    @ TopRow+2, LeftCol+1 prompt ' 2- Winesap       ' message 'Select Winesap Apples'
    @ TopRow+3, LeftCol+1 prompt ' 3- MacIntosh     ' message 'Select MacIntosh Apples'
    @ TopRow+4, LeftCol+1 prompt ' 4- Granny Smith  ' message 'Select Granny Smith Apples'
    @ TopRow+5, LeftCol+1 prompt ' 5- Red Delicious ' message 'Select Red Delicious Apples'
    @ TopRow+6, LeftCol+1 prompt ' 6- Exit          ' message 'Return to previous menu'
    menu to mChoice
    do case
    case mChoice = 0
      exit

    case mChoice = 1
      ShowSelection('Rome '+proper(lower(procname())))

    case mChoice = 2
      ShowSelection('Winesap '+proper(lower(procname())))

    case mChoice = 3
      ShowSelection('MacIntosh '+proper(lower(procname())))

    case mChoice = 4
      ShowSelection('Granny Smith '+proper(lower(procname())))

    case mChoice = 5
      ShowSelection('Red Delicious '+proper(lower(procname())))

    case mChoice = 6
      exit

    endcase

  enddo
  PopScreen()

return nil
// EOFunc Apples()



FUNCTION Oranges()
  local mChoice := 1       ,;                  // menu choice variable
        TopRow  := row()+1 ,;                  // top row for box
        LeftCol := col()+4                     // left column for box

  PushScreen(TopRow,LeftCol,TopRow+5,LeftCol+14,.T.,.T.)
  do while .T.
    @ maxrow()-2, 0 clear to maxrow()-2,79     // erase previous prompt message
    @ TopRow+1, LeftCol+1 prompt ' 1- Mandarin ' message 'Select Mandarin Oranges'
    @ TopRow+2, LeftCol+1 prompt ' 2- Navel    ' message 'Select Navel Oranges'
    @ TopRow+3, LeftCol+1 prompt ' 3- Valencia ' message 'Select Valencia Oranges'
    @ TopRow+4, LeftCol+1 prompt ' 4- Exit     ' message 'Return to previous menu'
    menu to mChoice
    do case
    case mChoice = 0
      exit

    case mChoice = 1
      ShowSelection('Mandarin '+proper(lower(procname())))

    case mChoice = 2
      ShowSelection('Navel '+proper(lower(procname())))

    case mChoice = 3
      ShowSelection('Valencia '+proper(lower(procname())))

    case mChoice = 4
      exit

    endcase

  enddo
  PopScreen()

return nil
// EOFunc Oranges()



FUNCTION Berries()
  local mChoice := 1       ,;                  // menu choice variable
        TopRow  := row()+1 ,;                  // top row for box
        LeftCol := col()+4                     // left column for box

  PushScreen(TopRow,LeftCol,TopRow+7,LeftCol+19,.T.,.T.)
  do while .T.
    @ maxrow()-2, 0 clear to maxrow()-2,79     // erase previous prompt message
    @ TopRow+1, LeftCol+1 prompt ' 1- Strawberries  ' message 'Select Strawberries'
    @ TopRow+2, LeftCol+1 prompt ' 2- Raspberries   ' message 'Select Raspberries'
    @ TopRow+3, LeftCol+1 prompt ' 3- Gooseberries  ' message 'Select Gooseberries'
    @ TopRow+4, LeftCol+1 prompt ' 4- Blueberries   ' message 'Select Blueberries'
    @ TopRow+5, LeftCol+1 prompt ' 5- Huckleberries ' message 'Select Huckleberries'
    @ TopRow+6, LeftCol+1 prompt ' 6- Exit          ' message 'Return to previous menu'
    menu to mChoice
    do case
    case mChoice = 0
      exit

    case mChoice = 1
       ShowSelection('Strawberries')

    case mChoice = 2
       ShowSelection('Raspberries')

    case mChoice = 3
       ShowSelection('Gooseberries')

    case mChoice = 4
       ShowSelection('Blueberries')

    case mChoice = 5
       ShowSelection('Huckleberries')

    case mChoice = 6
      exit

    endcase

  enddo
  PopScreen()

return nil
// EOFunc Berries()



FUNCTION Veggies()
  local mChoice := 1      ,;                   // menu choice variable
        TopRow := row()+1 ,;                   // top row for box
        LeftCol := col()+4                     // left column for box

  PushScreen(TopRow,LeftCol,TopRow+5,LeftCol+12,.T.,.T.)
  do while .T.
    @ maxrow()-2, 0 clear to maxrow()-2,79     // erase previous prompt message
    @ TopRow+1, LeftCol+1 prompt ' 1> Red    ' message 'Select Red Vegtables'
    @ TopRow+2, LeftCol+1 prompt ' 2> Green  ' message 'Select Green Vegtables'
    @ TopRow+3, LeftCol+1 prompt ' 3> Yellow ' message 'Select Yellow Vegtables'
    @ TopRow+4, LeftCol+1 prompt ' 4- Exit   ' message 'Return to previous menu'
    menu to mChoice
    do case
    case mChoice = 0
      exit

    case mChoice = 1
      RedVeggies()

    case mChoice = 2
      GreenVeggies()

    case mChoice = 3
      YellowVeggies()

    case mChoice = 4
      exit

    endcase

  enddo
  PopScreen()

return nil
// EOFunc Veggies()



FUNCTION RedVeggies()
  local mChoice := 1      ,;                   // menu choice variable
        TopRow := row()+1 ,;                   // top row for box
        LeftCol := col()+4                     // left column for box

  PushScreen(TopRow,LeftCol,TopRow+6,LeftCol+17,.T.,.T.)
  do while .T.
    @ maxrow()-2, 0 clear to maxrow()-2,79     // erase previous prompt message
    @ TopRow+1, LeftCol+1 prompt ' 1- Beets       ' message 'Select Beets'
    @ TopRow+2, LeftCol+1 prompt ' 2- Tomatoes    ' message 'Select Tomatoes'
    @ TopRow+3, LeftCol+1 prompt ' 3- Red Peppers ' message 'Select Red Peppers'
    @ TopRow+4, LeftCol+1 prompt ' 4- Onions      ' message 'Select Bermuda Onions'
    @ TopRow+5, LeftCol+1 prompt ' 5- Exit        ' message 'Return to previous menu'
    menu to mChoice
    do case
    case mChoice = 0
      exit

    case mChoice = 1
      ShowSelection('Beets')

    case mChoice = 2
      ShowSelection('Tomatoes')

    case mChoice = 3
      ShowSelection('Red Peppers')

    case mChoice = 4
      ShowSelection('Onions')

    case mChoice = 5
      exit

    endcase

  enddo
  PopScreen()

return nil
// EOFunc RedVeggies()



FUNCTION GreenVeggies()
  local mChoice := 1      ,;                   // menu choice variable
        TopRow := row()+1 ,;                   // top row for box
        LeftCol := col()+4                     // left column for box

  PushScreen(TopRow,LeftCol,TopRow+8,LeftCol+14,.T.,.T.)
  do while .T.
    @ maxrow()-2, 0 clear to maxrow()-2,79     // erase previous prompt message
    @ TopRow+1, LeftCol+1 prompt ' 1- Avocados ' message 'Select Avocados'
    @ TopRow+2, LeftCol+1 prompt ' 2- Celery   ' message 'Select Celery'
    @ TopRow+3, LeftCol+1 prompt ' 3- Lettuce  ' message 'Select Lettuce'
    @ TopRow+4, LeftCol+1 prompt ' 4- Broccoli ' message 'Select Broccoli'
    @ TopRow+5, LeftCol+1 prompt ' 5- Beans    ' message 'Select Green Beans'
    @ TopRow+6, LeftCol+1 prompt ' 6- Peas     ' message 'Select Peas'
    @ TopRow+7, LeftCol+1 prompt ' 7- Exit     ' message 'Return to previous menu'
    menu to mChoice
    do case
    case mChoice = 0
      exit

    case mChoice = 1
      ShowSelection('Avocados')

    case mChoice = 2
      ShowSelection('Celery')

    case mChoice = 3
      ShowSelection('Lettuce')

    case mChoice = 4
      ShowSelection('Broccoli')

    case mChoice = 5
      ShowSelection('Green Beans')

    case mChoice = 6
      ShowSelection('Peas')

    case mChoice = 7
      exit

    endcase

  enddo
  PopScreen()

return nil
// EOFunc GreenVeggies()



FUNCTION YellowVeggies()
  local mChoice := 1      ,;                   // menu choice variable
        TopRow := row()+1 ,;                   // top row for box
        LeftCol := col()+4                     // left column for box

  PushScreen(TopRow,LeftCol,TopRow+6,LeftCol+13,.T.,.T.)
  do while .T.
    @ maxrow()-2, 0 clear to maxrow()-2,79     // erase previous prompt message
    @ TopRow+1, LeftCol+1 prompt ' 1- Squash  ' message 'Select Summer Squash'
    @ TopRow+2, LeftCol+1 prompt ' 2- Onions  ' message 'Select Yellow Onions'
    @ TopRow+3, LeftCol+1 prompt ' 3- Pumpkin ' message 'Select Pumpkin'
    @ TopRow+4, LeftCol+1 prompt ' 4- Corn    ' message 'Select Corn'
    @ TopRow+5, LeftCol+1 prompt ' 5- Exit    ' message 'Return to previous menu'
    menu to mChoice
    do case
    case mChoice = 0
      exit

    case mChoice = 1
      ShowSelection('Summer Squash')

    case mChoice = 2
      ShowSelection('Yellow Onions')

    case mChoice = 3
      ShowSelection('Yellow Pumpkins?')

    case mChoice = 4
      ShowSelection('Corn')

    case mChoice = 5
      exit

    endcase

  enddo
  PopScreen()

return nil
// EOFunc YellowVeggies()



FUNCTION Meats()
  local mChoice := 1                           // menu choice variable

  PushScreen(2,34,8,47,.T.,.T.)
  do while .T.
    @ maxrow()-2, 0 clear to maxrow()-2,79     // erase previous prompt message
    @  3, 35 prompt ' 1> Beef    ' message 'Select Beef Menu'
    @  4, 35 prompt ' 2> Pork    ' message 'Select Pork Menu'
    @  5, 35 prompt ' 3> Poultry ' message 'Select Poultry Menu'
    @  6, 35 prompt ' 4> Fish    ' message 'Select Fish Menu'
    @  7, 35 prompt ' 5- Exit    ' message 'Return to previous menu'
    menu to mChoice
    do case
    case mChoice = 0
      exit

    case mChoice = 1
      Beef()

    case mChoice = 2
      Pork()

    case mChoice = 3
      Poultry()

    case mChoice = 4
      Fish()

    case mChoice = 5
      exit

    endcase

  enddo
  PopScreen()

return nil
// EOFunc Meats()



FUNCTION Beef()
  local mChoice := 1      ,;                   // menu choice variable
        TopRow := row()+1 ,;                   // top row for box
        LeftCol := col()+4                     // left column for box

  PushScreen(TopRow,LeftCol,TopRow+6,LeftCol+15,.T.,.T.)
  do while .T.
    @ maxrow()-2, 0 clear to maxrow()-2,79     // erase previous prompt message
    @ TopRow+1, LeftCol+1 prompt ' 1- Veal      ' message 'Select Veal'
    @ TopRow+2, LeftCol+1 prompt ' 2- Steak     ' message 'Select Steak'
    @ TopRow+3, LeftCol+1 prompt ' 3- Roast     ' message 'Select Roast'
    @ TopRow+4, LeftCol+1 prompt ' 4- Hamburger ' message 'Select Ground Beef'
    @ TopRow+5, LeftCol+1 prompt ' 5- Exit      ' message 'Return to previous menu'
    menu to mChoice
    do case
    case mChoice = 0
      exit

    case mChoice = 1
      ShowSelection('Veal')

    case mChoice = 2
      ShowSelection('Steak')

    case mChoice = 3
      ShowSelection('Roast')

    case mChoice = 4
      ShowSelection('Ground Beef')

    case mChoice = 5
      exit

    endcase

  enddo
  PopScreen()

return nil
// EOFunc Beef()



FUNCTION Pork()
  local mChoice := 1      ,;                   // menu choice variable
        TopRow := row()+1 ,;                   // top row for box
        LeftCol := col()+4                     // left column for box

  PushScreen(TopRow,LeftCol,TopRow+6,LeftCol+13,.T.,.T.)
  do while .T.
    @ maxrow()-2, 0 clear to maxrow()-2,79     // erase previous prompt message
    @ TopRow+1, LeftCol+1 prompt ' 1- Ribs    ' message 'Select Barbeque Ribs'
    @ TopRow+2, LeftCol+1 prompt ' 2- Sausage ' message 'Select Sausage'
    @ TopRow+3, LeftCol+1 prompt ' 3- Bacon   ' message 'Select Bacon'
    @ TopRow+4, LeftCol+1 prompt ' 4- Ham     ' message 'Select Ham'
    @ TopRow+5, LeftCol+1 prompt ' 5- Exit    ' message 'Return to previous menu'
    menu to mChoice
    do case
    case mChoice = 0
      exit

    case mChoice = 1
      ShowSelection('Barbeque Ribs')

    case mChoice = 2
      ShowSelection('Sausage')

    case mChoice = 3
      ShowSelection('Bacon')

    case mChoice = 4
      ShowSelection('Ham')

    case mChoice = 5
      exit

    endcase

  enddo
  PopScreen()

return nil
// EOFunc Pork()



FUNCTION Poultry()
  local mChoice := 1      ,;                   // menu choice variable
        TopRow := row()+1 ,;                   // top row for box
        LeftCol := col()+4                     // left column for box

  PushScreen(TopRow,LeftCol,TopRow+5,LeftCol+13,.T.,.T.)
  do while .T.
    @ maxrow()-2, 0 clear to maxrow()-2,79     // erase previous prompt message
    @ TopRow+1, LeftCol+1 prompt ' 1- Turkey  ' message 'Select Turkey'
    @ TopRow+2, LeftCol+1 prompt ' 2- Chicken ' message 'Select Chicken'
    @ TopRow+3, LeftCol+1 prompt ' 3- Squab   ' message 'Select Squab'
    @ TopRow+4, LeftCol+1 prompt ' 4- Exit    ' message 'Return to previous menu'
    menu to mChoice
    do case
    case mChoice = 0
      exit

    case mChoice = 1
      ShowSelection('Turkey')

    case mChoice = 2
      ShowSelection('Chicken')

    case mChoice = 3
      ShowSelection('Squab')

    case mChoice = 4
      exit

    endcase

  enddo
  PopScreen()

return nil
// EOFunc Poultry()



FUNCTION Fish()
  local mChoice := 1      ,;                   // menu choice variable
        TopRow := row()+1 ,;                   // top row for box
        LeftCol := col()+4                     // left column for box

  PushScreen(TopRow,LeftCol,TopRow+8,LeftCol+14,.T.,.T.)
  do while .T.
    @ maxrow()-2, 0 clear to maxrow()-2,79     // erase previous prompt message
    @ TopRow+1, LeftCol+1 prompt ' 1- Tuna     ' message 'Select Albacore Tuna'
    @ TopRow+2, LeftCol+1 prompt ' 2- Flounder ' message 'Select Flounder'
    @ TopRow+3, LeftCol+1 prompt ' 3- Cod      ' message 'Select Cod'
    @ TopRow+4, LeftCol+1 prompt ' 4- Perch    ' message 'Select Ocean Perch'
    @ TopRow+5, LeftCol+1 prompt ' 5- Trout    ' message 'Select Rainbow Trout'
    @ TopRow+6, LeftCol+1 prompt ' 6- Salmon   ' message 'Select Coho Salmon'
    @ TopRow+7, LeftCol+1 prompt ' 7- Exit     ' message 'Return to previous menu'
    menu to mChoice
    do case
    case mChoice = 0
      exit

    case mChoice = 1
      ShowSelection('Albacore Tuna')

    case mChoice = 2
      ShowSelection('Flounder')

    case mChoice = 3
      ShowSelection('Cod')

    case mChoice = 4
      ShowSelection('Ocean Perch')

    case mChoice = 5
      ShowSelection('Rainbow Trout')

    case mChoice = 6
      ShowSelection('Coho Salmon')

    case mChoice = 7
      exit

    endcase

  enddo
  PopScreen()

return nil
// EOFunc Fish()



FUNCTION ShowSelection(MenuSelection)
  local Message   := ' You selected '+MenuSelection+' '
  local LeftCol   := (80-(len(Message)))/2
  local RightCol  := LeftCol+len(Message)+1

  PushScreen(12,LeftCol,14,RightCol,.T.,.T.)
  @ 13, LeftCol+1 say Message
  tone(250,1)
  tone(500,2)
  inkey(1)
  PopScreen()

return nil
// EOFunc ShowSelection()



FUNCTION Proper(cString)
  local nPos, cWord, cProper := ""

  do while .not. empty( cString )
    if (nPos := at(" ", cString)) != 0
      cWord := substr( cString, 1, nPos )
      cString := substr( cString, nPos + 1 )
    else      // End of string
      cWord := cString
      cString := ""
    endif
  cProper := cProper + upper(substr(cWord, 1, 1)) + substr(cWord, 2)
  enddo

return cProper
// EOFunc Proper()



/******************************************************************************
  FUNCTION:
    PushScreen()

  PARAMETERS:
    TopRow    - integer, Top row of window

    LeftCol   - integer, Left column of window

    BotRow    - integer, Bottom row of window

    RightCol  - integer, Right column of window

    BoxClear  - boolean, if .T., area inside coordinates will be cleared

    BoxBorder - boolean, if .T., double-line box will be drawn, default.
                         if .F., no box will be drawn

    Single    - boolean, if .T., single-line box will be drawn,
                         if not passed and BoxBorder = .T. default double-line
                         box will be drawn

  RETURNS:
    nil

*******************************************************************************/
FUNCTION PushScreen (TopRow,LeftCol,BotRow,RightCol,BoxClear,BoxBorder,Single)
  local Screen  ,;  // Clippers' SaveScreen() variable
        Corners     // box coordinates variable

  // call Clippers' SaveScreen() function, passing coordinates
  Screen  := SaveScreen(TopRow,LeftCol,BotRow,RightCol)

  // concatenate coordinates, after converting to ASCII/ext. ASCII equivalents
  Corners := chr(TopRow)+chr(LeftCol)+chr(BotRow)+chr(RightCol)

  // increase no. of elements in ScreenArray by one
  asize(ScreenArray,(len(ScreenArray)+1))

  // insert empty element at new elements' position
  ains(ScreenArray,1)

  // place Corners and Screen variables onto 'stack'
  ScreenArray[1] := (Corners+Screen)

  // now check for number of passed of parameters and set defaults
  do case
  case PCount() = 4
    BoxClear  := .F.
    BoxBorder := .F.
  case PCount() = 5
    BoxClear  := .T.
    BoxBorder := .F.
    Single    := .F.
  case PCount() = 6
    BoxClear  := .T.
    BoxBorder := .T.
    Single    := .F.
  case PCount() = 7
    BoxClear  := .T.
    BoxBorder := .T.
    Single    := .T.
  endcase

  // if BoxClear = .T., clear area inside coordinates
  if BoxClear
    @ TopRow,LeftCol clear to BotRow,RightCol
  endif

  // if BoxBorder = .T., draw box around coordinates
  if BoxBorder

    // if Single = .T., use single-line box, else double-line box
    if Single
      @ TopRow,LeftCol TO BotRow,RightCol
    else
      @ TopRow,LeftCol to BotRow,RightCol Double
    endif
  endif

return nil
// EOFunc PushScreen()



/******************************************************************************
  FUNCTION:
    PopScreen()

  PARAMETERS:
    none, that's right. None!

  RETURNS:
    nil

******************************************************************************/
FUNCTION PopScreen()

  // variables for array element data
  local TopRow, LeftCol, BotRow, RightCol, Screen

  // extract first four characters and convert back to their decimal equivalents
  TopRow   := asc(substr(ScreenArray[1],1,1))
  LeftCol  := asc(substr(ScreenArray[1],2,1))
  BotRow   := asc(substr(ScreenArray[1],3,1))
  RightCol := asc(substr(ScreenArray[1],4,1))

  // extract remainder of element, actual previous screen contents
  Screen   := substr(ScreenArray[1],5)

  // call Clippers' RestScreen() function, passing variables containing data
  // extracted from array element
  restscreen(TopRow,LeftCol,BotRow,RightCol,Screen)

  // delete no longer needed data
  adel(ScreenArray,1)

  // decrease no. of elements of ScreenArray by one
  asize(ScreenArray,(len(ScreenArray)-1))

return nil
// EOFunc PopScreen()



/******************************************************************************
  FUNCTION:
    ReturnToMaster()

  PARAMETERS:
    none

  RETURNS:
    nil

******************************************************************************/
FUNCTION ReturnToMaster()

  // stuff keyboard with 'Escape' characters, according to number of screens
  // that have been 'Pushed' into array ScreenArray, returning application
  // to it's main menu.
  keyboard replicate(chr(27),len(ScreenArray))

return nil
// EOFunc ReturnToMaster()



FUNCTION LogOut()
  local mChoice := 1    ,;                    // menu choice variable
        ReturnValue                           // function return value

  PushScreen(11,22,15,56,.T.,.T.,.T.)    // use a single-line border this time
  @ 12,25 say 'Are you sure to want to EXIT?'
  @ 14,27 prompt '   Yes   '
  @ 14,44 prompt '   No   '
  menu to mChoice
  do case
  case mChoice = 1
    ReturnValue := .T.                        // 'Y' key hit

  case mChoice = 2 .or. mChoice = 0           // 'N' or 'Esc' key hit
    keyboard chr(4)                           // stuff keyboard with RtArrow
    ReturnValue := .F.

  endcase
  PopScreen()

return ReturnValue
// EOFunc LogOut()



