; Program   Popvid.asm   for clipper -> SAyWhat!
; Based (heavily!) on the example asm program in W85 Clipper doc 
; page 4-25 and the amended version in the 'README.1ST'
; As you will see, I make no claims to be an assembly language
; programmer BUT, this seems to work OK.
;
; Access by:  CALL POPVID with memvar
;                       or
;             CALL POPVID with 'command/'
;
;             Use with PLINK86 by "PLINK86 FI clipfile FI popvid"
;	      or  DOS linker by "LINK clipfile+popvid"
;
; by:
;	Robert F. Hicks
;	6508 Harwood Place
;	Springfield, VA 22152
;
; April 16, 1986

	PUBLIC	POPVID
_PROG	SEGMENT	BYTE
	ASSUME	CS:_PROG
;
POPVID	PROC 	FAR
	PUSH 	BP	     ; save registers and set up per Clipper
	MOV	BP,SP
	PUSH	DS
	PUSH	ES
	LDS	SI,[BP+6]    ; DS:SI now points to the string being
;			     ; passed by Clipper
	MOV	AH,14        ; set up for INT 10 function 'TTY'
	MOV	AL,255	     ; VIDPOP's wake up character
	INT	10H
	INT	10H	     ; send it twice to awaken vidpop
MORE:	MOV	AL,[SI]      ; get a character from the passed string
	INT	10H	     ; send it to VIDPOP
	INC	SI	     ; point to the next character
	CMP	AL,0	     ; is it the 0 string terminator
	JNZ	MORE	     ; no -go send another char
	POP	ES	     ; yes, restore for Clipper and return
	POP	DS
	POP	ES
	RET
POPVID	ENDP
_PROG	ENDS
	END

