/******************************************************************************
  (This program was an Original idea by JP Steffen <Compuserve: 76525,262>)

  Compile with /n

  Conception and Modification by:
     Alain Hogue
     AZA Informatique
     (514) 595-5885
     Montral, Qubec, Canada
     Compuserve: 75360,163
     18 janvier 1991

     This program is FreeWare, and you can change it to your heart
     content.

     Please retain this heading, so the credit will at least survive me.
     If you change/add something, if you find a bug or just hate it,
     please let me know.

     This is my first FreeWare, and I hope you will enjoyed it.


USAGE: POPDATE([<dDate>],        // Initial date, if NIL or EMPTY use DATE()
               [<nTop>],         // Row number, if NIL use ROW()
               [<nLeft>],        // Col number, if NIL use COL()
               [<cColorString>], // Color String, if NIL or EMPTY use SETCOLOR()
               [<lLangue>]       // If you want French (.T.) or English (.F.)
              ) -> lSucces       // Return .T. if user press RETURN
                                    <dDate> will be update with selected date
                                    AND will be KEYBOARD
EXAMPLE: ...

         @10,10 SAY "What is the date ?" GET mdate ;
                VALID POPDATE(@mdate,,, "W+/RB,W+/R", .T.)

         ...


NOTA:  I am also using the KEYBOARD function to replace the memvar
       with the new value, because by just replacing the <dDate>
       with the user selected date, it will NOT set UPDATED() to true.

******************************************************************************/
#include "Inkey.ch"
#include "Set.ch"
#define VIDE  SPACE(2)





*******************************************************************************
FUNCTION PopDate(dStarting, nTRow, nLCol, cColor, lLangue)
MEMVAR clr_pop
LOCAL cOldColor,;        // Old color setting
      cOldscreen,;       // Save the screen region
      nOldCursor,;       // Old cursor setting
      cOldDate,;         // Old date style
      nBRow,;            // Row position
      nRCol,;            // Column position
      lOk,;              // Logical indicator for keyboarding the resulting date
      dStart             // Working memvar for the date

PRIVATE lFrench          // This will be used to provide a french calendar

IF LASTKEY() == K_CTRL_HOME    // You can change this if you like

     dStart     := IIF(dStarting == NIL, DATE(), IIF(EMPTY(dStarting),;
                   DATE(), dStarting))

     nTRow      := IIF(nTRow == NIL, ROW() + 2, INT(nTRow))
     nTRow      := IIF(nTRow > MAXROW() - 13, MAXROW() - 13, nTRow)

     nLCol      := IIF(nLCol == NIL, COL() + 2, INT(nLCol))
     nLCol      := IIF(nLCol > MAXCOL() - 24, MAXCOL() - 24, nLCol)

     cOldColor  := SETCOLOR( IIF(cColor==NIL, SETCOLOR(), IIF(EMPTY(cColor),;
                   SETCOLOR(), cColor)))

     lFrench    := IIF(lLangue==NIL, .F., lLangue)    // You can select a
                                                      // language per default
     cOldDate   := SET(_SET_DATEFORMAT,"mm/dd/yyyy")
     nOldCursor := SETCURSOR(0)
     nBRow      := nTRow + 8
     nRCol      := nLCol + 21

     // Use you own box function here
     cOldscreen := SAVESCREEN(nTRow, nLCol, nBRow+4, nRCol+3)
     @ nTRow, nLCol CLEAR TO nBRow+3, nRCol+2
     @ nTRow, nLCol TO nBRow+3, nRCol+2
     BOXSHADOW(nTRow, nLCol, nBRow+3, nRCol+2)

     lOk := CalBrowse(@dStart, nTRow, nLCol, nBRow, nRCol)

     // Here also, use your own Unbox routine
     RESTSCREEN(nTRow, nLCol, nBRow+4, nRCol+3, cOldscreen)

     SETCOLOR(cOldColor)
     SETCURSOR(nOldCursor)
     SET(_SET_DATEFORMAT,cOldDate)

     IF lOk
          KEYBOARD DTOC((dStarting := dStart)) + CHR(13)
     ENDIF

     RETURN .F.     // This force the value to be display
                    // & leave the cursor on the same field
ELSE
     RETURN .T.
ENDIF





/*
  This is the main function, and by using a TBrowse object with
  a fixed array size, it display the current month in a calendar
  form. Change the array content and you display a new month.
*/
*******************************************************************************
STATIC FUNCTION CalBrowse
PARAMETERS dStart2, nT, nL, nB, nR // Theses will be used in calling function
MEMVAR lFrench                     // This is defined in PopDate
LOCAL o,;                          // TBrowse object
      nKey     := 0,;              // Key exeption holder
      nTargCol := 0,;              // Target column
      nTargRow := 0,;              // Target row
      nBott    := 0,;              // Last array row
      lRet     := .F.,;            // Loop controler
      aArray[6,7],;                // Maximum possible size array
      n := 1                       // browse row subscript holder

// This will initialize all the necessary memvar
calcul_new_date(@aArray, @nBott, @nTargCol, @nTargRow)

// Create the TBrowse object
o           := TBrowseNew( nT+3, nL+1, nB+2, nR+1 )
o:headsep   := ""
o:colsep    := " "

// Initialize the TBrowse blocks
// Note: during browse, the current row subscript is maintained
// by the blocks in local n
o:SkipBlock     := {|nSkipVal| SkipFunc( @n, nSkipVal, nBott)}
o:GoTopBlock    := {|| n := 1}
o:GoBottomBlock := {|| n := nBott}

// Create TBColumn objects,
// Initialize data retrieval blocks, and add to TBrowse object
// You could use a loop, but I dont want any macro
o:addColumn( TBColumnnew(IIF(lFrench," D"," S"), {|| aArray[n,1]} ))
o:addColumn( TBColumnnew(IIF(lFrench," L"," M"), {|| aArray[n,2]} ))
o:addColumn( TBColumnnew(IIF(lFrench," M"," T"), {|| aArray[n,3]} ))
o:addColumn( TBColumnnew(IIF(lFrench," M"," W"), {|| aArray[n,4]} ))
o:addColumn( TBColumnnew(IIF(lFrench," J"," T"), {|| aArray[n,5]} ))
o:addColumn( TBColumnnew(IIF(lFrench," V"," F"), {|| aArray[n,6]} ))
o:addColumn( TBColumnnew(IIF(lFrench," S"," S"), {|| aArray[n,7]} ))

// Position Cursor to start
o:ColPos := nTargCol
o:RowPos := nTargRow

// Start the event handler loop
WHILE .T.
      nKey := 0
      // Start the stabilization loop
      WHILE (!o:Stabilize())      // I have to stabilize the display to
      END                         // get the real column position

      nKey := INKEY(0)

      // Process the directional keys
      DO CASE
         CASE ( nKey == K_DOWN )
            IF n < nBott
               IF aArray[ n+1, o:ColPos ] # VIDE
                  o:Down()
               END
            ELSE
               IF aArray[ 1, o:ColPos ] # VIDE
                  o:RefreshCurrent()
                  o:RowPos := 1
               ELSE
                  o:RefreshCurrent()
                  o:RowPos := 1
                  o:Down()
               ENDIF
            END
         CASE ( nKey == K_UP )
            IF n > 1
               IF aArray[ n-1, o:ColPos ] # VIDE
                  o:Up()
               END
            ELSE
               IF aArray[ nBott, o:ColPos ] # VIDE
                  o:RefreshCurrent()
                  o:RowPos := nBott
               ELSE
                  o:RefreshCurrent()
                  o:RowPos := nBott
                  o:Up()
               ENDIF
            END

         CASE ( nKey == K_RIGHT )
            IF (o:colPos == 7) .AND. (o:RowPos < nBott)
               o:down()
               o:home()
            ELSE
               IF o:ColPos < 7 .AND. aArray[ n, o:ColPos + 1] # VIDE
                  o:Right()
               END
            END
         CASE ( nKey == K_LEFT )
            IF (o:colPos == 1) .AND. (o:RowPos > 1)
               o:up()
               o:end()
            ELSE
               IF o:ColPos > 1 .AND. aArray[ n, o:ColPos - 1] # VIDE
                  o:Left()
               END
            END

         CASE ( nKey == K_HOME )  // First day of month
            o:RefreshCurrent()
            o:RowPos := 1
            o:End()
            WHILE o:ColPos > 1 .AND. aArray[ 1, o:ColPos - 1 ] # VIDE
               o:Left()
            END

         CASE ( nKey == K_END )   // Last day of month
            o:RefreshCurrent()
            o:RowPos := nBott
            o:Home()
            WHILE o:ColPos < 7 .AND. aArray[ nBott, o:ColPos + 1 ] # VIDE
               o:Right()
            END

         CASE ( nKey == K_PGDN ) .OR. ( nKey == K_PGUP ) .OR. ;
              ( nKey == K_CTRL_PGDN ) .OR. (nKEY == K_CTRL_PGUP )

            dStart2 := CTOD(STR(MONTH(dStart2),2) + "/" +;
                       aArray[ n, o:ColPos ] + "/" + STR(YEAR(dStart2),4))

            DO CASE
               CASE ( nKey == K_PGUP )             // Next month
                  dStart2 := addmonth(dStart2, 1)
               CASE ( nKey == K_PGDN )             // Previous month
                  dStart2 := addmonth(dStart2, -1)
               CASE ( nKey == K_CTRL_PGUP )        // Next year
                  dStart2 := addyear(dStart2, 1)
               CASE ( nKey == K_CTRL_PGDN )        // Previous year
                  dStart2 := addyear(dStart2, -1)
            ENDCASE

            calcul_new_date(@aArray, @nBott, @nTargCol, @nTargRow)
            o:RowPos := nTargRow
            o:ColPos := nTargCol
            o:RefreshAll()

         CASE ( nKey == K_RETURN )   // User select
            dStart2 := CTOD(STR(MONTH(dStart2),2) + "/" +;
                       aArray[ n, o:ColPos ] + "/" + STR(YEAR(dStart2),4))
            lRet  := .T.
            EXIT

         CASE ( nKey == K_ESC )      // User abort
            lRet  := .F.
            EXIT

      ENDCASE
ENDDO
RETURN (lRet)





/*
  I don't know about you but I had to dissect the skipblock routine
  in order to understand what it does.
*/
*******************************************************************************
STATIC FUNCTION SkipFunc( n, nSkip_Val, nMaxVal)
LOCAL nMove := 0         // this value will be returned
IF nSkip_Val > 0
   WHILE n + nMove < nMaxVal .AND. nMove < nSkip_Val
      nMove++
   END
ELSEIF nSkip_Val < 0
   WHILE n + nMove > 1 .AND. nMove > nSkip_Val
      nMove--
   END
ENDIF
n += nMove
RETURN (nMove)





/*
  This will calculate and set the memvar to the
  current date value
*/
*******************************************************************************
STATIC FUNCTION calcul_new_date (aArray, nBott, nTargCol, nTargRow)
MEMVAR dStart2, nT, nL, nR           // This is defined in TBrowse
LOCAL n1stDay, nLastDate

n1stDay    := DOW((dStart2 - DAY(dStart2)) + 1)  //  First Day of Mo. (#)
nLastDate  := lastdate(dStart2)                  //  Last Date of Month
nBott      := WeeksInMo(n1stDay, nLastDate)      //  No. of Weeks (rows)

MakCalArr(@aArray, n1stDay, nLastDate, DAY(dStart2), @nTargCol, @nTargRow)
DspCalHead(dStart2, nT+1, nL+1, nR-1)            //  Show Month and Year

RETURN (NIL)





/*
  This will display the month and year heading
*/
*******************************************************************************
STATIC FUNCTION DspCalHead(dStartd, nLine, nBeg, nEnd)
MEMVAR lFrench                        // This is defined in PopDate
LOCAL cStr,nSpace

cStr := TRIM(IIF(lFrench, xcmonth(dStartd), CMONTH(dStartd))) + " ";
        + LTRIM(STR(YEAR(dStartd)))

@ nLine, nBeg CLEAR TO nLine, nEnd
nSpace   := INT((INT(((nEnd - nBeg) + 4) / 2) - (len(cStr) / 2)))
@ nLine,nBeg+nSpace SAY cStr
RETURN (NIL)





/*
  This will take aArray and fill all elements position
  for the current month (maybe AEVAL() could be used here?)
*/
*******************************************************************************
STATIC FUNCTION MakCalArr(aArray, n1day, nLastd, nTargd, nTargC, nTargR)
LOCAL nDayOfMo := 1,;
      r,c

FOR r = 1 TO 6
    FOR c = 1 TO 7
        IF nDayOfMo == nTargd       // store row & col of target day
           nTargR := r              // put the browse cursor here
           nTargC := c
        ENDIF
        IF c + (r - 1) * 7 < n1Day .OR. nDayOfMo > nLastD
           aArray[r,c] := VIDE
        ELSE
           aArray[r,c] := RIGHT(SPACE(2) + STR(nDayOfMo,2),2)
           nDayOfMo++
        ENDIF
    NEXT
NEXT
RETURN (NIL)





/*
  This function will returns the last date
  of month for input date
*/
*******************************************************************************
STATIC FUNCTION lastdate(nMth)
LOCAL nMois := 31,;
      nMonthNo := MONTH(nMth)

DO CASE
   CASE nMonthNo == 2
        IF dateisleap(nMth)     // Is this leap year?
           nMois := 29
        ELSE
           nMois := 28
        END
   CASE nMonthNo == 4
        nMois := 30
   CASE nMonthNo == 6
        nMois := 30
   CASE nMonthNo == 9
        nMois := 30
   CASE nMonthNo == 11
        nMois := 30
ENDCASE
RETURN (nMois)





/*
  Calculates the number of rows for the current month
*/
*******************************************************************************
STATIC FUNCTION WeeksInMo(nFday,nLdate)

IF nLdate == 31                          // 31 day month
   RETURN (IIF(nFday >= 6, 6, 5))
ELSEIF nLdate == 30                      // 30 day month
   RETURN (IIF(nFday == 7, 6, 5))
ELSEIF nLdate == 29                      // February - leap year
   RETURN (5)
ELSE                                     // February - 28 days
   RETURN (IIF(nFday == 1, 4, 5))
ENDIF





/*
  This is for you french people out there !
  All you have to do is to replace the CMONTH
  function with Xcmonth
*/
*******************************************************************************
FUNCTION xcmonth (_date)
LOCAL i := MONTH(_date),;
      cMois := "ERREUR"

DO CASE
     CASE i ==  1
          cMois := "Janvier"
     CASE i ==  2
          cMois := "Fvrier"
     CASE i ==  3
          cMois := "Mars"
     CASE i ==  4
          cMois := "Avril"
     CASE i ==  5
          cMois := "Mai"
     CASE i ==  6
          cMois := "Juin"
     CASE i ==  7
          cMois := "Juillet"
     CASE i ==  8
          cMois := "Aot"
     CASE i ==  9
          cMois := "Septembre"
     CASE i == 10
          cMois := "Octobre"
     CASE i == 11
          cMois := "Novembre"
     CASE i == 12
          cMois := "Dcembre"
ENDCASE
RETURN (cMois)





/*
  This function add/substract year
*/
*******************************************************************************
STATIC FUNCTION addyear(dDate, nAnnee)
LOCAL nMonth, nDay, nYear

nAnnee := IIF(nAnnee==NIL, 1, nAnnee)

// Break date up into its numeric components
nMonth := MONTH( dDate )
nDay   := DAY( dDate )
nYear  := YEAR( dDate ) + nAnnee

IF (nMonth == 2) .AND. (nDay > 28)
     nDay := lastdate(CTOD("02/01/" + STR(nYear,4)))
ENDIF

RETURN (CTOD( STR(nMonth, 2) + "/" + STR(nDay, 2) + "/" + STR(nYear, 4) ))





/*
  This function will add/substract ONE month ONLY
*/
*******************************************************************************
STATIC FUNCTION AddMonth( dDate, nMonths)
LOCAL nMonth, nDay, nYear

nMonths := IIF(nMonths==NIL, 1, IIF(nMonths > 1, 1,;
           IIF(nMonths < -1 , -1, nMonths)))

// Break date up into its numeric components
nMonth := MONTH( dDate )
nDay   := DAY( dDate )
nYear  := YEAR( dDate )

nMonth += nMonths
IF nMonth < 1
     nMonth := 12
     nYear--
ELSEIF nMonth > 12
     nMonth := 1
     nYear++
ENDIF

IF (nMonth == 2) .AND. (nDay > 28)
     nDay := lastdate(CTOD("02/01/" + STR(nYear,4)))
ELSEIF nDay == 31
     nDay := lastdate(CTOD(STR(nMonth,2) + "/01/" + STR(nYear,4)))
ENDIF

// Convert numeric portions to new date
RETURN (CTOD( STR(nMonth, 2) + "/" + STR(nDay, 2) + "/" + STR(nYear, 4) ))





/*
  This function will calculated if the date is in a leap year
  (taken from DATE.PRG included with 5.0)
*/
*******************************************************************************
FUNCTION DateIsleap( dDate )
LOCAL nYear := YEAR(dDate)
RETURN ((nYear % 4) == 0) .AND. (((nYear % 100) != 0) .OR. ((nYear % 400) == 0))





/*
  Draw a box shadow with see through
  (Included in BOX.PRG with 5.0)
*/
*******************************************************************************
STATIC FUNCTION BoxShadow( nTop, nLeft, nBottom, nRight )
LOCAL nShadTop, nShadLeft, nShadBottom, nShadRight

nShadTop   := nShadBottom := MIN(nBottom + 1, MAXROW())
nShadLeft  := nLeft + 1
nShadRight := MIN(nRight + 1, MAXCOL())

RESTSCREEN( nShadTop, nShadLeft, nShadBottom, nShadRight,;
       TRANSFORM( SAVESCREEN(nShadTop, nShadLeft, nShadBottom, nShadRight),;
       REPLICATE("X", nShadRight - nShadLeft + 1 ) ) )

nShadTop    := nTop + 1
nShadLeft   := nShadRight := MIN(nRight + 1, MAXCOL())
nShadBottom := nBottom

RESTSCREEN( nShadTop, nShadLeft, nShadBottom, nShadRight,;
       TRANSFORM( SAVESCREEN(nShadTop,  nShadLeft , nShadBottom,  nShadRight),;
       REPLICATE("X", nShadBottom - nShadTop + 1 ) ) )

RETURN (NIL)

