* Program Name: kawadder.prg  - POP_ADDER() 
* Author: Keith A. Wire 
* Copyright (c) 1990 by Keith's Hardware, Inc. 
*-----------------------------------------------------------------------------
* Created: 8/10/1989 at 14:40
* main = KAWADDER.PRG - Sample program
* Called From:
*.............................................................................
* Revision: 1.0 Last Revised: 1/20/1990 at 14:40
* Description: Original Creation.
*.............................................................................
*---------------------------- ALL RIGHTS RESERVED ----------------------------

RESTORE FROM ABCOLUSE ADDITIVE          && Get User colors
RESTORE FROM ABE_KEYS ADDITIVE          && My keyboard variables ex.) esc=13
SET SCOREBOARD OFF
win_color='4'
PUBLIC h_count,helppos[8],h_color[8],h_window[8],
h_count=0
AFILL(h_window,'')
SET CURSOR OFF
userfname='Keith'                       && Put your first name here!! Used in ABERROR
abs_double='ͻȺ '
abs_single='Ŀ '
SET COLOR TO (c_screen+','+c_variab)    && My standard screen colors
CLEAR SCREEN
HOT_KEY_ON()

* SIMPLE Sample of program data entry!
this_p_si=0
this_p_pe=0
this_p_va=0
@ 12,5 SAY 'Please enter the total Sick, Personal, and Vacation hours.'  
@ 15,22 SAY 'Sick hrs.'
@ 15,40 SAY 'Pers. hrs.'
@ 15,60 SAY 'Vaca. hrs.'
DO WHILE .T.                            && Get the sick, personal, & vacation
  @ 16,24 GET this_p_si PICTURE '9999.999'  && Normally I have a VALID()
  @ 16,43 GET this_p_pe PICTURE '9999.999'  && to make sure the value is
  @ 16,63 GET this_p_va PICTURE '9999.999'  && within the allowable range.
  SET CURSOR ON                             && But, like I said it is a 
  CLEAR TYPEAHEAD                           && SIMPLE example <g>.
  READ
  SET CURSOR OFF
  IF LASTKEY()=esc                      && <ESC> - ABORT
    CLEAR TYPEAHEAD
    IF Y_N_ANSWER('Are you sure you want to ABORT editing the '+;
      'sick, personal, and vacation hours for ?','Y')
      EXIT
    ELSE
      LOOP
    ENDIF
  ENDIF
ENDDO
SET CURSOR ON
RETURN


* KAW25.PRG
FUNCTION POP_ADDER                      && "ABE" ADDER
  PARAMETERS p_adder,l_adder,v_adder
  PRIVATE sav_row,sav_col,trans[50],i
  AFILL(trans,'')
  HOT_KEY_OFF()
  SET DECIMALS TO 9
  SET CURSOR OFF
  sav_row=ROW()
  sav_col=COL()
  def_tot_pi='999999999999999999'
  tot_pict=''
  _total=0
  _subtotal=0
  sav_total=0
  tot_tran=0
  tape_win=''
  _top_tape=1
  i = 0                                 && Input keyboard key
  _cl_adder=.F.                         && Clear adder flag
  dec_set = .F.                         && Decimal ? - keyboard routine
  dec_digit=0
  max_deci=0                            && Maximum number of decimals
  _mult_div=.F.                         && Start in ADD mode
  _add_mode=1                           && Start in ADD mode
  calc_scr=''
  _sub_retrn=.F.
  ad_tot_ok=.F.
  _tape=.F.
  ac_abort=0                            && Variables for ACHOICE
  ac_select=1
  ac_continue=2
  ac_excep=3
  ret_val=0
  ac_exit_ok=.F.
  add_error=.F.
  divide_err=.F.
  DO ADD_SCREEN
  DO CHANG_DEC WITH 2
  CLEAR TYPEAHEAD
  DO WHILE .T.                          && Input key & test loop
    i=INKEY(0)
    DO CASE
      CASE UPPER(CHR(i)) $'1234567890.'
        DO _NUMBER
      CASE i=plus                       && <+> sign
        DO ADD_NUM
      CASE i=minus                      && <-> sign
        DO ADD_NUM
      CASE i=rtn                        && <RTN> Total or Subtotal
        DO ADD_TOTAL
      CASE i=esc                        && <ESC> Quit
        SET FUNCTION 10 TO
        SET KEY f_10 TO
        IF _tape
          RESTSCREEN(4,6,22,34,tape_win)
        ENDIF
        RESTSCREEN(2,42,23,72,calc_scr)
        win_color=LST_CLR_ST()
        @ sav_row,sav_col SAY ''
        HOT_KEY_ON()
        SET CURSOR ON
        RETU(0)
      CASE i=68 .OR. i=100              && <D> Change number of decimal places
        DO CHANG_DEC
      CASE i=84 .OR. i=116              && <T> Display Tape
        DO DISP_TAPE
      CASE (i=83 .OR. i=115) .AND. _tape  && <S> Scroll display of tape
        IF tot_tran>16                  && We need to scroll
          SET COLOR TO GR+/W
          @ 21,8 SAY ' '+CHR(24)+CHR(25)+'-SCROLL  <ESC>-QUIT '
          SET COLOR TO N/W,W+/N
          ac_exit_ok=.F.
          sel_adder=ACHOICE(5,7,20,31,trans,.T.,'ADDFUNC',tot_tran,20)
          SET COLOR TO R+/W
          @ 21,8 TO 21,30
          SET COLOR TO (c_prom_&win_color)
          CLEAR TYPEAHEAD
        ELSE
          DO ABERROR WITH 'but there are '+IF(tot_tran>0,'only '+LTRIM(;
          STR(tot_tran,3,0)),'no')+" transactions entered so far. No need to "+;
          "scroll!"
        ENDIF
      CASE i=space                      && Space bar - Shift to Multiply/Divide
        DO SHIFT_ADD
      CASE i=7                          && Delete - Clear adder
        DO CLEAR_ADD
      CASE i=f_1                        && <F1> Help
        DO ADD_HELP
      CASE i=f_10                       && <F10> Quit - Return total
        IF ad_tot_ok                    && Did they finish the calculation
          IF Y_N_ANSWER(TRIM(userfname)+' are you sure you want to return '+LTRIM(STR(sav_total,;
            15,max_deci))+' to the program?')
            IF TYPE(v_adder)='N'
              SET FUNCTION 10 TO
              SET KEY f_10 TO
              IF _tape
                RESTSCREEN(4,6,22,34,tape_win)
              ENDIF
              RESTSCREEN(2,42,23,72,calc_scr)
              win_color=LST_CLR_ST()
              @ sav_row,sav_col SAY ''
              HOT_KEY_ON()
              &v_adder=sav_total
              SET CURSOR ON
              RETU(sav_total)
            ELSE
              DO ABERROR WITH 'but I can not return the total from the '+;
              'adder to this variable. You must quit the "ABE" ADDER using'+;
              ' the <ESC> key and then enter the total manually.'
            ENDIF
          ENDIF
        ELSE
          DO ABERROR WITH 'the calculation is not finished yet! You must have'+;
          ' a TOTAL before you can return it to the program.'
        ENDIF
    ENDCASE
  ENDDO  (WHILE .T.  Data entry from keyboard)
RETURN(0)
**************

PROCEDURE ADD_SCREEN                    && Part of "ABE" ADDER
  calc_scr=SAVESCREEN(2,42,23,72)
  win_color=NXT_CLR_ST()
  *COLORWIN(23,44,23,72,8)              && CT1 function for True Shaddowing
  *COLORWIN(3,71,22,72,8)               && CT1 function for True Shaddowing
  SET COLOR TO (c_scree_&win_color)
  @ 2,42,22,70 BOX (abs_double)
  SET COLOR TO (c_prom_&win_color)
  @ 3,46,7,67 BOX (abs_double)
  SET COLOR TO (c_title_&win_color)
  @ 2,50 SAY ' "ABE" ADDER '
  @ 22,49 SAY ' <F1> for HELP '
  SET COLOR TO (c_scree_&win_color)
  @  9,45 SAY 'Ŀ Ŀ Ŀ Ŀ'
  @ 10,45 SAY '               '
  @ 11,45 SAY '   '
  @ 12,45 SAY 'Ŀ Ŀ Ŀ Ŀ'
  @ 13,45 SAY '               '
  @ 14,45 SAY '   '
  @ 15,45 SAY 'Ŀ Ŀ Ŀ Ŀ'
  @ 16,45 SAY '               '
  @ 17,45 SAY '      '
  @ 18,45 SAY 'Ŀ Ŀ    '
  @ 19,45 SAY '                 '
  @ 20,45 SAY '     '
  @ 21,45 SAY '                  '
  SET COLOR TO (c_title_&win_color)
  @ 10,47 SAY '7'
  @ 10,53 SAY '8'
  @ 10,59 SAY '9'
  @ 10,65 SAY '-'
  @ 13,47 SAY '4'
  @ 13,53 SAY '5'
  @ 13,59 SAY '6'
  @ 13,65 SAY '+'
  @ 16,47 SAY '1'
  @ 16,53 SAY '2'
  @ 16,59 SAY '3'
  @ 17,65 SAY ''
  @ 19,50 SAY '0'
  @ 19,59 SAY '.'
  @ 19,65 SAY '*'
  SET COLOR TO (c_prom_&win_color)
RETURN
**************


PROCEDURE CHANG_DEC                     && Change the decimal position in the display
  PARAMETER ans                         && Part of "ABE" ADDER
  IF PCOUNT()=0
    WIN_PUSH(10,15,15,63)
    DO WHILE .T.
      ?? CHR(bell)
      ans=0
      @ 12,17 SAY 'How many decimals do you want to display?'
      SET COLOR TO (c_varia_&win_color)
      @12,60 SAY CHR(219)
      SET COLOR TO (c_scree_&win_color)
      i=INKEY(0)
      IF i<48 .OR. i>57
        LOOP
      ENDIF
      ans=i-48
      IF ans>8
        DO ABERROR WITH 'no more than 8 decimal places please!'
        LOOP
      ELSE
        EXIT
      ENDIF
    ENDDO
    WIN_POP()
  ENDIF
  tot_pict=POSREPL(def_tot_pi,'.',18-ABS(ans))
  FOR y=14-ABS(ans) TO 2 STEP -4
    tot_pict=POSREPL(tot_pict,',',y)
  NEXT
  max_deci=ans
  DO DISP_SUB
RETURN
**************

PROCEDURE DISP_TOT                      && Display total number
  IF _total>VAL(CHARREM(',',tot_pict))  && Part of "ABE" ADDER
    _tot_str=STUFF_COMM(LTRIM(STR(_total)))
    DO ABERROR WITH 'but that number is to big to display! '+;
    'I believe the answer was '+_tot_str+'.'
    @ 5,48 SAY ' ****  ERROR  ****'
    add_error=.T.
    DO UPD_TRANS WITH .T.
    DO CLEAR_ADD
    _total=0
    _subtotal=0
    add_error=.F.
  ELSE
    @ 5,48 SAY _total PICTURE tot_pict
  ENDIF
RETURN
**************

PROCEDURE DISP_SUB                      && Display subtotal number Part of "ABE" ADDER

  IF _subtotal>VAL(CHARREM(',',tot_pict))
    _stot_str=STUFF_COMM(LTRIM(STR(_subtotal)))
    DO ABERROR WITH 'but that number is to big to display! '+;
    'I believe the answer was '+_stot_str+'.'
    @ 5,48 SAY ' ****  ERROR  ****'
    add_error=.T.
    DO UPD_TRANS WITH .T.,_subtotal
    DO CLEAR_ADD
    _total=0
    _subtotal=0
    add_error=.F.
  ELSE
    @ 5,48 SAY _subtotal PICTURE tot_pict
  ENDIF
RETURN
**************

PROCEDURE _NUMBER                       && Act on NUMBER key pressed Part of "ABE" ADDER
  SET COLOR TO (c_scree_&win_color)
  @ 8,58 SAY '          '               && Clear <TOTAL> - <SUBTOTAL>
  SET COLOR TO (c_prom_&win_color)
  ad_tot_ok=.F.
  _cl_adder=.F.                         && Reset the Clear flag
  add_error=.F.                         && Reset adder error flag
  IF i=46                               && Period (.) decimal point
    IF dec_set                          && Has decimal already been set
      ?? CHR(bell)
    ELSE
      dec_set=.T.
    ENDIF
  ELSE                                  && It must be a number input
    num=i-48
    IF dec_set                          && Decimal set
      IF dec_digit<max_deci             && Check how many decimals they are allowed
        dec_digit=dec_digit+1
        _subtotal=_subtotal+num/(10**dec_digit)
      ENDIF
    ELSE
      _subtotal=_subtotal*10+num
    ENDIF
  ENDIF
  DO DISP_SUB
RETURN
**************

PROCEDURE SHIFT_ADD                     && They pressed the space bar Part of "ABE" ADDER
  SET COLOR TO (c_title_&win_color)
  IF _mult_div                          && toggle add/subt for mult/divide
    _mult_div=.F.
    @ 10,65 SAY '-'
    @ 13,65 SAY '+'
    @ 18,65 SAY ' '
    @ 17,65 SAY ''
    @ 19,65 SAY '*'
  ELSE
    _mult_div=.T.
    @ 10,65 SAY ''
    @ 13,65 SAY 'X'
    @ 18,65 SAY '='
    @ 17,65 SAY ' '
    @ 19,65 SAY ' '
  ENDIF
  SET COLOR TO (c_prom_&win_color)
RETURN
**************

PROCEDURE ADD_TOTAL                     && Enter key - SUBTOTAL - TOTAL Part of "ABE" ADDER
  dec_set=.F.
  dec_digit=0
  _cl_adder=.F.                         && Reset the Clear flag
  IF _sub_retrn                         && If this was the second time they
    IF !_mult_div
      SET COLOR TO (c_scree_&win_color)
      @ 8,58 SAY '   <TOTAL>'
      SET COLOR TO (c_prom_&win_color)
      DO UPD_TRANS WITH .T.
      DO DISP_TOT
      _sub_retrn=.F.                      && pressed the total key reset everyting
      sav_total=_total
      _total=0
      ad_tot_ok=.T.
    ENDIF
  ELSE                                  && This was the first time they pressed
    IF _total!=0 .OR. _subtotal!=0
      SET COLOR TO (c_scree_&win_color)
      @ 8,58 SAY '<SUBTOTAL>'
      SET COLOR TO (c_prom_&win_color)
      IF _subtotal!=0
        DO UPD_TRANS WITH .F.,_subtotal
      ENDIF
      IF !_mult_div
        _sub_retrn=.T.                    && total key
      ENDIF
      IF _add_mode=1                    && Add
        _total=_total+_subtotal
      ELSEIF _add_mode=2                && Subtract
        _total=_total-_subtotal
      ELSEIF _add_mode=3                && Multiply
        _total=_total*_subtotal
      ELSEIF _add_mode=4                && Divide
        _total=DIVIDE(_total,_subtotal)
        IF divide_err
          DO ABERROR WITH "but you can't divide by ZERO!"
          divide_err=.F.
        ENDIF
      ENDIF
    ENDIF
    DO DISP_TOT
    IF _mult_div                        && This was a multiply or divide
      SET COLOR TO (c_scree_&win_color) && so you don't need to press <RTN> twice
      @ 8,58 SAY '   <TOTAL>'
      SET COLOR TO (c_prom_&win_color)
      _sub_retrn=.F.                    && pressed the total key reset everyting
      IF !ad_tot_ok                     && If you haven't printed total DO-IT
        ad_tot_ok=.T.
        DO UPD_TRANS WITH .F.
      ENDIF
      _subtotal=0
      sav_total=_total
      _total=0
    ELSE
      IF !ad_tot_ok                     && If you haven't printed total DO-IT
        DO UPD_TRANS WITH .F.
        _subtotal=0
      ENDIF
    ENDIF
  ENDIF
RETURN
**************

PROCEDURE ADD_NUM                       && Process + or - keypress Part of "ABE" ADDER
  ad_tot_ok=.F.
  dec_set=.F.
  dec_digit=0
  _sub_retrn=.F.
  IF _mult_div
    IF _subtotal=0 .AND. _total=0       && They pressed the + or - key to
      _subtotal=sav_total               && process the previous total
    ENDIF
    IF _total=0                         && Get the first number of the product or division
      IF i=plus                         && Setup mode
        _add_mode=3
        DO UPD_TRANS WITH .F.,_subtotal
      ELSEIF i=minus
        _add_mode=4
        DO UPD_TRANS WITH .F.,_subtotal
      ENDIF
      _total=_subtotal
      _subtotal=0
    ELSE
      IF i=plus                         && Multiply
        _add_mode=3
        DO UPD_TRANS WITH .F.,_subtotal
        _total=_total*_subtotal
        _subtotal=0
      ELSEIF i=minus                    && Divide
        _add_mode=4
        DO UPD_TRANS WITH .F.,_subtotal
        _total=DIVIDE(_total,_subtotal)
        IF divide_err
          DO ABERROR WITH "but you can't divide by ZERO!"
          divide_err=.F.
        ENDIF
        _subtotal=0
      ENDIF
    ENDIF
  ELSE
    IF _subtotal=0 .AND. _total=0       && They pressed the + or - key to
      _subtotal=sav_total               && process the previous total
    ENDIF
    IF i=plus                           && Add
      _add_mode=1
      DO UPD_TRANS WITH .F.,_subtotal
      _total=_total+_subtotal
      _subtotal=0
    ELSEIF i=minus                      && Subtract
      _add_mode=2
      DO UPD_TRANS WITH .F.,_subtotal
      _total=_total-_subtotal
      _subtotal=0
    ENDIF
  ENDIF
  DO DISP_TOT
RETURN
**************

PROCEDURE ADD_HELP                      && Help window Part of "ABE" ADDER
  WIN_PUSH(8,27,22,57)
  SET COLOR TO (c_title_&win_color)
  @ 8,36 SAY " INSTRUCTIONS "
  @ 22,32 SAY ' Any Key to Continue '
  SET COLOR TO (c_scree_&win_color)
  @  9,30 SAY 'All number keys as usual'
  @ 10,30 SAY '<+> <-> keys as usual'
  @ 11,30 SAY '<SPACE>shift <+> to <*>'
  @ 12,30 SAY '        shift <-> to </>'
  @ 13,30 SAY ' <D>    change decimal pt.'
  @ 14,30 SAY ' <T>    display tape'
  @ 15,30 SAY ' <S>    scroll tape disp.'
  @ 16,30 SAY '<DEL>1st Clear entry'
  @ 17,30 SAY '        2nd Clear ADDDER'
  @ 18,30 SAY '<ESC>   to Quit'
  @ 19,30 SAY '<F10>   to Return Total'
  @ 20,30 SAY '          to program'
  INKEY(0)
  WIN_POP()
RETURN
**************

PROCEDURE CLEAR_ADD                     && Clear entry / Clear Adder Part of "ABE" ADDER
  dec_set=.F.
  dec_digit=0
  IF _cl_adder                          && If it has alredy been pressed once
    _total=0                            && then we are clearing the total
    DO UPD_TRANS
    DO DISP_TAPE
    _cl_adder=.F.
    DO DISP_TOT
  ELSE
    _subtotal=0                         && Just clearing the last entry
    _cl_adder=.T.
    DO DISP_SUB
  ENDIF
RETURN
**************

PROCEDURE DISP_TAPE                     && Display tape Part of "ABE" ADDER
  IF (i=84 .OR. i=116) .AND. _tape      && Stop displaying tape
    _tape=.F.
    RESTSCREEN(4,6,22,34,tape_win)
    RETU
  ENDIF
  IF _tape                              && Are we in the display mode
    SET COLOR TO N/W
    SCROLL(5,7,20,31,1)
    IF tot_tran>0                       && Have any transactions been entered yet?
      @ 20,7 SAY trans[tot_tran]
    ENDIF
    SET COLOR TO (c_prom_&win_color)
  ELSE                                  && Start displaying tape
    _tape=.T.
    SET COLOR TO N/W
    tape_win=SAVESCREEN(4,6,22,34)
    *COLORWIN(22,8,22,34)               && CT1 function for True Shaddowing
    *COLORWIN(5,33,21,34)               && CT1 function for True Shaddowing
    SET COLOR TO R+/W
    @ 4,6,21,32 BOX (abs_single)
    SET COLOR TO GR+/W
    @ 4,17 SAY ' TAPE '
    SET COLOR TO N/W
    IF tot_tran>15
      _top_tape=tot_tran-15
    ENDIF
    FOR disp_tape=tot_tran TO _top_tape STEP -1
      @ 20+disp_tape-tot_tran,7 SAY trans[disp_tape]
    NEXT
  ENDIF
  SET COLOR TO (c_prom_&win_color)
RETURN
**************

PROCEDURE UPD_TRANS                     && Update transactions array Part of "ABE" ADDER
  PARAMETER _type_tot,sub_amount
  IF PCOUNT()=1
    sub_amount=0
  ENDIF
  IF _cl_adder                          && Clear the adder (they pressed <DEL> twice
    IF tot_tran<50
      tot_tran=tot_tran+1
      trans[tot_tran]=STR(0,20,max_deci)+' C'
    ELSE
      FOR _x=1 TO 49
        trans[_x]=trans[_x+1]
      NEXT
      trans[50]=STR(0,20,max_deci)+' C'
    ENDIF
    RETU
  ENDIF
  IF _type_tot                          && If _type_tot=.T. Update from total
    IF tot_tran<50
      tot_tran=tot_tran+1
      trans[tot_tran]=STR(IF(PCOUNT()=1,_total,sub_amount),20,max_deci)+' *'
      trans[tot_tran]=STUFF_COMM(trans[tot_tran],.T.)+IF(add_error,'ER','')
    ELSE
      FOR _x=1 TO 49
        trans[_x]=trans[_x+1]
      NEXT
      trans[50]=STR(IF(PCOUNT()=1,_total,sub_amount),20,max_deci)+' *'
      trans[tot_tran]=STUFF_COMM(trans[50],.T.)+IF(add_error,'ER','')
    ENDIF
  ELSE                                  && If _type_tot=.F. Update from _subtotal
    IF _total!=0 .OR. _subtotal!=0 .OR. sub_amount!=0
      IF tot_tran<50
        tot_tran=tot_tran+1
        trans[tot_tran]=STR(IF(PCOUNT()=1,_total,sub_amount),20,max_deci)+;
        IF(_sub_retrn,' ',IF(_add_mode=1,' +',IF(_add_mode=2,' -',IF;
        (ad_tot_ok,' =',IF(_add_mode=3,' X',' ')))))
        trans[tot_tran]=STUFF_COMM(trans[tot_tran],.T.)+IF(add_error,'ER','')
      ELSE
        FOR _x=1 TO 49
          trans[_x]=trans[_x+1]
        NEXT
        trans[50]=STR(IF(PCOUNT()=1,_total,sub_amount),20,max_deci)+IF(_sub_retrn,;
        ' ',IF(_add_mode=1,' +',IF(_add_mode=2,' -',IF(ad_tot_ok,' =',;
        IF(_add_mode=3,' X',' ')))))
        trans[tot_tran]=STUFF_COMM(trans[tot_tran],.T.)+IF(add_error,'ER','')
      ENDIF
    ENDIF
  ENDIF
  IF _tape
    DO DISP_TAPE
  ENDIF
RETURN
**************

FUNCTION ADDFUNC                        && User function for ACHOICE in "ABE" ADDER
  PARAMETERS mode,cur_elem,rel_pos
  PRIVATE key
  rel_start=rel_pos
  DO CASE
    CASE mode=ac_excep
      key=LASTKEY()
      DO CASE
        CASE key=30
          ret_val=ac_continue
        CASE key=esc
          KEYBOARD CHR(ctrl_pg_dn)+CHR(rtn)      && Go to last item
          ac_exit_ok=.T.
          ret_val=ac_continue
        CASE ac_exit_ok
          ret_val=ac_abort
        OTHERWISE
          ret_val=ac_continue
      ENDCASE
    OTHERWISE
      ret_val=ac_continue
  ENDCASE
RETURN ret_val
*************

* KAW26.PRG
FUNCTION DIVIDE                         && Check divide by zero not allowed
  PARAMETERS numerator,denominat
  IF denominat=0
    divide_err=.T.
    RETU(0)
  ENDIF
RETURN(numerator/denominat)
**************

* KAW27.PRG
FUNCTION STUFF_COMM                     && Stuff comma into tape display Part of "ABE" ADDER
  PARAMETER st_to_stuf,stuf_trim
  IF TYPE('stuf_trim')='U'
    stuf_trim=.F.
  ENDIF
  IF !('.' $ st_to_stuf)
    st_to_stuf=POSINS(st_to_stuf,'.',IF('C'$st_to_stuf .OR. 'E'$st_to_stuf;
    .OR. '+'$st_to_stuf .OR. '-'$st_to_stuf .OR. 'X'$st_to_stuf .OR. ;
    '*'$st_to_stuf .OR. ''$st_to_stuf .OR. ''$st_to_stuf .OR. '='$st_to_stuf,;
    LEN(st_to_stuf)-1,LEN(st_to_stuf)+1))
  ENDIF
  dec_posit=AT('.',st_to_stuf)
  IF LEN(LEFT(LTRIM(CHARREM('-',st_to_stuf)),;
    AT('.',LTRIM(CHARREM('-',st_to_stuf)))-1))>3
    IF stuf_trim                        && Do we trim the number each time we insert a comma
      FOR x=dec_posit-3 TO 2+COUNTLEFT(st_to_stuf,' ') STEP -4
        st_to_stuf=SUBSTR(POSINS(st_to_stuf,',',x),2)
      NEXT
    ELSE
      FOR x=dec_posit-3 TO 2+COUNTLEFT(st_to_stuf,' ') STEP -3
        st_to_stuf=POSINS(st_to_stuf,',',x)
      NEXT
    ENDIF
  ENDIF
RETURN(st_to_stuf)
********************************* END of "ABE" ADDER ************************

**************

* KAW22.PRG
FUNCTION HOT_KEY_ON                     && Turn HOT-KEYS ON
  SET KEY 286 TO POP_ADDER              && <ALT-A> POP-UP ADDING MACHINE
  *
  *   Set all your HOT keys here
  *
RETURN(.T.)
**************

FUNCTION HOT_KEY_OFF                    && Turn HOT-KEYS OFF
  SET KEY 286 TO
  *
  *   Reset all your HOT keys here
  *
RETURN(.T.)
********************

* KAW2.PRG
PROCEDURE ABERROR                       && Print error messages
  PARAMETERS message
  PRIVATE sav_row,sav_col,top_row,top_col,bot_row,bot_col,save_color
  sav_row=ROW()
  sav_col=COL()
  SET CURSOR OFF
  save_color=SETCOLOR(c_error)
  message="I'm sorry "+TRIM(userfname)+', '+message
  rows=ROUND((LEN(message)+33)/66,0)
  wide=IF(rows=1,IF(LEN(message)>28,LEN(message),28),66)
  top_row=12-INT(rows/2)
  top_col=40-INT(wide/2)-2
  bot_row=top_row+rows+3
  bot_col=top_col+wide+2+2
  scerror=SAVESCREEN(top_row,top_col,bot_row+1,bot_col+2)
  *COLORWIN(bot_row+1,top_col+2,bot_row+1,bot_col+2,8)  && CT1 function for True Shaddowing
  *COLORWIN(top_row+1,bot_col+1,bot_row  ,bot_col+2,8)  && CT1 function for True Shaddowing
  @ top_row,top_col,bot_row,bot_col BOX abs_single
  TONE(70,5)
  @ top_row,top_col+INT(wide/2)-1 SAY ' ERROR '
  @ bot_row-1,top_col+INT(wide-28)/2+3 SAY 'Press any key to continue...'
  SET CURSOR OFF
  MEMOEDIT(message,top_row+1,top_col+3,bot_row-2,bot_col-3,.T.,'ABERMEFU')
  RESTSCREEN(top_row,top_col,bot_row+1,bot_col+2,scerror)
  scerror=''
  SET COLOR TO (save_color)
  @ sav_row,sav_col SAY ''
RETURN
**************

FUNCTION ABERMEFU                       && Error & Message function to get out of MEMOEDIT
  PARAMETERS s,l,c
  IF c!=0 .OR. l!=1
    IF LASTKEY()=ctrl_w
      RETU(0)
    ENDIF
    KEYBOARD CHR(ctrl_w)
  ENDIF
RETURN(0)
**************

* KAW28.PRG
FUNCTION Y_N_ANSWER                     && Get yes or no using INKEY() not READ
  PARAMETERS y_n_mess,y_n_prompt
  PRIVATE new_str[12],tot_len,rows,nex_word,len_n_word,tot_len
  PRIVATE wide,top_row,top_col,bot_row,bot_col,i,sav_row,sav_col
  AFILL(new_str,'')
  sav_row=ROW()
  sav_col=COL()
  IF TYPE('y_n_prompt')='U'
    y_n_prompt='Y'
  ENDIF
  tot_len=0
  rows=1
  IF LEN(y_n_mess)>65
    DO WHILE .T.
      nex_word=N_WORD(@y_n_mess)
      len_n_wd=LEN(nex_word)
      IF EMPTY(len_n_wd)
        EXIT
      ENDIF
      IF tot_len+len_n_wd>65
        rows=rows+1
        tot_len=0
      ENDIF
      new_str[rows]=new_str[rows]+nex_word
      tot_len=tot_len+len_n_wd
    ENDDO
  ELSE
    new_str[rows]=y_n_mess
  ENDIF
  top_row=15-rows
  IF rows<2 .AND. LEN(y_n_mess)+4<68
    wide=LEN(y_n_mess)+4
    bot_row=top_row+rows+3
  ELSE
    wide=66
    bot_row=top_row+rows+4
  ENDIF
  IF wide<12
    wide=12
  ENDIF
  top_col=40-ROUND(wide/2,0)-2
  bot_col=top_col+wide+4
  WIN_PUSH(top_row,top_col,bot_row,bot_col)
  SET COLOR TO (c_title_&win_color)
  @ top_row,top_col+INT(wide/2)-3 SAY ' QUESTION ? '
  SET COLOR TO (c_scree_&win_color)
  FOR x=1 TO rows
    @ top_row+1+x,top_col+2 SAY new_str[x]
  NEXT
  ?? CHR(bell)
  _the_row=ROW()
  _the_col=COL()+2
  SET CURSOR ON
  DO WHILE .T.
    SET COLOR TO (c_varia_&win_color)
    @ _the_row,_the_col SAY y_n_prompt
    @ _the_row,_the_col SAY ''
    SET COLOR TO (c_scree_&win_color)
    i=INKEY(0)
    IF i=89 .OR. i=121                  && They said yes
      y_n_ans=.T.
      EXIT
    ELSEIF i=78 .OR. i=110              && They said NO
      y_n_ans=.F.
      EXIT
    ELSEIF i=rtn                        && Pressed <RTN>
      y_n_ans=IF(UPPER(y_n_prompt)='Y',.T.,.F.)
      EXIT
    ELSE
      DO ABERROR WITH 'please press Y or N to answer!'
      LOOP
    ENDIF
  ENDDO
  WIN_POP()
  @ sav_row,sav_col SAY ''
RETURN(y_n_ans)
**************

* KAW23.PRG
FUNCTION WIN_PUSH                       && Push a HELP window on the screen
  PARAMETERS h_t_row,h_t_col,h_b_row,h_b_col
  win_color=NXT_CLR_ST()
  h_count=h_count+1                     && Increment the window counter
  helppos[h_count]=TRANSFORM(h_t_row,'99')+TRANSFORM(h_t_col,'99')+;
  TRANSFORM(h_b_row,'99')+TRANSFORM(h_b_col,'99')
  h_color[h_count]=SETCOLOR(c_scree_&win_color+','+c_varia_&win_color)
  h_window[h_count]=SAVESCREEN(h_t_row,h_t_col,h_b_row+1,h_b_col+2)
  *COLORWIN(h_b_row+1,h_t_col+2,h_b_row+1,h_b_col+2,8)  && CT1 function for True Shaddowing
  *COLORWIN(h_t_row+1,h_b_col+1,h_b_row  ,h_b_col+2,8)  && CT1 function for True Shaddowing
  SET COLOR TO (c_bord_&win_color)
  @ h_t_row,h_t_col,h_b_row,h_b_col BOX (abs_single)
  SET COLOR TO (c_scree_&win_color)
RETURN(.T.)
**************

FUNCTION WIN_POP                        && Pop off the last HELP screen
  h_t_row=VAL(SUBSTR(helppos[h_count],1,2))
  h_t_col=VAL(SUBSTR(helppos[h_count],3,2))
  h_b_row=VAL(SUBSTR(helppos[h_count],5,2))
  h_b_col=VAL(SUBSTR(helppos[h_count],7,2))
  RESTSCREEN(h_t_row,h_t_col,h_b_row+1,h_b_col+2,h_window[h_count])
  SET COLOR TO (h_color[h_count])
  h_window[h_count]=''
  h_count=h_count-1
  win_color=LST_CLR_ST()
RETURN(.T.)
**************

* KAW13.PRG
FUNCTION NXT_COLOR                      && Generate the next WINDOW color as a NUMBER variable
RETURN(IF(cl_level<4,cl_level+1,1))
**************

FUNCTION LST_COLOR                      && Generate the last WINDOW color as a NUMBER variable
RETURN(IF(cl_level=1,4,cl_level-1))
**************

FUNCTION NXT_CLR_ST                     && Generate the next WINDOW color as a STRING variable
  num_color=VAL(win_color)
RETURN(LTRIM(STR(IF(num_color<4,num_color+1,1))))
**************

FUNCTION LST_CLR_ST                     && Generate the last WINDOW color as a STRING variable
  num_color=VAL(win_color)
RETURN(LTRIM(STR(IF(num_color=1,4,num_color-1))))
**************

* KAW15.PRG
FUNCTION N_WORD                         && Parsing function to return next word used in QUESTION()
  PARAMETERS _string,_separator
  IF EMPTY(_string)
    RETU('')
  ENDIF
  _user_sep=.T.
  IF PCOUNT()=1
    _separator=' '
    _user_sep=.F.
  ENDIF
  _location=AT(_separator,_string)
  rtn_str=IF(!EMPTY(_location),LEFT(_string,_location+IF(_user_sep,-1,0)),_string)
  _string=IF(!EMPTY(_location),SUBSTR(_string,_location+1),'')
RETURN(rtn_str)
**************

* KAW3.PRG
PROCEDURE MESSAGE                       && Print messages or notices
  PARAMETERS message,_title,w_color
  PRIVATE save_color,sav_row,sav_col,top_row,top_col,bot_row,bot_col
  sav_row=ROW()
  sav_col=COL()
  IF TYPE('w_color')='U'
    win_color=NXT_CLR_ST()
    w_color=win_color
    rest_win=.T.
  ELSE
    rest_win=.F.
  ENDIF
  IF w_color='0'                      && Use error colors
    save_color=SETCOLOR(c_error)
  ELSE
    save_color=SETCOLOR(c_scree_&w_color)
  ENDIF
  SET CURSOR OFF
  rows=ROUND((LEN(message)+33)/66,0)
  wide=IF(rows=1,IF(LEN(message)>28,LEN(message),28),66)
  top_row=12-INT(rows/2)
  top_col=40-INT(wide/2)-2
  bot_row=top_row+rows+3
  bot_col=top_col+wide+4
  scmess=SAVESCREEN(top_row,top_col,bot_row+1,bot_col+2)
  *COLORWIN(bot_row+1,top_col+2,bot_row+1,bot_col+2,8)  && CT1 function for True Shaddowing
  *COLORWIN(top_row+1,bot_col+1,bot_row  ,bot_col+2,8)  && CT1 function for True Shaddowing
  @ top_row,top_col CLEAR TO bot_row,bot_col
  IF w_color!='0'
    SET COLOR TO (c_bord_&w_color)
  ENDIF
  @ top_row,top_col TO bot_row,bot_col
  TONE(70,5)
  IF w_color!='0'
    SET COLOR TO (c_title_&w_color)
  ENDIF
  @ top_row,top_col+INT(wide-LEN(_title))/2+2 SAY ' '+ALLTRIM(_title)+' '
  IF w_color!='0'
    SET COLOR TO (c_scree_&w_color)
  ENDIF
  @ bot_row-1,top_col+INT(wide-28)/2+3 SAY 'Press any key to continue...'
  MEMOEDIT(message,top_row+1,top_col+3,bot_row-2,bot_col-3,.T.,'ABERMEFU')
  RESTSCREEN(top_row,top_col,bot_row+1,bot_col+2,scmess)
  scmess=''
  SET COLOR TO (save_color)
  IF rest_win
    win_color=LST_CLR_ST()
  ENDIF
  @ sav_row,sav_col SAY ''
RETURN
**************


********************************************************************
* The following functions are NOT necessary if you have "Clipper Tools One"!
* They are NOT total replacements for CT1 functions but work for the ADDER

FUNCTION COUNTLEFT                      && Returns the number of spaces on the 
  PRIVATE string,dummy                  && Left side of the String
  PARAMETERS string,dummy
RETURN(LEN(string)-LEN(LTRIM(string)))
**************

FUNCTION CHARREM                        && Removes character from string
  PRIVATE char,string
  PARAMETER char,string
RETURN(STRTRAN(string,char))
**************

FUNCTION POSREPL                        && Replace a Character in a String
  PRIVATE string,char,posit
  PARAMETER string,char,posit
RETURN(LEFT(string,posit-1)+char+SUBSTR(string,posit+1))
*RETURN(STRTRAN(string,'9',char,posit,1))  && For some reason STRTRAN doesn't work here
*                                             It messes up the PICTURE - Any Ideas
**************

FUNCTION POSINS                         && Insert a Character in a String
  PRIVATE string,char,posit
  PARAMETER string,char,posit
RETURN(LEFT(string,posit-1)+char+SUBSTR(string,posit))
*RETURN(STUFF(string,posit,1,char))
**************

