/*
   Program Name: PICKONE.PRG       Copyright: Rent Roll Inc. (c) 1992
   Date Created: 03/23/92          Language:  Clipper
   Time Created: 14:08:10          Author:    Stephen L. Woolstenhulme

Syntax:     PICKONE( [< cText >], < aPicks >,  [< nRow >], ;
            [< nWhich >], [< cColor >] )

Params:     cText  -  Character string to display along top of box.
                      Defaults to ''.

            aPicks -  Array of menu choices (make sure they will fit
                      within the box on a single line.

            nRow   -  Row on which to display choices.
                      Defaults to 21.

            nWhich -  The number of the first choice to highlight.
                      Defaults to 1.

            cColor -  Color string.
                      Default is 'w+/r, n/w ,,, w+/n'.

Purpose:    Draw a box with a bold border, a centered text line, and
            up to five horizontal menu choices.

Returns:    Number of selected array element.

Example:    nChoice := pickone('Quit?', {' Yes ', ' No '}, 20, 2, 'w+/rb' )

*/

function PickOne( cText, aPicks, nRow, nWhich, cColor )

   local nOffSet, nArrayLen, nSpace, nLcol, cScrn, nLen, i
   local getlist := {}
   memvar gcBoxColor
   nOffSet := len( cText ) / 2 + 2
   nArrayLen := 0
   nRow   := iif( nRow == Nil, 21, nRow )
   nWhich := iif( nWhich == Nil, 1, nWhich )

   if cColor == Nil
       if type( 'gcBoxColor' ) == 'C'
           cColor := gcBoxColor
       else
           cColor := 'w+/r, n/w ,,, w+/n'
       endif
   endif

   nRow := if( nRow > maxcol() - 1, maxcol() - 1, nRow )
   nRow := if( nRow < 2, 2, nRow )
   nLen := len( aPicks )

   for i := 1 to nLen
      nArrayLen += len( aPicks[ i ] )
   next

   if nArrayLen + len( aPicks ) - 1 >= len( cText )
      nSpace := 2
   else
      nSpace :=  ( len( cText ) - nArrayLen ) / ( len( aPicks ) + 1 )
   endif

   nLcol  := ( maxcol() / 2 + 1 ) - ;
               ( max( len( cText ), nArrayLen + nSpace * len( aPicks ) ) / 2 )
   cScrn  := savescreen( nRow - 3, 0, nRow + 3, maxcol() )
   cColor := SetColor( cColor )
   // Shadow( nRow-2, nLcol-2, nRow+1, 81 - nLcol )
   @ nRow - 2, nLcol - 2, nRow + 1, 81 - nLcol box "ͻȺ "
   @ nRow - 1, ( maxcol() / 2 ) - ( len( cText ) / 2 ) say cText
   nOffSet := ( maxcol() / 2 + 1 ) - ( nArrayLen + ( nSpace * ( len( aPicks ) + 1 ) ) ) / 2
   @ nRow, nOffSet say ""
   nLen := len( aPicks )

   for i=1 to nLen
      @ nRow, COL() + nSpace prompt aPicks[i]
   next

   menu to nWhich
   setcolor( cColor )
   restscreen( nRow - 3, 0, nRow + 3, maxcol(), cScrn )
return nWhich

