************************************
* Program Name: pickit.prg 
* Author: Larry D. Weldon 
* Copyright (c) 1989 by Weldon's Custom Software
*-----------------------------------------------------------------------------
* Created: 4/19/1989 at 18:57
* main = 
* Called From:
* --- Data Base Files ---   ----- Index Files -----   ----- Other Files ---- 
*
*
*
*.............................................................................
* Revision: 1.0 Last Revised: 4/19/1989 at 18:57
* Description: Original Creation.
*.............................................................................
* Usage: Pick list in a valid clause
*			The database, and index are USEd and SET INDEX TOed
*            if zero is passed, no index is used. This makes it impossible
*            to return on found; no seek can be done, so operator picks.
*        If the index is specified, a softseek is done on the 
*            variable ret_mvar. If found, .t. is returned. No action.
*        DBEDIT is called 
*        When dbedit returns, the record is at the choice, and RET_FLD is
*            placed in the address provided for RET_MVAR
*        RET_MVAR is a variable in the current GET and is passed by
*            reference (i.e. @memvar)
*        Just before the RETURN .T. the RET_MVAR is said at the current
*            GET row and column as passed in dmrow and dmcol
* Returns: .t. or .f. : currently only .t.
*---------------------------- ALL RIGHTS RESERVED ----------------------------

function pick
parameters data_base, data_index, search_fld, fill_fld, ;
            dmrow, dmcol, return_fld


* expL = pick(expC1, expC2, expC3, @memvar, row, col, expC4)
*             dbf    ntx    search, replace,  screen  replace with

* EX:  pick("accounts", "accounts", "m->name", @name, row(), col(), "name")
* database: accounts | index: accounts
* search data is in field: name. This will be expanded as a macro.
* where to put the returned value: &fill_fld = field_name_to_be_returned
* where to display the new value before return: row(), col()
* what should be returned: name (&fill_fld = &return_fld)

* returns true if a selection was made or if the contents of memvar are
* found in an indexed database. If the dbf is not indexed by an ntx of
* the expC2 name or ret_mvar is not found, provide a dbedit selection of
* the dbf fields as specified by expC3 dsplay_fld (may be complex).
* IMPORTANT!! Pass ret_mvar (@memvar) by reference with the @ sign, and
* set expC4 (ret_fld) to the NAME of the field you want. The actual data
* return is accomplished by placing the contents of ret_fld (at the dbedit
* selected record) into the address passed as the address of memvar.
* This function can be used as a valid function if implemented properly.


* There are really several things happening from call to return:
*     call pick in a valid function passing everything pick needs to:
*        - open a database and (possibly multiple) indexes
*        - search for data in the database which was already typed
*           (return .T. at this point if the data is found and valid)
*           (return .F. if you are ADDing data not yet appended to a
*            database where said data will not be UNIQUE).
*        - allow the operator to select a data record in dbedit
*        - fill in the field on the screen
*        - place the data selected into the memvar (passed by reerence)
*        - return .T. or .F. allows the valid clause to work correctly

* atbox and unbox dynamic allocation and deallocation for screens
extern boxes

* source file line display/debugging data
* public mprg
* mprg = "\tools\pickit.prg"
* altd()

* how big is the (character) field we're entering/editing
len_retvar = len(fill_fld)

* keep track of where we were
pk_alias = alias()

* We either got a complex expression or a single field name to seek on.
* Here we take advantage of Clipper's pseudo public variables which are
* always available downstream.
* You might pass     ..., "m->name+m->phone", ...
* What you have to be careful of is using a field from a dbf record as 
* the search instead of the memvar duplicate you really wanted to use.
if "+" $ search_fld .or. "m->" $ search_fld
   seeker = &search_fld
else
   * ... or you might pass just ..., "name", ...
   seeker = m->&search_fld
endif

* we need to extract just the database name for is_used to get the alias.
dbf_file = substr(data_base, rat("\", data_base) + 1)

* cycle through all aliases for this one. Is it used?
if is_used(dbf_file)
   select &dbf_file
   * remember where we were
   was_used = .t.
   go_back = recno()
else
   select 0
   use &data_base alias tempdbf
   was_used = .f.
endif

* do we seek and how are we going to do it
do_seek = .f.

* numeric indexes would pose problems
if type("data_index") != "N"
   * only one index is to be used
   if !","$data_index
      * it is not a complex index (cindex)
      cindex = .f.
      data_index = strip_extension(data_index) + ".ntx"
	   if file(data_index)
		   if !was_used
            set index to &data_index
         endif
		   do_seek = .t.
	   endif
   else
      * more than one index is needed so parse them out
      * this is useful if valid criteria is in one order (for seeking)
      * but the data used for picking is in another order (for scanning)
      * EX. account number is to be entered, but who cares; I only know the
      *     account name! set order to 2 will be used before the pick
      cindex = .t.
      di1 = substr(data_index, 1, at(",", data_index) - 1)
      di2 = substr(data_index, at(",", data_index) + 1)
      di1 = di1 + ".ntx"
      di2 = di2 + ".ntx"
      if file(di1) .and. file(di2)
		   if !was_used
            set index to &di1, &di2
         endif
         do_seek = .t.
      endif
   endif
endif

* OK, should we seek, or just provide the pick?
if do_seek
   * use softseek so if they did make a partial entry we'll be in
   * the ballpark
	set softseek on
	seek seeker
	set softseek off
endif

* where should we put the pick box; we don't want to cover up the
* screen stuff where we are now.
te = iif(row() >= 12, 1, 12)
be = te + 8
le = iif(col() >= 39, 1, 34)
re = le + 44

* make an array so dbedit has some field names to work with
public fldnams[fcount()]
nflds = afields(fldnams)

* we did a seek earlier or they haven't entered any character at all
* if it was found, it's valid! (unless it was empty)
if !found() .or. empty(&search_fld)
   * save the screen portion and place the pick box
   atbox(te -1, le -1, be +1, re +1)
   * complex index is neccessary in some cases where data entry within
   * the 'dbed_func' is allowed. You may want two indexes updated.
   if cindex
      set order to 2
   endif

   * dbed_func can be tailored to exact needs
   dbedit(te, le, be, re, fldnams, "dbed_func")
   set order to 1
   * restore the screen as it was before pick
   unbox()
endif

* get rid of the field names array
release fldnams

* user wants to bail out, maybe they spelled a new entry wrong
* in any event, it's not valid
if lastkey() = 27
   _pick_ret = .f.
else
   * because we were passed the address pointer to the memvar in fill_fld
   * and the name of the field we want returned.
   fill_fld = &return_fld
   * put the returned value on the screen
   @ dmrow, dmcol - len_retvar say fill_fld
   * set up the valid clause return (actual)
   _pick_ret = .t.
endif

* was the database in use before it ended up here?
if was_used
   go go_back
else
   * if we opened the database
   use
endif

* now... where were we?
select &pk_alias

* return the .T. or .F. the valid clause requires!
return _pick_ret



***************************************************
function dbed_func		&& used by any dbedit or by editdb()
parameters mode,fld_num

* what is the current field?
private cur_field
cur_field = field(fld_num)

* what did they try to do?
lk = lastkey()

* where on the screen are we?
row1 = row()
col1 = col()

set cursor off

* what to do...
do case
	case mode = 0		&& idle state
		return 1
	case mode = 1		&& bof
		return 1
	case mode = 2
		return 1
	case mode = 3
		return 1

   *  we only care about mode 4 - key exception not handled by dbedit
	case lk = 294	&& Alt-L   && L locate
		save screen to dbed_sc1
      * locate any data from the selected dbf for the pick
		locate_it()
		clear
		restore screen from dbed_sc1
		return 2
	case lk = 305	&& Alt N   && N continue locate
		continue
		return 2
	case lk = 27  && escape from edit
		return 0
	case lk = 22  && insert a record with Ins key
      * this is used for addition of new entries; you could go to
      * a complete data entry screen for the current database!
      if !empty(fill_fld)
   		append blank
         * at least put in what we already typed
         replace &return_fld with fill_fld
         * you would add your data entry here -----------------------
      endif
		return 1
   case lk = 13
      return 0
	otherwise   && if an alpha or numeric key do an entry
      if answer("Do you really want to edit this field? ")
		   do case
			   case LK<48 .OR. LK>123
				   RETURN 1
			   case LK>57 .AND. LK<65
				   RETURN 1
			   case LK>90 .AND. LK<97
				   RETURN 1
		   endcase
		   KEYBOARD chr(lk)
		   set cursor on
         cur_cont = &cur_field
         if type("cur_cont") == "C"
   		   new_cont = get_string (row(), col(), cur_cont, len(cur_cont))
            replace &cur_field with new_cont
         endif
         if type("cur_cont") == "N"
   		   new_cont = val(get_string (row(), col(), cur_cont, 10))
            replace &cur_field with new_cont
         endif
         if type("cur_cont") == "D"
   		   new_cont = ctod(get_string (row(), col(), cur_cont, 8))
            replace &cur_field with new_cont
         endif
         if type("cur_cont") == "L"
   		   new_cont = iif(upper(get_string (row(), col(), cur_cont, 1)) = "Y", ;
               .t., .f.)
            replace &cur_field with new_cont
         endif
		   set cursor off
		   return 1
      endif
      return 1
	endcase
   @row1,col1 say &cur_field
return 1



