 /*
   PICKFILE.PRG
   
   Author     : Phil Barnett
   
   Written    : 04/18/93
   
   Function   : Pops a picklist of files.
   
   Purpose    : Generic file picking routine.
   
   Syntax     : PICKFILE( [FILESPEC] )
   
   Parameters : FILESPEC is a DOS filename. Wildcards permitted
   
   Returns    : Character file name of selected file or "" if nothing picked.
   
   Example    : yourfile := pickfile( '*.dbf' )
   
                if empty(yourfile)
                  ? 'You pressed Escape or No Matching File'
                else
                  ? 'The file you selected is: '+yourfile
                endif
   
   Released to Public Domain by Author.             
                
*/

#xcommand DEFAULT <foo> TO <bar> => ;
          IF <foo> == NIL ; <foo> := <bar> ; ENDIF

#include "box.ch"
#include "directry.ch"

********************

function pickfile( cFileSpec )

local cOldString := savescreen(8, 19, 16, 61)
local aFiles := directory( cFileSpec )
local aPickList := {}
local cRetVal := ''

default cFileSpec to '*.*'

DispBox( 8, 19, 16, 61, B_SINGLE + " ", "+W/R" )
  
IF LEN( aFiles ) > 0

  AEVAL( aFiles, {|xx| aadd( aPickList, ;
                        pad( xx[ F_NAME ],13 ) + ;
                        str( xx[ F_SIZE ],8 ) + '  ' + ;
                       dtoc( xx[ F_DATE ] ) + '  ' + ;
                             xx[ F_TIME ] ) } )
                             
  sel := achoice( 9, 20, 15, 60, aPickList)
  
  cRetVal := iif( lastkey() == 27, '', aFiles[ sel ][ 1 ] )
  
else

  sel := achoice( 9, 20, 15, 60, { "No files match " + cFileSpec } )
  
ENDIF

restscreen(8, 19, 16, 61, cOldString)

Return cRetVal

