/*
 * File......: PICKDATE.PRG
 * Author....: Berend M. Tober
 * CIS ID....: 70541,1030
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Berend M. Tober and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FT_PICKDATE()
 *  $CATEGORY$
 *     Date string selection menu.
 *  $ONELINER$
 *     Pop-up achoice menu for setting date format.
 *  $SYNTAX$
 *     FT_PICKDATE( [<nTop>], [<nCol>], [<cColor>] ) -> cDateFormat
 *  $ARGUMENTS$
 *       <nTop>      - Top row of menu box.
 *       <nCol>      - Left edge column of menu box.
 *       <cColor>    - Menu color definition string.
 *  $RETURNS$
 *     cDateFormat - The date format string.
 *  $DESCRIPTION$
 *     This function is valuable if you want to offer users the option
 *     of easily selecting the date format in your applications. It
 *     works by creating an ACHOICE menu of twelve different date
 *     formats.  The routine attempts to find the currently set format
 *     amongst the twelve options and positions the cursor accordingly.
 *     The selected format is set as well as returned to the calling
 *     program.  I generally make a call to this routine as one of the
 *     options on my 'SET USER CONFIGURATION' menu selection.
 *  $EXAMPLES$
 *     cDateFormat := FT_PICKDATE()          // Offers centered menu
 *                                           // and returns the setting
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *     box.ch
 *  $END$
 */


*************************************************************************
* File: PICKDATE.PRG -- Created by Berend M. Tober 1994/03/13
*************************************************************************
*
*  Displays ACHOICE menu of date formats and sets to selected format
*
*  Calling syntax:
*
*  FT_PICKDATE( [<nTop>], [<nCol>], [<cColor>] ) -> cDateFormat
*
*  Parameters:
*
*    <nTop>      - Top row of menu box.
*    <nCol>      - Left edge column of menu box.
*    <cColor>    - Menu color definition string.
*
*  Returns:
*    cDateFormat - Date format string.

#include "box.ch"

#ifdef FT_TEST    // Sample test program
PROCEDURE TEST()
   CLEAR SCREEN

   DO WHILE LASTKEY() <> 27   // Quit on ESC

      FT_PICKDATE()

      SETPOS( MAXROW(), 0 )
      QQOUT( SPACE(MAXCOL()) )
      SETPOS( MAXROW(), 0 )
      QQOUT( "THE DATE IS "+DTOC( DATE() ))
   ENDDO

   QUIT
   RETURN
#endif

**************** FT_PICKDATE( nTop, nCol, cColor ) ****************
FUNCTION FT_PICKDATE( nTop, nCol, cColor )

   * Displays pop-up menu to select CA date formats
   LOCAL aFormat :=  {;
            "dd-mm-yy"  , ;
            "dd-mm-yyyy", ;
            "dd.mm.yyyy", ;
            "dd/mm/yyyy", ;
            "mm-dd-yy"  , ;
            "mm-dd-yyyy", ;
            "mm/dd/yy"  , ;
            "mm/dd/yyyy", ;
            "yy.mm.dd"  , ;
            "yyyy-mm-dd", ;
            "yyyy.mm.dd", ;
            "yyyy/mm/dd"  ;
            }
   LOCAL cOldScrn    := SAVESCREEN()
   LOCAL lOldExact   := SET(_SET_EXACT, .T.)
   LOCAL cOldColor   := SETCOLOR( IF( cColor == NIL, "N/W, W/N", cColor) )
   LOCAL nHigh       := LEN( aFormat )
   LOCAL nWide       := LEN( aFormat[1] )
   STATIC nFormat

   * Find longest date format string.
   AEVAL( aFormat, {|x| nWide := MAX(nWide, LEN(x) )} )

   * Default box position is center of screen
	nTop := IF( nTop = NIL, MAX(INT( 0.5*( MAXROW()-nHigh ) ),4), nTop )
	nCol := IF( nCol = NIL, MAX(INT( 0.5*( MAXCOL()-nWide ) ),4), nCol )

   * Determine array element number of current date format, if any
   nFormat := ASCAN( aFormat, SET ( _SET_DATEFORMAT ) )


   DISPBOX( nTop-1, nCol-1, (nTop+nHigh), (nCol+nWide), B_SINGLE+" ")

   nFormat := ACHOICE( nTop, nCol, nTop+nHigh-1, nCol+nWide-1, aFormat,,,nFormat, )

   IF nFormat > 0
      SET(_SET_DATEFORMAT, aFormat[nFormat])
   ENDIF
   SETCOLOR( cOldColor )
   SET(_SET_EXACT, lOldExact)
   RESTSCREEN(,,,,cOldScrn)
   RETURN IIF( nFormat > 0, aFormat[nFormat], NIL )
* end of FUNCTION FT_PICKDATE( nTop, nCol, cColor )
