                IDEAL

PUBLIC          MOUSE_INIT
PUBLIC          MOUSE_ON
PUBLIC          MOUSE_OFF
PUBLIC          MOUSE_POS
PUBLIC          MOUSE_MCHK
PUBLIC          MOUSE_MON
PUBLIC          MOUSE_MOFF

EXTRN           __parni:FAR
EXTRN           __storni:FAR
EXTRN           __retl:FAR


;*** define keys to insert based on mouse conditions.
;
     MOUSE_KEY           equ 4C00H     ; numpad 5 Mouse Event!

;*** Define keyboard buffer area.
;
segment BIOS_DATA at 40h
org             1ah
BUFFER_HEAD     dw      ?       ; pointer to the keybord
                                ; buffer head
BUFFER_TAIL     dw      ?       ; pointer to the keyboard
                                ; buffer tail
org             80h
BUFFER_START    dw      ?       ; starting keyboard buffer address
BUFFER_END      dw      ?       ; ending keyboard buffer address
ends    BIOS_DATA

SEGMENT         PH_CODE         'CODE'
                ASSUME CS:PH_CODE


                ; (yes I know it is in the Code Segment!)

GOOD_MOUSE      DW      0       ; indicates if mouse has been reset before
MOUSE_BUT       DW      0
MOUSE_ROW       DW      0
MOUSE_COL       DW      0


PROC            MOUSE_INIT      FAR

                push    bp              ; Save registers
                mov     bp,sp
                push    ds
                push    es
                push    si
                push    di

                ; Chk for the mouse driver!
                mov     ax,3533h
                int     21h

                xor     dx,dx           ; assume the worst (return dx)

                or      bx,bx
                jne     @@Chk_IRET
                mov     ax,es
                or      ax,ax
                je      @@Done

@@Chk_IRET:
                mov     ax,[ES:BX]
                cmp     ax,0cfh         ; IRET
                je      @@Done          ; Bad news nothing their!

                ; it looks like we have a mouse!
                xor     ax,ax
                int     33h
                or      ax,ax           ; zero means their is no mouse!
                je      @@Done          ; man am I confused!

                mov     [cs:GOOD_MOUSE],1
                inc     dx

@@Done:
                push    dx
                CALL    __retl          ; up the routine (extended interface)
                ADD     SP,2

                pop     di              ; Restore registers
                pop     si
                pop     es
                pop     ds
                pop     bp

                ret

ENDP            MOUSE_INIT              ; End of routine


PROC            MOUSE_ON        FAR

                push    bp              ; Save registers
                mov     bp,sp
                push    ds
                push    es
                push    si
                push    di

                ; Chk for the mouse driver!
                MOV     AX,[CS:GOOD_MOUSE]
                OR      AX,AX
                JNE     @@OK            ; I have already checked before

                xor     bx,bx           ; return to Clipper a .F. to tell
                JMP     @@Done          ; the prg the bad news

@@OK:
                MOV     AX,1
                INT     33H             ; Mouse on

                inc     bx              ; return to Clipper a .T. to tell

@@Done:
                PUSH    BX              ; it that MOUSE_ON() succeeded
                CALL    __retl          ; up the routine (extended interface)
                ADD     SP,2

                pop     di              ; Restore registers
                pop     si
                pop     es
                pop     ds
                pop     bp

                ret

ENDP            MOUSE_ON                ; End of routine


PROC            MOUSE_OFF       FAR

                push    bp              ; Save registers
                mov     bp,sp
                push    ds
                push    es
                push    si
                push    di

                ; Chk for the mouse driver!
                MOV     AX,[CS:GOOD_MOUSE]
                OR      AX,AX
                JNE     @@OK            ; I have already checked before

                xor     bx,bx           ; return to Clipper a .F. to tell
                JMP     @@Done          ; the prg the bad news

@@OK:
                MOV     AX,2
                INT     33H             ; Mouse off

                inc     bx              ; return to Clipper a .T. to tell

@@Done:
                PUSH    BX              ; it that MOUSE_ON() succeeded
                CALL    __retl          ; up the routine (extended interface)
                ADD     SP,2

                pop     di              ; Restore registers
                pop     si
                pop     es
                pop     ds
                pop     bp

                ret

ENDP            MOUSE_OFF               ; End of routine


PROC            MOUSE_POS       FAR

                push    bp              ; Save registers
                mov     bp,sp
                push    ds
                push    es
                push    si
                push    di

                ; Chk for the mouse driver!
                MOV     AX,[CS:GOOD_MOUSE]
                OR      AX,AX
                JNE     @@OK            ; I have already checked before

                xor     bx,bx           ; return to Clipper a .F. to tell
                JMP     @@Done          ; the prg the bad news

@@OK:
                MOV     AX,3
                INT     33H             ; Get Mouse Pos (AX still = 1)

                MOV     AX,3            ; Push the Button Stat parm pos
                PUSH    AX
                PUSH    BX              ; Push the Button Stat

                DEC     AX
                PUSH    AX              ; Push mouse_col parm pos
                SHR     CX,1
                SHR     CX,1
                SHR     CX,1
                PUSH    CX              ; Push the mouse col

                DEC     AX
                PUSH    AX              ; Push mouse_row parm pos
                SHR     DX,1
                SHR     DX,1
                SHR     DX,1
                PUSH    DX              ; Push mouse row
                CALL    __storni        ; Save the Button Stat variable
                ADD     SP,4
                CALL    __storni        ; Save the mouse col variable
                ADD     SP,4
                CALL    __storni        ; Save the mouse row variable
                ADD     SP,4

                MOV     BX,1            ; Every thing worked!

@@Done:
                PUSH    BX              ; it that MOUSE_ON() succeeded
                CALL    __retl          ; up the routine (extended interface)
                ADD     SP,2

                pop     di              ; Restore registers
                pop     si
                pop     es
                pop     ds
                pop     bp

                ret

ENDP            MOUSE_POS               ; End of routine


PROC            MOUSE_MCHK      FAR

                push    bp              ; Save registers
                mov     bp,sp
                push    ds
                push    es
                push    si
                push    di

                ; Chk for the mouse driver!
                MOV     AX,[CS:GOOD_MOUSE]
                OR      AX,AX
                JNE     @@OK            ; I have already checked before

                xor     bx,bx           ; return to Clipper a .F. to tell
                JMP     @@Done          ; the prg the bad news

@@OK:
                mov     ax,1
                push    ax
                PUSH    [CS:MOUSE_ROW]
                call    __storni
                add     sp,4

                mov     ax,2
                push    ax
                PUSH    [CS:MOUSE_COL]
                call    __storni
                add     sp,4

                mov     ax,3
                push    ax
                PUSH    [CS:MOUSE_BUT]
                call    __storni
                add     sp,4

                ; clear out values for next call!
                mov     [CS:MOUSE_BUT],0
                mov     [CS:MOUSE_COL],0
                mov     [CS:MOUSE_ROW],0

                mov     bx,1
@@Done:
                PUSH    bx
                CALL    __retl
                ADD     SP,2

                pop     di              ; Restore registers
                pop     si
                pop     es
                pop     ds
                pop     bp

                ret

ENDP            MOUSE_MCHK              ; End of routine


; MOUSE_MON (mouse mask)
;   set up interrupt routine to control the mouse flag
;
PROC            MOUSE_MON       FAR

                push    bp              ; Save registers
                mov     bp,sp
                push    ds
                push    es
                push    si
                push    di

                ; Chk for the mouse driver!
                MOV     AX,[CS:GOOD_MOUSE]
                OR      AX,AX
                JNE     @@OK            ; I have already checked before

                xor     bx,bx           ; return to Clipper a .F. to tell
                JMP     @@Done          ; the prg the bad news

@@OK:
                ; first turn on the cursor
                MOV     AX,1
                INT     33h             ; should turn on the cursor

                MOV     AX,SEG MOUSE_INT ;tell function 12 where to find the
                MOV     ES,AX           ; the mouse routine
                MOV     DX,OFFSET MOUSE_INT
                MOV     AX,12           ; use function 12
                MOV     CX,0101010B     ; set up the mask for buttons
                                        ; and cursor

                INT     33H             ; set it up!

                MOV     BX,1            ; return a .T. to Clipper to tell it

@@Done:
                PUSH    BX              ; that the installation was successful
                CALL    __retl          ; (using Clipper's extended interface)
                ADD     SP,2

                pop     di              ; Restore registers
                pop     si
                pop     es
                pop     ds
                pop     bp

                ret

ENDP            MOUSE_MON


PROC            MOUSE_MOFF      FAR

                push    bp              ; Save registers
                mov     bp,sp
                push    ds
                push    es
                push    si
                push    di

                ; Chk for the mouse driver!
                MOV     AX,[CS:GOOD_MOUSE]
                OR      AX,AX
                JNE     @@OK            ; I have already checked before

                MOV     BX,0            ; return to Clipper a .F. to tell
                JMP     @@Done          ; the prg the bad news

@@OK:
                MOV     AX,SEG MOUSE_INT ;tell function 12 where to find the
                MOV     ES,AX           ; the mouse routine
                MOV     DX,OFFSET MOUSE_INT
                MOV     AX,12           ; use function 12
                MOV     CX,0            ; clear the mouse mask

                INT     33H             ; set it up!

                ; now turn off the cursor
                MOV     AX,2
                INT     33h             ; should turn off the cursor

                MOV     BX,1            ; return to Clipper a .T. to tell

@@Done:
                PUSH    BX              ; it that MOUSE_ON() succeeded
                CALL    __retl          ; up the routine (extended interface)
                ADD     SP,2

                pop     di              ; Restore registers
                pop     si
                pop     es
                pop     ds
                pop     bp

                ret

ENDP            MOUSE_MOFF


PROC            MOUSE_INT       FAR

                ; save the mouse state for recall
                mov     [CS:MOUSE_BUT],bx

                SHR     CX,1
                SHR     CX,1
                SHR     CX,1
                mov     [CS:MOUSE_COL],cx

                SHR     DX,1
                SHR     DX,1
                SHR     DX,1
                mov     [CS:MOUSE_ROW],dx

                MOV     AX,MOUSE_KEY
                CALL    INSERT

                ret

ENDP            MOUSE_INT               ; End of routine



; INSERT - procedure to insert keys into keyboard buffer
proc            INSERT          near
                mov     bx,BIOS_DATA    ; point DS to the BIOS data area
                mov     ds,bx           ;
                assume  ds:BIOS_DATA    ;
                cli                     ; disable interrupts
                mov     bx,[BUFFER_TAIL] ; get buffer tail address
                mov     dx,bx           ; transfer it to DX
                add     dx,2            ; calculate next buffer position
                cmp     dx,[BUFFER_END] ; did we overshoot the end?
                jne     @@ENDOFBUF      ; no, then continue
                mov     dx,[BUFFER_START] ; yes, then wrap to start
                                        ; of buffer
@@ENDOFBUF:
                cmp     cx,[BUFFER_HEAD] ; is the buffer full?
                je      @@Done           ; yes, then end now
                mov     [bx],ax          ; insert the keycode
                mov     bx,dx            ; advance the tail
                mov     [BUFFER_TAIL],bx ; record its new position

@@Done:
                sti                      ; enable interrupts
                assume  ds:nothing       ;
                ret                      ; exit user sub-routine
endp            INSERT


ENDS            PH_CODE                 ; End of code segment
                END


