;-----------------------------------------------------------------------------
; NUMFILES reports the number of SFT entries created to record the state
; of open files, and thus the setting of FILES= in CONFIG.SYS.
;
; Compile with Microsoft MASM 5.0 or Borland TASM
;         MASM numfiles
;         TASM numfiles
;
; Link the numfiles.OBJ file with your Clipper linker.
;         CLIPPER prog
;         BLINKER OUTP prog FILE prog,numfiles LIB clipper
;
; Clipper Syntax:  lfiles = NUMFILES()
;
; NUMFILES 1.0 Copyright (c) 1991 Jeff Prosise
; First published in PC Magazine, November 12, 1991
;
; Adopted for use in Clipper by: Per Kjellqvist   CIS 71540,2311
;----------------------------------------------------------------------------

public          NUMFILES

extrn           __retni:far

_prog           segment 'CODE'
                assume  cs:_prog

NUMFILES        proc    far

                push    bp                      ; preserve BP reg
                mov     bp,sp                   ; BP point to stack
                push    ds                      ; must save regs
                push    es                      ;
                push    si                      ;
                push    di                      ;

                xor     cx,cx                   ; Zero SFT entry count
                mov     ah,52h                  ; Get address of DOS's List
                int     21h                     ;     of Lists
                mov     di,es:[bx+4]            ; Place address of first SFT
                mov     es,es:[bx+6]            ;     header in ES:DI
;
; Walk the chain of SFT headers counting the number of entries in each block.
;
mloop:          add     cx,es:[di+4]            ; Add number of SFT entries
                                                ;     in this block
                mov     bx,es:[di]              ; Place address of next SFT
                mov     es,es:[di+2]            ;     header in ES:DI and loop
                mov     di,bx                   ;     if the offset address
                cmp     di,0FFFFh               ;     isn't equal to FFFFh
                jne     mloop
;
; Send return value, restore registers and exit
;
                push     cx                     ; push return value
                call     __retni                ; and return it to CLIPPER
                add      sp,2                   ; fix up the stack

                pop     di                      ; restore regs
                pop     si                      ;
                pop     es                      ;
                pop     ds                      ;
                pop     bp                      ;
                ret                             ; far return to CLIPPER

NUMFILES        endp

_prog           ends
                end
