
 ****************************************************************************
 * Name:      Lockout.prg                                                   *
 * Task:      Demontration on record lockout using an array                 *
 *                                                                          *
 * Function:  ULOCK     select records to lockout                           *
 *            URECALL   select records to recall                            *
 *                                                                          *
 ****************************************************************************
USE lockout

PRIV Afilter[LASTREC()], lline[1]
******************************************************************************
SET CURSOR OFF
CLEAR
@  1,0 TO 24,79
@  4,9 TO 16,21 DOUB
SET COLO TO n/w
@ 1,30 SAY " RECORD LOCKOUT DEMO "
@ 24,1 SAY "Options: [F9]-Recall records              [RETURN]-Lock out record  [ESC]-Quit"
@ 3,11 SAY "DATABASE"
SET COLO TO w/n

AFILL(Afilter,.T.)
SET FILT TO Afilter[RECNO()]
GO TOP
lline[1] = "name"
DBEDIT(5,10,15,20,lline,"ULOCK","","",""," ","")
RETU

*-----------------------------------------------------------------------------
FUNC ULOCK
PARA lmode
PRIV lreturn, linkey, lscreen

linkey = LASTKEY()
lreturn = 1
DO CASE
   CASE lmode = 4 .AND. linkey = 13   && [RETURN]
        Afilter[RECNO()] = .F.
        GO TOP
        lreturn=2
   CASE lmode = 3 .OR. (lmode = 4 .AND. linkey = -8) && [F9]
        SET FILT TO ! Afilter[RECNO()]
        GO TOP
        IF !EOF()
           SAVE SCREEN TO lscreen
           @  4,39 TO 16,51 DOUB
           SET COLO TO n/w
           @ 24,1 SAY "Options:                                     [RETURN]-recall record [ESC]-Quit"
           @ 3,42 SAY "RECALL"
           SET COLO TO w/n
           DBEDIT(5,40,15,50,lline,"URECALL","","",""," ","")
           RESTORE SCREEN FROM lscreen
        ENDI
        SET FILT TO Afilter[RECNO()]
        GO TOP
   CASE lmode = 4 .AND. linkey = 27   && [ESC]
        lreturn=0
ENDC
RETU lreturn

*-----------------------------------------------------------------------------
FUNC URECALL
PARA lmode
PRIV lreturn, linkey

linkey = LASTKEY()
lreturn = 1
DO CASE
   CASE lmode = 3
        GO TOP
        lreturn = 0
   CASE lmode = 4
        DO CASE
           CASE linkey = 13   && [RETURN]
                Afilter[RECNO()] = .T.
                GO TOP
                lreturn=2
           CASE linkey = 27   && [ESC]
                GO TOP
                lreturn=0
       ENDC
ENDC
RETU lreturn
