
 ****************************************************************************
 * Name:      Per_Rest.prg                                                  *
 * Task:      Restore files from removable media                            *
 *                                                                          *
 * Function:  HREST()    New disk                                           *
 *            HPROMPT()  Text on line 24                                    *
 *            HSORRY()   Popup window                                       *
 * Procedure:                                                               *
 *            HSTAT     Display copying progress                            *                                  *
 * Local:                                                                   *
 *            lrow      display pointer                                     *
 *            lclm      display pointer                                     *
 *            lbyte_tot bytes to be copied                                  *
 *            lbyte_cop bytes copied                                        *
 *            lfile_no  file number (ARRAY pointer)                         *
 *            lname     name of file without extension                      *
 *            lback     name of file with .bak extension                    *
 *            linfile   F handle                                            *
 *            loutfile  F handle                                            *
 *            lxx       temporary                                           *
 *            lread     read value and bytes read                           *
 *            lwrite    bytes written                                       *
 *            ldrive    drive to backup to                                  *
 *            ldisk_no  disk number in use                                  *
 *            linc      no of bytes copied each time round the loop         *
 *            lbuffer   text buffer                                         *
 *            lpos      position in input file relative to 0                *
 *            lexit     logical counter                                     *
 *            lbackno   a number given a backup set                         *
 *            ARcopy[]  array with file names of each disk                  *
 ****************************************************************************

PRIV lrow,lclm,lbyte_tot,lbyte_cop,lfile_no,linfile,lxx,lread,ldrive,lbackno,;
     ldisk_no,linc,lbuffer,loutfile,lpos,lexit,lwrite,lname,lback,lscreen

PRIV PX_disk,PX_number,PX_byte

******************************************************************************
SET CURSOR OFF
CLEAR
@  1,0  TO 24,79
@  6,40 TO 23,75
@ 13,40 TO 13,75
SET COLO TO n/w
@ 1,2 SAY " RESTORE FILES FROM REMOVABLE MEDIA "
@ 6,42 SAY " STATUS "
SET COLO TO w/n
@ 13,40 SAY ""
@ 13,75 SAY ""

@  3,5  SAY "Source Drive........"
@  4,5  SAY "Target Drive/path..."
@  8,42 SAY "Estimated Time......"
@  9,42 SAY "Bytes to Copy......."
@ 11,42 SAY "Bytes Copied........"
@ 12,42 SAY "Completed...........           %"


*******************************************************************************
DO WHIL .T.
   lpath   = "C:\"+CURDIR()+"\"
   lpath   = lpath+SPAC(30-LEN(lpath))
   ldrive  = "A"
   HPROMPT("Enter Source: path and file info, Target drive                      [ESC]-Quit")
   @ 3,27 GET ldrive PICT "@A !"
   @ 4,27 GET lpath
   SET CURSOR ON
   READ
   SET CURSOR OFF
   lpath=TRIM(lpath)
   IF ! ldrive $"AB"
     HSORRY("SORRY, Drive does not contain a removable media")
   ELSE
     lxx = FCREATE(lpath+"temp")
     IF lxx = -1
        HSORRY("Sorry, Target drive and path not found")
     ELSE
        FCLOSE(lxx)
        ERASE &lpath.temp
        EXIT
     ENDI
   ENDI
ENDD

IF LASTKEY()<>27

 lrow      = 8
 lclm      = 5
 lbackno   = 0
 linc      = 1024
 lback     = ""
 lname     = ""
 lbyte_tot = 0
 lbyte_cop = 0
 ldisk_no  = 1

 DO WHIL .T.
    lscreen  = SAVESCREEN(21,0,23,79)
    lxx = "PLEASE Put Backup Disk No ["+STR(ldisk_no,2)+"] in Source drive ["+ldrive+"]"
    @ 21,(76-LEN(lxx))/2,23,(82+LEN(lxx))/2 BOX ""
    @ 22,(80-LEN(lxx))/2 SAY lxx

    HPROMPT("Wait Mode:                 Press ANY KEY to Continue                [ESC]-Quit")
    IF INKEY(0)=27     && WAIT
       RESTSCREEN(21,0,23,79,lscreen)
       EXIT            && --------> [ESC]
    ELSE
       HPROMPT("Backup:                       DISK ACCESS                           [ESC]-Quit")
       IF FILE(ldrive+":per_back.mem")
          REST FROM &ldrive.:per_back.mem ADDI
          IF PX_disk = ldisk_no
             IF (PX_number=lbackno).OR.ldisk_no=1  && ALL CONTROLS PASSED
                IF ldisk_no = 1
                   lbyte_tot = PX_byte     && bytes to copy
                   lbackno   = PX_number
                   DO HSTAT
                ENDI
                PRIV ARcopy[ADIR(ldrive+":*.*")]
                ADIR(ldrive+":*.*",ARcopy)
                RESTSCREEN(21,0,23,79,lscreen)
                IF HREST()   &&--------> DO DISK READ ROUTINE
                   EXIT
                ENDI
                ldisk_no = ldisk_no+1            && increment disk number
             ELSE
                HSORRY("Sorry, The diskette does not belong to this backup set")
             ENDI
          ELSE
             HSORRY("Sorry, This is not the correct disk number")
          ENDI
       ELSE
          HSORRY("Sorry, No disk in drive or Not a backup disk")
       ENDI
    ENDI
 ENDD

 IF lbyte_cop <> lbyte_tot   && ESCAPED while restore not complete
    ERASE &lpath.&lname
    RENAME &lpath.&lback TO &lpath.&lname
    lbyte_cop = lbyte_cop-lpos
    DO HSTAT
    @ lrow,lclm+12 SAY " -"
 ENDI

ENDI

SET CURS ON
CLEAR
RETU

******************************************************************************
******************************************************************************
FUNC HREST      && restore files from one disk

lexit = .F.

FOR lfile_no = 2 TO LEN(ARcopy)   && (skips 1 -> per_back.mem)

    IF lname = ARcopy[lfile_no]                     && APPEND TO FILE
       loutfile = FOPEN(lpath+lname,2)
       FSEEK(loutfile,0,2)   && move to end of file
    ELSE                                            && MAKE NEW FILE
       IF lbyte_cop > 0
          @ lrow,lclm+12 SAY " "
          lclm=IF(lrow<>22,lclm,IF(lclm=23,5,23))
          lrow=IF(lrow<>22,lrow+1,8)
       ENDI
       ERASE &lpath.&lback
       lname = ARcopy[lfile_no]
       IF FILE(lpath+lname)
          lback = LEFT(lname,LEN(lname)-4)+".bak"
          RENAME &lpath.&lname TO &lpath.&lback
       ENDI
       loutfile = FCREATE(lpath+lname)             && Create the target file
       @ lrow,lclm SAY lname
       SET COLO TO *w/n
       @ lrow,lclm+12 SAY " *"
       SET COLO TO w/n
    ENDI

    linfile  = FOPEN(ldrive+":"+lname)      && Open the source file
    lbuffer  = SPAC(linc)
    lpos     = 0

    DO WHIL .T.
       lread     = FREAD(linfile,@lbuffer,linc)
       lwrite    = FWRITE(loutfile,lbuffer,lread)
       lpos      = lpos+lwrite
       lbyte_cop = lbyte_cop+lwrite
       DO HSTAT
       IF lwrite < lread       && SOMETHING WENT WRONG
          HSORRY("Sorry, a DOS disk access error has occured"+STR(FERROR(),3))
          lexit = .T.
          EXIT
       ELSE
          IF lread = 0    && File has been successfully copied
             EXIT
          ENDI
       ENDI
    ENDD

    FCLOSE(linfile)
    FCLOSE(loutfile)

    IF lexit
       EXIT
    ENDI

NEXT

IF (lbyte_cop = lbyte_tot)
   ERASE &lpath.&lback
   @ lrow,lclm+12 SAY " "
   HSORRY("RESTORE COMPLETE")
   lexit=.T.
ENDI

RETU lexit

******************************************************************************
******************************************************************************
PROC HSTAT      && progress status
PRIV ltime

ltime = (lbyte_tot-lbyte_cop)/2900    && I found speed to be approx 2900 b/sec

@  8,66 SAY SUBS(STR(INT(ltime/3600%24)+10^2,2+1),2)+":"+;   && Hours
            SUBS(STR(INT(ltime/60%60)+10^2,2+1),2)+":"+;     && Minutes
            SUBS(STR(INT(ltime%60)+10^2,2+1),2)              && Seconds
@  9,63 SAY TRAN(lbyte_tot-lbyte_cop,"999,999,999")
@ 11,63 SAY TRAN(lbyte_cop,"999,999,999")
@ 12,69 SAY TRAN(ROUND(lbyte_cop/lbyte_tot*100,0),"999")

RETU
******************************************************************************
******************************************************************************
FUNC HSORRY
PARA lstring
PRIV lscreen,lxx

 ****************************************************************************
 * Syntax:   HSORRY(<expC>)                                                 *
 * Argument: <expC> is string to be shown on screen.                        *
 * Return:   .T.                                                            *
 * Usage:    Used to display a message when the user has made a misstake.   *
 * Note:     The message is placed in a box, and is allways displayed on    *
 *           line 21.                                                       *
 * Example:  HSORRY("Sorry, The name is not valid")                         *
 ****************************************************************************

 lscreen = SAVESCREEN(20,0,22,79)
 TONE(900,1)
 TONE(900,1)
 TONE(900,1)
 TONE(900,2)
 @ 20,(76-LEN(lstring))/2,22,(82+LEN(lstring))/2 BOX ""
 @ 21,(80-LEN(lstring))/2-1 SAY " "+lstring+" "
 HPROMPT("                        Press ANY key to continue")
 INKEY(0)
 RESTSCREEN(20,0,22,79,lscreen)

RETU .T.



******************************************************************************
******************************************************************************
FUNC HPROMPT
PARA lstring

 ****************************************************************************
 * Syntax:   HPROMPT(<expC>)                                                *
 * Argument: <expC> is the text to be displayed on line 24 in inverse.      *
 * Return:   .T.                                                            *
 * Usage:    To display a prompt line corresponding to current action.      *
 * Note:                                                                    *
 * Example:  HPROMPT("text on line 24")                                     *
 ****************************************************************************

 SET COLO TO n/w
 @ 24,1 SAY lstring+SPAC(78-LEN(lstring))
 SET COLO TO w/n

RETU .T.

