/*
 * pe.ch
 *
 * Taylor Data Services
 *
 * Placed into the Public Domain
 *
 */



// PE command defines

#command @ <row>, <col> PE GET <var>;
                        [PICTURE <pic>];
                        [VALID <valid>];
                        [WHEN <when>];
                        [COLOR <color>];
                        [SEND <msg>];
      => SetPos( <row>, <col> );
       ; AAdd(GetList,;
              PEAdd(PE_NORMAL, <(var)>,;
                    { |PE_0| if( PE_0 == NIL, <var>, <var> := PE_0 ) },;
                    <row>, <col>, <pic>,;
                    <{valid}>, <{when}>, <color>);
             );
       ; PE_ShowGet(ATail(GetList));
      [; ATail(GetList):<msg>]

#command @ <row>, <col> PE BUTTON <var> ON <onchar> OFF <offchar>;
                        [VALID <valid>];
                        [WHEN <when>];
                        [COLOR <color>];
                        [SEND <msg>];
      => SetPos( <row>, <col> );
       ; AAdd(GetList,;
              PEAdd(PE_BUTTON, <(var)>,;
                    { |PE_0| if( PE_0 == NIL, if(<var>, <onchar>, <offchar>), <var> := (PE_0 == <onchar>) ) },;
                    <row>, <col>,,;
                    <{valid}>, <{when}>, <color>,;
                    { <onchar>, <offchar> });
             );
       ; PE_ShowGet(ATail(GetList));
      [; ATail(GetList):<msg>]


***
*   @..SAY..GET
*

#command @ <row>, <col> SAY <sayxpr>;
                        [<sayClauses,...>];
                        PE GET <var>;
                        [<getClauses,...>];
      => @ <row>, <col> SAY <sayxpr> [<sayClauses>]                     ;
       ; @ Row(), Col()+1 PE GET <var> [<getClauses>]



// PE get types

#define PE_NORMAL 0         // just a regular get field
#define PE_BUTTON 2         // simple button field

// PE object element defines

#define PE_TYPE  1
#define PE_CARGO 2

// default PE values

#define PE_BTCHAR Chr(219)  // button .t. symbol
#define PE_BFCHAR Chr(254)  // button .f. symbol

// button object elements

#define PE_B_ON  1
#define PE_B_OFF 2

