/*
 * pe.prg
 *
 * Taylor Data Services
 *
 * Placed into the Public Domain
 *
 */


#include "setcurs.ch"
#include "getexit.ch"
#include "pe.ch"

#define K_SPACE 32

static PE_0
static PE_1




function PEAdd(nType, cName, cVBlock, nGetRow, nGetCol,;
                      cPict, bValid, bWhen, cColor, xCargo)

local oGet := GetNew(nGetRow, nGetCol, cVBlock, cName, cPict, cColor)


cColor := if(ValType(cColor) == "C", cColor, SetColor())

if ( ValType(oGet) == "O" )
    if ( ValType(bValid) == "B" )
        oGet:postBlock := bValid
    endif

    if ( ValType(bWhen) == "B" )
        oGet:preBlock := bWhen
    endif

    oGet:reader := {|PE_1| PEReader(PE_1) }
    
    if ( nType == PE_BUTTON )
        oGet:Cargo := { PE_BUTTON, xCargo }
    endif
endif

return (oGet)





static function PEReader(oGet)

local nType  := 0
local aCargo := {}
local nHKey  := 0
local nKey   := 0
local cKey   := ''
local t      := ""


if ( ValType(oGet:cargo) != "A" )
    GetReader(oGet)
else
    nType  := oGet:cargo[PE_TYPE]
    aCargo := oGet:cargo[PE_CARGO]

    oGet:exitState := GE_NOEXIT

    if ( nType == PE_BUTTON )
        oGet:setFocus()

        if ( GetPreValidate(oGet) )
            while ( oGet:exitState == GE_NOEXIT )
                while ( oGet:exitState == GE_NOEXIT )
                    nKey := Inkey(0)

                    cKey := Chr(nKey)

                    do case
                        case cKey $ "YyTtXx"
                            oGet:varPut(aCargo[PE_B_ON])
                            oGet:updateBuffer()

                        case cKey $ "NnFf"
                            oGet:varPut(aCargo[PE_B_OFF])
                            oGet:updateBuffer()

                        case nKey == K_SPACE
                            oGet:varPut(if(oGet:varGet() == aCargo[PE_B_ON],;
                                           aCargo[PE_B_OFF], aCargo[PE_B_ON]))

                            oGet:updateBuffer()

                        case nKey < 32 .or. nKey > 255
                            GetApplyKey(oGet, nKey)

                    endcase
                enddo

                if ( !GetPostValidate(oGet) )
                    oGet:exitState := GE_NOEXIT
                endif
            enddo
        endif

        oGet:killFocus()
    endif
endif

return (NIL)





static function PE_CheckWhen(oGet)

if ( ValType(oGet:preBlock) == "B" )
    oGet:exitState := if(Eval(oGet:preBlock, oGet), GE_NOEXIT, GE_WHEN)
endif

return (oGet:exitState == GE_NOEXIT)





function PE_ShowGet(oGet)

local nType
local aCargo

if ( ValType(oGet:cargo) != "A" )
    oGet:display()
else
    nType  := oGet:cargo[PE_TYPE]
    aCargo := oGet:cargo[PE_CARGO]

    if ( nType == PE_BUTTON )
        oGet:display()
    endif
endif

return (NIL)

