
**
* Program Name: WP51.PRG
* Description.: Driver for PDM Menu System program
* Language....: Clipper S'87
* LIB required: CC.LIB v1.04, EXTEND.LIB
* Gen Time....: 06/08/91 17:59:49
* Generated by: PDM Sys - the ClipCode Pull Down Menu System  v1.06
**
*** Set CLIPPER Environment ***
SET CURSOR OFF
SET DELETED ON                          && Filter out Deleted Records
SET EXACT ON
SET SCOREBOARD OFF
SET SOFTSEEK OFF

PDMSETUP()

*** Set Color for Initial Screen ***
SET COLOR TO ( PDM_CONFG[7] )
@1,0 SAY REPLICATE( CHR( PDM_CONFG[8] ), 1840 ) && char for init screen

SET COLOR TO ( PDM_COLOR[1] )           && hcolor when not selected
@ PDM_CONFG[2],00

SET COLOR TO ( PDM_CONFG[6] )           && color for init bottom panel
@ PDM_CONFG[4],00
@ PDM_CONFG[4],00 SAY PDM_CONFG[9]      && text for init bottom panel

MENUPD( 0, 0 )                          && just display h menu

PRIVATE key, hOpt, vOpt, pdSEL, sv_panel
pdSel= 1
DO WHILE .T.

  *SETCANCEL(.F.)                        && Disable alt-C interrupt
  INKEY(0)
  key= LASTKEY()                        && key= INKEY(0) misses alt-D
  *SETCANCEL(.T.)                        && Enable alt-C interrupt

  DO CASE
  *?*CASE key = 28                         && F1=Help

  *?*CASE key = -2                         && F3=Exit
  ***  EXIT2DOS()

  CASE key = 27                         && Exit
    PRIVATE Opts[2]
    Opts[1]= "Yes"
    Opts[2]= "No"
     * Syntx: message text,       [ title,prmpts,colors,mRow,mColm,TmO ]
    IF BOXMSG( "Exit Program to DOS?",.F., Opts ) = 1
      EXIT
    ELSE
      LOOP
    ENDIF
  CASE key = -9                         && F10=Menu
    hOpt=  1
    vOpt=  0
  *?*CASE key = 3                          && PgDn=Next
  ***  SKIP 1
  ***  IF EOF()
  ***    BOXMSG( "At End-of-File" )
  ***    SKIP -1
  ***  ENDIF
  *?*CASE key = 18                         && PgUp=Prev
  ***  SKIP -1
  ***  IF BOF()
  ***    BOXMSG( "At Beginning-of-File" )
  ***  ENDIF

  CASE ASCAN( PDM_HOTKY, key ) > 0      && If found, returns the ss
    hOpt=  ASCAN( PDM_HOTKY, key )
    vOpt=  1
  OTHERWISE
    LOOP
  ENDCASE

  IF hOpt < 1
    LOOP
  ENDIF

  sv_panel= BOXSAVE( PDM_CONFG[4],00, PDM_CONFG[4],79 )
  pdSel   = 1
  DO WHILE pdSel <> 0

    pdSel= MENUPD( @hOpt, @vOpt )
    IF pdSel > 0
      DO CASE
      OTHERWISE
        * Syntx: message text/array, [ title,prmpts,colors,mRow,mColm,TmO ]
        BOXMSG( "PDM Option Selected: "+LTRIM( STR(pdSel) ) )
      ENDCASE
    ENDIF
  ENDDO WHILE pdSel <> 0
  BOXREST( sv_panel )

ENDDO
SET COLOR TO
SET CURSOR ON
CLEAR
QUIT                                                    && End of: MAIN LINE
**

*------------------------------------------------------------------------------*
* Function....: PDMSETUP()
* Purpose.....: UDF to Create PDMSETUP()
* Parameters..: none
* Generated by: PDM - the ClipCode Pull Down Menu System
* Assumption..: the presence of these PUBLIC arrays:
*             : <arrC>: PDM_HPROM = horizontal menu prompt text
*             : <arrN>: PDM_HCOLM = horizontal starting columns for prompts
*             : <arrC>: PDM_HTRIG = horizontal trigger letters
*             : <arrN>: PDM_HTPOS = horizontal trigger letter positions
*             : <arrN>: PDM_VSS1  = starting array subscript
*             : <arrN>: PDM_VSS2  = ending array subscript
*             : <arrC>: PDM_VPROM = vertical menu prompt text
*             : <arrC>: PDM_VTRIG = vertical trigger letters
*             : <arrN>: PDM_VCOLM = vertical starting columns for v prompts
*             : <arrN>: PDM_VTPOS = vertical trigger letter positions
*             : <arrL>: PDM_VACTV = vertical active status array
*             : <arrC>: PDM_COLOR = PDM color strings for SET COLOR TO
*                                     [ 1] hcolor when not selected
*                                     [ 2] hcolor for unselected trigger
*                                     [ 3] hcolor for selected option
*                                     [ 4] hcolor for selected trigger
*                                     [ 5] vcolor for box
*                                     [ 6] vcolor when not selected
*                                     [ 7] vcolor for unselected trigger
*                                     [ 8] vcolor for selected option
*                                     [ 9] vcolor for selected trigger
*                                     [10] vcolor for inactive option
*                                     [11] vcolor for message row
*             : <arrC>: PDM_VMSSG = vertical message help text
*             : <arrX>: PDM_CONFG = PDM configuration
*                                     [1] = expN: box type: 0,1,2
*                                     [2] = expN: row for horiz menu
*                                     [3] = expN: row for box top
*                                     [4] = expN: message row
*                                     [5] = expN: time out
*                                     [6] = expC: color for init bottom panel
*                                     [7] = expC: color for init screen
*                                     [8] = expN: char for init screen
*                                     [9] = expC: text for init bottom panel
* Calls.......: PDM_INIT()
* CC.LIB Calls: ALONGEST(), ATNEXT()
* Language....: Clipper S'87
* Returns.....: <expL>: .T.
*------------------------------------------------------------------------------*
FUNCTION PDMSETUP

PRIVATE dimh, dimv, ss

*** MENUPD Horizontal ***
dimh= 9
PUBLIC PDM_HPROM[dimh]                  && horizontal menu prompt text
PDM_HPROM[1]= "File"
PDM_HPROM[2]= "Edit"
PDM_HPROM[3]= "Search"
PDM_HPROM[4]= "Layout"
PDM_HPROM[5]= "Mark"
PDM_HPROM[6]= "Tools"
PDM_HPROM[7]= "Font"
PDM_HPROM[8]= "Graphics"
PDM_HPROM[9]= "Help"

PUBLIC PDM_HCOLM[dimh]                  && horizontal starting columns for prompts
PDM_HCOLM[1]= 0
PDM_HCOLM[2]= 5
PDM_HCOLM[3]= 10
PDM_HCOLM[4]= 17
PDM_HCOLM[5]= 24
PDM_HCOLM[6]= 29
PDM_HCOLM[7]= 35
PDM_HCOLM[8]= 40
PDM_HCOLM[9]= 49

PUBLIC PDM_HOTKY[dimh]                  && horiz Hot/alt keys INKEY()
PDM_HOTKY[1]= 289
PDM_HOTKY[2]= 274
PDM_HOTKY[3]= 287
PDM_HOTKY[4]= 294
PDM_HOTKY[5]= 306
PDM_HOTKY[6]= 276
PDM_HOTKY[7]= 280
PDM_HOTKY[8]= 290
PDM_HOTKY[9]= 291

PUBLIC PDM_HTRIG[dimh]                  && horizontal trigger letters
PDM_HTRIG[1]= "F"
PDM_HTRIG[2]= "E"
PDM_HTRIG[3]= "S"
PDM_HTRIG[4]= "L"
PDM_HTRIG[5]= "M"
PDM_HTRIG[6]= "T"
PDM_HTRIG[7]= "o"
PDM_HTRIG[8]= "G"
PDM_HTRIG[9]= "H"

PUBLIC PDM_HTPOS[dimh]                  && horizontal trigger letter  positions
PDM_HTPOS[1]= 1
PDM_HTPOS[2]= 1
PDM_HTPOS[3]= 1
PDM_HTPOS[4]= 1
PDM_HTPOS[5]= 1
PDM_HTPOS[6]= 1
PDM_HTPOS[7]= 2
PDM_HTPOS[8]= 1
PDM_HTPOS[9]= 1

*** PDMENUV Vertical ***
PUBLIC PDM_VSS1[dimh]                   && starting array subscript
PDM_VSS1[1]= 1
PDM_VSS1[2]= 16
PDM_VSS1[3]= 34
PDM_VSS1[4]= 44
PDM_VSS1[5]= 60
PDM_VSS1[6]= 74
PDM_VSS1[7]= 93
PDM_VSS1[8]= 108
PDM_VSS1[9]= 115

dimv= 117
PUBLIC PDM_VPROM[dimv]                  && vertical menu prompt text
PDM_VPROM[  1]= " Retrieve   "
PDM_VPROM[  2]= " Save       "
PDM_VPROM[  3]= " Text In   "
PDM_VPROM[  4]= " Text Out  "
PDM_VPROM[  5]= " Password  "
PDM_VPROM[  6]= "-"
PDM_VPROM[  7]= " List Files "
PDM_VPROM[  8]= " Summary    "
PDM_VPROM[  9]= "-"
PDM_VPROM[ 10]= " Print      "
PDM_VPROM[ 11]= "-"
PDM_VPROM[ 12]= " Setup     "
PDM_VPROM[ 13]= "-"
PDM_VPROM[ 14]= " Go to DOS  "
PDM_VPROM[ 15]= " Exit       "
PDM_VPROM[ 16]= " Move (Cut)      "
PDM_VPROM[ 17]= " Copy            "
PDM_VPROM[ 18]= " Paste           "
PDM_VPROM[ 19]= " Append          "
PDM_VPROM[ 20]= "-"
PDM_VPROM[ 21]= " Delete          "
PDM_VPROM[ 22]= " Undelete        "
PDM_VPROM[ 23]= "-"
PDM_VPROM[ 24]= " Block           "
PDM_VPROM[ 25]= " Select         "
PDM_VPROM[ 26]= " Comment        "
PDM_VPROM[ 27]= " Convert Case    "
PDM_VPROM[ 28]= " Protect Block   "
PDM_VPROM[ 29]= "-"
PDM_VPROM[ 30]= " Switch Document "
PDM_VPROM[ 31]= " Window          "
PDM_VPROM[ 32]= "-"
PDM_VPROM[ 33]= " Reveal Codes    "
PDM_VPROM[ 34]= " Forward  "
PDM_VPROM[ 35]= " Backward "
PDM_VPROM[ 36]= " Next     "
PDM_VPROM[ 37]= " Previous "
PDM_VPROM[ 38]= "-"
PDM_VPROM[ 39]= " Replace  "
PDM_VPROM[ 40]= "-"
PDM_VPROM[ 41]= " Extended"
PDM_VPROM[ 42]= "-"
PDM_VPROM[ 43]= " Go to    "
PDM_VPROM[ 44]= " Line     "
PDM_VPROM[ 45]= " Page     "
PDM_VPROM[ 46]= " Document "
PDM_VPROM[ 47]= " Other    "
PDM_VPROM[ 48]= "-"
PDM_VPROM[ 49]= " Columns "
PDM_VPROM[ 50]= " Tables  "
PDM_VPROM[ 51]= " Math    "
PDM_VPROM[ 52]= "-"
PDM_VPROM[ 53]= " Footnote"
PDM_VPROM[ 54]= " Endnote "
PDM_VPROM[ 55]= "-"
PDM_VPROM[ 56]= " Justify "
PDM_VPROM[ 57]= " Align   "
PDM_VPROM[ 58]= "-"
PDM_VPROM[ 59]= " Styles   "
PDM_VPROM[ 60]= " Index                "
PDM_VPROM[ 61]= " Table of Contents    "
PDM_VPROM[ 62]= " List                 "
PDM_VPROM[ 63]= " Cross-Reference     "
PDM_VPROM[ 64]= " Table of Authorities"
PDM_VPROM[ 65]= "-"
PDM_VPROM[ 66]= " Define              "
PDM_VPROM[ 67]= "-"
PDM_VPROM[ 68]= " Generate             "
PDM_VPROM[ 69]= "-"
PDM_VPROM[ 70]= " Master Documents    "
PDM_VPROM[ 71]= " Subdocument          "
PDM_VPROM[ 72]= "-"
PDM_VPROM[ 73]= " Document Compare    "
PDM_VPROM[ 74]= " Spell            "
PDM_VPROM[ 75]= " Thesaurus        "
PDM_VPROM[ 76]= "-"
PDM_VPROM[ 77]= " Macro           "
PDM_VPROM[ 78]= "-"
PDM_VPROM[ 79]= " Date Text        "
PDM_VPROM[ 80]= " Date Code        "
PDM_VPROM[ 81]= " Date Format      "
PDM_VPROM[ 82]= "-"
PDM_VPROM[ 83]= " Outline         "
PDM_VPROM[ 84]= " Paragraph Number "
PDM_VPROM[ 85]= " Define           "
PDM_VPROM[ 86]= "-"
PDM_VPROM[ 87]= " Merge Codes     "
PDM_VPROM[ 88]= " Merge            "
PDM_VPROM[ 89]= "-"
PDM_VPROM[ 90]= " Sort             "
PDM_VPROM[ 91]= "-"
PDM_VPROM[ 92]= " Line Draw        "
PDM_VPROM[ 93]= " Base Font   "
PDM_VPROM[ 94]= "-"
PDM_VPROM[ 95]= " Normal      "
PDM_VPROM[ 96]= " Appearance "
PDM_VPROM[ 97]= " Superscript "
PDM_VPROM[ 98]= " Subscript   "
PDM_VPROM[ 99]= " Fine        "
PDM_VPROM[100]= " Small       "
PDM_VPROM[101]= " Large       "
PDM_VPROM[102]= " Very Large  "
PDM_VPROM[103]= " Extra Large "
PDM_VPROM[104]= "-"
PDM_VPROM[105]= " Print Color "
PDM_VPROM[106]= "-"
PDM_VPROM[107]= " Characters  "
PDM_VPROM[108]= " Figure   "
PDM_VPROM[109]= " Table Box "
PDM_VPROM[110]= " Text Box  "
PDM_VPROM[111]= " User Box  "
PDM_VPROM[112]= " Equation  "
PDM_VPROM[113]= "-"
PDM_VPROM[114]= " Line     "
PDM_VPROM[115]= " Help     "
PDM_VPROM[116]= " Index    "
PDM_VPROM[117]= " Template "

PUBLIC PDM_VTRIG[dimv]                  && vertical trigger letters
PDM_VTRIG[  1]= "R"
PDM_VTRIG[  2]= "S"
PDM_VTRIG[  3]= "I"
PDM_VTRIG[  4]= "O"
PDM_VTRIG[  5]= "w"
PDM_VTRIG[  6]= "-"
PDM_VTRIG[  7]= "F"
PDM_VTRIG[  8]= "m"
PDM_VTRIG[  9]= "-"
PDM_VTRIG[ 10]= "P"
PDM_VTRIG[ 11]= "-"
PDM_VTRIG[ 12]= "t"
PDM_VTRIG[ 13]= "-"
PDM_VTRIG[ 14]= "G"
PDM_VTRIG[ 15]= "x"
PDM_VTRIG[ 16]= "M"
PDM_VTRIG[ 17]= "C"
PDM_VTRIG[ 18]= "P"
PDM_VTRIG[ 19]= "A"
PDM_VTRIG[ 20]= "-"
PDM_VTRIG[ 21]= "D"
PDM_VTRIG[ 22]= "U"
PDM_VTRIG[ 23]= "-"
PDM_VTRIG[ 24]= "B"
PDM_VTRIG[ 25]= "e"
PDM_VTRIG[ 26]= "o"
PDM_VTRIG[ 27]= "v"
PDM_VTRIG[ 28]= "t"
PDM_VTRIG[ 29]= "-"
PDM_VTRIG[ 30]= "S"
PDM_VTRIG[ 31]= "W"
PDM_VTRIG[ 32]= "-"
PDM_VTRIG[ 33]= "R"
PDM_VTRIG[ 34]= "F"
PDM_VTRIG[ 35]= "B"
PDM_VTRIG[ 36]= "N"
PDM_VTRIG[ 37]= "P"
PDM_VTRIG[ 38]= "-"
PDM_VTRIG[ 39]= "R"
PDM_VTRIG[ 40]= "-"
PDM_VTRIG[ 41]= "E"
PDM_VTRIG[ 42]= "-"
PDM_VTRIG[ 43]= "G"
PDM_VTRIG[ 44]= "L"
PDM_VTRIG[ 45]= "P"
PDM_VTRIG[ 46]= "D"
PDM_VTRIG[ 47]= "O"
PDM_VTRIG[ 48]= "-"
PDM_VTRIG[ 49]= "C"
PDM_VTRIG[ 50]= "T"
PDM_VTRIG[ 51]= "M"
PDM_VTRIG[ 52]= "-"
PDM_VTRIG[ 53]= "F"
PDM_VTRIG[ 54]= "E"
PDM_VTRIG[ 55]= "-"
PDM_VTRIG[ 56]= "J"
PDM_VTRIG[ 57]= "A"
PDM_VTRIG[ 58]= "-"
PDM_VTRIG[ 59]= "S"
PDM_VTRIG[ 60]= "I"
PDM_VTRIG[ 61]= "C"
PDM_VTRIG[ 62]= "L"
PDM_VTRIG[ 63]= "R"
PDM_VTRIG[ 64]= "A"
PDM_VTRIG[ 65]= "-"
PDM_VTRIG[ 66]= "D"
PDM_VTRIG[ 67]= "-"
PDM_VTRIG[ 68]= "G"
PDM_VTRIG[ 69]= "-"
PDM_VTRIG[ 70]= "M"
PDM_VTRIG[ 71]= "S"
PDM_VTRIG[ 72]= "-"
PDM_VTRIG[ 73]= "o"
PDM_VTRIG[ 74]= "S"
PDM_VTRIG[ 75]= "h"
PDM_VTRIG[ 76]= "-"
PDM_VTRIG[ 77]= "a"
PDM_VTRIG[ 78]= "-"
PDM_VTRIG[ 79]= "T"
PDM_VTRIG[ 80]= "C"
PDM_VTRIG[ 81]= "F"
PDM_VTRIG[ 82]= "-"
PDM_VTRIG[ 83]= "O"
PDM_VTRIG[ 84]= "P"
PDM_VTRIG[ 85]= "D"
PDM_VTRIG[ 86]= "-"
PDM_VTRIG[ 87]= "r"
PDM_VTRIG[ 88]= "M"
PDM_VTRIG[ 89]= "-"
PDM_VTRIG[ 90]= "S"
PDM_VTRIG[ 91]= "-"
PDM_VTRIG[ 92]= "L"
PDM_VTRIG[ 93]= "o"
PDM_VTRIG[ 94]= "-"
PDM_VTRIG[ 95]= "N"
PDM_VTRIG[ 96]= "A"
PDM_VTRIG[ 97]= "p"
PDM_VTRIG[ 98]= "b"
PDM_VTRIG[ 99]= "F"
PDM_VTRIG[100]= "S"
PDM_VTRIG[101]= "L"
PDM_VTRIG[102]= "V"
PDM_VTRIG[103]= "E"
PDM_VTRIG[104]= "-"
PDM_VTRIG[105]= "C"
PDM_VTRIG[106]= "-"
PDM_VTRIG[107]= "h"
PDM_VTRIG[108]= "F"
PDM_VTRIG[109]= "T"
PDM_VTRIG[110]= "B"
PDM_VTRIG[111]= "U"
PDM_VTRIG[112]= "E"
PDM_VTRIG[113]= "-"
PDM_VTRIG[114]= "L"
PDM_VTRIG[115]= "H"
PDM_VTRIG[116]= "I"
PDM_VTRIG[117]= "T"

PUBLIC PDM_VTPOS[dimv]                  && vertical trigger letter positions
PDM_VTPOS[  1]= 2
PDM_VTPOS[  2]= 2
PDM_VTPOS[  3]= 7
PDM_VTPOS[  4]= 7
PDM_VTPOS[  5]= 6
PDM_VTPOS[  6]= 1
PDM_VTPOS[  7]= 7
PDM_VTPOS[  8]= 4
PDM_VTPOS[  9]= 1
PDM_VTPOS[ 10]= 2
PDM_VTPOS[ 11]= 1
PDM_VTPOS[ 12]= 4
PDM_VTPOS[ 13]= 1
PDM_VTPOS[ 14]= 2
PDM_VTPOS[ 15]= 3
PDM_VTPOS[ 16]= 2
PDM_VTPOS[ 17]= 2
PDM_VTPOS[ 18]= 2
PDM_VTPOS[ 19]= 2
PDM_VTPOS[ 20]= 1
PDM_VTPOS[ 21]= 2
PDM_VTPOS[ 22]= 2
PDM_VTPOS[ 23]= 1
PDM_VTPOS[ 24]= 2
PDM_VTPOS[ 25]= 3
PDM_VTPOS[ 26]= 3
PDM_VTPOS[ 27]= 5
PDM_VTPOS[ 28]= 5
PDM_VTPOS[ 29]= 1
PDM_VTPOS[ 30]= 2
PDM_VTPOS[ 31]= 2
PDM_VTPOS[ 32]= 1
PDM_VTPOS[ 33]= 2
PDM_VTPOS[ 34]= 2
PDM_VTPOS[ 35]= 2
PDM_VTPOS[ 36]= 2
PDM_VTPOS[ 37]= 2
PDM_VTPOS[ 38]= 1
PDM_VTPOS[ 39]= 2
PDM_VTPOS[ 40]= 1
PDM_VTPOS[ 41]= 2
PDM_VTPOS[ 42]= 1
PDM_VTPOS[ 43]= 2
PDM_VTPOS[ 44]= 2
PDM_VTPOS[ 45]= 2
PDM_VTPOS[ 46]= 2
PDM_VTPOS[ 47]= 2
PDM_VTPOS[ 48]= 1
PDM_VTPOS[ 49]= 2
PDM_VTPOS[ 50]= 2
PDM_VTPOS[ 51]= 2
PDM_VTPOS[ 52]= 1
PDM_VTPOS[ 53]= 2
PDM_VTPOS[ 54]= 2
PDM_VTPOS[ 55]= 1
PDM_VTPOS[ 56]= 2
PDM_VTPOS[ 57]= 2
PDM_VTPOS[ 58]= 1
PDM_VTPOS[ 59]= 2
PDM_VTPOS[ 60]= 2
PDM_VTPOS[ 61]= 10
PDM_VTPOS[ 62]= 2
PDM_VTPOS[ 63]= 8
PDM_VTPOS[ 64]= 11
PDM_VTPOS[ 65]= 1
PDM_VTPOS[ 66]= 2
PDM_VTPOS[ 67]= 1
PDM_VTPOS[ 68]= 2
PDM_VTPOS[ 69]= 1
PDM_VTPOS[ 70]= 2
PDM_VTPOS[ 71]= 2
PDM_VTPOS[ 72]= 1
PDM_VTPOS[ 73]= 12
PDM_VTPOS[ 74]= 2
PDM_VTPOS[ 75]= 3
PDM_VTPOS[ 76]= 1
PDM_VTPOS[ 77]= 3
PDM_VTPOS[ 78]= 1
PDM_VTPOS[ 79]= 7
PDM_VTPOS[ 80]= 7
PDM_VTPOS[ 81]= 7
PDM_VTPOS[ 82]= 1
PDM_VTPOS[ 83]= 2
PDM_VTPOS[ 84]= 2
PDM_VTPOS[ 85]= 2
PDM_VTPOS[ 86]= 1
PDM_VTPOS[ 87]= 4
PDM_VTPOS[ 88]= 2
PDM_VTPOS[ 89]= 1
PDM_VTPOS[ 90]= 2
PDM_VTPOS[ 91]= 1
PDM_VTPOS[ 92]= 2
PDM_VTPOS[ 93]= 8
PDM_VTPOS[ 94]= 1
PDM_VTPOS[ 95]= 2
PDM_VTPOS[ 96]= 2
PDM_VTPOS[ 97]= 4
PDM_VTPOS[ 98]= 4
PDM_VTPOS[ 99]= 2
PDM_VTPOS[100]= 2
PDM_VTPOS[101]= 2
PDM_VTPOS[102]= 2
PDM_VTPOS[103]= 2
PDM_VTPOS[104]= 1
PDM_VTPOS[105]= 8
PDM_VTPOS[106]= 1
PDM_VTPOS[107]= 3
PDM_VTPOS[108]= 2
PDM_VTPOS[109]= 2
PDM_VTPOS[110]= 7
PDM_VTPOS[111]= 2
PDM_VTPOS[112]= 2
PDM_VTPOS[113]= 1
PDM_VTPOS[114]= 2
PDM_VTPOS[115]= 2
PDM_VTPOS[116]= 2
PDM_VTPOS[117]= 2

PUBLIC PDM_VACTV[dimv]                  && vertical active status array
AFILL( PDM_VACTV, .T. )
PDM_VACTV[  6]= .F.
PDM_VACTV[  9]= .F.
PDM_VACTV[ 11]= .F.
PDM_VACTV[ 13]= .F.
PDM_VACTV[ 16]= .F.
PDM_VACTV[ 17]= .F.
PDM_VACTV[ 19]= .F.
PDM_VACTV[ 20]= .F.
PDM_VACTV[ 21]= .F.
PDM_VACTV[ 23]= .F.
PDM_VACTV[ 27]= .F.
PDM_VACTV[ 28]= .F.
PDM_VACTV[ 29]= .F.
PDM_VACTV[ 32]= .F.
PDM_VACTV[ 38]= .F.
PDM_VACTV[ 40]= .F.
PDM_VACTV[ 42]= .F.
PDM_VACTV[ 48]= .F.
PDM_VACTV[ 52]= .F.
PDM_VACTV[ 55]= .F.
PDM_VACTV[ 58]= .F.
PDM_VACTV[ 61]= .F.
PDM_VACTV[ 62]= .F.
PDM_VACTV[ 65]= .F.
PDM_VACTV[ 67]= .F.
PDM_VACTV[ 69]= .F.
PDM_VACTV[ 72]= .F.
PDM_VACTV[ 76]= .F.
PDM_VACTV[ 78]= .F.
PDM_VACTV[ 82]= .F.
PDM_VACTV[ 86]= .F.
PDM_VACTV[ 89]= .F.
PDM_VACTV[ 91]= .F.
PDM_VACTV[ 94]= .F.
PDM_VACTV[104]= .F.
PDM_VACTV[106]= .F.
PDM_VACTV[113]= .F.

PUBLIC PDM_COLOR[11]                    && PDM color strings for SET COLOR TO
PDM_COLOR[ 1]= "B/W"                     && [ 1] hcolor when not selected
PDM_COLOR[ 2]= "R/W"                     && [ 2] hcolor for unselected trigger
PDM_COLOR[ 3]= "W/R"                     && [ 3] hcolor for selected option
PDM_COLOR[ 4]= "W/R"                     && [ 4] hcolor for selected trigger
PDM_COLOR[ 5]= "B/W"                     && [ 5] vcolor for box
PDM_COLOR[ 6]= "B/W"                     && [ 6] vcolor when not selected
PDM_COLOR[ 7]= "R/W"                     && [ 7] vcolor for unselected trigger
PDM_COLOR[ 8]= "W/R"                     && [ 8] vcolor for selected option
PDM_COLOR[ 9]= "W/R"                     && [ 9] vcolor for selected trigger
PDM_COLOR[10]= "N+/W"                    && [10] vcolor for inactive option
PDM_COLOR[11]= "N/W"                     && [11] vcolor for message row

PUBLIC PDM_CONFG[9]                     && PDM configuration
PDM_CONFG[1]= 1                          && [1] = expN: box type: 0,1,2
PDM_CONFG[2]= 0                          && [2] = expN: row for horiz menu
PDM_CONFG[3]= 2                          && [3] = expN: row for box top
PDM_CONFG[4]= 24                         && [4] = expN: message row
PDM_CONFG[5]= 0                          && [5] = expN: time out
PDM_CONFG[6]= "W+/B"                     && [6] = expC: color for init bottom panel
PDM_CONFG[7]= "W+/B"                     && [7] = expC: color for init screen
PDM_CONFG[8]= 32                         && [8] = expN: char for init screen
*                                        && [9] = expC: text for init bottom panel
PDM_CONFG[9]= "                                                      Doc 1 Pg 1 Ln 1  Pos 1"

PDM_INIT()                    && Initialize remaining optional PDM PUBLIC arrays

RETURN .T.                                                 && End of: PDMSETUP()
*------------------------------------------------------------------------------*
*<eof>