
**
* Program Name: PW20.PRG
* Description.: Driver for PDM Menu System program
* Language....: Clipper S'87
* LIB required: CC.LIB v1.04, EXTEND.LIB
* Gen Time....: 06/08/91 17:59:15
* Generated by: PDM Sys - the ClipCode Pull Down Menu System  v1.06
**
*** Set CLIPPER Environment ***
SET CURSOR OFF
SET DELETED ON                          && Filter out Deleted Records
SET EXACT ON
SET SCOREBOARD OFF
SET SOFTSEEK OFF

PDMSETUP()

*** Set Color for Initial Screen ***
SET COLOR TO ( PDM_CONFG[7] )
@1,0 SAY REPLICATE( CHR( PDM_CONFG[8] ), 1840 ) && char for init screen

SET COLOR TO ( PDM_COLOR[1] )           && hcolor when not selected
@ PDM_CONFG[2],00

SET COLOR TO ( PDM_CONFG[6] )           && color for init bottom panel
@ PDM_CONFG[4],00
@ PDM_CONFG[4],00 SAY PDM_CONFG[9]      && text for init bottom panel

MENUPD( 0, 0 )                          && just display h menu

PRIVATE key, hOpt, vOpt, pdSEL, sv_panel
pdSel= 1
DO WHILE .T.

  *SETCANCEL(.F.)                        && Disable alt-C interrupt
  INKEY(0)
  key= LASTKEY()                        && key= INKEY(0) misses alt-D
  *SETCANCEL(.T.)                        && Enable alt-C interrupt

  DO CASE
  *?*CASE key = 28                         && F1=Help

  *?*CASE key = -2                         && F3=Exit
  ***  EXIT2DOS()

  CASE key = 27                         && Exit
    PRIVATE Opts[2]
    Opts[1]= "Yes"
    Opts[2]= "No"
     * Syntx: message text,       [ title,prmpts,colors,mRow,mColm,TmO ]
    IF BOXMSG( "Exit Program to DOS?",.F., Opts ) = 1
      EXIT
    ELSE
      LOOP
    ENDIF
  CASE key = -9                         && F10=Menu
    hOpt=  1
    vOpt=  0
  *?*CASE key = 3                          && PgDn=Next
  ***  SKIP 1
  ***  IF EOF()
  ***    BOXMSG( "At End-of-File" )
  ***    SKIP -1
  ***  ENDIF
  *?*CASE key = 18                         && PgUp=Prev
  ***  SKIP -1
  ***  IF BOF()
  ***    BOXMSG( "At Beginning-of-File" )
  ***  ENDIF

  CASE ASCAN( PDM_HOTKY, key ) > 0      && If found, returns the ss
    hOpt=  ASCAN( PDM_HOTKY, key )
    vOpt=  1
  OTHERWISE
    LOOP
  ENDCASE

  IF hOpt < 1
    LOOP
  ENDIF

  sv_panel= BOXSAVE( PDM_CONFG[4],00, PDM_CONFG[4],79 )
  pdSel   = 1
  DO WHILE pdSel <> 0

    pdSel= MENUPD( @hOpt, @vOpt )
    IF pdSel > 0
      DO CASE
      OTHERWISE
        * Syntx: message text/array, [ title,prmpts,colors,mRow,mColm,TmO ]
        BOXMSG( "PDM Option Selected: "+LTRIM( STR(pdSel) ) )
      ENDCASE
    ENDIF
  ENDDO WHILE pdSel <> 0
  BOXREST( sv_panel )

ENDDO
SET COLOR TO
SET CURSOR ON
CLEAR
QUIT                                                    && End of: MAIN LINE
**

*------------------------------------------------------------------------------*
* Function....: PDMSETUP()
* Purpose.....: UDF to Create PDMSETUP()
* Parameters..: none
* Generated by: PDM - the ClipCode Pull Down Menu System
* Assumption..: the presence of these PUBLIC arrays:
*             : <arrC>: PDM_HPROM = horizontal menu prompt text
*             : <arrN>: PDM_HCOLM = horizontal starting columns for prompts
*             : <arrC>: PDM_HTRIG = horizontal trigger letters
*             : <arrN>: PDM_HTPOS = horizontal trigger letter positions
*             : <arrN>: PDM_VSS1  = starting array subscript
*             : <arrN>: PDM_VSS2  = ending array subscript
*             : <arrC>: PDM_VPROM = vertical menu prompt text
*             : <arrC>: PDM_VTRIG = vertical trigger letters
*             : <arrN>: PDM_VCOLM = vertical starting columns for v prompts
*             : <arrN>: PDM_VTPOS = vertical trigger letter positions
*             : <arrL>: PDM_VACTV = vertical active status array
*             : <arrC>: PDM_COLOR = PDM color strings for SET COLOR TO
*                                     [ 1] hcolor when not selected
*                                     [ 2] hcolor for unselected trigger
*                                     [ 3] hcolor for selected option
*                                     [ 4] hcolor for selected trigger
*                                     [ 5] vcolor for box
*                                     [ 6] vcolor when not selected
*                                     [ 7] vcolor for unselected trigger
*                                     [ 8] vcolor for selected option
*                                     [ 9] vcolor for selected trigger
*                                     [10] vcolor for inactive option
*                                     [11] vcolor for message row
*             : <arrC>: PDM_VMSSG = vertical message help text
*             : <arrX>: PDM_CONFG = PDM configuration
*                                     [1] = expN: box type: 0,1,2
*                                     [2] = expN: row for horiz menu
*                                     [3] = expN: row for box top
*                                     [4] = expN: message row
*                                     [5] = expN: time out
*                                     [6] = expC: color for init bottom panel
*                                     [7] = expC: color for init screen
*                                     [8] = expN: char for init screen
*                                     [9] = expC: text for init bottom panel
* Calls.......: PDM_INIT()
* CC.LIB Calls: ALONGEST(), ATNEXT()
* Language....: Clipper S'87
* Returns.....: <expL>: .T.
*------------------------------------------------------------------------------*
FUNCTION PDMSETUP

PRIVATE dimh, dimv, ss

*** MENUPD Horizontal ***
dimh= 6
PUBLIC PDM_HPROM[dimh]                  && horizontal menu prompt text
PDM_HPROM[1]= " F1-Help "
PDM_HPROM[2]= " F2-File/Print "
PDM_HPROM[3]= " F3-Edit "
PDM_HPROM[4]= " F4-Format "
PDM_HPROM[5]= " F5-Dictionary "
PDM_HPROM[6]= " F6-Addresses "

PUBLIC PDM_HCOLM[dimh]                  && horizontal starting columns for prompts
PDM_HCOLM[1]= 0
PDM_HCOLM[2]= 10
PDM_HCOLM[3]= 26
PDM_HCOLM[4]= 36
PDM_HCOLM[5]= 48
PDM_HCOLM[6]= 64

PUBLIC PDM_HOTKY[dimh]                  && horiz Hot/alt keys INKEY()
PDM_HOTKY[1]= 28
PDM_HOTKY[2]= -1
PDM_HOTKY[3]= -2
PDM_HOTKY[4]= -3
PDM_HOTKY[5]= -4
PDM_HOTKY[6]= -5

PUBLIC PDM_HTRIG[dimh]                  && horizontal trigger letters
PDM_HTRIG[1]= ""
PDM_HTRIG[2]= ""
PDM_HTRIG[3]= ""
PDM_HTRIG[4]= ""
PDM_HTRIG[5]= ""
PDM_HTRIG[6]= ""

PUBLIC PDM_HTPOS[dimh]                  && horizontal trigger letter  positions
PDM_HTPOS[1]= 1
PDM_HTPOS[2]= 1
PDM_HTPOS[3]= 1
PDM_HTPOS[4]= 1
PDM_HTPOS[5]= 1
PDM_HTPOS[6]= 1

*** PDMENUV Vertical ***
PUBLIC PDM_VSS1[dimh]                   && starting array subscript
PDM_VSS1[1]= 1
PDM_VSS1[2]= 2
PDM_VSS1[3]= 13
PDM_VSS1[4]= 29
PDM_VSS1[5]= 40
PDM_VSS1[6]= 44

dimv= 49
PUBLIC PDM_VPROM[dimv]                  && vertical menu prompt text
PDM_VPROM[ 1]= "  1. Help Index  "
PDM_VPROM[ 2]= "  1. Get file            Ctrl-G  "
PDM_VPROM[ 3]= "  2. Save working copy   Ctrl-S  "
PDM_VPROM[ 4]= "  3. Delete file                 "
PDM_VPROM[ 5]= "-"
PDM_VPROM[ 6]= "  4. Insert file                 "
PDM_VPROM[ 7]= "-"
PDM_VPROM[ 8]= "  5. Print working copy  Ctrl-O  "
PDM_VPROM[ 9]= "-"
PDM_VPROM[10]= "  6. Erase working copy          "
PDM_VPROM[11]= "-"
PDM_VPROM[12]= "  7. Use macros           Alt-0  "
PDM_VPROM[13]= "  1. Insert blank line  Ctrl-I  "
PDM_VPROM[14]= "  2. Delete word        Ctrl-W  "
PDM_VPROM[15]= "  3. Delete line        Ctrl-L  "
PDM_VPROM[16]= "-"
PDM_VPROM[17]= "  4. Mark text          Ctrl-T  "
PDM_VPROM[18]= "  5. Mark rectangle     Ctrl-R  "
PDM_VPROM[19]= "  6. Paste              Ctrl-P  "
PDM_VPROM[20]= "-"
PDM_VPROM[21]= "  7. Boldface word      Ctrl-B  "
PDM_VPROM[22]= "  8. Underline word     Ctrl-U  "
PDM_VPROM[23]= "-"
PDM_VPROM[24]= "  9. Draw lines                 "
PDM_VPROM[25]= "-"
PDM_VPROM[26]= "  A. Find & Replace     Ctrl-F  "
PDM_VPROM[27]= "-"
PDM_VPROM[28]= "  B. Calculate          Ctrl-M  "
PDM_VPROM[29]= "  1. Set left/right margins & tabs    Ctrl-[  "
PDM_VPROM[30]= "  2. Set top/bottom margins & length          "
PDM_VPROM[31]= "  3. Set header                               "
PDM_VPROM[32]= "  4. Set footer                               "
PDM_VPROM[33]= "-"
PDM_VPROM[34]= "  5. Turn indent on/off               Ctrl-N  "
PDM_VPROM[35]= "  6. Turn double spacing on/off       Ctrl-D  "
PDM_VPROM[36]= "-"
PDM_VPROM[37]= "  7. Center line                      Ctrl-X  "
PDM_VPROM[38]= "  8. Left justify line                        "
PDM_VPROM[39]= "  9. Right justify line                       "
PDM_VPROM[40]= "  1. Proof word          Ctrl-A  "
PDM_VPROM[41]= "  2. Proof document      Ctrl-V  "
PDM_VPROM[42]= "-"
PDM_VPROM[43]= "  3. Find synonyms               "
PDM_VPROM[44]= "  1. Select address book  "
PDM_VPROM[45]= "-"
PDM_VPROM[46]= "  2. Add an address       "
PDM_VPROM[47]= "  3. Find an address      "
PDM_VPROM[48]= "-"
PDM_VPROM[49]= "  4. Specify copy format  "

PUBLIC PDM_VTRIG[dimv]                  && vertical trigger letters
PDM_VTRIG[ 1]= "1"
PDM_VTRIG[ 2]= "1"
PDM_VTRIG[ 3]= "2"
PDM_VTRIG[ 4]= "3"
PDM_VTRIG[ 5]= "-"
PDM_VTRIG[ 6]= "4"
PDM_VTRIG[ 7]= "-"
PDM_VTRIG[ 8]= "5"
PDM_VTRIG[ 9]= "-"
PDM_VTRIG[10]= "6"
PDM_VTRIG[11]= "-"
PDM_VTRIG[12]= "7"
PDM_VTRIG[13]= "1"
PDM_VTRIG[14]= "2"
PDM_VTRIG[15]= "3"
PDM_VTRIG[16]= "-"
PDM_VTRIG[17]= "4"
PDM_VTRIG[18]= "5"
PDM_VTRIG[19]= "6"
PDM_VTRIG[20]= "-"
PDM_VTRIG[21]= "7"
PDM_VTRIG[22]= "8"
PDM_VTRIG[23]= "-"
PDM_VTRIG[24]= "9"
PDM_VTRIG[25]= "-"
PDM_VTRIG[26]= "A"
PDM_VTRIG[27]= "-"
PDM_VTRIG[28]= "B"
PDM_VTRIG[29]= "1"
PDM_VTRIG[30]= "2"
PDM_VTRIG[31]= "3"
PDM_VTRIG[32]= "4"
PDM_VTRIG[33]= "-"
PDM_VTRIG[34]= "5"
PDM_VTRIG[35]= "6"
PDM_VTRIG[36]= "-"
PDM_VTRIG[37]= "7"
PDM_VTRIG[38]= "8"
PDM_VTRIG[39]= "9"
PDM_VTRIG[40]= "1"
PDM_VTRIG[41]= "2"
PDM_VTRIG[42]= "-"
PDM_VTRIG[43]= "3"
PDM_VTRIG[44]= "1"
PDM_VTRIG[45]= "-"
PDM_VTRIG[46]= "2"
PDM_VTRIG[47]= "3"
PDM_VTRIG[48]= "-"
PDM_VTRIG[49]= "4"

PUBLIC PDM_VTPOS[dimv]                  && vertical trigger letter positions
PDM_VTPOS[ 1]= 3
PDM_VTPOS[ 2]= 3
PDM_VTPOS[ 3]= 3
PDM_VTPOS[ 4]= 3
PDM_VTPOS[ 5]= 1
PDM_VTPOS[ 6]= 3
PDM_VTPOS[ 7]= 1
PDM_VTPOS[ 8]= 3
PDM_VTPOS[ 9]= 1
PDM_VTPOS[10]= 3
PDM_VTPOS[11]= 1
PDM_VTPOS[12]= 3
PDM_VTPOS[13]= 3
PDM_VTPOS[14]= 3
PDM_VTPOS[15]= 3
PDM_VTPOS[16]= 1
PDM_VTPOS[17]= 3
PDM_VTPOS[18]= 3
PDM_VTPOS[19]= 3
PDM_VTPOS[20]= 1
PDM_VTPOS[21]= 3
PDM_VTPOS[22]= 3
PDM_VTPOS[23]= 1
PDM_VTPOS[24]= 3
PDM_VTPOS[25]= 1
PDM_VTPOS[26]= 3
PDM_VTPOS[27]= 1
PDM_VTPOS[28]= 3
PDM_VTPOS[29]= 3
PDM_VTPOS[30]= 3
PDM_VTPOS[31]= 3
PDM_VTPOS[32]= 3
PDM_VTPOS[33]= 1
PDM_VTPOS[34]= 3
PDM_VTPOS[35]= 3
PDM_VTPOS[36]= 1
PDM_VTPOS[37]= 3
PDM_VTPOS[38]= 3
PDM_VTPOS[39]= 3
PDM_VTPOS[40]= 3
PDM_VTPOS[41]= 3
PDM_VTPOS[42]= 1
PDM_VTPOS[43]= 3
PDM_VTPOS[44]= 3
PDM_VTPOS[45]= 1
PDM_VTPOS[46]= 3
PDM_VTPOS[47]= 3
PDM_VTPOS[48]= 1
PDM_VTPOS[49]= 3

PUBLIC PDM_VACTV[dimv]                  && vertical active status array
AFILL( PDM_VACTV, .T. )
PDM_VACTV[ 5]= .F.
PDM_VACTV[ 7]= .F.
PDM_VACTV[ 9]= .F.
PDM_VACTV[11]= .F.
PDM_VACTV[16]= .F.
PDM_VACTV[20]= .F.
PDM_VACTV[23]= .F.
PDM_VACTV[25]= .F.
PDM_VACTV[27]= .F.
PDM_VACTV[33]= .F.
PDM_VACTV[36]= .F.
PDM_VACTV[42]= .F.
PDM_VACTV[45]= .F.
PDM_VACTV[48]= .F.

PUBLIC PDM_COLOR[11]                    && PDM color strings for SET COLOR TO
PDM_COLOR[ 1]= "BG/N"                    && [ 1] hcolor when not selected
PDM_COLOR[ 2]= "BG/N"                    && [ 2] hcolor for unselected trigger
PDM_COLOR[ 3]= "N/BG"                    && [ 3] hcolor for selected option
PDM_COLOR[ 4]= "N/BG"                    && [ 4] hcolor for selected trigger
PDM_COLOR[ 5]= "BG+/BG"                  && [ 5] vcolor for box
PDM_COLOR[ 6]= "B/BG"                    && [ 6] vcolor when not selected
PDM_COLOR[ 7]= "B/BG"                    && [ 7] vcolor for unselected trigger
PDM_COLOR[ 8]= "N/BG"                    && [ 8] vcolor for selected option
PDM_COLOR[ 9]= "N/BG"                    && [ 9] vcolor for selected trigger
PDM_COLOR[10]= "R/BG"                    && [10] vcolor for inactive option
PDM_COLOR[11]= "N/W"                     && [11] vcolor for message row

PUBLIC PDM_CONFG[9]                     && PDM configuration
PDM_CONFG[1]= 0                          && [1] = expN: box type: 0,1,2
PDM_CONFG[2]= 0                          && [2] = expN: row for horiz menu
PDM_CONFG[3]= 2                          && [3] = expN: row for box top
PDM_CONFG[4]= 22                         && [4] = expN: message row
PDM_CONFG[5]= 0                          && [5] = expN: time out
PDM_CONFG[6]= "W/B"                      && [6] = expC: color for init bottom panel
PDM_CONFG[7]= "W/B"                      && [7] = expC: color for init screen
PDM_CONFG[8]= 32                         && [8] = expN: char for init screen
*                                        && [9] = expC: text for init bottom panel
PDM_CONFG[9]= "[T23T56]Working Copy  Inserting                                   0%      Line 1 of Pg 1Esc-Main Menu                                                                   "

PDM_INIT()                    && Initialize remaining optional PDM PUBLIC arrays

RETURN .T.                                                 && End of: PDMSETUP()
*------------------------------------------------------------------------------*
*<eof>