
**
* Program Name: CAP.PRG
* Description.: Driver for PDM Menu System program
* Language....: Clipper S'87
* LIB required: CC.LIB v1.04, EXTEND.LIB
* Gen Time....: 06/08/91 17:58:22
* Generated by: PDM Sys - the ClipCode Pull Down Menu System  v1.06
**
*** Set CLIPPER Environment ***
SET CURSOR OFF
SET DELETED ON                          && Filter out Deleted Records
SET EXACT ON
SET SCOREBOARD OFF
SET SOFTSEEK OFF

PDMSETUP()

*** Set Color for Initial Screen ***
SET COLOR TO ( PDM_CONFG[7] )
@1,0 SAY REPLICATE( CHR( PDM_CONFG[8] ), 1840 ) && char for init screen

SET COLOR TO ( PDM_COLOR[1] )           && hcolor when not selected
@ PDM_CONFG[2],00

SET COLOR TO ( PDM_CONFG[6] )           && color for init bottom panel
@ PDM_CONFG[4],00
@ PDM_CONFG[4],00 SAY PDM_CONFG[9]      && text for init bottom panel

MENUPD( 0, 0 )                          && just display h menu

PRIVATE key, hOpt, vOpt, pdSEL, sv_panel
pdSel= 1
DO WHILE .T.

  *SETCANCEL(.F.)                        && Disable alt-C interrupt
  INKEY(0)
  key= LASTKEY()                        && key= INKEY(0) misses alt-D
  *SETCANCEL(.T.)                        && Enable alt-C interrupt

  DO CASE
  *?*CASE key = 28                         && F1=Help

  *?*CASE key = -2                         && F3=Exit
  ***  EXIT2DOS()

  CASE key = 27                         && Exit
    PRIVATE Opts[2]
    Opts[1]= "Yes"
    Opts[2]= "No"
     * Syntx: message text,       [ title,prmpts,colors,mRow,mColm,TmO ]
    IF BOXMSG( "Exit Program to DOS?",.F., Opts ) = 1
      EXIT
    ELSE
      LOOP
    ENDIF
  CASE key = -9                         && F10=Menu
    hOpt=  1
    vOpt=  0
  *?*CASE key = 3                          && PgDn=Next
  ***  SKIP 1
  ***  IF EOF()
  ***    BOXMSG( "At End-of-File" )
  ***    SKIP -1
  ***  ENDIF
  *?*CASE key = 18                         && PgUp=Prev
  ***  SKIP -1
  ***  IF BOF()
  ***    BOXMSG( "At Beginning-of-File" )
  ***  ENDIF

  CASE ASCAN( PDM_HOTKY, key ) > 0      && If found, returns the ss
    hOpt=  ASCAN( PDM_HOTKY, key )
    vOpt=  1
  OTHERWISE
    LOOP
  ENDCASE

  IF hOpt < 1
    LOOP
  ENDIF

  sv_panel= BOXSAVE( PDM_CONFG[4],00, PDM_CONFG[4],79 )
  pdSel   = 1
  DO WHILE pdSel <> 0

    pdSel= MENUPD( @hOpt, @vOpt )
    IF pdSel > 0
      DO CASE
      CASE pdSel =  1                    && Select a Data File
        SELECTFIL()
      CASE pdSel =  2                    && Create a new Data File
        CREATEFIL()
      CASE pdSel =  4                    && Exit CAP Program  F3
        EXIT2DOS()
      CASE pdSel =  5                    && Display the Data File
        DISPFIL()
      CASE pdSel =  6                    && Add a new label to the Data File
        ADDREC()
      CASE pdSel =  7                    && Change the current label's data
        CHGREC()
      CASE pdSel =  9                    && Delete the current label from the Data File
        DELREC()
      CASE pdSel = 10                    && Select a Label Format
        SELECTFMT()
      CASE pdSel = 11                    && Create a new Label Format
        CREATEFMT()
      CASE pdSel = 13                    && Print Labels
        DO PRINTLBL
      CASE pdSel = 14                    && Display the Current Configuration
        DISPCONFG()
      CASE pdSel = 15                    && Printer Selection
        SELECTPRN()
      CASE pdSel = 16                    && Screen Color Options
        SCRNCONFG()
      CASE pdSel = 17                    && Display Help Text   F1
        DISPHELP()
      OTHERWISE
        * Syntx: message text/array, [ title,prmpts,colors,mRow,mColm,TmO ]
        BOXMSG( "PDM Option Selected: "+LTRIM( STR(pdSel) ) )
      ENDCASE
    ENDIF
  ENDDO WHILE pdSel <> 0
  BOXREST( sv_panel )

ENDDO
SET COLOR TO
SET CURSOR ON
CLEAR
QUIT                                                    && End of: MAIN LINE
**

*------------------------------------------------------------------------------*
* Function....: PDMSETUP()
* Purpose.....: UDF to Create PDMSETUP()
* Parameters..: none
* Generated by: PDM - the ClipCode Pull Down Menu System
* Assumption..: the presence of these PUBLIC arrays:
*             : <arrC>: PDM_HPROM = horizontal menu prompt text
*             : <arrN>: PDM_HCOLM = horizontal starting columns for prompts
*             : <arrC>: PDM_HTRIG = horizontal trigger letters
*             : <arrN>: PDM_HTPOS = horizontal trigger letter positions
*             : <arrN>: PDM_VSS1  = starting array subscript
*             : <arrN>: PDM_VSS2  = ending array subscript
*             : <arrC>: PDM_VPROM = vertical menu prompt text
*             : <arrC>: PDM_VTRIG = vertical trigger letters
*             : <arrN>: PDM_VCOLM = vertical starting columns for v prompts
*             : <arrN>: PDM_VTPOS = vertical trigger letter positions
*             : <arrL>: PDM_VACTV = vertical active status array
*             : <arrC>: PDM_COLOR = PDM color strings for SET COLOR TO
*                                     [ 1] hcolor when not selected
*                                     [ 2] hcolor for unselected trigger
*                                     [ 3] hcolor for selected option
*                                     [ 4] hcolor for selected trigger
*                                     [ 5] vcolor for box
*                                     [ 6] vcolor when not selected
*                                     [ 7] vcolor for unselected trigger
*                                     [ 8] vcolor for selected option
*                                     [ 9] vcolor for selected trigger
*                                     [10] vcolor for inactive option
*                                     [11] vcolor for message row
*             : <arrC>: PDM_VMSSG = vertical message help text
*             : <arrX>: PDM_CONFG = PDM configuration
*                                     [1] = expN: box type: 0,1,2
*                                     [2] = expN: row for horiz menu
*                                     [3] = expN: row for box top
*                                     [4] = expN: message row
*                                     [5] = expN: time out
*                                     [6] = expC: color for init bottom panel
*                                     [7] = expC: color for init screen
*                                     [8] = expN: char for init screen
*                                     [9] = expC: text for init bottom panel
* Calls.......: PDM_INIT()
* CC.LIB Calls: ALONGEST(), ATNEXT()
* Language....: Clipper S'87
* Returns.....: <expL>: .T.
*------------------------------------------------------------------------------*
FUNCTION PDMSETUP

PRIVATE dimh, dimv, ss

*** MENUPD Horizontal ***
dimh= 6
PUBLIC PDM_HPROM[dimh]                  && horizontal menu prompt text
PDM_HPROM[1]= " File "
PDM_HPROM[2]= " View "
PDM_HPROM[3]= " Edit "
PDM_HPROM[4]= " Print "
PDM_HPROM[5]= " Configure "
PDM_HPROM[6]= " Help "

PUBLIC PDM_HCOLM[dimh]                  && horizontal starting columns for prompts
PDM_HCOLM[1]= 1
PDM_HCOLM[2]= 7
PDM_HCOLM[3]= 13
PDM_HCOLM[4]= 19
PDM_HCOLM[5]= 26
PDM_HCOLM[6]= 73

PUBLIC PDM_HOTKY[dimh]                  && horiz Hot/alt keys INKEY()
PDM_HOTKY[1]= 289
PDM_HOTKY[2]= 303
PDM_HOTKY[3]= 274
PDM_HOTKY[4]= 281
PDM_HOTKY[5]= 302
PDM_HOTKY[6]= 291

PUBLIC PDM_HTRIG[dimh]                  && horizontal trigger letters
PDM_HTRIG[1]= "F"
PDM_HTRIG[2]= "V"
PDM_HTRIG[3]= "E"
PDM_HTRIG[4]= "P"
PDM_HTRIG[5]= "C"
PDM_HTRIG[6]= "H"

PUBLIC PDM_HTPOS[dimh]                  && horizontal trigger letter  positions
PDM_HTPOS[1]= 2
PDM_HTPOS[2]= 2
PDM_HTPOS[3]= 2
PDM_HTPOS[4]= 2
PDM_HTPOS[5]= 2
PDM_HTPOS[6]= 2

*** PDMENUV Vertical ***
PUBLIC PDM_VSS1[dimh]                   && starting array subscript
PDM_VSS1[1]= 1
PDM_VSS1[2]= 5
PDM_VSS1[3]= 6
PDM_VSS1[4]= 10
PDM_VSS1[5]= 14
PDM_VSS1[6]= 17

dimv= 17
PUBLIC PDM_VPROM[dimv]                  && vertical menu prompt text
PDM_VPROM[ 1]= " Select a Data File     "
PDM_VPROM[ 2]= " Create a new Data File "
PDM_VPROM[ 3]= "-"
PDM_VPROM[ 4]= " Exit CAP Program  F3   "
PDM_VPROM[ 5]= " Display the Data File "
PDM_VPROM[ 6]= " Add a new label to the Data File            "
PDM_VPROM[ 7]= " Change the current label's data             "
PDM_VPROM[ 8]= "-"
PDM_VPROM[ 9]= " Delete the current label from the Data File "
PDM_VPROM[10]= " Select a Label Format     "
PDM_VPROM[11]= " Create a new Label Format "
PDM_VPROM[12]= "-"
PDM_VPROM[13]= " Print Labels              "
PDM_VPROM[14]= " Display the Current Configuration "
PDM_VPROM[15]= " Printer Selection                 "
PDM_VPROM[16]= " Screen Color Options              "
PDM_VPROM[17]= " Display Help Text   F1 "

PUBLIC PDM_VTRIG[dimv]                  && vertical trigger letters
PDM_VTRIG[ 1]= "S"
PDM_VTRIG[ 2]= "C"
PDM_VTRIG[ 3]= "-"
PDM_VTRIG[ 4]= "x"
PDM_VTRIG[ 5]= "D"
PDM_VTRIG[ 6]= "A"
PDM_VTRIG[ 7]= "C"
PDM_VTRIG[ 8]= "-"
PDM_VTRIG[ 9]= "D"
PDM_VTRIG[10]= "S"
PDM_VTRIG[11]= "C"
PDM_VTRIG[12]= "-"
PDM_VTRIG[13]= "P"
PDM_VTRIG[14]= "D"
PDM_VTRIG[15]= "P"
PDM_VTRIG[16]= "S"
PDM_VTRIG[17]= "D"

PUBLIC PDM_VTPOS[dimv]                  && vertical trigger letter positions
PDM_VTPOS[ 1]= 2
PDM_VTPOS[ 2]= 2
PDM_VTPOS[ 3]= 1
PDM_VTPOS[ 4]= 3
PDM_VTPOS[ 5]= 2
PDM_VTPOS[ 6]= 2
PDM_VTPOS[ 7]= 2
PDM_VTPOS[ 8]= 1
PDM_VTPOS[ 9]= 2
PDM_VTPOS[10]= 2
PDM_VTPOS[11]= 2
PDM_VTPOS[12]= 1
PDM_VTPOS[13]= 2
PDM_VTPOS[14]= 2
PDM_VTPOS[15]= 2
PDM_VTPOS[16]= 2
PDM_VTPOS[17]= 2

PUBLIC PDM_VACTV[dimv]                  && vertical active status array
AFILL( PDM_VACTV, .T. )
PDM_VACTV[ 3]= .F.
PDM_VACTV[ 8]= .F.
PDM_VACTV[12]= .F.

PUBLIC PDM_VMSSG[dimv]                  && vertical message help text
PDM_VMSSG[ 1]= "Select any available CAP Data File"
PDM_VMSSG[ 2]= "Create a new CAP Data File"
PDM_VMSSG[ 3]= "-"
PDM_VMSSG[ 4]= "Exit the CAP program"
PDM_VMSSG[ 5]= "View the currently selected Data file"
PDM_VMSSG[ 6]= "Add a new label to the Data File "
PDM_VMSSG[ 7]= "Change the currently viewed label data"
PDM_VMSSG[ 8]= "-"
PDM_VMSSG[ 9]= "Delete the currently viewed label data"
PDM_VMSSG[10]= "Select a Label Format"
PDM_VMSSG[11]= "Create a new Label Format"
PDM_VMSSG[12]= "-"
PDM_VMSSG[13]= "Print labels"
PDM_VMSSG[14]= "Display the current configuration selections"
PDM_VMSSG[15]= "Select printer options"
PDM_VMSSG[16]= "Select Screen Color Options "
PDM_VMSSG[17]= "Display Help Text "

PUBLIC PDM_COLOR[11]                    && PDM color strings for SET COLOR TO
PDM_COLOR[ 1]= "N/W"                     && [ 1] hcolor when not selected
PDM_COLOR[ 2]= "BG+/W"                   && [ 2] hcolor for unselected trigger
PDM_COLOR[ 3]= "W+/R"                    && [ 3] hcolor for selected option
PDM_COLOR[ 4]= "BG+/R"                   && [ 4] hcolor for selected trigger
PDM_COLOR[ 5]= "N/W"                     && [ 5] vcolor for box
PDM_COLOR[ 6]= "N/W"                     && [ 6] vcolor when not selected
PDM_COLOR[ 7]= "BG+/W"                   && [ 7] vcolor for unselected trigger
PDM_COLOR[ 8]= "W+/R"                    && [ 8] vcolor for selected option
PDM_COLOR[ 9]= "BG+/R"                   && [ 9] vcolor for selected trigger
PDM_COLOR[10]= "N+/W"                    && [10] vcolor for inactive option
PDM_COLOR[11]= "N/W"                     && [11] vcolor for message row

PUBLIC PDM_CONFG[9]                     && PDM configuration
PDM_CONFG[1]= 1                          && [1] = expN: box type: 0,1,2
PDM_CONFG[2]= 0                          && [2] = expN: row for horiz menu
PDM_CONFG[3]= 2                          && [3] = expN: row for box top
PDM_CONFG[4]= 24                         && [4] = expN: message row
PDM_CONFG[5]= 0                          && [5] = expN: time out
PDM_CONFG[6]= "N/W"                      && [6] = expC: color for init bottom panel
PDM_CONFG[7]= "W+/B"                     && [7] = expC: color for init screen
PDM_CONFG[8]= 176                        && [8] = expN: char for init screen
*                                        && [9] = expC: text for init bottom panel
PDM_CONFG[9]= " Alt+Letter=Menu  Esc=Cancel  F1=Help  F3=Exit  F10=Menu  PgDn=Next PgUp=Prev"

PDM_INIT()                    && Initialize remaining optional PDM PUBLIC arrays

RETURN .T.                                                 && End of: PDMSETUP()
*------------------------------------------------------------------------------*

*------------------------------------------------------------------------------*
* Function..: SELECTFIL()
* Purpose...: Select a Data File
* Parameters: 
* Cautions..: none
* Returns...: <expL>: .T.
*------------------------------------------------------------------------------*
FUNCTION SELECTFIL
*PARAM 

*PRIVATE 

BOXMSG( "PDM Option Selected: "+LTRIM( STR(pdSel) ) )    && *?* temp

RETURN .T.                                                && End of: SELECTFIL()
*------------------------------------------------------------------------------*

*------------------------------------------------------------------------------*
* Function..: CREATEFIL()
* Purpose...: Create a new Data File
* Parameters: 
* Cautions..: none
* Returns...: <expL>: .T.
*------------------------------------------------------------------------------*
FUNCTION CREATEFIL
*PARAM 

*PRIVATE 

BOXMSG( "PDM Option Selected: "+LTRIM( STR(pdSel) ) )    && *?* temp

RETURN .T.                                                && End of: CREATEFIL()
*------------------------------------------------------------------------------*

*------------------------------------------------------------------------------*
* Function..: EXIT2DOS()
* Purpose...: Exit CAP Program  F3
* Parameters: 
* Cautions..: none
* Returns...: <expL>: .T.
*------------------------------------------------------------------------------*
FUNCTION EXIT2DOS
*PARAM 

*PRIVATE 

BOXMSG( "PDM Option Selected: "+LTRIM( STR(pdSel) ) )    && *?* temp

RETURN .T.                                                 && End of: EXIT2DOS()
*------------------------------------------------------------------------------*

*------------------------------------------------------------------------------*
* Function..: DISPFIL()
* Purpose...: Display the Data File
* Parameters: 
* Cautions..: none
* Returns...: <expL>: .T.
*------------------------------------------------------------------------------*
FUNCTION DISPFIL
*PARAM 

*PRIVATE 

BOXMSG( "PDM Option Selected: "+LTRIM( STR(pdSel) ) )    && *?* temp

RETURN .T.                                                  && End of: DISPFIL()
*------------------------------------------------------------------------------*

*------------------------------------------------------------------------------*
* Function..: ADDREC()
* Purpose...: Add a new label to the Data File
* Parameters: 
* Cautions..: none
* Returns...: <expL>: .T.
*------------------------------------------------------------------------------*
FUNCTION ADDREC
*PARAM 

*PRIVATE 

BOXMSG( "PDM Option Selected: "+LTRIM( STR(pdSel) ) )    && *?* temp

RETURN .T.                                                   && End of: ADDREC()
*------------------------------------------------------------------------------*

*------------------------------------------------------------------------------*
* Function..: CHGREC()
* Purpose...: Change the current label's data
* Parameters: 
* Cautions..: none
* Returns...: <expL>: .T.
*------------------------------------------------------------------------------*
FUNCTION CHGREC
*PARAM 

*PRIVATE 

BOXMSG( "PDM Option Selected: "+LTRIM( STR(pdSel) ) )    && *?* temp

RETURN .T.                                                   && End of: CHGREC()
*------------------------------------------------------------------------------*

*------------------------------------------------------------------------------*
* Function..: DELREC()
* Purpose...: Delete the current label from the Data File
* Parameters: 
* Cautions..: none
* Returns...: <expL>: .T.
*------------------------------------------------------------------------------*
FUNCTION DELREC
*PARAM 

*PRIVATE 

BOXMSG( "PDM Option Selected: "+LTRIM( STR(pdSel) ) )    && *?* temp

RETURN .T.                                                   && End of: DELREC()
*------------------------------------------------------------------------------*

*------------------------------------------------------------------------------*
* Function..: SELECTFMT()
* Purpose...: Select a Label Format
* Parameters: 
* Cautions..: none
* Returns...: <expL>: .T.
*------------------------------------------------------------------------------*
FUNCTION SELECTFMT
*PARAM 

*PRIVATE 

BOXMSG( "PDM Option Selected: "+LTRIM( STR(pdSel) ) )    && *?* temp

RETURN .T.                                                && End of: SELECTFMT()
*------------------------------------------------------------------------------*

*------------------------------------------------------------------------------*
* Function..: CREATEFMT()
* Purpose...: Create a new Label Format
* Parameters: 
* Cautions..: none
* Returns...: <expL>: .T.
*------------------------------------------------------------------------------*
FUNCTION CREATEFMT
*PARAM 

*PRIVATE 

BOXMSG( "PDM Option Selected: "+LTRIM( STR(pdSel) ) )    && *?* temp

RETURN .T.                                                && End of: CREATEFMT()
*------------------------------------------------------------------------------*

*------------------------------------------------------------------------------*
* Procedure.: PRINTLBL
* Purpose...: Print Labels
* Parameters: 
* Cautions..: none
* Returns...: <expL>: .T.
*------------------------------------------------------------------------------*
PROCEDURE PRINTLBL
*PARAM 

*PRIVATE 

BOXMSG( "PDM Option Selected: "+LTRIM( STR(pdSel) ) )    && *?* temp

RETURN                                                  && End of: PROC PRINTLBL
*------------------------------------------------------------------------------*

*------------------------------------------------------------------------------*
* Function..: DISPCONFG()
* Purpose...: Display the Current Configuration
* Parameters: 
* Cautions..: none
* Returns...: <expL>: .T.
*------------------------------------------------------------------------------*
FUNCTION DISPCONFG
*PARAM 

*PRIVATE 

BOXMSG( "PDM Option Selected: "+LTRIM( STR(pdSel) ) )    && *?* temp

RETURN .T.                                                && End of: DISPCONFG()
*------------------------------------------------------------------------------*

*------------------------------------------------------------------------------*
* Function..: SELECTPRN()
* Purpose...: Printer Selection
* Parameters: 
* Cautions..: none
* Returns...: <expL>: .T.
*------------------------------------------------------------------------------*
FUNCTION SELECTPRN
*PARAM 

*PRIVATE 

BOXMSG( "PDM Option Selected: "+LTRIM( STR(pdSel) ) )    && *?* temp

RETURN .T.                                                && End of: SELECTPRN()
*------------------------------------------------------------------------------*

*------------------------------------------------------------------------------*
* Function..: SCRNCONFG()
* Purpose...: Screen Color Options
* Parameters: 
* Cautions..: none
* Returns...: <expL>: .T.
*------------------------------------------------------------------------------*
FUNCTION SCRNCONFG
*PARAM 

*PRIVATE 

BOXMSG( "PDM Option Selected: "+LTRIM( STR(pdSel) ) )    && *?* temp

RETURN .T.                                                && End of: SCRNCONFG()
*------------------------------------------------------------------------------*

*------------------------------------------------------------------------------*
* Function..: DISPHELP()
* Purpose...: Display Help Text   F1
* Parameters: 
* Cautions..: none
* Returns...: <expL>: .T.
*------------------------------------------------------------------------------*
FUNCTION DISPHELP
*PARAM 

*PRIVATE 

BOXMSG( "PDM Option Selected: "+LTRIM( STR(pdSel) ) )    && *?* temp

RETURN .T.                                                 && End of: DISPHELP()
*------------------------------------------------------------------------------*
*<eof>