
**
* Program Name: QC20.PRG
* Description.: Driver for PDM Menu System program
* Language....: Clipper S'87
* LIB required: CC.LIB v1.04, EXTEND.LIB
* Gen Time....: 06/08/91 17:59:31
* Generated by: PDM Sys - the ClipCode Pull Down Menu System  v1.06
**
*** Set CLIPPER Environment ***
SET CURSOR OFF
SET DELETED ON                          && Filter out Deleted Records
SET EXACT ON
SET SCOREBOARD OFF
SET SOFTSEEK OFF

PDMSETUP()

*** Set Color for Initial Screen ***
SET COLOR TO ( PDM_CONFG[7] )
@1,0 SAY REPLICATE( CHR( PDM_CONFG[8] ), 1840 ) && char for init screen

SET COLOR TO ( PDM_COLOR[1] )           && hcolor when not selected
@ PDM_CONFG[2],00

SET COLOR TO ( PDM_CONFG[6] )           && color for init bottom panel
@ PDM_CONFG[4],00
@ PDM_CONFG[4],00 SAY PDM_CONFG[9]      && text for init bottom panel

MENUPD( 0, 0 )                          && just display h menu

PRIVATE key, hOpt, vOpt, pdSEL, sv_panel
pdSel= 1
DO WHILE .T.

  *SETCANCEL(.F.)                        && Disable alt-C interrupt
  INKEY(0)
  key= LASTKEY()                        && key= INKEY(0) misses alt-D
  *SETCANCEL(.T.)                        && Enable alt-C interrupt

  DO CASE
  *?*CASE key = 28                         && F1=Help

  *?*CASE key = -2                         && F3=Exit
  ***  EXIT2DOS()

  CASE key = 27                         && Exit
    PRIVATE Opts[2]
    Opts[1]= "Yes"
    Opts[2]= "No"
     * Syntx: message text,       [ title,prmpts,colors,mRow,mColm,TmO ]
    IF BOXMSG( "Exit Program to DOS?",.F., Opts ) = 1
      EXIT
    ELSE
      LOOP
    ENDIF
  CASE key = -9                         && F10=Menu
    hOpt=  1
    vOpt=  0
  *?*CASE key = 3                          && PgDn=Next
  ***  SKIP 1
  ***  IF EOF()
  ***    BOXMSG( "At End-of-File" )
  ***    SKIP -1
  ***  ENDIF
  *?*CASE key = 18                         && PgUp=Prev
  ***  SKIP -1
  ***  IF BOF()
  ***    BOXMSG( "At Beginning-of-File" )
  ***  ENDIF

  CASE ASCAN( PDM_HOTKY, key ) > 0      && If found, returns the ss
    hOpt=  ASCAN( PDM_HOTKY, key )
    vOpt=  1
  OTHERWISE
    LOOP
  ENDCASE

  IF hOpt < 1
    LOOP
  ENDIF

  sv_panel= BOXSAVE( PDM_CONFG[4],00, PDM_CONFG[4],79 )
  pdSel   = 1
  DO WHILE pdSel <> 0

    pdSel= MENUPD( @hOpt, @vOpt )
    IF pdSel > 0
      DO CASE
      OTHERWISE
        * Syntx: message text/array, [ title,prmpts,colors,mRow,mColm,TmO ]
        BOXMSG( "PDM Option Selected: "+LTRIM( STR(pdSel) ) )
      ENDCASE
    ENDIF
  ENDDO WHILE pdSel <> 0
  BOXREST( sv_panel )

ENDDO
SET COLOR TO
SET CURSOR ON
CLEAR
QUIT                                                    && End of: MAIN LINE
**

*------------------------------------------------------------------------------*
* Function....: PDMSETUP()
* Purpose.....: UDF to Create PDMSETUP()
* Parameters..: none
* Generated by: PDM - the ClipCode Pull Down Menu System
* Assumption..: the presence of these PUBLIC arrays:
*             : <arrC>: PDM_HPROM = horizontal menu prompt text
*             : <arrN>: PDM_HCOLM = horizontal starting columns for prompts
*             : <arrC>: PDM_HTRIG = horizontal trigger letters
*             : <arrN>: PDM_HTPOS = horizontal trigger letter positions
*             : <arrN>: PDM_VSS1  = starting array subscript
*             : <arrN>: PDM_VSS2  = ending array subscript
*             : <arrC>: PDM_VPROM = vertical menu prompt text
*             : <arrC>: PDM_VTRIG = vertical trigger letters
*             : <arrN>: PDM_VCOLM = vertical starting columns for v prompts
*             : <arrN>: PDM_VTPOS = vertical trigger letter positions
*             : <arrL>: PDM_VACTV = vertical active status array
*             : <arrC>: PDM_COLOR = PDM color strings for SET COLOR TO
*                                     [ 1] hcolor when not selected
*                                     [ 2] hcolor for unselected trigger
*                                     [ 3] hcolor for selected option
*                                     [ 4] hcolor for selected trigger
*                                     [ 5] vcolor for box
*                                     [ 6] vcolor when not selected
*                                     [ 7] vcolor for unselected trigger
*                                     [ 8] vcolor for selected option
*                                     [ 9] vcolor for selected trigger
*                                     [10] vcolor for inactive option
*                                     [11] vcolor for message row
*             : <arrC>: PDM_VMSSG = vertical message help text
*             : <arrX>: PDM_CONFG = PDM configuration
*                                     [1] = expN: box type: 0,1,2
*                                     [2] = expN: row for horiz menu
*                                     [3] = expN: row for box top
*                                     [4] = expN: message row
*                                     [5] = expN: time out
*                                     [6] = expC: color for init bottom panel
*                                     [7] = expC: color for init screen
*                                     [8] = expN: char for init screen
*                                     [9] = expC: text for init bottom panel
* Calls.......: PDM_INIT()
* CC.LIB Calls: ALONGEST(), ATNEXT()
* Language....: Clipper S'87
* Returns.....: <expL>: .T.
*------------------------------------------------------------------------------*
FUNCTION PDMSETUP

PRIVATE dimh, dimv, ss

*** MENUPD Horizontal ***
dimh= 10
PUBLIC PDM_HPROM[dimh]                  && horizontal menu prompt text
PDM_HPROM[ 1]= " File "
PDM_HPROM[ 2]= " Edit "
PDM_HPROM[ 3]= " View "
PDM_HPROM[ 4]= " Search "
PDM_HPROM[ 5]= " Make "
PDM_HPROM[ 6]= " Run "
PDM_HPROM[ 7]= " Debug "
PDM_HPROM[ 8]= " Utility "
PDM_HPROM[ 9]= " Options "
PDM_HPROM[10]= " Help "

PUBLIC PDM_HCOLM[dimh]                  && horizontal starting columns for prompts
PDM_HCOLM[ 1]= 1
PDM_HCOLM[ 2]= 7
PDM_HCOLM[ 3]= 13
PDM_HCOLM[ 4]= 19
PDM_HCOLM[ 5]= 27
PDM_HCOLM[ 6]= 33
PDM_HCOLM[ 7]= 38
PDM_HCOLM[ 8]= 45
PDM_HCOLM[ 9]= 54
PDM_HCOLM[10]= 73

PUBLIC PDM_HOTKY[dimh]                  && horiz Hot/alt keys INKEY()
PDM_HOTKY[ 1]= 289
PDM_HOTKY[ 2]= 274
PDM_HOTKY[ 3]= 303
PDM_HOTKY[ 4]= 287
PDM_HOTKY[ 5]= 306
PDM_HOTKY[ 6]= 275
PDM_HOTKY[ 7]= 288
PDM_HOTKY[ 8]= 278
PDM_HOTKY[ 9]= 280
PDM_HOTKY[10]= 291

PUBLIC PDM_HTRIG[dimh]                  && horizontal trigger letters
PDM_HTRIG[ 1]= "F"
PDM_HTRIG[ 2]= "E"
PDM_HTRIG[ 3]= "V"
PDM_HTRIG[ 4]= "S"
PDM_HTRIG[ 5]= "M"
PDM_HTRIG[ 6]= "R"
PDM_HTRIG[ 7]= "D"
PDM_HTRIG[ 8]= "U"
PDM_HTRIG[ 9]= "O"
PDM_HTRIG[10]= "H"

PUBLIC PDM_HTPOS[dimh]                  && horizontal trigger letter  positions
PDM_HTPOS[ 1]= 2
PDM_HTPOS[ 2]= 2
PDM_HTPOS[ 3]= 2
PDM_HTPOS[ 4]= 2
PDM_HTPOS[ 5]= 2
PDM_HTPOS[ 6]= 2
PDM_HTPOS[ 7]= 2
PDM_HTPOS[ 8]= 2
PDM_HTPOS[ 9]= 2
PDM_HTPOS[10]= 2

*** PDMENUV Vertical ***
PUBLIC PDM_VSS1[dimh]                   && starting array subscript
PDM_VSS1[ 1]= 1
PDM_VSS1[ 2]= 13
PDM_VSS1[ 3]= 20
PDM_VSS1[ 4]= 26
PDM_VSS1[ 5]= 35
PDM_VSS1[ 6]= 42
PDM_VSS1[ 7]= 48
PDM_VSS1[ 8]= 59
PDM_VSS1[ 9]= 65
PDM_VSS1[10]= 70

dimv= 73
PUBLIC PDM_VPROM[dimv]                  && vertical menu prompt text
PDM_VPROM[ 1]= " New                "
PDM_VPROM[ 2]= " Open...            "
PDM_VPROM[ 3]= " Open Last File  F2 "
PDM_VPROM[ 4]= " Merge...           "
PDM_VPROM[ 5]= " Save               "
PDM_VPROM[ 6]= " Save As...         "
PDM_VPROM[ 7]= " Save All           "
PDM_VPROM[ 8]= "-"
PDM_VPROM[ 9]= " Print...           "
PDM_VPROM[10]= " DOS Shell          "
PDM_VPROM[11]= "-"
PDM_VPROM[12]= " Exit        Alt+F4 "
PDM_VPROM[13]= " Undo  Alt+Backspace "
PDM_VPROM[14]= " Cut       Shift+Del "
PDM_VPROM[15]= " Copy       Ctrl+Ins "
PDM_VPROM[16]= " Paste     Shift+Ins "
PDM_VPROM[17]= " Clear           Del "
PDM_VPROM[18]= "-"
PDM_VPROM[19]= " Read Only           "
PDM_VPROM[20]= " Source...          "
PDM_VPROM[21]= " Include...         "
PDM_VPROM[22]= "-"
PDM_VPROM[23]= " Output Screen   F4 "
PDM_VPROM[24]= " Maximize  Ctrl+F10 "
PDM_VPROM[25]= " Windows...         "
PDM_VPROM[26]= " Find...                  "
PDM_VPROM[27]= " Selected Text     Ctrl+\ "
PDM_VPROM[28]= " Repeat Last Find      F3 "
PDM_VPROM[29]= " Change...                "
PDM_VPROM[30]= "-"
PDM_VPROM[31]= " Function...              "
PDM_VPROM[32]= "-"
PDM_VPROM[33]= " Next Error      Shift+F3 "
PDM_VPROM[34]= " Previous Error  Shift+F4 "
PDM_VPROM[35]= " Compile File      UNTITLED.C   "
PDM_VPROM[36]= " Build Program     UNTITLED.EXE "
PDM_VPROM[37]= " Rebuild All       UNTITLED.EXE "
PDM_VPROM[38]= "-"
PDM_VPROM[39]= " Set Program List...            "
PDM_VPROM[40]= " Edit Program List...           "
PDM_VPROM[41]= " Clear Program List             "
PDM_VPROM[42]= " Restart       Shift+F5 "
PDM_VPROM[43]= " Go                  F5 "
PDM_VPROM[44]= " Continue To Cursor  F7 "
PDM_VPROM[45]= " Trace Into          F8 "
PDM_VPROM[46]= " Step Over          F10 "
PDM_VPROM[47]= " Animate                "
PDM_VPROM[48]= " Calls...            "
PDM_VPROM[49]= " Breakpoint...    F9 "
PDM_VPROM[50]= " Watchpoint...       "
PDM_VPROM[51]= "-"
PDM_VPROM[52]= " Watch Value...      "
PDM_VPROM[53]= " Modify Value...     "
PDM_VPROM[54]= "-"
PDM_VPROM[55]= " History On          "
PDM_VPROM[56]= " Undo                "
PDM_VPROM[57]= " Replay              "
PDM_VPROM[58]= " Truncate User Input "
PDM_VPROM[59]= " Run DOS Command...    "
PDM_VPROM[60]= " Customize Menu...     "
PDM_VPROM[61]= "-"
PDM_VPROM[62]= " Brief Editor  Alt+F10 "
PDM_VPROM[63]= " PFM            Alt+F9 "
PDM_VPROM[64]= " Learn QuickC          "
PDM_VPROM[65]= " Display...     "
PDM_VPROM[66]= " Make...        "
PDM_VPROM[67]= " Run / Debug... "
PDM_VPROM[68]= " Environment... "
PDM_VPROM[69]= " Full Menus     "
PDM_VPROM[70]= " Index                  "
PDM_VPROM[71]= " Contents               "
PDM_VPROM[72]= " Topic:              F1 "
PDM_VPROM[73]= " Help On Help  Shift+F1 "

PUBLIC PDM_VTRIG[dimv]                  && vertical trigger letters
PDM_VTRIG[ 1]= "N"
PDM_VTRIG[ 2]= "O"
PDM_VTRIG[ 3]= "O"
PDM_VTRIG[ 4]= "M"
PDM_VTRIG[ 5]= "S"
PDM_VTRIG[ 6]= "A"
PDM_VTRIG[ 7]= "v"
PDM_VTRIG[ 8]= "-"
PDM_VTRIG[ 9]= "P"
PDM_VTRIG[10]= "D"
PDM_VTRIG[11]= "-"
PDM_VTRIG[12]= "x"
PDM_VTRIG[13]= "U"
PDM_VTRIG[14]= "C"
PDM_VTRIG[15]= "o"
PDM_VTRIG[16]= "P"
PDM_VTRIG[17]= "l"
PDM_VTRIG[18]= "-"
PDM_VTRIG[19]= "R"
PDM_VTRIG[20]= "S"
PDM_VTRIG[21]= "I"
PDM_VTRIG[22]= "-"
PDM_VTRIG[23]= "O"
PDM_VTRIG[24]= "z"
PDM_VTRIG[25]= "W"
PDM_VTRIG[26]= "F"
PDM_VTRIG[27]= "S"
PDM_VTRIG[28]= "R"
PDM_VTRIG[29]= "C"
PDM_VTRIG[30]= "-"
PDM_VTRIG[31]= "u"
PDM_VTRIG[32]= "-"
PDM_VTRIG[33]= "N"
PDM_VTRIG[34]= "P"
PDM_VTRIG[35]= "C"
PDM_VTRIG[36]= "B"
PDM_VTRIG[37]= "R"
PDM_VTRIG[38]= "-"
PDM_VTRIG[39]= "S"
PDM_VTRIG[40]= "E"
PDM_VTRIG[41]= "P"
PDM_VTRIG[42]= "R"
PDM_VTRIG[43]= "G"
PDM_VTRIG[44]= "C"
PDM_VTRIG[45]= "T"
PDM_VTRIG[46]= "S"
PDM_VTRIG[47]= "A"
PDM_VTRIG[48]= "C"
PDM_VTRIG[49]= "B"
PDM_VTRIG[50]= "p"
PDM_VTRIG[51]= "-"
PDM_VTRIG[52]= "W"
PDM_VTRIG[53]= "M"
PDM_VTRIG[54]= "-"
PDM_VTRIG[55]= "H"
PDM_VTRIG[56]= "U"
PDM_VTRIG[57]= "R"
PDM_VTRIG[58]= "T"
PDM_VTRIG[59]= "R"
PDM_VTRIG[60]= "C"
PDM_VTRIG[61]= "-"
PDM_VTRIG[62]= "B"
PDM_VTRIG[63]= "P"
PDM_VTRIG[64]= "L"
PDM_VTRIG[65]= "D"
PDM_VTRIG[66]= "M"
PDM_VTRIG[67]= "R"
PDM_VTRIG[68]= "E"
PDM_VTRIG[69]= "F"
PDM_VTRIG[70]= "I"
PDM_VTRIG[71]= "C"
PDM_VTRIG[72]= "T"
PDM_VTRIG[73]= "H"

PUBLIC PDM_VTPOS[dimv]                  && vertical trigger letter positions
PDM_VTPOS[ 1]= 2
PDM_VTPOS[ 2]= 2
PDM_VTPOS[ 3]= 2
PDM_VTPOS[ 4]= 2
PDM_VTPOS[ 5]= 2
PDM_VTPOS[ 6]= 7
PDM_VTPOS[ 7]= 4
PDM_VTPOS[ 8]= 1
PDM_VTPOS[ 9]= 2
PDM_VTPOS[10]= 2
PDM_VTPOS[11]= 1
PDM_VTPOS[12]= 3
PDM_VTPOS[13]= 2
PDM_VTPOS[14]= 2
PDM_VTPOS[15]= 3
PDM_VTPOS[16]= 2
PDM_VTPOS[17]= 3
PDM_VTPOS[18]= 1
PDM_VTPOS[19]= 2
PDM_VTPOS[20]= 2
PDM_VTPOS[21]= 2
PDM_VTPOS[22]= 1
PDM_VTPOS[23]= 2
PDM_VTPOS[24]= 8
PDM_VTPOS[25]= 2
PDM_VTPOS[26]= 2
PDM_VTPOS[27]= 2
PDM_VTPOS[28]= 2
PDM_VTPOS[29]= 2
PDM_VTPOS[30]= 1
PDM_VTPOS[31]= 2
PDM_VTPOS[32]= 1
PDM_VTPOS[33]= 2
PDM_VTPOS[34]= 2
PDM_VTPOS[35]= 2
PDM_VTPOS[36]= 2
PDM_VTPOS[37]= 2
PDM_VTPOS[38]= 1
PDM_VTPOS[39]= 2
PDM_VTPOS[40]= 2
PDM_VTPOS[41]= 8
PDM_VTPOS[42]= 2
PDM_VTPOS[43]= 2
PDM_VTPOS[44]= 2
PDM_VTPOS[45]= 2
PDM_VTPOS[46]= 2
PDM_VTPOS[47]= 2
PDM_VTPOS[48]= 2
PDM_VTPOS[49]= 2
PDM_VTPOS[50]= 7
PDM_VTPOS[51]= 1
PDM_VTPOS[52]= 2
PDM_VTPOS[53]= 2
PDM_VTPOS[54]= 1
PDM_VTPOS[55]= 2
PDM_VTPOS[56]= 2
PDM_VTPOS[57]= 2
PDM_VTPOS[58]= 2
PDM_VTPOS[59]= 2
PDM_VTPOS[60]= 2
PDM_VTPOS[61]= 1
PDM_VTPOS[62]= 2
PDM_VTPOS[63]= 2
PDM_VTPOS[64]= 2
PDM_VTPOS[65]= 2
PDM_VTPOS[66]= 2
PDM_VTPOS[67]= 2
PDM_VTPOS[68]= 2
PDM_VTPOS[69]= 2
PDM_VTPOS[70]= 2
PDM_VTPOS[71]= 2
PDM_VTPOS[72]= 2
PDM_VTPOS[73]= 2

PUBLIC PDM_VACTV[dimv]                  && vertical active status array
AFILL( PDM_VACTV, .T. )
PDM_VACTV[ 3]= .F.
PDM_VACTV[ 8]= .F.
PDM_VACTV[11]= .F.
PDM_VACTV[13]= .F.
PDM_VACTV[14]= .F.
PDM_VACTV[15]= .F.
PDM_VACTV[16]= .F.
PDM_VACTV[17]= .F.
PDM_VACTV[18]= .F.
PDM_VACTV[20]= .F.
PDM_VACTV[22]= .F.
PDM_VACTV[30]= .F.
PDM_VACTV[31]= .F.
PDM_VACTV[32]= .F.
PDM_VACTV[33]= .F.
PDM_VACTV[34]= .F.
PDM_VACTV[35]= .F.
PDM_VACTV[38]= .F.
PDM_VACTV[40]= .F.
PDM_VACTV[41]= .F.
PDM_VACTV[48]= .F.
PDM_VACTV[51]= .F.
PDM_VACTV[54]= .F.
PDM_VACTV[56]= .F.
PDM_VACTV[57]= .F.
PDM_VACTV[58]= .F.
PDM_VACTV[61]= .F.

PUBLIC PDM_COLOR[11]                    && PDM color strings for SET COLOR TO
PDM_COLOR[ 1]= "N/W"                     && [ 1] hcolor when not selected
PDM_COLOR[ 2]= "W+/W"                    && [ 2] hcolor for unselected trigger
PDM_COLOR[ 3]= "W/N"                     && [ 3] hcolor for selected option
PDM_COLOR[ 4]= "W+/N"                    && [ 4] hcolor for selected trigger
PDM_COLOR[ 5]= "N/W"                     && [ 5] vcolor for box
PDM_COLOR[ 6]= "N/W"                     && [ 6] vcolor when not selected
PDM_COLOR[ 7]= "W+/W"                    && [ 7] vcolor for unselected trigger
PDM_COLOR[ 8]= "W/N"                     && [ 8] vcolor for selected option
PDM_COLOR[ 9]= "W+/N"                    && [ 9] vcolor for selected trigger
PDM_COLOR[10]= "N+/W"                    && [10] vcolor for inactive option
PDM_COLOR[11]= "N/W"                     && [11] vcolor for message row

PUBLIC PDM_CONFG[9]                     && PDM configuration
PDM_CONFG[1]= 1                          && [1] = expN: box type: 0,1,2
PDM_CONFG[2]= 0                          && [2] = expN: row for horiz menu
PDM_CONFG[3]= 2                          && [3] = expN: row for box top
PDM_CONFG[4]= 24                         && [4] = expN: message row
PDM_CONFG[5]= 0                          && [5] = expN: time out
PDM_CONFG[6]= "N/W"                      && [6] = expC: color for init bottom panel
PDM_CONFG[7]= "W+/B"                     && [7] = expC: color for init screen
PDM_CONFG[8]= 176                        && [8] = expN: char for init screen
*                                        && [9] = expC: text for init bottom panel
PDM_CONFG[9]= " Enter=Select Esc=Cancel F1=Help F10=Menu "

PDM_INIT()                    && Initialize remaining optional PDM PUBLIC arrays

RETURN .T.                                                 && End of: PDMSETUP()
*------------------------------------------------------------------------------*
*<eof>