
**
* Program Name: PDMDEMO1.PRG
* Description.: Driver for PDM Menu System program
* Language....: Clipper S'87
* LIB required: CC.LIB v1.04, EXTEND.LIB
* Gen Time....: 06/08/91 17:57:40
* Generated by: PDM Sys - the ClipCode Pull Down Menu System  v1.06
**
*** Set CLIPPER Environment ***
SET CURSOR OFF
SET DELETED ON                          && Filter out Deleted Records
SET EXACT ON
SET SCOREBOARD OFF
SET SOFTSEEK OFF

PDMSETUP()

*** Set Color for Initial Screen ***
SET COLOR TO ( PDM_CONFG[7] )
@1,0 SAY REPLICATE( CHR( PDM_CONFG[8] ), 1840 ) && char for init screen

SET COLOR TO ( PDM_COLOR[1] )           && hcolor when not selected
@ PDM_CONFG[2],00

SET COLOR TO ( PDM_CONFG[6] )           && color for init bottom panel
@ PDM_CONFG[4],00
@ PDM_CONFG[4],00 SAY PDM_CONFG[9]      && text for init bottom panel

MENUPD( 0, 0 )                          && just display h menu

PRIVATE key, hOpt, vOpt, pdSEL, sv_panel
pdSel= 1
DO WHILE .T.

  *SETCANCEL(.F.)                        && Disable alt-C interrupt
  INKEY(0)
  key= LASTKEY()                        && key= INKEY(0) misses alt-D
  *SETCANCEL(.T.)                        && Enable alt-C interrupt

  DO CASE
  *?*CASE key = 28                         && F1=Help

  *?*CASE key = -2                         && F3=Exit
  ***  EXIT2DOS()

  CASE key = 27                         && Exit
    PRIVATE Opts[2]
    Opts[1]= "Yes"
    Opts[2]= "No"
     * Syntx: message text,       [ title,prmpts,colors,mRow,mColm,TmO ]
    IF BOXMSG( "Exit Program to DOS?",.F., Opts ) = 1
      EXIT
    ELSE
      LOOP
    ENDIF
  CASE key = -9                         && F10=Menu
    hOpt=  1
    vOpt=  0
  *?*CASE key = 3                          && PgDn=Next
  ***  SKIP 1
  ***  IF EOF()
  ***    BOXMSG( "At End-of-File" )
  ***    SKIP -1
  ***  ENDIF
  *?*CASE key = 18                         && PgUp=Prev
  ***  SKIP -1
  ***  IF BOF()
  ***    BOXMSG( "At Beginning-of-File" )
  ***  ENDIF

  CASE ASCAN( PDM_HOTKY, key ) > 0      && If found, returns the ss
    hOpt=  ASCAN( PDM_HOTKY, key )
    vOpt=  1
  OTHERWISE
    LOOP
  ENDCASE

  IF hOpt < 1
    LOOP
  ENDIF

  sv_panel= BOXSAVE( PDM_CONFG[4],00, PDM_CONFG[4],79 )
  pdSel   = 1
  DO WHILE pdSel <> 0

    pdSel= MENUPD( @hOpt, @vOpt )
    IF pdSel > 0
      DO CASE
      OTHERWISE
        * Syntx: message text/array, [ title,prmpts,colors,mRow,mColm,TmO ]
        BOXMSG( "PDM Option Selected: "+LTRIM( STR(pdSel) ) )
      ENDCASE
    ENDIF
  ENDDO WHILE pdSel <> 0
  BOXREST( sv_panel )

ENDDO
SET COLOR TO
SET CURSOR ON
CLEAR
QUIT                                                    && End of: MAIN LINE
**

*------------------------------------------------------------------------------*
* Function....: PDMSETUP()
* Purpose.....: UDF to Create PDMSETUP()
* Parameters..: none
* Generated by: PDM - the ClipCode Pull Down Menu System
* Assumption..: the presence of these PUBLIC arrays:
*             : <arrC>: PDM_HPROM = horizontal menu prompt text
*             : <arrN>: PDM_HCOLM = horizontal starting columns for prompts
*             : <arrC>: PDM_HTRIG = horizontal trigger letters
*             : <arrN>: PDM_HTPOS = horizontal trigger letter positions
*             : <arrN>: PDM_VSS1  = starting array subscript
*             : <arrN>: PDM_VSS2  = ending array subscript
*             : <arrC>: PDM_VPROM = vertical menu prompt text
*             : <arrC>: PDM_VTRIG = vertical trigger letters
*             : <arrN>: PDM_VCOLM = vertical starting columns for v prompts
*             : <arrN>: PDM_VTPOS = vertical trigger letter positions
*             : <arrL>: PDM_VACTV = vertical active status array
*             : <arrC>: PDM_COLOR = PDM color strings for SET COLOR TO
*                                     [ 1] hcolor when not selected
*                                     [ 2] hcolor for unselected trigger
*                                     [ 3] hcolor for selected option
*                                     [ 4] hcolor for selected trigger
*                                     [ 5] vcolor for box
*                                     [ 6] vcolor when not selected
*                                     [ 7] vcolor for unselected trigger
*                                     [ 8] vcolor for selected option
*                                     [ 9] vcolor for selected trigger
*                                     [10] vcolor for inactive option
*                                     [11] vcolor for message row
*             : <arrC>: PDM_VMSSG = vertical message help text
*             : <arrX>: PDM_CONFG = PDM configuration
*                                     [1] = expN: box type: 0,1,2
*                                     [2] = expN: row for horiz menu
*                                     [3] = expN: row for box top
*                                     [4] = expN: message row
*                                     [5] = expN: time out
*                                     [6] = expC: color for init bottom panel
*                                     [7] = expC: color for init screen
*                                     [8] = expN: char for init screen
*                                     [9] = expC: text for init bottom panel
* Calls.......: PDM_INIT()
* CC.LIB Calls: ALONGEST(), ATNEXT()
* Language....: Clipper S'87
* Returns.....: <expL>: .T.
*------------------------------------------------------------------------------*
FUNCTION PDMSETUP

PRIVATE dimh, dimv, ss

*** MENUPD Horizontal ***
dimh= 3
PUBLIC PDM_HPROM[dimh]                  && horizontal menu prompt text
PDM_HPROM[1]= " First Menu 1 "
PDM_HPROM[2]= " Second Menu 2 "
PDM_HPROM[3]= " Third Menu 3 "

PUBLIC PDM_HCOLM[dimh]                  && horizontal starting columns for prompts
PDM_HCOLM[1]= 1
PDM_HCOLM[2]= 15
PDM_HCOLM[3]= 30

PUBLIC PDM_HOTKY[dimh]                  && horiz Hot/alt keys INKEY()
PDM_HOTKY[1]= 289
PDM_HOTKY[2]= 287
PDM_HOTKY[3]= 276

PUBLIC PDM_HTRIG[dimh]                  && horizontal trigger letters
PDM_HTRIG[1]= "F"
PDM_HTRIG[2]= "S"
PDM_HTRIG[3]= "T"

PUBLIC PDM_HTPOS[dimh]                  && horizontal trigger letter  positions
PDM_HTPOS[1]= 2
PDM_HTPOS[2]= 2
PDM_HTPOS[3]= 2

*** PDMENUV Vertical ***
PUBLIC PDM_VSS1[dimh]                   && starting array subscript
PDM_VSS1[1]= 1
PDM_VSS1[2]= 4
PDM_VSS1[3]= 7

dimv= 10
PUBLIC PDM_VPROM[dimv]                  && vertical menu prompt text
PDM_VPROM[ 1]= " Vert menu 1     "
PDM_VPROM[ 2]= " Vert Menu 2     "
PDM_VPROM[ 3]= " Vertical menu 3 "
PDM_VPROM[ 4]= " Option vert 4 "
PDM_VPROM[ 5]= " vert menu 5   "
PDM_VPROM[ 6]= " vert menu 6   "
PDM_VPROM[ 7]= " vert menu 7 "
PDM_VPROM[ 8]= "-"
PDM_VPROM[ 9]= " vert menu 8 "
PDM_VPROM[10]= " vert menu 9 "

PUBLIC PDM_VTRIG[dimv]                  && vertical trigger letters
PDM_VTRIG[ 1]= "V"
PDM_VTRIG[ 2]= "M"
PDM_VTRIG[ 3]= "e"
PDM_VTRIG[ 4]= "p"
PDM_VTRIG[ 5]= "v"
PDM_VTRIG[ 6]= "m"
PDM_VTRIG[ 7]= "v"
PDM_VTRIG[ 8]= "-"
PDM_VTRIG[ 9]= "e"
PDM_VTRIG[10]= "r"

PUBLIC PDM_VTPOS[dimv]                  && vertical trigger letter positions
PDM_VTPOS[ 1]= 2
PDM_VTPOS[ 2]= 7
PDM_VTPOS[ 3]= 3
PDM_VTPOS[ 4]= 3
PDM_VTPOS[ 5]= 2
PDM_VTPOS[ 6]= 7
PDM_VTPOS[ 7]= 2
PDM_VTPOS[ 8]= 1
PDM_VTPOS[ 9]= 3
PDM_VTPOS[10]= 4

PUBLIC PDM_VACTV[dimv]                  && vertical active status array
AFILL( PDM_VACTV, .T. )
PDM_VACTV[ 8]= .F.

PUBLIC PDM_VMSSG[dimv]                  && vertical message help text
PDM_VMSSG[ 1]= "help text 1"
PDM_VMSSG[ 2]= "help text 2"
PDM_VMSSG[ 3]= "help text 3"
PDM_VMSSG[ 4]= "help text 4"
PDM_VMSSG[ 5]= "help text 5"
PDM_VMSSG[ 6]= "help text 6"
PDM_VMSSG[ 7]= "help text 7"
PDM_VMSSG[ 8]= "-"
PDM_VMSSG[ 9]= "help text 8"
PDM_VMSSG[10]= "help text 9"

PUBLIC PDM_COLOR[11]                    && PDM color strings for SET COLOR TO
PDM_COLOR[ 1]= "B/W"                     && [ 1] hcolor when not selected
PDM_COLOR[ 2]= "B+/W"                    && [ 2] hcolor for unselected trigger
PDM_COLOR[ 3]= "W+/R"                    && [ 3] hcolor for selected option
PDM_COLOR[ 4]= "W+/R"                    && [ 4] hcolor for selected trigger
PDM_COLOR[ 5]= "W+/B"                    && [ 5] vcolor for box
PDM_COLOR[ 6]= "W/B"                     && [ 6] vcolor when not selected
PDM_COLOR[ 7]= "W+/B"                    && [ 7] vcolor for unselected trigger
PDM_COLOR[ 8]= "R/W"                     && [ 8] vcolor for selected option
PDM_COLOR[ 9]= "R/W"                     && [ 9] vcolor for selected trigger
PDM_COLOR[10]= "R/B"                     && [10] vcolor for inactive option
PDM_COLOR[11]= "N/W"                     && [11] vcolor for message row

PUBLIC PDM_CONFG[9]                     && PDM configuration
PDM_CONFG[1]= 1                          && [1] = expN: box type: 0,1,2
PDM_CONFG[2]= 0                          && [2] = expN: row for horiz menu
PDM_CONFG[3]= 2                          && [3] = expN: row for box top
PDM_CONFG[4]= 24                         && [4] = expN: message row
PDM_CONFG[5]= 10                         && [5] = expN: time out
PDM_CONFG[6]= "N/W"                      && [6] = expC: color for init bottom panel
PDM_CONFG[7]= "W+/B"                     && [7] = expC: color for init screen
PDM_CONFG[8]= 32                         && [8] = expN: char for init screen
*                                        && [9] = expC: text for init bottom panel
PDM_CONFG[9]= " Esc=Exit Alt+Letter=Menu"

PDM_INIT()                    && Initialize remaining optional PDM PUBLIC arrays

RETURN .T.                                                 && End of: PDMSETUP()
*------------------------------------------------------------------------------*
*<eof>