/*
    HM_DEMO2.PRG

    Demo of how to use the [xProcess] parameter as a codeblock.  It also
    demonstrates the use of these APIs:

    ADhm_current() - returns the index position of the currently highlighted
        option.
    ADhm_exit() - instructs the menu engine to terminate.
*/

//---------
func main()
local aMenu := { "Databases", "Utilities", "Quit" }
ADhormenu( aMenu,, {|e| Xsel_handler(e)} )
return nil

//------------------
func Xsel_handler(e)
local nSel := ADhm_current(e)
local aMsg := {;
                "Selected ",;
                "Think of this message box as a major procedure that you call.",;
                "When the procedure ends, control goes back to the menu.",;
                "Note that the Esc key and the right mouse button are not active.",;
                "Typically, that's how you want them - there is a 'Quit' option.";
              }

if nSel = 1
    aMsg[1] += "Databases."
    ADmessage( aMsg )
elseif nSel = 2
    aMsg[1] += "Utilities."
    ADmessage( aMsg )
elseif nSel = 3
    ADhm_exit(e)
endif
return nil

