code_seg SEGMENT PARA PUBLIC 'CODE'
     
   ASSUME   CS:code_seg,DS:code_seg,ES:code_seg
   ORG     00h
     
; ---------- main calling routine for program ----------
     
main proc far
     
   jmp start                                  ; jump to start of code
     
   mv_val_stp    DW    0                      ; originate SP value
   mv_ptr_stg    DD    7 DUP (0)              ; pointer storage
   mv_pcx_hdl    DW    0                      ; pcx file handle
   mv_pcx_byt    DW    0                      ; width in byt
   mv_byt_lef    DW    0                      ; pcx bytes remaining
   mv_pcx_cry    DB    'C'                    ; carry byte for buffer
   mv_pcx_buf    DB    512 DUP ('X')          ; pcx buffer
   mv_pcl_beg    DB    27,'*t300R',27,'*r1A'  ; start cmd
   mv_pcl_dat    DB    27,'*b00000W'          ; data cmd
   mv_pcl_end    DB    27,'*rB'               ; stop cmd
     
start:
     
   cld                     ; just for safety's sake
   mov   cs:mv_val_stp,sp  ; save the stack pointer
   mov   cs:mv_pcx_hdl,0   ; clear file handle
   call  store_pointers    ; store far pointers
   call  beg_graphics      ; set laser to graphics print
   call  open_file         ; routine to open file
   call  load_width        ; routine to get width in bytes
   call  print_pcx         ; routine to do actual printing
   call  close_file        ; routine to close file
   call  end_graphics      ; end graphics print
     
   ret
     
main endp
     
; ---------- routine to store passed parameter address block --------
     
store_pointers  proc  near
     
   mov   si,di                    ; swap the original passed
   push  es                       ;   block pointers es:di
   pop   ds                       ;   into ds:si for move
   push  cs                       ; point es:di to storage
   pop   es                       ;   in code segment for
   mov   di,offset cs:mv_ptr_stg  ;   parameter pointers
   mov   cx,14                    ; we're moving 14 words
   rep   movsw                    ; do it
   push  cs                       ; align cs
   pop   ds                       ;        and ds
     
   ret
     
store_pointers  endp
     
; ---------- routine to initialize laserjet for graphics ----------
     
beg_graphics  proc  near
     
   mov   si,offset mv_pcl_beg  ; print to initialization string
   mov   cx,12                 ; load string length
   mov   dx,0                  ; target lpt1
   call  print_str             ; general use print routine
     
   ret
     
beg_graphics  endp
     
; ---------- routine to signal start of data block ----------
     
beg_data  proc  near
     
   cmp   mv_byt_lef,1          ; last buffer byte?
   jnz   prt_head              ; if not print the header
   cmp   al,0C0h               ; are upper two bits set?
   jae   skip_head             ; if so we will have a carry
prt_head:
   push  si                    ; save pcx buffer pointer
   mov   si,offset mv_pcl_dat  ; point to data signal string
   mov   cx,9                  ; load string length
   mov   dx,0                  ; target lpt1
   call  print_str             ; general use print routine
   pop   si                    ; restore buffer pointer
skip_head:
     
   ret
     
beg_data  endp

; ---------- routine to end laserjet graphics mode ----------
     
end_graphics  proc  near
     
   mov   si,offset mv_pcl_end  ; point to cleanup string
   mov   cx,4                  ; load string length
   mov   dx,0                  ; target lpt1
   call  print_str             ; general use print routine
   ret
     
end_graphics  endp
     
; ---------- routine to print a string ----------
     
print_str  proc  near
     
   push ax             ; save loaded character
prt_loop:
   lodsb               ; load a byte
   mov   ah,0          ; signal print byte function
   int   17h           ; call bios print function
   test  ah,00001111b  ; check for any print error
   jnz   fatal_error   ; jump one way to error out
   loop  prt_loop      ; loop for next byte
   pop   ax            ; restore loaded character
     
   ret
     
print_str  endp
     
; ---------- routine to print a single byte ----------
     
print_byte  proc  near
     
   mov   ah,0          ; signal print byte function
   int   17h           ; call bios print function
   test  ah,00001111b  ; check for any print error
   jnz   fatal_error   ; jump one way to error out
   ret
     
print_byte  endp
     
; ---------- routine to open source file ----------
     
open_file  proc  near
     
   push  ds                ; save data segment
   lds   dx,cs:mv_ptr_stg  ; point to file spec
   mov   ah,3Dh            ; DOS open file function
   mov   al,2              ; set read and write mode
   int   21h               ; call DOS open file
   pop   ds                ; restore segment
   jc    fatal_error       ; jump to error routine
   mov   cs:mv_pcx_hdl,ax  ; store source file handle
   ret
     
open_file  endp
     
; ---------- routine to load image width word ----------
     
load_width  proc  near
     
   mov   ax,4200h              ; move pointer absolute
   mov   bx,cs:mv_pcx_hdl      ; storage file handle value
   xor   cx,cx                 ; zero most significant word
   mov   dx,66                 ; setup move to image width
   int   21h                   ; word and move pointer
   mov   ah,3Fh                ; function to read from file
   mov   cx,2                  ; one word of data
   mov   dx,offset mv_pcx_byt  ; point to storage
   int   21h                   ; read image width word
   jc    fatal_error           ; jump one way if error
   cmp   ax,2                  ; did we read two bytes?
   jnz   fatal_error           ; jump one way if error
   mov   ax,4201h              ; move pointer relative
   xor   cx,cx                 ; zero most significant word
   mov   dx,60d                ; load least significant word
   int   21h                   ; move the pointer
   mov   dx,mv_pcx_byt         ; setup for convert to ascii
   mov   di,offset mv_pcl_dat  ; point to image width area
   add   di,3                  ; skip past escape prefix
   call  bin2dec1              ; convert from binary
     
   ret
     
load_width  endp
     
; ---------- routine to load pcx buffer ----------
     
load_pcx_buff  proc  near
     
   push  dx                    ; save any adjustment factor
   mov   ah,3Fh                ; function to read from file
   mov   cx,512                ; next 512 bytes if possible
   mov   dx,offset mv_pcx_buf  ; point to storage for read
   int   21h                   ; read the bytes
   jc    fatal_error           ; jump one way if error
   mov   si,offset mv_pcx_buf  ; respot to start of buffer
   pop   dx                    ; restore adjustment factor
     
   ret
     
load_pcx_buff  endp
     
; ---------- routine to close file ----------
     
close_file  proc  near
   mov  ah,3Eh            ; function to close file
   mov  bx,cs:mv_pcx_hdl  ; get file handle
   int  21h               ; close the file
   jc   fatal_error       ; jump one way if error
   ret
     
close_file  endp

; ---------- routine for fatal error handling ----------
     
fatal_error  proc  near
     
   call  end_graphics        ; try to terminate graphics
   cmp   cs:mv_pcx_hdl,0     ; was file opened?
   jz    skip_close          ; if not just skip close
   mov   ah,3Eh              ; function to close file
   mov   bx,cs:mv_pcx_hdl    ; get file handle
   int   21h                 ; close the file
skip_close:
   les   di,cs:mv_ptr_stg    ; blank parameter one as
   mov   al,20h              ;  error signal to dbase
blank_loop:
   stosb                     ; store a space to string
   cmp   byte ptr es:[di],0  ; end of string yet?
   jz    blank_done          ; if so, exit
   jmp   SHORT  blank_loop   ; if not, do another
blank_done:
   mov   sp,cs:mv_val_stp    ; get original stack pointer
   retf                      ; return to dbase
     
fatal_error  endp
     
; ---------- routine to print pcx picture ----------
     
print_pcx  proc  near
     
   xor   dx,dx             ; zero dx for buffer adjustments
   xor   bp,bp             ; zero bp for send header signal
print_loop:
   call  load_pcx_buff     ; load the buffer
   mov   mv_byt_lef,ax     ; store the byte counter
   mov   cx,ax             ; set up jump on cx
   jcxz  print_done        ; done if cx is zero
   sub   si,dx             ; adjust si by dx value
   add   mv_byt_lef,dx     ; adjust byte counter by dx
   xor   dx,dx             ; clear dx
byte_loop:
   mov   al,[si]           ; get a data byte
   cmp   bp,0              ; are we just starting a line?
   jnz   skip_header       ; if not just skip otherwise
   call  beg_data          ; transmit a data header
skip_header:
   cmp   al,0C0h           ; are upper two bits set?
   jb    one_byte          ; if not just store the byte
   cmp   mv_byt_lef,1      ; is it a paired single byte?
   jnz   run_of_bytes      ; if not do run of bytes
   mov   mv_pcx_cry,al     ; otherwise move to carry byte
   inc   dx                ;   then move one to signal
   jmp   SHORT buff_done   ;   then exit buffer loop
run_of_bytes:
   and   ax,03Fh           ; calc the repeat count
   mov   cx,ax             ; store the repeat count
   inc   si                ; point to repeat byte
   mov   al,byte ptr [si]  ; store the repeat byte
   dec   mv_byt_lef        ; adjust bytes left counter
   dec   cx                ; one done after loop
   add   bp,cx             ; add bytes written
   jcxz  one_byte          ; jump if only one
rep_loop:
   call  print_byte        ; send a byte to printer
   loop  rep_loop          ; loop until run is done
one_byte:
   dec   mv_byt_lef        ; decrement the bytes left
   inc   bp                ; increment the bytes processed
   call  print_byte        ; print a single byte
   mov   cx,mv_byt_lef     ; set up jump on cx test
   jcxz  buff_done         ; exit if no more bytes in buffer
   inc   si                ; otherwise point to next byte
   cmp   bp,mv_pcx_byt     ; test if bp says line is complete
   jne   byte_loop         ; jump back if not, otherwise
   xor   bp,bp             ;   zero bp to signal start of new
   jmp   byte_loop         ;   line and then jump back
buff_done:
   cmp   bp,mv_pcx_byt     ; test if bp says line is complete
   jne   print_loop        ; jump back if not, otherwise
   xor   bp,bp             ;   zero bp to signal start of new
   jmp   print_loop        ;   line and then jump back
     
print_done:
     
   ret
     
print_pcx  endp
     
; ---------- routine to convert binary to ascii decimal ----------
     
bin2dec1  proc  near
     
   cld               ; move in forward direction
   mov   al,'0'      ; ascii zero fill the target area
   mov   cx,5        ; pcl width designator is up to
   rep   stosb       ;   five decimal digits
   dec   di          ; adjust pointer to right digit
   mov   cx,0        ; initialize counter
bin_loop1:
   push  cx          ; save counter
   mov   ax,dx       ; get binary number into ax
   mov   dx,0        ; clear dx for divide operation
   mov   cx,10       ; get the divisor in cx
   div   cx          ; divide ax by cx
   xchg  ax,dx       ; swap registers
   add   al,30h      ; convert hex to ascii
   mov   es:[di],al  ; store in the assembly area
   dec   di          ; step backwards
   pop   cx          ; get the counter
   inc   cx          ; count the digit
   cmp   dx,0        ; out of numerator yet?
   jnz   bin_loop1   ; if not, repeat the process
     
   ret
     
bin2dec1  endp
     
; ---------- end of code segment ----------
     
code_seg ENDS     ; end of code segment
     
        end main  ; end assembly
     
; ---------- end of module ----------
