* PARTIDX3.prg    - Generate partial index
*
*
* Version Date     Comment                                        Done by
* ======= ======== ============================================== ===========
*   1.00  05/15/90 Initial version.                               K. Foley
*   1.01  09/27/90 This is the multi-user version                 K. Foley
*   3.00  10/05/91 Totally changed the inner workings of xFAKEOUT K. Foley
*


* Parameters
*
*  IndxKey      Character   - Index key for the new index file
*  LeadIndex    Character   - Name of the master index
*  NewIndex     Character   - Name of the slave index to be created.
*  UserFunct    Character   - User specified function or macro expression
*                             used to halt indexing.
*
*
*  NOTE: Assumes database is already positioned at starting record.
*        The first or last key in the index will usually NOT belong to
*        the partial index.  To restrict the use of this eronius key,
*        use SET FILTER, after the partial index has been built and
*        used.  Since the index being used is small, SET FILTER will not
*        dramatically impede performance, as it would have if a larger
*        index was being used.
*
*

*  EXAMPLE:  This example builds a partial index called BOB.NTX that only
*            contains keys for records with FILEID equal to 20555 .
*
*
*  use BENE2CL
*  * The index key is for this file is str( FILEID, 6, 0 )
*  set index to BNSEQ
*
*  seek " 20555"
*
*  PartIndx3( "str( FILEID, 6, 0 )", "BNSEQ", "BOB", "FILEID = 20555" )
*  set index to BOB,.....
*  set filter to FILEID = 20555
*
*  * Activate the filter and go back to the top
*  skip 2
*  go top
*   .
*   .
* RETURN
*
*
* The statment "FILEID = 20555" could have been replaced with a function
* such as "OkFunct()" .  Note that if a function is used () must be used.
* It is also possible to include parameters this way "OkFunct(2,34)" .
*
*  An example of a user function is given below.
*
*
* FUNCTION OkFunct
* Private RetVal
*
*   if POOL->TEAM <> "HOU"
*     RetVal = .F.
*   else
*     RetVal = .T.
*   endif
*
* RETURN( RetVal )
*

* PROCEDURE PartIdx3
Parameters IndxKey, LeadIndex, NewIndex, UserFunct
  Private HardPath, Handle, CallLevel, NextRec, FirstRecord
  Private LastPoint[ 20 ], LastItemA, LastItemB

  for LastItemA = 1 to 20
    LastPoint[ LastItemA ] = 0
  next
  LastItemA = 0
  LastItemB = .F.

  * Set the xFAKEOUT call counter
  CallLevel = 0

  * Store the current record - this will be the first record in the new index
  FirstRecord = RECNO()

  * Close any indexes on this file
  set index to

  * Create a valid record for NextRec in the event that no records are valid
  NextRec = LASTREC()

  * Create partial index using the xFAKEOUT function
  index on xFAKEOUT() to &NewIndex.

  * Close the new partial index
  set index to

  * Try to determine the location of the new index - location may not
  * be obvious due to SET PATH, or SET DEFAULT
  do case

    * Check the location via the SET DEFAULT
    case FILE( gdefault() + NewIndex )
      HardPath = gdefault() + NewIndex

    * Check the location via the SET DEFAULT with .NTX attached
    case FILE( gdefault() + NewIndex + ".NTX" )
      HardPath = gdefault() + NewIndex + ".NTX"

    * Check the location via the current DOS directory with .NTX attached
    case FILE( NewIndex + ".NTX" )
      HardPath = NewIndex + ".NTX"

    * Check the location via the current DOS directory
    otherwise
      HardPath = NewIndex

  endcase

  set index to

  Handle = FOPEN( HardPath, 2 )
  if Handle > 0
    FSEEK( Handle, 22, 0 )
    FWRITE( Handle, IndxKey + space(200), 200 )
  else
    * MsgDisp("Unable to rewrite index header for " + HardPath,.f.,"w+/r","w+/r")
  endif
  FCLOSE(Handle)

  set index to &NewIndex.

RETURN


FUNCTION xFAKEOUT
  Private RetVal

  if LastItemB
    * Handle LASTREC() pointer(s).  There could be more than one
    * in a multi-user environment.  The NextRec variable is invalidated
    * until all items in the array have been used up.

    if LastItemA >= 1
      NextRec = -1
      go LastPoint[ LastItemA ]
      LastItemA = LastItemA - 1
    else
      NextRec = LASTREC()
    endif

  else

    do case

      * Set the current and next pointers to valid values
      case CallLevel = 2
        go NextRec
        skip 1
        NextRec = RECNO()

      * First call to xFAKEOUT .  This is used to determine the size of the
      * index key.
      case CallLevel = 0
        * Do nothing
        CallLevel = 1

      * Set the lead index and position the record pointers
      case CallLevel = 1
        CallLevel = 2
        set index to &LeadIndex.
        go FirstRecord
        NextRec = RECNO()

    endcase

    * If the current record is LASTREC, see if there are any more
    * valid records.  If there are valid records, store this LASTREC,
    * and reassign NextRec

    if CallLevel >= 2
      if NextRec = LASTREC()
        if &UserFunct.
          LastItemA = LastItemA + 1
          LastPoint[ LastItemA ] = NextRec
          skip 1
          NextRec = RECNO()
        else
          LastItemB = .T.
          if LastItemA >= 1
            NextRec = LastPoint[ LastItemA ]
           LastItemA = LastItemA - 1
          endif
        endif
      endif
    endif

  endif

  @ 0,0 SAY RECNO()

  * Evaluate the user termination function.  If the user function is false
  * then current and next pointers to EOF() values to halt indexing.

  if CallLevel >= 2
    if ! &UserFunct. .or. NextRec > LASTREC() .or. RECNO() = LASTREC()
      * Close the Lead index
      set index to

      * Halt index function by going to LASTREC
      go LASTREC()
    endif
  endif

RETURN ( &IndxKey. )


* If you have the C code to do this - ( found in Rick Spence's Book )
* use it.  This dummy function returns "".  The C function, if available,
* returns the  SET DEFAULT variable, such as F:\FRED\, or C:\DATA\, ...
* The reason for using this function is to ensure that the newly created
* index file can be located by FOPEN() for rewriting of the index header.
*
* If the index header is not rewritten, then the value for the index key
* will remain xFAKEOUT.  This will lead to problems if the xFAKEOUT function
* is not available to your programs.
*
* As long as your current DOS directory is the same as SET DEFAULT
* when you build your partial indexes, then you don't need the  C  code.
*

FUNCTION gDefault
RETURN( "" )




















