	PAGE	76,132
	NAME	PARSING
	.286
;********
;
;  CLIPPER character = PARSING( expC1, [expC2] )
;
;  Replacement for Straley's toolbox function, PARSING.  Written in assembly
;  for increased performance.
;
;  Returns the portion of the string, expC1, to the left of the delimiter.
;  Whole string is returned if delimiter, expC2, is not found.	If the
;  delimiter parameter is omitted, '+' and '/' are used in turn.
;  Function is declared type VOID in CLfunc since it uses RETCLEN to
;  do the actual return
;
;  If the source string is passed by reference, the portion returned
;  plus the delimiter will be removed from the source string.
;
;  If no parms are passed, a null string is returned.
;  If the delimiter is passed and is a null string, the entire string
;  is returned.


	INCLUDE EXTENDA.INC

;***************
;
;	define segment names
;
	CODESEG PARSING


;***************
;
;	declaration of public functions
;
	CLpublic <PARSING>

;externals
	CLextern <far _storclen>	    ;EXTOR string store function

;function declaration
	CLfunc void PARSING <char string, char delim>

;local variables
	CLlocal <int pass, int len, int x >

;begin code
	CLcode
	   PUSH 	  ES		    ;not saved by macros, save it here
	   MOV		  len, 0	    ;zero return count
	   MOV		  pass, 1	    ;set for 1 pass operation
	   CLD				    ;set string increment

	   TESTNUL	  string	    ;test for string parm
	   JZ  SHORT	  TEST_LOOP	    ;return null if no parms
;
	   PUSH 	  1		    ;get the string length
	   CALL FAR PTR   __PARCLEN
	   ADD		  SP, 2 	    ;pop the stack
	   MOV		  len, AX	    ;save the length
;
	   TESTNUL	  delim 	    ;test for delim parm
	   JNZ SHORT	  GET_DELIM	    ;if passed, go get it
;test for special delimiter
	Ccall _parinfo <2>		    ;get delimiter parameter type
	   TEST 	  AX, $$LOGICAL     ;is it logical?
	   JZ  SHORT	  SET_DEFAULT	    ;no, go set defaults
	   MOV		  x, "|"	    ;yes, use queer delimiter
	   JMP SHORT	  TEST_LOOP
SET_DEFAULT:
	   INC		  pass		    ;set for 2 pass operation
	   MOV		  x, "+"	    ;1st pass delimiter
	   JMP SHORT	  TEST_LOOP
GET_DELIM:
	Ccall _parclen <2>		    ;get the delimiter length
	   OR		  AX, AX	    ;is delimiter null?
	   JNZ SHORT	  DELIM_OK	    ;no, go get it
	   LES		  DI, string	    ;set up to return entire string
	   MOV		  CX, 0
	   JMP SHORT	  PARSE_RET	    ;go do the return
DELIM_OK:
	   LES		  BX, delim	    ;get delimiter address
	   MOV		  AL, ES:[BX]	    ;get delimiter
	   MOV		  x, AX 	    ;save delimiter
TEST_LOOP:
	   LES		  DI, string	    ;load string address
	   MOV		  CX, len	    ;use length as count
	   MOV		  AX, x 	    ;get delimiter
	   REPNE SCASB			    ;scan the string
	   JZ  SHORT	  FOUND_IT	    ;jump if delim found in string
	   DEC		  pass		    ;check if 2 passes required
	   JZ  SHORT	  PARSE_RET	    ;jump if finished
	   MOV		  x, "/"	    ;use alternate delimiter
	   JMP SHORT	  TEST_LOOP	    ;go back & try again
FOUND_IT:
	   PUSH 	  CX		    ;save count for string update, if needed
	   INC		  CX		    ;count has moved past delimiter, back up
	   SUB		  len, CX	    ;get length of token in len
	   POP		  CX		    ;restore remaining count
PARSE_RET:    ;set up to modify source string
	   PUSH 	  1		    ;parameter #
	   PUSH 	  CX		    ;string length remaining
	   PUSH 	  ES		    ;address segment
	   PUSH 	  DI		    ;address offset
;return none, some or all of source string
	   PUSH 	  len		    ;token length
	   PUSH 	  ES		    ;string pointer segment
	   PUSH 	  OFFPART string    ;string pointer offset
	   CALL FAR PTR   __RETCLEN	    ;return the token
	   ADD		  SP, 6
;now modify the source string
	   CALL FAR PTR   __STORCLEN	    ;call EXTOR function to return string
	   ADD		  SP, 8 	    ;with token and delimiter removed

	   POP		  ES
	CLret				    ;clean up and do actual return

;end of assembly
	   END
