*
*  Program Ŀ
*   Application: Multiple Child Notepad Example - Revision 4                
*   Description: Main Program for Application                               
*     File Name: Padding.PRG                                                
*        Author: Jean-Pierre Zacaropoulos+John Skelton+Greg Lief            
*  Date created: 11-15-93              Date updated: 02-11-94              
*  Time created: 10:38:14am            Time updated: 10:38:14am            
*     Make File: Padding.RMK                                                
*     Exec File: Padding.EXE                                                
*     Copyright: (c) 1993, 1994 by Wine Software Partners                   
*     All Clip4Win users are welcome to use the code at no charge as long   
*     as neither myself nor Wine Software Partners is held responsible for  
*     any damage whatsoever you or anyone else may incurfrom its use.       
* 

****************************************************************************
* REV NOTES: Revision 1 - issued January 27, 1994
* This is released with no guarantees. It has been tested, but not all bugs
* may be cleared. This example is to be used as an example and can be
* improved.
*
* Free to all Clip4Win registered owners and CA-VO regietered owners.
*
* All I ask is that if you like it, let me know, if you improve it, please
* let me know as so that I can also benefit from these improvements, if you
* find a bug, please let me know so that we may work on eliminating it together.
*
* You can reach me on CompuServe
* Jean-Pierre Zacaropoulos CIS # [71562,530]
****************************************************************************


#DEFINE APP_NAME  "Browse Class"

#INCLUDE "Padding.ch"


	STATIC nMainEvId     // ID of main event handler... visible throughout
                        // because it must be reset periodically
   STATIC cDIB          // handle for bitmapped logo in main window... must be
                        // visible in several places for copying to Clipboard
   STATIC NotehWnd      // Keeper of the Main Window handle

	STATIC hCTL3D        // For 3D effect of Dialog Boxes

	// #DEFINE DEBUG
	#DEFINE RDDNAME  "SIXCDX"
*
*  Function Ŀ
*          Name: Start                                                      
*   Description: Main Function of Application                               
*  Date created: 11-15-93              Date updated: 02-11-94              
*  Time created: 10:41:11am            Time updated: 02:43:15pm            
* Ĵ
*     Arguments: None                                                       
*  Return Value: NIL                                                        
*      See Also:                                                            
* 
FUNCTION Start

	LOCAL nEvent
	LOCAL hMenu
   LOCAL lMainloop := .t.
   LOCAL hCurrWnd
   LOCAL hWnd
   LOCAL hInst
   LOCAL nAccelKey,AccelKeyList
	LOCAL cC3D
	LOCAL hPassedEdit,TheEditClass
	SET SCOREBOARD OFF
	SET DELETED ON

	//RDDSetDefault(RDDNAME)
   // our application's instance
   hInst := _GetInstance()

	// New Window
   hWnd  := WinSetup(APP_NAME, "Multiple NotePad Example", 5, 5, 600, 440)
 	NotehWnd := hWnd
	#Ifdef DEBUG
	  MessageBox(GetFocus(),"Main Wnd "+str(hWnd),"",MB_OKCANCEL)
	#endif

	// Setting up usage of the 3D dll
	hCTL3D   := LoadLibrary("CTL3D.DLL")
   hInst    := _GetInstance()
   cC3D     := GetProcAddress(hCTL3D,"Ctl3dRegister",;
                                  "Pascal","int","HWND")
   CallDLL(cC3D,hInst)
   cC3D     := GetProcAddress(hCTL3D,"Ctl3dAutoSubclass",;
                                  "Pascal","int","HWND")
   CallDLL(cC3D,hInst)

	// Set the number of handles required for the application
	SetHandleCount(30)


	MenuSetup()
   HideCaret(hWnd)          // disable screen cursor
	nMainEvId := AddHandler(hWnd,{|nEvent| MainEvent(hWnd,nEvent) })

   C4W_AutoClose(.f.)       // force confirm when closing window w/ ALT-F4

accelerators
AKEY    asc("Z"), 501, VIRTKEY, CONTROL   // Ctrl-Z = Undo
AKEY    asc("X"), 502, VIRTKEY, CONTROL   // Ctrl-X = Cut
AKEY    asc("C"), 503, VIRTKEY, CONTROL   // Ctrl-C = Copy
AKEY    asc("R"), 504, VIRTKEY, CONTROL   // Ctrl-R = Clear
AKEY    asc("V"), 505, VIRTKEY, CONTROL   // Ctrl-V = Paste
AKEY    VK_F5,    506, VIRTKEY            // F5     = insert Date/Time
AKEY    VK_F1,    507, VIRTKEY            // F1   = Help!
AKEY    VK_F2,    508, VIRTKEY            // F2   = NotePad Help!

use accelerators

   // begin event loop
   DO WHILE lMainloop
		// Using the modified ChkEvent()
      DO WHILE (nEvent := ChkNEvnt()) == EVENT_NONE
      ENDDO

		DO CASE

      CASE nEvent == EVENT_CLOSE .OR. nEvent == EVENT_QUIT
         // determine if the main window is currently active
         // _LasthWnd() returns a handle to the currently active window
         hCurrWnd := _LasthWnd()
         IF hWnd == hCurrWnd
            lMainloop := ! DoMainExit()
         ELSE
				TheEditClass := GetFocus()
				IF GetIdhEdit(TheEditClass) > 0
					DoNoteExit(GetIdhEdit(TheEditClass))
				 //	DestroyWindow(hCurrWnd)
				 //	DelEditChild(GetId(hCurrWnd))
				ELSE
               DestroyWindow(hCurrWnd)
				ENDIF
			  //BringWindowToTop(hWnd)
         ENDIF
	 	CASE nEvent == EVENT_ACCELKEY
			hPassedEdit := GetFocus()
			#ifdef DEBUG
			   MessageBox(GetFocus(),"hPassedEdit "+str(hPassedEdit)+Chr(13)+;
				  "GET FOCUS in Case ev. "+str(GetFocus())+chr(13)+;
				  "Get _Last "+str(_LasthWnd()),"",MB_OKCANCEL)
			#endif
			Accelerate(hPassedEdit)
			// We are passing the window with ID # for use with aEdit
		OTHERWISE
			HandleEvent(nEvent)
		ENDCASE
	ENDDO
	end accelerators
   RETURN(NIL)

*  Function Ŀ
*          Name: DoMainExit()                                               
*   Description: Exit from Main Program - Calls DoQuit for actual Exit      
*  Date created: 11-15-93              Date updated: 02-11-94              
*  Time created: 11:13:27am            Time updated: 02:43:27pm            
* Ĵ
*     Arguments: None                                                       
*  Return Value: lReturn                                                    
*      See Also:                                                            
* 
STATIC FUNCTION DoMainExit()
	LOCAL lReturn := .F.
	IF CloseEditAll()          // Checks that all edit children have been saved
		SETFOCUS(NotehWnd)
		IF MessageBox(0, "Leaving so soon?", "EXIT TO WINDOWS",;
              MB_OKCANCEL + MB_ICONQUESTION) == IDOK
			lReturn := .T.
			PgmExit()
      ELSE
	 	   lReturn:=.f.
	   ENDIF
	 ELSE
		lReturn := .F.
	 ENDIF
	RETURN(lReturn)

*  Function Ŀ
*          Name: DoQuit()                                                   
*   Description: Exits from application                                     
*  Date created: 12-21-93              Date updated: 02-11-94              
*  Time created: 11:15:03am            Time updated: 02:43:36pm            
* Ĵ
*     Arguments: None                                                       
*  Return Value: NIL                                                        
*      See Also:                                                            
* 
   STATIC FUNCTION DoQuit()
   IF DoMainExit()
		PgmExit()
	ENDIF
	RETURN(NIL)

*  Function Ŀ
*          Name: MainEvent()                                                
*   Description: Show the Logo in main Window                               
*  Date created: 11-15-93              Date updated: 02-11-94              
*  Time created: 11:17:17am            Time updated: 02:43:41pm            
* Ĵ
*     Arguments: hWnd                                                       
*              : nEvent                                                     
*  Return Value: NIL                                                        
*      See Also:                                                            
* 
	STATIC FUNCTION MainEvent(hWnd,nEvent)
   LOCAL hDC
   LOCAL aDIBRect, aClientRect
   DO CASE
   CASE nEvent == EVENT_REDRAW
     hDC := GetDC(hWnd)
     IF cDIB == NIL
       cDIB := ReadDIB("Clip4Win.BMP")
     ENDIF
     aDIBRect := GetDIBRect(cDIB)
     aClientRect := GetClientRect(hWnd)
     ShowDIB(hDC, cDIB, (aClientRect[W_RIGHT] - aDIBRect[W_RIGHT]) / 2, ;
                      (aClientRect[W_BOTTOM] - aDIBRect[W_BOTTOM]) / 2)
     ReleaseDC(hWnd, hDC)
   ENDCASE
   RETURN(NIL)

*  Function Ŀ
*          Name: MenuSetup()                                                
*   Description: Create Main Menu and Attach to Main Window                 
*  Date created: 11-15-93              Date updated: 02-11-94              
*  Time created: 11:18:34am            Time updated: 02:43:48pm            
* Ĵ
*     Arguments: None                                                       
*  Return Value: hMenu --------> hMenu Handle                               
*      See Also:                                                            
* 
	STATIC FUNCTION MenuSetup()
   LOCAL hWnd := SelectWindow()
   LOCAL hMenu
	LOCAL hPopupMenu
   LOCAL hPopup2


   // in the event that there is already a menu attached to this
   // window, we must get rid of it
   IF (hMenu := GetMenu(hWnd)) <> NIL
      DestroyMenu(hMenu)
   ENDIF

   hMenu := CreateMenu()
   hPopupMenu := CreatePopupMenu()
	AppendMenu(hMenu, "file", MF_ENABLED +MF_POPUP, "&File",hPopupMenu)
	AppendMenu(hPopupMenu, "exit",   MF_ENABLED + MF_STRING, "E&xit", {|| DoQuit()})

	hPopupMenu := CreatePopupMenu()
	AppendMenu(hMenu, "Pad",MF_ENABLED + MF_POPUP, "&Pad", hPopupMenu)
   AppendMenu(hPopupMenu, "note",    MF_ENABLED + MF_STRING, "&Note Pad", {|| notepad(hWnd,,,"W")})
	AppendMenu(hPopupMenu, "read",    MF_ENABLED + MF_STRING, "&Read Only",{|| notepad(hWnd,DoReadTxt(),"Harmony","R") })

	hPopupMenu := CreatePopupMenu()
	AppendMenu(hMenu, "Help",MF_ENABLED + MF_POPUP, "&Help", hPopupMenu)
	AppendMenu(hPopupMenu, "help",    MF_ENABLED + MF_STRING, "&Help"+chr(K_TAB)+"F1", {|| winhelp(hWnd,"pad.hlp",HELP_CONTENTS,0)})


	SetMenu(hWnd, hMenu)
	RETURN(hMenu)

FUNCTION DoReadTXT
	LOCAL cReturn
/* Not yet working
  	RDDSetDefault("SIXCDX")
	DBUSEAREA(.T.,"SIXCDX","TESTDBF","TESTDBF")
	DBSELECTAR("TESTDBF")
	USE TESTDBF NEW VIA SIXCDX

   INDEX ON TESTDBF->LAST TAG BAGNAME
	//ORDSETFOCUS("LAST")
   SEEK "ZAC"
	skip
	cReturn:=TESTDBF->MEM
*/
	cReturn:="Harmony.TTT"
RETURN(cReturn)

*  Function Ŀ
*          Name: msg()                                                      
*   Description: Shows a message in a Dialog Box                            
*  Date created: 11-15-93              Date updated: 02-11-94              
*  Time created: 11:32:11am            Time updated: 02:44:29pm            
* Ĵ
*     Arguments: cMsg                                                       
*  Return Value: NIL                                                        
*      See Also: MessageBox()                                               
* 
	FUNCTION msg(cMsg)
   MessageBox(,cMsg, "Info", ;
                MB_ICONINFORMATION + MB_OK)
   RETURN(NIL)


*  Function Ŀ
*          Name: WinNew()                                                   
*   Description: Creates a new window                                       
*  Date created: 11-15-93              Date updated: 12-21-93              
*  Time created: 11:49:42am            Time updated: 11:49:42am            
* Ĵ
*     Arguments: cTitle                                                     
*              : nX                                                         
*              : nY                                                         
*              : nWidth                                                     
*              : nHeight                                                    
*              : nStyle                                                     
*  Return Value: hWnd ---------> New window handle                          
*      See Also:                                                            
* 
	FUNCTION WinNew(cTitle, nX, nY, nWidth, nHeight, nStyle)
	LOCAL hInst := _GetInstance()
	LOCAL nCmdShow := _GetnCmdShow()
	LOCAL hWin

	IF nStyle == NIL
   	nStyle := WS_OVERLAPPEDWINDOW
	ENDIF
	hWin := CreateWindow(APP_NAME,           ;       // window class
   	                 cTitle,              ;       // caption for title bar
      	              nStyle,              ;       // window style
         	           nX,                  ;       // x co-ordinate
            	        nY,                  ;       // y co-ordinate
               	     nWidth,              ;       // width
                  	  nHeight,             ;       // height
                 	     SelectWindow(),      ;       // hWnd of parent
                   	  0,                   ;       // hMenu of menu (none yet)
                    	  hInst)                       // our own app instance

	IF hWin == 0
   	// probably out of resources
   	MessageBox( , "Can't create window", "Error", MB_ICONEXCLAMATION + MB_OK)
   	RETURN(NIL)
	ENDIF

	HideCaret(hWin)
	// make sure it's displayed ...
	ShowWindow(hWin, nCmdShow)
	// ... and up to date
	UpdateWindow(hWin)
	RETURN(hWin)


*  Function Ŀ
*          Name: nstr()                                                     
*   Description:                                                            
*  Date created: 12-29-93              Date updated: 12-29-93              
*  Time created: 09:09:57pm            Time updated: 09:09:57pm            
* Ĵ
*     Arguments: n                                                          
*  Return Value: None                                                       
*      See Also:                                                            
* 
FUNCTION nstr(n)
RETURN(alltrim(str(n)) + " ")

// Not freeing up all resources will cause the resources available
// to be lowered each time your app is run and eventually the
// system will run out and die!
// See Petzold's Programming Windows for an explaination of
// resources and how to manage them....

*  Function Ŀ
*          Name: PgmExit                                                    
*   Description: Close all windows, dialogs, etc prior to Exit              
*  Date created:                       Date updated: 02-11-94              
*  Time created:                       Time updated: 02:44:43pm            
* Ĵ
*     Arguments: None                                                       
*  Return Value: None                                                       
*      See Also:                                                            
* 
STATIC FUNCTION PgmExit
       LOCAL cC3D := GetProcAddress(hCTL3D,"Ctl3dUnregister",;
                                    "Pascal","int","HWND")

		 WinHelp(NotehWnd,"Pad.Hlp",HELP_QUIT,0)
		 WinHelp(NotehWnd,"Note.Hlp",HELP_QUIT,0)
       CallDLL(cC3D,_GetInstance())
       FreeLibrary(hCTL3D)
       DestroyWindow(NotehWnd)
       UnregisterClass(APP_NAME,_GetInstance())
       QUIT
RETURN(NIL)

/*
   Function: Accelerate() -- process an accelerator key
*/

*  Function Ŀ
*          Name: accelerate()          Docs: Wine Software Partners         
*   Description: Process the accelerator keys from multiple menues          
*        Author: Jean-Pierre Zacaropoulos                                   
*  Date created: 02-11-94              Date updated: 02-11-94              
*  Time created: 02:45:23pm            Time updated: 02:45:23pm            
*     Copyright: Wine Software Partners                                     
* Ĵ
*     Arguments: hThehWnd                                                   
*  Return Value: nil                                                        
*      See Also:                                                            
* 
Static FUNCTION accelerate(hThehWnd)
local nAccelkey := _lastwParam()
Local accel_hWnd:=hThehWnd
LOCAL accel_hMenu := NIL
LOCAL accel_hEdit := NIL
LOCAL Child_ID := GetIdhEdit(hThehWnd)
LOCAL nWhich := 0
#Ifdef DEBUG
  MessageBox(GetFocus(),"GETIdhEdit=Child_ID= "+str(Child_ID),"",MB_OKCANCEL)
#endif
IF Child_ID > 0
	nWhich := 1
	accel_hWnd  := ReturnChild(Child_ID,"hWnd")
	accel_hMenu := ReturnChild(Child_ID,"hMenu")
	accel_hEdit := ReturnChild(Child_ID,"hEdit")   //same as hTheWnd
ELSE
	nWhich := 0
	IF (accel_hMenu := GetMenu(Accel_hWnd)) == NIL
		// Accel_hWnd has no menu
		accel_hMenu := Getmenu()
	ENDIF
	accel_hEdit := NIL
ENDIF
 //If GetMenuId is added it always returns nil. Maybe the wrong param are
 //being passes. Looks like it works well without it
IF accel_hMenu != NIL  //.AND. GetMenuId(accel_hMenu, _lastwParam()) != NIL
	SelectWindow(Accel_hWnd)
	// do not setfocus to it otherwise the help screen will show below the
	// NotePad window.

	IF Child_ID > 0

		do case
			case nAccelkey == 501
				// Check to ensure that there is a codeblock, and if there is
				// one then evaluate it.
				IF GetMenuBlock(accel_hMenu, "undo") != NIL
      			eval(GetMenuBlock(accel_hMenu, "undo"))
				ENDIF
			case nAccelkey == 502
				IF GetMenuBlock(accel_hMenu, "cut") != NIL
					eval(GetMenuBlock(accel_hMenu, "cut"))
				ENDIF
			case nAccelkey == 503
				IF GetMenuBlock(accel_hMenu, "copy") != NIL
					eval(GetMenuBlock(accel_hMenu, "copy"))
				ENDIF
			case nAccelkey == 504
				IF GetMenuBlock(accel_hMenu, "clear") != NIL
	      		eval(GetMenuBlock(accel_hMenu, "clear"))
				ENDIF
			case nAccelkey == 505
				IF GetMenuBlock(accel_hMenu, "paste") != NIL
					eval(GetMenuBlock(accel_hMenu, "paste"))
				ENDIF
			case nAccelkey == 506
				IF GetMenuBlock(accel_hMenu, "timedate") != NIL
					eval(GetMenuBlock(accel_hMenu, "timedate"))
				ENDIF
			case nAccelKey == 508
				IF GetMenuBlock(accel_hMenu, "notehelp") != NIL
					eval(GetMenuBlock(accel_hMenu, "notehelp"))
				ENDIF
			case nAccelkey == 507
				accel_hMenu := GetMenu(NotehWnd)
				IF GetMenuBlock(accel_hMenu, "help") != NIL
					eval(GetMenuBlock(accel_hMenu, "help"))
				ENDIF
		endcase

	ELSE

		DO CASE
		  	case nAccelkey == 507
		  		accel_hMenu := GetMenu(NotehWnd)
				IF GetMenuBlock(accel_hMenu, "help") != NIL
      			eval(GetMenuBlock(accel_hMenu, "help"))
				ENDIF
		ENDCASE
	ENDIF
ENDIF

return nil


*  Function Ŀ
*          Name: WinSetup()            Docs: Wine Software Partners         
*   Description: Modified from C4W to be able to add the ICON               
*  Date created: 02-11-94              Date updated: 02-11-94              
*  Time created: 02:46:29pm            Time updated: 02:46:29pm            
* Ĵ
*     Arguments: cAppName                                                   
*              : cTitle                                                     
*              : nx                                                         
*              : ny                                                         
*              : nw                                                         
*              : nh                                                         
*  Return Value: end of file Padding@.PRG                                    
*      See Also:                                                            
* 
STATIC FUNCTION WinSetup(cAppName, cTitle,nx,ny,nw,nh)
       LOCAL  hWnd, hInst, hPrevInst, nCmdShow, hBrush, hIcon

       hInst     := _GetInstance()
       hPrevInst := _GetPrevInstance()
       nCmdShow  := _GetnCmdShow()
       hBrush    := GetStockObject(WHITE_BRUSH)

// Load your own icon here.....
     hIcon     := LoadIcon(hInst,"NOTEPAD"+CHR(0))

// If you do not have the RC.EXE change this to
//       hIcon     := 0
// and change the .RMK file not to include the RC -k ..

       IF hPrevInst == 0
          IF !RegisterClass(CS_HREDRAW + CS_VREDRAW + CS_SAVEBITS + CS_DBLCLKS,;
                            hInst, ;
                            hIcon, ;
                            LoadCursor(,IDC_ARROW),;
                            hBrush,;
                            cAppName)

             QUIT
         ENDIF
      ENDIF
      hWnd := CreateWindow(cAppName,    ;
                           cTitle,      ;
                           WS_CLIPCHILDREN + WS_CAPTION + WS_SYSMENU + WS_MINIMIZEBOX +WS_THICKFRAME + WS_MAXIMIZEBOX,;
                           nx,           ;
                           ny,           ;
                           nw,         ;
                           nh,         ;
                           0,           ;
                           0,           ;
                           hInst)
      ShowWindow(hWnd, nCmdShow)
      UpdateWindow(hWnd)
RETURN(hWnd)
*/


// end of file Padding.PRG
