*  Program Ŀ
*   Application: Multiple Child Notepad Example                             
*   Description: The making of a multiple child notepad for Clip4Win        
*     File Name: NOTEPAD.PRG                                                
*        Author: John Skelton/Greg Lief - modified by J-P Zacaropoulos      
*  Date created: 12-29-93              Date updated: 02-11-94              
*  Time created: 08:14:34pm            Time updated: 16:10:15pm            
*     Make File: Padding.RMK                                                
*     Exec File: Padding.EXE           Note : Requires the ChildArr.Prg     
*     Copyright: (c)                          with C4W lib < 9/9/93         
*                                             you also need Edit.prg        
* 
/*
    NOTES: (a) Be certain to specify the heapsize parameter in your .DEF
               file, which allocates memory for the edit control buffer.
			  (b)  Wine Software Partners does not make any guarantees implied
					 or otherwise about this program. Use at your own discretion.
*/
#INCLUDE "Padding.CH"

#DEFINE APP_NAME  "Browse Class"
#DEFINE APP_FONT  "System"


STATIC cText, nLimit
STATIC OldWindow, hPrevInst, nCmdShow
STATIC ID_EDIT
STATIC nX,nY,nZ   // Window coordinates so that we may stagger them

*  Function Ŀ
*          Name: notepad()             Docs: Wine Software Partners         
*   Description: The main function for NotePad for C4W                      
*  Date created: ??-??-??              Date updated: 02-11-94              
*  Time created: ??:??:??pm            Time updated: 02:51:54pm            
*     Copyright:See padding.prg                                             
* Ĵ
*     Arguments: MainhWnd ------> Parent window                             
*              : n -------------> Edit Limit                                
*              : cFile ---------> The Text File to retreive                 
*              : cFileName------> The FileName to showup on NotePadd        
*              : cRead ---------> R if readonly file W if Read/Write        
*  Return Value: (NIL)                                                      
*      See Also:                                                            
* 
FUNCTION notepad(MainhWnd,cFile,cFileName,cRead,n)
LOCAL bEvent
LOCAL nEvent
LOCAL hDC
LOCAL aClientRect
LOCAL aDIBRect
LOCAL cDIB
LOCAL coords_[4]
LOCAL x
LOCAL nAccelKey,AccelKeyList
LOCAL hWnd, hMenu, hEdit, hInst , Child_ID  // for this instance of Note Pad
LOCAL hFont
LOCAL aFontNew := {0, 0, 0, 0, 400, .f., .f., .f., 1, 0, 0, 0, 0, APP_FONT}

// We now initialize the unique EDIT id
IF ID_EDIT == NIL
	ID_EDIT := 1
ENDIF

// Initialize the nX, nY coordinates
IF nZ == Nil
	nZ := 1
ENDIF
// if over 6 notepads opened, start back at 1
IF nZ >  6
	nZ := 1
ENDIF
nX := nZ*10
nY := (nZ*10)+40
nZ++

// Initialize the read only parameter if NIL so as to make it read/write
IIF(cRead == NIL, cRead := "W", cRead := cRead )

// Initialize the name of the file to retreive if not NIL
IIF(cFile==NIL,cFile := "(Untitled)",cFile := cFile)

// Set the main handles for the different items for which we have to keep
// trak for several NotePads

OldWindow := MainhWnd     // This is now stored in the static var OldWindow
hInst := _GetInstance()
hPrevInst = _GetPrevInstance()
nCmdShow = _GetnCmdShow()

hWnd = CreateWindow(APP_NAME,	  		  	;	// window class
		    " Notepad - " + cFile, 		;	// caption for title bar
            WS_OVERLAPPEDWINDOW,       ;	// window style
	   	    nX,                       ;	// x co-ordinate
	   	    nY,	                    	;	// y co-ordinate
		      580,                       ;	// width
		      390,                  		;	// height
		      MainhWnd,                	;	// hWnd of parent
            0,                         ;  // hMenu of menu (none yet)
				hInst)	                  	// our own app instance

IF hWnd == 0
   MessageBox(, "Window Creation Failed!", "Error", MB_ICONEXCLAMATION + MB_OK)
   hWnd := NIL
ENDIF

// Get the Unique ID # to be used for this instance of NotePad
// and register the hWnd and type (Read Only or Read/Write) in the array
Child_ID := AddhWndChild(hWnd,cRead)


ShowWindow(hWnd,nCmdShow)
UpdateWindow(hWnd)
HideCaret(hWnd)

// You need to pass the ID for storage of the other required parameters for
// this instance
hMenu := MenuSetup(Child_ID)

// Create the internal window for the edit
hEdit := CreateWindow("edit",            ;      // window class
                     '',                 ;      // initial buffer
                     WS_CHILD            ;      // child window
                     + WS_VISIBLE        ;      // ... that can be seen
                     + WS_VSCROLL        ;      // ... vert. scroll bar
                     + WS_BORDER         ;      // ... with a border
                     + ES_LEFT           ;      // ... left justified
                     + ES_MULTILINE      ;      // ... allow several lines
                     + ES_AUTOVSCROLL    ;      // ... auto vert. scroll
                     + ES_AUTOHSCROLL    ;      // ... auto horiz. scroll**
                     + WS_HSCROLL,       ;      // ... horiz. scroll bar**
                     10, 10,             ;      // x,y position
                     570, 370,           ;      // width, height
                     hWnd,               ;      // parent window
                     ID_EDIT,            ;      // id for child control to use
		 				   hInst)	 						// our own app instance


// limit maximum size of text if passed as parameter
IF n <> NIL
   nLimit := n
   EditLimitText(hEdit, nLimit)
ENDIF

// Register the different parts of this instance of NotePad in the arrays
// kept by ChildArr.PRG
AddEditChild(Child_ID,hMenu,hEdit,hInst,ID_EDIT,cFIle,cFileName)
hFont := CreateFont(aFontNew)
SendMessage(hEdit,WM_SETFONT,hFont,0)
AddFont(Child_ID,aFontNew,10)

// Increment the ID_EDIT so that each instance has a unique identifier
ID_EDIT++

AddHandler(hWnd,{|nEvent| EditEvent(nEvent,Child_ID)})
ShowCaret(hWnd)
// If read only file, then retreive file
IF cRead == "R"
	DoShow(Child_ID)
	SetWindowText(hWnd, " Reading about " + cFileName)
ENDIF

SetFocus(hEdit)
C4W_AutoClose(.f.)

RETURN(NIL)

*  Function Ŀ
*          Name: MenuSetup()           Docs: Wine Software Partners         
*   Description: Sets a menu dialog                                         
*  Date created: ??-??-??              Date updated: 02-11-94              
*  Time created: ??:??:??pm            Time updated: 02:52:19pm            
* Ĵ
*     Arguments: Child_ID                                                   
*  Return Value: (hMenu)                                                    
*      See Also:                                                            
* 
STATIC FUNCTION MenuSetup(Child_ID)
LOCAL hPopupMenu, hMenu
// Obtain the window handel for this instance from the ChildArr.PRG
LOCAL hWnd  := ReturnChild(Child_ID,"hWnd")
LOCAL cRead := ReturnChild(Child_ID,"cRead")

IF (hMenu := GetMenu(hWnd)) <> NIL
     DestroyMenu(hMenu)
ENDIF

hMenu = CreateMenu()

hPopupMenu = CreatePopupMenu()
AppendMenu(hMenu, "file", MF_ENABLED + MF_POPUP, "&File", hPopupMenu)
IF cRead == "W"
   AppendMenu(hPopupMenu, "new", MF_ENABLED + MF_STRING, "&New", {|| DoOpen(.t.,Child_ID)})
   AppendMenu(hPopupMenu, "open", MF_ENABLED + MF_STRING, "&Open...", {|| DoOpen(.f.,Child_ID)})
   AppendMenu(hPopupMenu, "save", MF_ENABLED + MF_STRING, "&Save", {|| DoSave(,Child_ID)})
   AppendMenu(hPopupMenu, "saveas", MF_ENABLED + MF_STRING, "Save &As...", {|| DoSave(.t.,Child_ID)})
ENDIF
AppendMenu(hPopupMenu, "print", MF_ENABLED + MF_STRING, "&Print", {|| DoPrint(Child_ID)})
AppendMenu(hPopupMenu, "", MF_SEPARATOR)
AppendMenu(hPopupMenu, "exit", MF_ENABLED + MF_STRING, "E&xit", {|| DoNoteExit(Child_ID)} )

hPopupMenu = CreatePopupMenu()
AppendMenu(hMenu, "edit", MF_ENABLED + MF_POPUP, "&Edit", hPopupMenu)
IF cRead == "W"
   AppendMenu(hPopupMenu, "undo", MF_GRAYED + MF_STRING,   "&Undo"+chr(K_TAB)+"Ctrl-Z", {|| DoUndo(Child_ID) })
   AppendMenu(hPopupMenu, "", MF_SEPARATOR)
   AppendMenu(hPopupMenu, "cut",  MF_ENABLED + MF_STRING,   "Cu&t"+chr(K_TAB)+"Ctrl-X", {|| DoCut(Child_ID)})
   AppendMenu(hPopupMenu, "clear", MF_ENABLED + MF_STRING, "E&rase"+chr(K_TAB)+"Ctrl-R", {|| DoClear(Child_ID)})
ENDIF
AppendMenu(hPopupMenu, "copy", MF_ENABLED + MF_STRING,  "&Copy"+chr(K_TAB)+"Ctrl-C", {|| DoCopy(Child_ID)})
IF cRead == "W"
   AppendMenu(hPopupMenu, "paste", IF(IsClipBFormatAvailable(CF_TEXT), MF_ENABLED, MF_GRAYED) + ;
                                + MF_STRING,            "&Paste"+chr(K_TAB)+"Ctrl-V", {|| DoPaste(Child_ID)})
   AppendMenu(hPopupMenu, "", MF_SEPARATOR)
   AppendMenu(hPopupMenu, "timedate", MF_ENABLED + MF_STRING, "Time/&Date"+chr(K_TAB)+"F5", {|| TimeDate(Child_ID)})
   AppendMenu(hPopupMenu, "", MF_SEPARATOR)
   AppendMenu(hPopupMenu, "wordwrap", MF_ENABLED + MF_STRING, "&Word Wrap", {|i| WordWrap(i,Child_ID)})
   AppendMenu(hPopupMenu, "font", MF_ENABLED + MF_STRING, "&Font...", {|| DoFont(Child_ID) })
ENDIF

hPopupMenu = CreatePopupMenu()
AppendMenu(hMenu, "search", MF_ENABLED + MF_POPUP, "&Search", hPopupMenu)
AppendMenu(hPopupMenu, "find", MF_ENABLED + MF_STRING, "&Find...", {|| DoFind(Child_ID) })
IF cRead == "W"
   AppendMenu(hPopupMenu, "replace", MF_ENABLED + MF_STRING, "&Replace...", {|| DoReplace(Child_ID) })
ENDIF

hPopupMenu = CreatePopupMenu()
AppendMenu(hMenu, "Help", MF_ENABLED + MF_POPUP, "&Help", hPopupMenu)
AppendMenu(hPopupMenu, "notehelp", MF_ENABLED + MF_STRING, "&Help"+chr(K_TAB)+"F2", {|| winhelp(hWnd,"note.hlp",HELP_CONTENTS,0)})
AppendMenu(hPopupMenu, "about", MF_ENABLED + MF_STRING, "&About", {|| Credits()})

SetMenu(hWnd, hMenu )
RETURN(hMenu)



*  Function Ŀ
*          Name: Credits()             Docs: Wine Software Partners         
*   Description: Pop up for Help - About                                    
*  Date created: ??-??-??              Date updated: 02-11-94              
*  Time created: ??:??:??am            Time updated: 02:53:28pm            
* Ĵ
*     Arguments: None                                                       
*  Return Value: (NIL)                                                      
*      See Also:                                                            
* 
STATIC FUNCTION Credits()
STATIC aDlg
IF aDlg == NIL
   aDlg := CreateDialog("About Notepad",                                   ;
                       WS_CAPTION + WS_SYSMENU + WS_GROUP + WS_TABSTOP     ;
                       + WS_THICKFRAME + WS_VISIBLE + WS_POPUP,            ;
                       80, 50, 175, 75)
   aDlg := AppendDialog(aDlg, "", DLG_STATIC,                              ;
                        SS_CENTER + WS_CHILD + WS_VISIBLE,                 ;
                        1, 6, 173, 8,                                      ;
                        "Notepad")
   aDlg := AppendDialog(aDlg, "", DLG_STATIC,                              ;
                        SS_CENTER + WS_CHILD + WS_VISIBLE,                 ;
                        1, 17, 173, 8,                                     ;
                        "By Clip4Win and Wine Software Partners")
   aDlg := AppendDialog(aDlg, "", DLG_STATIC,                              ;
                        SS_CENTER + WS_CHILD + WS_VISIBLE,                 ;
                        1, 28, 173, 8,                                     ;
                        "Copyright (c) 1993, 1994")
   aDlg := AppendDialog(aDlg,"IDCANCEL", DLG_BUTTON,                       ;
                        BS_DEFPUSHBUTTON + WS_CHILD                        ;
                        + WS_VISIBLE + WS_TABSTOP,                         ;
                        64, 53, 40, 14,                                    ;
                        "&Okay")
   aDlg := AppendDialog(aDlg, "", DLG_STATIC,                              ;
                        SS_ICON + WS_CHILD + WS_VISIBLE,                   ;
                        27, 51, 18, 20,                                    ;
                        "editicon")
ENDIF
ModalDialog(aDlg, _GetInstance(), SelectWindow())
RETURN(NIL)


*  Function Ŀ
*          Name: DoNoteExit(Child_ID)      Docs: Wine Software Partners     
*   Description: Checks the saving status of the Note Pad and sends the OK  
*  Date created: ??-??-??              Date updated: 02-11-94              
*  Time created: ??:??:??pm            Time updated: 02:53:49pm            
* Ĵ
*     Arguments: Child_ID                                                   
*  Return Value: (NIL)                                                      
*      See Also:                                                            
* 
FUNCTION DoNoteExit(Child_ID)
LOCAL nSel, GoOut:= .F.
// Obtain the necessary handles for this instance
LOCAL hWnd := ReturnChild(Child_ID,"hWnd")
LOCAL hEdit := ReturnChild(Child_ID,"hEdit")
LOCAL hMenu := ReturnChild(Child_ID,"hMenu")
LOCAL cFile := ReturnChild(Child_ID,"cFile")

WINHELP(hWnd,"Note.Hlp",HELP_QUIT,0)
IF EditGetModify(hEdit)
   nSel := MessageBox(0, "The text in " + cFile + " has changed." + ;
                   CR + "Do you want to save the changes?", ;
                   "Notepad", MB_YESNOCANCEL + MB_ICONEXCLAMATION)
   DO CASE
      CASE nSel == IDYES
         DoSave(,Child_ID)
				 GoOut := .T.
		  CASE nSel == IDNO
				 GoOut := .T.
		  CASE nSel == IDCANCEL
				 GoOut := .F.
   ENDCASE
ELSE
	GoOut := .T.
ENDIF

// If exiting do some cleanup and remove the element for this instance from
// the array in ChildArr.PRG
IF GoOut
  DestroyWindow(hWnd)
  DestroyMenu(hMenu)
  DelEditChild(Child_ID)
  BringWindowToTop(OldWindow)
  UpdateWindow(OldWindow)
ENDIF
RETURN(NIL)


*  Function Ŀ
*          Name: EditEvent(nEvent,Child_ID)  Docs: Wine Software Partners   
*   Description: Does the main part of the editing                          
*  Date created: ??-??-??              Date updated: 02-11-94              
*  Time created: ??:??:??pm            Time updated: 02:54:10pm            
* Ĵ
*     Arguments: nEvent                                                     
*              : Child_ID                                                   
*  Return Value: (NIL)                                                      
*      See Also:                                                            
* 
FUNCTION EditEvent(nEvent,Child_ID)
LOCAL nEN
LOCAL x
LOCAL aClientRect
LOCAL hWnd := ReturnChild(Child_ID,"hWnd")
LOCAL hEdit := ReturnChild(Child_ID,"hEdit")
LOCAL hMenu := ReturnChild(Child_ID,"hMenu")
LOCAL nID_EDIT := ReturnChild(Child_ID,"Edit_ID")
LOCAL cRead := ReturnChild(Child_ID,"CREAD")
DO CASE
	   CASE nEvent == EVENT_WINSIZE
       aClientRect := GetClientRect(hWnd)
      MoveWindow(hEdit, aClientRect[1], aClientRect[2], ;
                        aClientRect[3], aClientRect[4], .f.)
      InvalidateRect(hWnd)

   CASE nEvent == EVENT_SETFOCUS .and. SelectWindow() <> hEdit
				IF hEdit != NIL
				   SetFocus(hEdit)
					IF cRead == "W"
						IF IsClipBFormatAvailable(CF_TEXT)
	                  EnableMenuItem(hMenu,"paste",MF_ENABLED)
                  ELSE
	                  EnableMenuItem(hMenu,"paste",MF_GRAYED)
                  ENDIF
					ENDIF
			  ENDIF

   CASE nEvent == EVENT_CONTROL
      IF _LastwParam() == nID_EDIT  .AND. hEdit != NIL   // child id
         // process message sent by the edit control
         nEN = _LastHilParam()   // get the reason for the msg

         IF nEN == EN_MAXTEXT .or. nEN == EN_ERRSPACE
				IF cRead == "R"
            	MessageBox( , "No more space for additional notepads!";
						+chr(13)+"Close one or two of the notepads"+Chr(13)+;
						"so that you may open a new one.";
				  		,"Information", MB_ICONHAND + MB_OK)
					DoNoteExit(Child_ID)
			   ELSE
            	MessageBox( , "No more room in this notepad!";
						+chr(13)+"Save and Exit the notepad."+Chr(13)+;
						"Continue on a new one.";
						,"Information", MB_ICONHAND + MB_OK)
				ENDIF
         ELSEIF nEN == EN_CHANGE .AND. cRead == "W"
            IF EditCanUndo(hEdit)
               EnableMenuItem(hMenu, "undo", MF_ENABLED)
            ENDIF
				IF IsClipBFormatAvailable(CF_TEXT)
	            EnableMenuItem(hMenu,"paste",MF_ENABLED)
            ELSE
	            EnableMenuItem(hMenu,"paste",MF_GRAYED)
            END
			ENDIF
      ENDIF
ENDCASE
// This has been giving me some problems upon exit giving error
// Until I moved it into the DO CASE
//EnableMenuItem(hMenu, "paste", ;
   //   IF(IsClipBFormatAvailable(CF_TEXT), MF_ENABLED, MF_GRAYED) )
RETURN(NIL)

*  Function Ŀ
*          Name: DoShow(Child_ID)      Docs: Wine Software Partners         
*   Description: Reads the text file                                        
*  Date created: 12-21-93              Date updated: 02-11-94              
*  Time created: 01:56:24pm            Time updated: 02:54:30pm            
* Ĵ
*     Arguments: Child_ID                                                   
*  Return Value: NIL                                                        
*      See Also:                                                            
* 
	STATIC FUNCTION DoShow(Child_ID)
	LOCAL cFile := ReturnChild(Child_ID,"cFile")
 	EditSetReadOnly(ReturnChild(Child_ID,"hEdit"),.T.)
	EditSetText(ReturnChild(Child_ID,"hEdit"), memoread(cFile) )
 	RETURN(NIL)


*  Function Ŀ
*          Name: wordwrap(Child_ID)    Docs: Wine Software Partners         
*   Description: Enables the word wrapping feature                          
*  Date created: ??-??-??              Date updated: 02-11-94              
*  Time created: ??:??:??pm            Time updated: 02:54:48pm            
* Ĵ
*     Arguments: cItem                                                      
*              : Child_ID                                                   
*  Return Value: (NIL)                                                      
*      See Also:                                                            
* 
FUNCTION wordwrap(cItem,Child_ID)
LOCAL hWnd := ReturnChild(Child_ID,"hWnd")
LOCAL hEdit := ReturnChild(Child_ID,"hEdit")
LOCAL hMenu := ReturnChild(Child_ID,"hMenu")
LOCAL ID_EDIT := ReturnChild(Child_ID,"Edit_ID")
LOCAL hInst := ReturnChild(Child_ID,"hInst")
LOCAL cFile := ReturnChild(Child_ID,"cFile")
LOCAL aFont := ReturnChild(Child_ID,"aFont")
LOCAL nCheck := CheckMenuItem(hMenu, cItem,MF_CHECKED)
LOCAL x
LOCAL cOldText,hFont
LOCAL aClientRec := GetClientRect(hWnd)

CheckMenuItem(hMenu, cItem, IF(nCheck == MF_CHECKED, MF_UNCHECKED, MF_CHECKED))
// retrieve current edit control buffer
x        := SendMessage(hEdit, WM_GETTEXTLENGTH, 0, 0)
cOldText := space(x)
SendMessage(hEdit, WM_GETTEXT, x, cOldText)
DestroyWindow(hEdit)
hEdit = CreateWindow("edit",             ;      // window class
                     '',                 ;      // initial buffer
                     WS_CHILD            ;      // child window
                     + WS_VISIBLE        ;      // ... that can be seen
                     + WS_VSCROLL        ;      // ... vert. scroll bar
                     + WS_BORDER         ;      // ... with a border
                     + ES_LEFT           ;      // ... left justified
                     + ES_MULTILINE      ;      // ... allow several lines
                     + ES_AUTOVSCROLL    ;      // ... auto vert. scroll
                     + IF(nCheck == MF_CHECKED,         ; // allow horiz. scroll
                       WS_HSCROLL + ES_AUTOHSCROLL, 0), ; // if word wrap is off
                      0,  0,             ;      // x,y position
							aClientRect[3],     ;      // width
							aClientRect[4],     ;      // height
                     hWnd,               ;      // parent window
                     ID_EDIT,            ;      // id for child control to use
		     hInst)			// our own app instance

 // Replace the info in the array with the new hEdit
	AddEditChild(Child_ID,hMenu,hEdit,hInst,ID_EDIT,cFile)

// limit maximum size of text if passed as parameter
IF nLimit <> NIL
   EditLimitText(hEdit, nLimit)
ENDIF
EditSetText(hEdit, cOldText)
hFont := CreateFont(aFont)
SendMessage(hEdit,WM_SETFONT,hFont,0)
SetFocus(hEdit)
RETURN(NIL)


*  Function Ŀ
*          Name: DoOpen()              Docs: Wine Software Partners         
*   Description: Opens a new or an existing file                            
*  Date created: ??-??-??              Date updated: 02-11-94              
*  Time created: ??:??:??pm            Time updated: 02:55:07pm            
* Ĵ
*     Arguments: lNew                                                       
*              : Child_ID                                                   
*  Return Value: (NIL)                                                      
*      See Also:                                                            
* 
STATIC FUNCTION DoOpen(lNew,Child_ID)

LOCAL nSel
LOCAL cTempFile
LOCAL hWnd := ReturnChild(Child_ID,"hWnd")
LOCAL hEdit := ReturnChild(Child_ID,"hEdit")
LOCAL hMenu := ReturnChild(Child_ID,"hMenu")
LOCAL nID_EDIT := ReturnChild(Child_ID,"Edit_ID")
LOCAL cFile := ReturnChild(Child_ID,"cFile")
LOCAL hFont
LOCAL aFontNew := {0, 0, 0, 0, 400, .f., .f., .f., 1, 0, 0, 0, 0, APP_FONT}
LOCAL lContinue := ! EditGetModify(hEdit)
IF ! lContinue
   nSel := MessageBox(0, "The text in " + cFile + " has changed." + ;
                   CR + "Do you want to save the changes?", ;
                   "Notepad", MB_YESNOCANCEL + MB_ICONEXCLAMATION)
   IF nSel == IDYES
      DoSave(,Child_ID)
   ENDIF
   lContinue := ( nSel <> IDCANCEL )
ENDIF
IF lContinue
   IF lNew
      cFile := "(Untitled)"
		AddFileName(Child_ID,cFile)
      EditSetText(hEdit, '')
		hFont := CreateFont(aFontNew)
		SendMessage(hEdit,WM_SETFONT,hFont,0)
      SetWindowText(hWnd, " Notepad - " + cFile)
   ELSE
      cTempFile := GetOpenFileName(, "*.txt", "Select a text file for editing", ;
                                     { {"text files", "*.txt"} } )
      IF cTempFile <> NIL
         IF directory(cTempFile)[1][F_SIZE] < 32762
            cFile := cTempFile
				AddFileName(Child_ID,cFile)
            EditSetText(hEdit, memoread(cFile) )
            SetWindowText(hWnd, " Notepad - " + upper(cFile))
         ELSE
            MessageBox(, "The " + cFile + " file is too large." + CR + ;
                   CR + "Please use another editor to edit the file.", ;
                   "Notepad", MB_OK + MB_ICONEXCLAMATION)
         ENDIF
      ENDIF
   ENDIF
ENDIF
SetFocus(hEdit)
RETURN(NIL)


*  Function Ŀ
*          Name: DoSave()              Docs: Wine Software Partners         
*   Description: Save the text in the notepad                               
*  Date created: ??-??-??              Date updated: 02-11-94              
*  Time created: ??:??:??am            Time updated: 02:55:33pm            
* Ĵ
*     Arguments: lNeedFileName---> .T. if file is untitled                  
*              : Child_ID                                                   
*  Return Value: (NIL)                                                      
*      See Also:                                                            
* 
FUNCTION DoSave(lNeedFilename,Child_ID)
LOCAL hWnd := ReturnChild(Child_ID,"hWnd")
LOCAL hEdit := ReturnChild(Child_ID,"hEdit")
LOCAL hMenu := ReturnChild(Child_ID,"hMenu")
LOCAL nID_EDIT := ReturnChild(Child_ID,"Edit_ID")
LOCAL cFile := ReturnChild(Child_ID,"cFile")

LOCAL x
LOCAL y := ''
LOCAL nLines
LOCAL cTempfile
LOCAL hOldcursor
LOCAL hCursor


IF lNeedFileName == NIL
   lNeedfilename := (cFile == "(Untitled)")
ENDIF

IF lNeedfilename
   cTempfile := GetSaveFileName(, "*.txt", "Select file to save to")
   IF cTempfile <> NIL
      cFile := cTempfile
		AddFileName(Child_ID,cFile)
      SetWindowText(hWnd, " Notepad - " + upper(cFile))
   ENDIF
ENDIF
IF cFile <> "(Untitled)"
   hCursor := LoadCursor( , IDC_WAIT)
   hOldCursor := SetCursor(hCursor)
   //nLines := SendMessage(hEdit, EM_GETLINECOUNT) - 2
	 nLines := SendMessage(hEdit, EM_GETLINECOUNT) - 1
   FOR x := 0 to nLines
      y += EditGetLine(hEdit, x) + CRLF
   NEXT

   /*
      Note: it would also be possible to retrieve the entire contents
      of the edit buffer at one fell swoop like so:

      x := SendMessage(hEdit, WM_GETTEXTLENGTH, 0, 0)
      y := space(x)
      SendMessage(hEdit, WM_GETTEXT, x, @y)

      However, this generally requires that you allocate a lot more
      free memory for the internal heap (i.e., the "heapsize" parameter
      in your .DEF file)
   */

   memowrit(cFile, y)
   EditSetModify(hEdit, .f.)   // toggle global "has the file changed?" flag
   SetCursor(hOldCursor)
ENDIF
SetFocus(hEdit)
RETURN(NIL)


*  Function Ŀ
*          Name: DoPrint(Child_ID)     Docs: Wine Software Partners         
*   Description: Print the file                                             
*  Date created: ??-??-??              Date updated: 02-11-94              
*  Time created: ??:??:??pm            Time updated: 02:57:04pm            
* Ĵ
*     Arguments: Child_ID                                                   
*  Return Value: (NIL)                                                      
*      See Also:                                                            
* 
STATIC FUNCTION DoPrint(Child_ID)
LOCAL hWnd := ReturnChild(Child_ID,"hWnd")
LOCAL hEdit := ReturnChild(Child_ID,"hEdit")
LOCAL hMenu := ReturnChild(Child_ID,"hMenu")
LOCAL nID_EDIT := ReturnChild(Child_ID,"Edit_ID")
LOCAL cFile := ReturnChild(Child_ID,"cFile")
LOCAL aFont := ReturnChild(Child_ID,"aFont")
LOCAL nPointSize := ReturnChild(Child_ID,"nPointSize")


LOCAL aPrintDlg := array(PD_LENGTH)   // from COMMDLG.CH
LOCAL nCurrLine, nFirstLineToPrint
LOCAL nLines
LOCAL hCursor
LOCAL hOldcursor
LOCAL hPrintFont
LOCAL Oldheight
LOCAL x
LOCAL y
LOCAL z
LOCAL i
LOCAL cBuff
LOCAL hLib
LOCAL aTM := {}
LOCAL nChrHeight
LOCAL nChrsPerLine, nLinesPerPage, nTotalPages
LOCAL hOldFont
LOCAL PD_vars, DoPageNumb := .F., DoCollate := .F.
// set up defaults if no font previously selected
IF nPointSize == NIL
   nPointSize := 10
ENDIF
IF aFont == NIL
   aFont := {0, 0, 0, 0, 400, .f., .f., .f., 1, 0, 0, 0, 0, "Arial"}
ENDIF

/*
// If nothing to print get out. However this does not seem to work
// as it looks like nLines is > 0 even if there is nothing in the
// notepad
nLines := SendMessage(hEdit,EM_GETLINECOUNT)
IF nLines <= 0
  RETURN(NIL)
ENDIF
*/

// allows user to input FROM.. TO.. Page numbers up to 99 which is
// 5 folds what can be saved in a notepad. If this is not initialized
// user will not be able to enter numbers as the WINDOWS default for
// PD_NMAXPAGE is 0 which prevents  the user from entering something
// bigger than 0.
aPrintDlg[PD_NMINPAGE] := 1
aPrintDlg[PD_NMAXPAGE] := 99 // nTotalPages

aPrintDlg[PD_NFROMPAGE] := 1
aPrintDlg[PD_NTOPAGE] := 99  //nTotalPages



// set up initial values for printer dialog
// see COMMDLG.CH for other flags that can be used
aPrintDlg[PD_HWNDOWNER] := SelectWindow()
aPrintDlg[PD_NFLAGS]    := PD_HIDEPRINTTOFILE + PD_NOSELECTION + ;
	                        PD_RETURNDC ///  + PD_PAGENUMS
PD_vars := aPrintDlg[PD_NFLAGS]
x := PrintDlg(aPrintDlg)
IF x == NIL .or. ! x
   // cancelled by the user
	RETURN(NIL)
ENDIF

// Checks if Collate and Page Numbering was selected
IIF(C4W_And(aPrintDlg[PD_NFLAGS],PD_COLLATE)!=0,DoCollate := .T.,DoCollate := .F. )
//IIF(C4W_And(aPrintDlg[PD_NFLAGS],PD_PAGENUMS)!=0,DoPageNumb := .T.,DoPageNumb := .F. )

// save current font height
oldheight := aFont[TM_Height]

// convert point size from x/72 units to printer pixel units
aFont[TM_Height]:= -(nPointsize * ;
                     GetDeviceCaps(aPrintDlg[PD_HDC], LOGPIXELSY) / 72)

// select the best matching font
hPrintFont := CreateFont(aFont)

hCursor    := LoadCursor( , IDC_WAIT)
hOldCursor := SetCursor(hCursor)

hOldFont := SelectObject(aPrintDlg[PD_HDC], hPrintFont)

nLines := SendMessage(hEdit, EM_GETLINECOUNT)

GetTextMetrics(aPrintDlg[PD_HDC], @aTm)

nChrHeight    := aTm[TM_Height] + aTm[TM_ExternalLeading]
nChrsPerLine  := C4W_Int(GetDeviceCaps(aPrintDlg[PD_HDC], HORZRES) / aTm[TM_AveCharWidth])
nLinesPerPage := C4W_Int((GetDeviceCaps(aPrintDlg[PD_HDC], VERTRES) / nChrHeight))-5
nTotalPages   := int((nLines + nlinesPerPage - 1) / nLinesPerPage)

IF aPrintDlg[PD_NTOPAGE] > nTotalPages
   aPrintDlg[PD_NTOPAGE] := nTotalPages
ENDIF

StartDoc(aPrintDlg[PD_HDC], " Notepad - " + upper(cFile))

DO CASE
	CASE DoCollate == .T.
      FOR x := 1 to aPrintDlg[PD_NCOPIES]
        nCurrLine := ((aPrintDlg[PD_NFROMPAGE]-1)*nLinesPerPage)
        FOR y :=aPrintDlg[PD_NFROMPAGE] to aPrintDlg[PD_NTOPAGE]
          StartPage(aPrintDlg[PD_HDC])
          FOR z:= 1 to nLinesPerPage
            // make sure we don't try to print more than we got!
            IF (nCurrLine <= nLines)
               TextOut(aPrintDlg[PD_HDC], 0, z * nChrHeight, ;
                    EditGetLine(hEdit, nCurrLine++) )
            ENDIF
          NEXT
		    //Print an empty line + a line w/the Page Number
			 TextOut(aPrintDlg[PD_HDC],0,(nLinesPerpages+3)*nChrHeight, ;
			      (Space(40)+"Page "+str(y,3,0)) )

		    EndPage(aPrintDlg[PD_HDC])
          // after an endpage you need to re-select the object in use
          SelectObject(aPrintDlg[PD_HDC], hPrintFont)
        NEXT
      NEXT
	CASE DoCollate == .F.
		nCurrLine := ((aPrintDlg[PD_NFROMPAGE]-1)*nLinesPerPage)
		nFirstLineToPrint := nCurrLine
		FOR y :=aPrintDlg[PD_NFROMPAGE] to aPrintDlg[PD_NTOPAGE]
		  FOR x := 1 to aPrintDlg[PD_NCOPIES]
			 StartPage(aPrintDlg[PD_HDC])
			 nCurrLine := nFirstLineToPrint
			 FOR z:= 1 to nLinesPerPage
            // make sure we don't try to print more than we got!
            IF (nCurrLine <= nLines)
               TextOut(aPrintDlg[PD_HDC], 0, z * nChrHeight, ;
                    EditGetLine(hEdit, nCurrLine++) )
            ENDIF
          NEXT
		    //Print an empty line + a line w/the Page Number
		    TextOut(aPrintDlg[PD_HDC],0,(nLinesPerPage+3)*nChrHeight, ;
			      (Space(40)+"Page "+str(y,3,0)) )

		    EndPage(aPrintDlg[PD_HDC])
          // after an endpage you need to re-select the object in use
          SelectObject(aPrintDlg[PD_HDC], hPrintFont)
			 IF x >= aPrintDlg[PD_NCOPIES]
				nFirstLineToPrint := nCurrLine
			 ENDIF
		  NEXT
		NEXT
ENDCASE

EndDoc(aPrintDlg[PD_HDC])
DeleteDC(aPrintDlg[PD_HDC])
SetCursor(hOldCursor)
RETURN(NIL)


*  Function Ŀ
*          Name: DoUndo(Child_ID)      Docs: Wine Software Partners         
*   Description: To undo a deletion/cut                                     
*  Date created: ??-??-??              Date updated: 02-11-94              
*  Time created: ??:??:??pm            Time updated: 02:58:17pm            
* Ĵ
*     Arguments: Child_ID                                                   
*  Return Value: (NIL)                                                      
*      See Also:                                                            
* 
STATIC FUNCTION DoUndo(Child_ID)
LOCAL hEdit := ReturnChild(Child_ID,"hEdit")
LOCAL hMenu := ReturnChild(Child_ID,"hMenu")

IF EditCanUndo(hEdit)
   EditUndo(hEdit)
ENDIF
EnableMenuItem(hMenu, "undo", MF_GRAYED)

RETURN(NIL)


*  Function Ŀ
*          Name: DoCut()               Docs: Wine Software Partners         
*   Description: Processes a cut to clipboard                               
*  Date created: ??-??-??              Date updated: 02-11-94              
*  Time created: ??:??:??pm            Time updated: 02:58:33pm            
* Ĵ
*     Arguments: Child_ID                                                   
*  Return Value: (NIL)                                                      
*      See Also:                                                            
* 
STATIC FUNCTION DoCut(Child_ID)
LOCAL hEdit := ReturnChild(Child_ID,"hEdit")
LOCAL hMenu := ReturnChild(Child_ID,"hMenu")
SendMessage(hEdit, WM_CUT, 0)
IF EditCanUndo(hEdit)
   EnableMenuItem(hMenu, "undo", MF_ENABLED)
ENDIF
EnableMenuItem(hMenu, "paste", ;
      IF(IsClipBFormatAvailable(CF_TEXT), MF_ENABLED, MF_GRAYED) )

RETURN(NIL)

*  Function Ŀ
*          Name: DoCopy()              Docs: Wine Software Partners         
*   Description: Processes a copy to the Clipboard                          
*  Date created: ??-??-??              Date updated: 02-11-94              
*  Time created: ??:??:??pm            Time updated: 02:58:47pm            
* Ĵ
*     Arguments: Child_ID                                                   
*  Return Value: (NIL)                                                      
*      See Also:                                                            
* 
FUNCTION DoCopy(Child_ID)
LOCAL hEdit := ReturnChild(Child_ID,"hEdit")
LOCAL hMenu := ReturnChild(Child_ID,"hMenu")
LOCAL cRead := ReturnChild(Child_ID,"CREAD")

SendMessage(hEdit, WM_COPY, 0)
IF cRead == "W"
   EnableMenuItem(hMenu, "paste", ;
     IF(IsClipBFormatAvailable(CF_TEXT), MF_ENABLED, MF_GRAYED) )
ENDIF
RETURN(NIL)

*  Function Ŀ
*          Name: DoClear()             Docs: Wine Software Partners         
*   Description: Delete highlited area and does not copy to Clipboard       
*  Date created: ??-??-??              Date updated: 12-29-93              
*  Time created: ??:??:??pm            Time updated: 08:52:17pm            
* Ĵ
*     Arguments: Child_ID                                                   
*  Return Value: (NIL)                                                      
*      See Also:                                                            
* 
STATIC FUNCTION DoClear(Child_ID)
LOCAL hEdit := ReturnChild(Child_ID,"hEdit")
LOCAL hMenu := ReturnChild(Child_ID,"hMenu")
SendMessage(hEdit, WM_CLEAR, 0)
IF EditCanUndo(hEdit)
   EnableMenuItem(hMenu, "undo", MF_ENABLED)
ENDIF
RETURN(NIL)

*  Function Ŀ
*          Name: DoPaste()             Docs: Wine Software Partners         
*   Description: Process a paste from the clipboard                         
*  Date created: ??-??-??              Date updated: 02-11-94              
*  Time created: ??:??:??pm            Time updated: 02:59:37pm            
* Ĵ
*     Arguments: Child_ID                                                   
*  Return Value: (NIL)                                                      
*      See Also:                                                            
* 
STATIC FUNCTION DoPaste(Child_ID)
LOCAL hEdit := ReturnChild(Child_ID,"hEdit")
LOCAL hMenu := ReturnChild(Child_ID,"hMenu")
SendMessage(hEdit, WM_PASTE, 0)
EnableMenuItem(hMenu, "undo", MF_GRAYED)

RETURN(NIL)

*  Function Ŀ
*          Name: TimeDate()            Docs: Wine Software Partners         
*   Description: see note                                                   
*  Date created: ??-??-??              Date updated: 02-11-94              
*  Time created: ??:??:??pm            Time updated: 02:59:57pm            
* Ĵ
*     Arguments: Child_ID                                                   
*  Return Value: (NIL)                                                      
*      See Also:                                                            
* 
// this FUNCTION demonstrates how to "paste" a piece of text
// into the edit buffer at the current location... note that
// both the 2nd and 3rd parameters to EditSetSel() should be -1
STATIC FUNCTION TimeDate(Child_ID)
LOCAL hEdit := ReturnChild(Child_ID,"hEdit")
EditSetSel(hEdit, -1, -1, .f.)
EditReplaceSel(hEdit, substr(time(), 1, 5) + '  ' + dtoc(date()))
RETURN(NIL)


*  Function Ŀ
*          Name: DoFind()              Docs: Wine Software Partners         
*   Description: Process a search for a string                              
*  Date created: ??-??-93              Date updated: 02-11-94              
*  Time created: ??:??:??pm            Time updated: 03:00:19pm            
* Ĵ
*     Arguments: Child_ID   // Used to obtain handles of parents            
*  Return Value: (NIL)                                                      
*      See Also:                                                            
* 
FUNCTION DoFind(Child_ID)
	// Statics for use with find next
	STATIC cFindtext := ''     // Holds the string to find
	STATIC cTextLine           // Holds the Text of one line
	STATIC nOldLine            // The old line # in case there is more
										// than one instance of cFindtext in line
	STATIC cOldFind            // The old cFindtext - same reason as nOldLine
	STATIC lGoNext					// To increment to FOR..NEXT loop
	STATIC nTheCut             // To relocate the pointer position after the
										// first occurence within one line
   STATIC lDown := .T.        // Do we want to seach down or up
	STATIC lWholeWord          // Do we want whole words only (.t. for yes)
	STATIC lCase               // Do we want case sensitive search (.t. if yes)

	// Parent window's handles
	LOCAL hWnd := ReturnChild(Child_ID,"hWnd")    // The Parent Window Handle
	LOCAL hEdit := ReturnChild(Child_ID,"hEdit")  // The Parent Window hEdit
	LOCAL hInst := ReturnChild(Child_ID,"hInst")  // The Parent Window hInst

	// Various Local declarations
	LOCAL lNotFound := .F.     // Flag to send a not found message
	LOCAL nPtr,nTotPtr  			// Pointer to start of cFindTxt
	LOCAL nTotalLines   			// Total number of Lines in text
	LOCAL nStart       			// Starting line number
	LOCAL nLineCount   			// Line count going through the For Next Loop
	LOCAL aDlg         			// Handle returned by the Dialog Window
	LOCAL nDisplayDlg  			// Return from ModalDialog()
	LOCAL hCursor      			// Handle for WAIT cursor
	LOCAL hOldCursor   			// Holds old cursor
	LOCAL nStep := 1           // Incremental Step for the FOR .. NEXT loop
	LOCAL nLength              // Holds the length of cFindText for use with
										// checking whole word or upper/lower case
	LOCAL cTextLeft            // Holds the line of text for same reason as
										// for nLength. May be different than cTextLine
										// if a find was already obtained on that same
										// line

	// Give a default to the statics
 	IF nOldLine == NIL
		nOldLine := 0
	ENDIF

	IF cOldFind == NIL
		cOldFind := ""
	ENDIF

	IF lGoNext == NIL
		lGoNext := .F.
	ENDIF

	IF nTheCut == NIL .OR. cOldFind != cFindText
		nTheCut := 0
	ENDIF

	IF lWholeWord == NIL
		lWholeWord := .F.
	ENDIF

	IF lCase == NIL
		lCase := .F.
	ENDIF

	// Start of DIALOG
	aDlg := CreateDialog("Find",                                         ;
                    WS_CAPTION + WS_SYSMENU + WS_GROUP + WS_TABSTOP     ;
		    + WS_THICKFRAME + WS_VISIBLE + WS_POPUP,	                     ;
                    30, 70, 240, 60 )

	// Return value = 1 for nDisplayDlg := ModalDialog(....)
	aDlg := AppendDialog(aDlg, "", DLG_STATIC,                           ;
                    WS_CHILD + WS_VISIBLE,                              ;
                    5, 10, 47, 20,                                      ;
                    "Fi&nd What:")

	//Return value =  2
	aDlg := AppendDialog(aDlg, "findwhat", DLG_EDIT,                     ;
                    ES_LEFT + ES_NOHIDESEL                              ;
                    + WS_BORDER + WS_TABSTOP                            ;
		    			  + WS_CHILD + WS_VISIBLE, 				               ;
                    48, 9, 135, 12,                                     ;
                    cFindText)
	//Return value = 3
	aDlg := AppendDialog(aDlg, "findnext", DLG_BUTTON,                   ;
                    BS_DEFPUSHBUTTON + WS_TABSTOP                       ;
						  + WS_CHILD + WS_VISIBLE,                            ;
                    190, 9, 45, 14,                                     ;
                    "&Find Next")

	//Return value = 4
	aDlg := AppendDialog(aDlg, "wholeword", DLG_BUTTON,                  ;
                    BS_CHECKBOX + WS_TABSTOP + WS_CHILD + WS_VISIBLE,   ;
                    5, 28, 90, 12,                                      ;
                    "Match &Whole Word Only")

	CheckDlgButton(aDlg, "wholeword", IF(lWholeWord, 1, 0) )

	//Return value = 5
	aDlg := AppendDialog(aDlg, "matchcase", DLG_BUTTON,                  ;
                    BS_CHECKBOX + WS_TABSTOP + WS_CHILD + WS_VISIBLE,   ;
                    5, 42, 50, 12,                                      ;
                    "Match &Case")

	 CheckDlgButton(aDlg, "matchcase", IF(lCase, 1, 0) )


	//Return value = 6
	aDlg := AppendDialog(aDlg, "", DLG_STATIC,                           ;
                    SS_BLACKFRAME + WS_CHILD + WS_VISIBLE,              ;
                    113, 32, 70, 21,                                    ;
		    "")

	//Return Value = 7
	aDlg := AppendDialog(aDlg, "", DLG_STATIC,                           ;
                    WS_CHILD + WS_VISIBLE,                              ;
                    117, 28, 33, 12,                                    ;
                    " Direction ")

	//Return value = 8
	aDlg := AppendDialog(aDlg, "up", DLG_BUTTON, BS_AUTORADIOBUTTON +    ;
                    WS_TABSTOP + WS_CHILD + WS_VISIBLE,                 ;
                    118, 38, 24, 14,                                    ;
                    "&Up")

	//Return Value = 9
	aDlg := AppendDialog(aDlg, "down", DLG_BUTTON, BS_AUTORADIOBUTTON +  ;
                    + WS_TABSTOP + WS_CHILD + WS_VISIBLE,               ;
                    149, 38, 30, 14,                                    ;
                    "&Down")

	CheckDlgButton(aDlg, IF(lDown, "down", "up"), 1)

	//Return value = 10
	aDlg := AppendDialog(aDlg, "cancel", DLG_BUTTON,                     ;
                    BS_PUSHBUTTON + WS_TABSTOP                         	;
						  + WS_CHILD + WS_VISIBLE,                            ;
                    190, 27, 45, 14,                                    ;
                    "Cancel")
	// Display the Dialog
	nDisplayDlg := ModalDialog(aDlg, hInst, hWnd)


	//0 returned if ESC key was hit & 10 --> if Cancel Button was activated.
	// So if ESC was not hit & the Cancel button was not pushed
	// & there was input by User in Dialog Box
	IF nDisplayDlg <> 0 .AND. nDisplayDlg <> 10 .AND. ;
		    ! empty( cFindText := GetDialogResult(aDlg, "findwhat") )

		// Check if lWholeWord or lCase was chosen
		lWholeword := ( GetDialogResult(aDlg, "wholeword") == 1 )
      lCase := ( GetDialogResult(aDlg, "matchcase") == 1 )

		// Set parameters for search depending on direction
		lDown := ( GetDialogResult(aDlg, "down") == 1 )
		IF lDown
			// EM_GETLINECOUNT returns the total number of lines in the
			// Edit Control starting with 0  so use -1
			nTotalLines := SendMessage(hEdit, EM_GETLINECOUNT) - 1
			nStep := 1
		ELSE
			nTotalLines := -1
			nStep := -1
		ENDIF

		//   If the FindNext button was pressed then
		//   Determine the line that we are currently on (for Find Next) by
		//   using EditLineFromChar(hEdit, nPos) which returns the line number
		//   indicated by the character position .
		//   EditLineIndex() returns the character position of a line
		//   within a multi-line edit control -- Starts @ 0 so use - 1 for
		//   current line
		nStart := EditLineFromChar(hEdit, EditLineIndex(hEdit, -1) )

		// Load WAIT type cursor
      hCursor := LoadCursor( , IDC_WAIT)

		// Save old cursor for clean-up and instantiate WAIT cursor
		// during the search.
		hOldCursor := SetCursor(hCursor)

		// If we already did a find and searching for a second one
		IF lGoNext
			IF lDown
				nStart++
			ELSE
				nStart--
			ENDIF
		ENDIF

		// Start the search loop
		FOR nLineCount := nStart to nTotalLines  STEP nStep
		  	// If the line number is the same as last time and the string
			// to find is the same as last time the use the var containing
			// the remaining of the line since it holds another instance of
			// the string. If not then get the text line
			IF nLineCount == nOldLine .AND. cFindText == cOldFind
				cTextLine := cTextLine
			ELSE
				cTextLine := EditGetLine(hEdit,nLineCount)
				IF nLineCount != nOldLine
					nTheCut := 0
   			ENDIF
			ENDIF

			// For use with lCase or Whole Word search
			cTextLeft := cTextLine

			// If lCase is not sensitive then is the upper of cFindText is in
			// the upper of line else is cFindText in Line
			IF ( .not. lCase .and. upper(cFindText) $ upper(cTextLine) ) .or. ;
                 ( lCase .and. cFindText $ cTextLine )

				// Determine the begining position within the line
				nPtr := AT(UPPER(cFindText),UPPER(cTextLine))
				// Determine the cursor position within the total text
				// EditLineIndex returns the cursor position up to the
				// begining of the line on which the cursor resides
				// Use -1 to get to the start
				// nTheCut is the position within the line if the search found
				// a word in that same line
				nTotPtr := EditLineIndex(hEdit,nLineCount) + nPtr -1 + nTheCut
				// Set the cursor to cover the string
				EditSetSel(hEdit,nTotPtr,(nTotPtr+len(cFindText)),.T.)
				// Change the cursor back to the old cursor
				SetCursor(hOldCursor)
				// Set the flag to having found a string
				lNotFound := .F.
				// Find the begining of the remaing part of the text line
				nTheCut +=At(cFindText,cTextLine)+Len(cFindText)-1
				// Obtain remaining of the line to see if there is another
				// occurence of cFindText
				cTextline := substr(cTextLine,(nPtr+len(cFindText)),len(cTextLine))
				// Let's find out if there is another occurence
				IF UPPER(cFindText) $ UPPER(cTextLine)
					nOldLine := nLineCount
					cOldFind := cFindText
					lGoNext := .F.

				ELSE
					nOldLine := 0
					cOldFind := ""
					cTextLine := ""
					lGoNext := .T.
					nTheCut := 0
				ENDIF
				 // further filtering logic to ensure this is the case
         	IF lWholeword
            	IF lCase
               	nPtr := at(cFindText, cTextLeft)
            	ELSE
               	nPtr := at(upper(cFindText), upper(cTextLeft))
            	ENDIF
            	nLength := len(cFindText)
            	IF ( nPtr == 1 .and. substr(cTextLeft, nLength + 1, 1) == " " ) .or.  ;
                 ( substr(cTextLeft, nPtr - 1, 1) == " " .and.                       ;
                   substr(cTextLeft, nPtr + nLength, 1) == " ")                 .or. ;
                 ( substr(cTextLeft, nPtr - 1, 1) == " " .and.                       ;
                   nPtr + nLength - 1 == len(cTextLeft))
               	EXIT
            	ENDIF
         	ELSE
				  // Need to exit to be able to have the highlight work
				  EXIT
				ENDIF

		  	ELSE
				// String was not found
				lNotFound := .T.
			ENDIF
	  NEXT

	  IF lNotFound
	  		MessageBox(,'Cannot find "'+cFindtext+'"',"Error",;
				MB_ICONASTERISK + MB_OK)
	  ENDIF
	  SetCursor(hOldCursor)
	ENDIF
	RETURN(NIL)

*  Function Ŀ
*          Name: DoReplace()           Docs: Wine Software Partners         
*   Description: Process the search and replace                             
*  Date created: ??-??-??              Date updated: 02-15-94              
*  Time created: ??:??:??pm            Time updated: 02:46:03pm            
* Ĵ
*     Arguments: Child_ID                                                   
*  Return Value: (NIL)                                                      
*      See Also:                                                            
* 
STATIC FUNCTION DoReplace(Child_ID)
STATIC cFindtext := ''
STATIC cReplaceText := ''
LOCAL hWnd := ReturnChild(Child_ID,"hWnd")
LOCAL hEdit := ReturnChild(Child_ID,"hEdit")
LOCAL hMenu := ReturnChild(Child_ID,"hMenu")
LOCAL nID_EDIT := ReturnChild(Child_ID,"Edit_ID")
LOCAL hInst := ReturnChild(Child_ID,"hInst")

LOCAL lWholeword
LOCAL cWhole_y := ""
LOCAL x := 1
LOCAL y := "",y_left := ""
LOCAL lCase := .F.
LOCAL nPtr := 0
LOCAL nOld_Ptr := 0
LOCAL nFull_Ptr := 0
LOCAL nLines := 0
LOCAL nStart := -1
LOCAL aDlg
LOCAL lContinue := .t.
LOCAL lNew_Line := .T.
LOCAL lOkToChange := .T.
LOCAL lReplaceAll := .F.
LOCAL hCursor
LOCAL hOldCursor
LOCAL nLength := 0


aDlg := CreateDialog("Replace",                                         ;
                    WS_CAPTION + WS_SYSMENU + WS_GROUP + WS_TABSTOP     ;
		    + WS_THICKFRAME + WS_VISIBLE + WS_POPUP,		;
                    40, 70, 210, 80)

aDlg := AppendDialog(aDlg, "", DLG_STATIC,                             ;
                    WS_CHILD + WS_VISIBLE,                             ;
                    5, 10, 47, 20,                                     ;
                    "Fi&nd What:")

aDlg := AppendDialog(aDlg, "findwhat", DLG_EDIT,                        ;
                    ES_LEFT + ES_NOHIDESEL                              ;
                    + WS_BORDER + WS_TABSTOP                            ;
		    + WS_CHILD + WS_VISIBLE, 				;
                    53, 9, 100, 12,                                      ;
                    cFindText)

aDlg := AppendDialog(aDlg, "", DLG_STATIC,                          ;
                    WS_CHILD + WS_VISIBLE,                          ;
                    5, 25, 47, 12,                                  ;
                    "&Replace With:")

aDlg := AppendDialog(aDlg, "replace", DLG_EDIT,                      ;
                    ES_LEFT + ES_NOHIDESEL                           ;
                    + WS_BORDER + WS_TABSTOP                         ;
                    + WS_CHILD + WS_VISIBLE,                         ;
                    53, 24, 100, 12,                                  ;
                    cReplaceText)

aDlg := AppendDialog(aDlg, "wholeword", DLG_BUTTON,                    ;
                    BS_CHECKBOX + WS_TABSTOP + WS_CHILD + WS_VISIBLE,  ;
                    5, 45, 90, 12,                                     ;
                    "Match &Whole Word Only")

aDlg := AppendDialog(aDlg, "matchcase", DLG_BUTTON,                    ;
                    BS_CHECKBOX + WS_TABSTOP + WS_CHILD + WS_VISIBLE,  ;
                    5, 59, 50, 12,                                     ;
                    "Match &Case")

aDlg := AppendDialog(aDlg, "findnext", DLG_BUTTON,                      ;
                    BS_DEFPUSHBUTTON + WS_TABSTOP + WS_CHILD + WS_VISIBLE, ;
                    160, 9, 45, 14,                                     ;
                    "&Find Next")

aDlg := AppendDialog(aDlg, "replace", DLG_BUTTON,                       ;
                    BS_PUSHBUTTON + WS_TABSTOP + WS_CHILD + WS_VISIBLE, ;
                    160, 25, 45, 14,                                    ;
                    "&Replace")

aDlg := AppendDialog(aDlg, "replaceall", DLG_BUTTON,                    ;
                    BS_PUSHBUTTON + WS_TABSTOP + WS_CHILD + WS_VISIBLE, ;
                    160, 41, 45, 14,                                    ;
                    "Replace &All")

aDlg := AppendDialog(aDlg, "cancel", DLG_BUTTON,                        ;
                    BS_PUSHBUTTON + WS_TABSTOP + WS_CHILD + WS_VISIBLE, ;
                    160, 57, 45, 14,                                    ;
                    "Cancel")


x := ModalDialog(aDlg, hInst, hWnd)
IF x <> 0 .and. x <> 10 .and. ;
           ! empty( cFindText := GetDialogResult(aDlg, "findwhat") )
   lWholeword := ( GetDialogResult(aDlg, "wholeword") == 1 )
   cFindText := GetDialogResult(aDlg, "findwhat")
   lCase := ( GetDialogResult(aDlg, "matchcase") == 1 )
   nLines := SendMessage(hEdit, EM_GETLINECOUNT) - 2
   cReplaceText := GetDialogResult(aDlg, "replace")
   lReplaceAll := (x == 9)

   // determine the line that we are currently on (for Find Next)
   IF x == 7
		//   EditLineFromChar(hEdit, nPos) returns the line number indicated
		//   by the character position .
		//   EditLineIndex() returns the character position of a line
		//   within a multi-line edit control -- Starts @ 0 so use - 1 for
		//   current line
			nStart := EditLineFromChar(hEdit, EditLineIndex(hEdit, -1) ) - 1
   ELSE
      nStart := -1
   ENDIF
   hCursor := LoadCursor( , IDC_WAIT)
   hOldCursor := SetCursor(hCursor)
	y := ""
	y_Left := ""
	nPtr := 0
	nOld_Ptr := 0
	DO WHILE lContinue
		// checking each line for occurence until we find one
		IF lNew_Line
			FOR x := nStart to nLines
				y := EditGetLine(hEdit, x)
				y_Left := y
		  		nPtr := 0
				nOld_Ptr := 0
			   IF ( .not. lCase .and. upper(cFindText) $ upper(y_Left) ) .or. ;
                    ( lCase .and. cFindText $ y_Left )
            	exit
         	ENDIF
         NEXT
		ENDIF
		//If we have not reached beyond the end of the text
      IF x <= nLines
			//Lets find the begining of the search string
			IF lCase
            nPtr := at(cFindText, y_Left)
         ELSE
            nPtr := at(upper(cFindText), upper(y_Left))
         ENDIF
			//the begining of the string in the whole of y is
			nOld_Ptr := nOld_Ptr+nPtr
			//EditLineIndex() starts at 0, so subtract 1 to get correct
			//total count
			nFull_Ptr := (EditLineIndex(hEdit,x) - 1)+nOld_Ptr
			// Lets check if WholeWord case was chosen
			IF lWholeWord
				nLength := LEN(cFindText)
				// Make sure we ae searching the latest update of the line
				cWhole_y := EditGetLine(hEdit, x)
				// Need to check if there is a blank or other punctuation marks
				// before and after the word
				IF nPtr == 1 .AND. (SUBSTR(cWhole_y,nLength+1,1) $ (". ,:;!?/()");
						.OR. (SUBSTR(cWhole_y,nLength+1,1) == '"') )
					lOkToChange := .T.
				ELSE
					IF ((SUBSTR(cWhole_y,nOld_Ptr-1,1) $ (". ,:;!?/()");
							.OR. (SUBSTR(cWhole_y,nOld_Ptr-1,1) == '"') ));
							.AND. ((SUBSTR(cWhole_y,nOld_Ptr+nLength,1) $ (". ,:;!?/()");
							.OR. (SUBSTR(cWhole_y,nOld_Ptr+nLength,1) == '"') ))
					  lOkToChange := .T.
					ELSE
					  lOkToChange := .F.
					ENDIF
				ENDIF
			ENDIF
			IF lOkToChange
 				EditSetSel(hEdit, nFull_Ptr, nFull_Ptr + len(cFindText), .t.)
   	      EditReplaceSel(hEdit, cReplaceText)
			ENDIF
			lContinue := lReplaceAll
			IF lContinue
				//Move the pointer to 1 past the end of the replaced string.
				//Use nPtr because it gives the begining of the string in
				//the y_left.Use of nOld_Ptr would require to have saved
				//the original y and did repalcing manipulations up to
				//that point.
				y_Left := SUBSTR(y_Left,(nPtr+len(cFindText)),len(y_Left))

				//Subtract 1 because you want the count to end of the word
				// and just before the begining of y_Left
				IF lOkToChange
					nOld_Ptr := nOld_Ptr+len(cReplaceText)-1
				ELSE
					nOld_Ptr := nOld_Ptr+Len(cFindText)-1
				ENDIF
			ENDIF
			IF len(y_Left)>len(cFindText)
					// If there is another occurrence of the search string
					// in the line, then stay in the same line
					IF ( .NOT.  lCase .AND. (upper(cFindText) $ upper(y_Left)));
							 .OR. (lCase .AND. (cFindText $ y_Left))
						nStart := x
						lNew_Line := .F.
					ELSE
						nStart := ++x
						y := ""
						y_Left := ""
						nOld_Ptr := 0
						lNew_Line := .T.
					ENDIF
			ELSE
					nStart := ++x
					y := ""
					y_Left := ""
					nOld_Ptr := 0
					lNew_Line := .T.
			ENDIF
      ELSE
         IF ! lReplaceAll
            MessageBox( , 'Cannot find "' + cFindText + '"', "Error",;
					 MB_ICONASTERISK + MB_OK)
         ENDIF
         lContinue := .f.
      ENDIF
   enddo
   SetCursor(hOldCursor)
ENDIF
RETURN(NIL)



*  Function Ŀ
*          Name: DoFont()              Docs: Wine Software Partners         
*   Description: Changes the font as requested by User                      
*  Date created: ??-??-??              Date updated: 02-11-94              
*  Time created: ??:??:??pm            Time updated: 03:01:07pm            
* Ĵ
*     Arguments: Child_ID                                                   
*  Return Value: (NIL)                                                      
*      See Also:                                                            
* 
STATIC FUNCTION DoFont(Child_ID)
LOCAL hWnd := ReturnChild(Child_ID,"hWnd")
LOCAL hEdit := ReturnChild(Child_ID,"hEdit")
LOCAL hMenu := ReturnChild(Child_ID,"hMenu")
LOCAL nID_EDIT := ReturnChild(Child_ID,"Edit_ID")

LOCAL hOldFont,hFont
LOCAL aFont := ReturnChild(Child_ID,"aFont")
LOCAL nPointSize := ReturnChild(Child_ID,"nPointSize")
LOCAL hDC
LOCAL nColor := RGB(0, 0, 0) // black
LOCAL aTm := {}
// establish defaults if no font previously selected
IF nPointSize == NIL
   nPointSize := 10
ENDIF
IF aFont == NIL
   aFont := {0, 0, 0, 0, 400, .f., .f., .f., 1, 0, 0, 0, 0, "Arial"}
ENDIF
aFont := ChooseFont(aFont, , CF_BOTH + CF_EFFECTS, @nColor)
IF aFont <> NIL   // else user chose cancel/close or hit Esc
   hDC := GetDC(hEdit)
   SetTextColor(hDC, nColor)
   hFont    := CreateFont(aFont)
   hOldFont := SelectObject(hDC, hFont)
   SendMessage(hEdit, WM_SETFONT, hFont, 0 )
   GetTextMetrics(hDC, @aTm)
   nPointsize:= int(72 * aTm[TM_Height] - aTm[TM_InternalLeading]) / ;
                GetDeviceCaps(hDC, LOGPIXELSY)
	AddFont(Child_ID,aFont,nPointsize)
ENDIF
RETURN(NIL)

// ---------- End of Notepad.prg
