*  Program Ŀ
*   Application: Multiple Child Notepad Example                             
*   Description: Array to store info for multiple child-windows             
*              : Based on the Event Handlers from John M. Skelton           
*     File Name: CHILDARR.PRG                                               
*        Author: Jean-Pierre Zacaropoulos                                   
*  Date created: 12-20-93              Date updated: 12-21-93              
*  Time created: 12:09:13pm            Time updated: 12:09:13pm            
*     Make File: Padding.RMK                                                
*     Exec File: Padding.EXE           Docs By: Wine Software Partners      
*     Copyright: (c) 1993 by Wine Software Partners                         
* 
	// This is provided free of charge for use by C4W registered owners and
	// CA-VO registered owners.

	#DEFINE WIN_WANT_HELP
	#INCLUDE	 "windows.ch"
	#DEFINE CR chr(13)
	//#DEFINE DEBUG

	// It is faster and easier to use multiple arrays than a single array
	// containing sub-arrays.

	STATIC	aChild    := {}  // the notepad window handles
	STATIC	aMenu     := {}  // the Menu handles
	STATIC   aEdit     := {}  // child edit window handles
	STATIC   aInst     := {}  // the hInst
	STATIC   aEditId   := {}  // the Child ID_EDIT
	STATIC   aFileNm   := {}  // the name of the file being edited
	STATIC   aFileName := {}  // the name of the file as notepad title
	STATIC   aRead     := {}  // the read only or not attribute
	STATIC   aFont 	 := {}  // The fonts in case they were changed

//Returns: a unique id, for use with DelEditChild(), and for retreival purposes

*  Function Ŀ
*          Name: AddhWndChild()            Docs: Wine Software Partners     
*   Description: Stores the Child-Windows Handles                           
*  Date created: 12-20-93              Date updated: 02-11-94              
*  Time created: 12:14:39pm            Time updated: 03:08:22pm            
* Ĵ
*     Arguments: hWnd --------> The Main Child Window Handle                
*              : cRead--------> The File Name to be registered              
*  Return Value: nId   -------> A unique Id # to be used to retrieve        
*              :                information from the static arrays          
*      See Also:                                                            
* 
	FUNCTION AddhWndChild(hWnd,cRead)   // --> nId  (for use with DelChildArr)
	LOCAL nId

	IF (nId := ascan(aChild, nil)) != 0
		// re-use an empty slot
		aChild[nId] := hWnd
		// Revision 2 changed aRead to aRead[nId] which makes better sense
		// But then what do you expect at midnight.
		aRead[nId]:= cRead
	ELSE
		AADD(aChild, hWnd)
		AADD(aMenu, NIL)
		AADD(aEdit, NIL)
		AADD(aInst, NIL)
		AADD(aEditId, NIL)
		AADD(aFileNm, NIL)
		AADD(aFileName,NIL)
		AADD(aRead,cRead)
		AADD(aFont,{NIL,NIL})
		nId = len(aChild)
	ENDIF
	RETURN(nId)


*  Function Ŀ
*          Name: AddEditChild()        Docs: Wine Software Partners         
*   Description: Stores the different ids necessary for the edit windows    
*  Date created: 12-20-93              Date updated: 02-11-94              
*  Time created: 12:30:26pm            Time updated: 03:08:46pm            
* Ĵ
*     Arguments: nId ---------> Array element                               
*              : hMenu -------> Menu Handle                                 
*              : hEdit -------> Edit Window Handle                          
*              : hInst -------> Current Inst                                
*              : Edit_ID -----> Edit Window Unique ID                       
*              : Edit_ID -----> Edit Window Unique ID                       
*              : cFile -------> The File Name i.e cName.txt                 
*              : cFileName----> The file name to show in notepad title      
*  Return Value: (NIL)                                                      
*      See Also:                                                            
* 
	FUNCTION AddEditChild(nId,hMenu,hEdit,hInst,Edit_ID,cFile,cFileName)
	aMenu[nId]  	:= hMenu
	aEdit[nId]  	:= hEdit
	aInst[nId]  	:= hInst
	aEditId[nId] 	:= Edit_ID
	aFileNM[nId]   := cFile
	aFileName[nId] := cFileName

	RETURN(NIL)

*  Function Ŀ
*          Name: AddFileName()         Docs: Wine Software Partners         
*   Description: Adds the name of the file being edited                     
*  Date created: 01-26-94              Date updated: 02-11-94              
*  Time created: 01:01:45pm            Time updated: 03:14:02pm            
* Ĵ
*     Arguments: nId                                                        
*              : cFileNm -----> File Name as xxx.txt                        
*              : cFilename----> Filename to show in title                   
*  Return Value: NIL                                                        
*      See Also:                                                            
* 
	FUNCTION AddFileName(nId,cFileNm,cFileName)
	aFileNM[nId]   := cFileNm
	aFileName[nId] := cFileName
	RETURN(NIL)

*  Function Ŀ
*          Name: AddFont()             Docs: Wine Software Partners         
*   Description: Adds the fonts attribute, just in case they were changed   
*  Date created: 01-26-94              Date updated: 02-11-94              
*  Time created: 01:01:45pm            Time updated: 03:14:09pm            
* Ĵ
*     Arguments: nId                                                        
*              : aFontPointer                                               
*              : nPointSize                                                 
*  Return Value: NIL                                                        
*      See Also:                                                            
* 
	FUNCTION AddFont(nId,aFontPointer,nPointSize)
	aFont[nId][1]   := aFontPointer
	aFont[nId][2]   := nPointSize
	RETURN(NIL)

*  Function Ŀ
*          Name: DelEditChild()        Docs: Wine Software Partners         
*   Description: Del the array elements for that child window               
*  Date created: 12-20-93              Date updated: 02-11-94              
*  Time created: 12:34:17pm            Time updated: 03:14:41pm            
* Ĵ
*     Arguments: nId ---------> Array element                               
*  Return Value: (NIL)                                                      
*      See Also:                                                            
* 
	FUNCTION DelEditChild(nId)
	// An alternative would be to delete the array elements, but that
	// does not preserve the values of id's after the deleted elements.
	// Also, storing nil is faster than removing the arrays elements.
	aChild[nId] := aMenu[nId] := aEdit[nId]  := NIL
	aInst[nId]  := aEditId[nId] := NIL
	aFileNM[nId] := aFileName[nId] := aRead[nId] := NIL
	RETURN(NIL)


*  Function Ŀ
*          Name: ReturnChild()         Docs: Wine Software Partners         
*   Description: Returns the appropriate handle/ID to use with Children     
*  Date created: 12-20-93              Date updated: 02-11-94              
*  Time created: 12:36:17pm            Time updated: 03:14:59pm            
* Ĵ
*     Arguments: nId ---------> Array element                               
*              : which_one ---> Which array                                 
*  Return Value: (cReturn)                                                  
*      See Also:                                                            
* 
	FUNCTION ReturnChild(nId,which_one)
	LOCAL cReturn , c

	DO CASE
	CASE UPPER(which_one) == "HWND"
		cReturn := aChild[nId]
	CASE UPPER(which_one) == "HMENU"
	  	cReturn := aMenu[nId]
	CASE UPPER(which_one) == "HEDIT"
	  	cReturn := aEdit[nId]
	CASE UPPER(which_one) == "HINST"
	  	cReturn := aInst[nId]
	CASE UPPER(which_one) == "EDIT_ID"
	  	cReturn := aEditId[nId]
   CASE UPPER(which_one) == "CFILE"
	  	cReturn := aFileNM[nId]
	CASE UPPER(which_one) == "CFILENAME"
		cReturn := aFileName[nId]
	CASE UPPER(which_one) == "CREAD"
		cReturn := aRead[nId]
	CASE UPPER(which_one) == "AFONT"
		cReturn := aFont[nId][1]
	CASE UPPER(which_one) == "NPOINTSIZE"
		cReturn := aFont[nId][2]
	OTHERWISE
		cReturn := NIL
   ENDCASE

	RETURN(cReturn)

*  Function Ŀ
*          Name: GetID()               Docs: Wine Software Partners         
*   Description: Returns the element of the array holding the handles       
*  Date created: 12-29-93              Date updated: 02-11-94              
*  Time created: 09:27:28pm            Time updated: 03:15:18pm            
* Ĵ
*     Arguments: hWnd                                                       
*  Return Value: Child_ID                                                   
*      See Also: GetIDhEdit                                                 
* 
	FUNCTION GetID(hWnd)
	RETURN(ASCAN(aChild,hWnd))

*  Function Ŀ
*          Name: GetIDhEdit()               Docs: Wine Software Partners         
*   Description: Returns the element of the array holding the handles       
*  Date created: 12-29-93              Date updated: 02-11-94              
*  Time created: 09:27:28pm            Time updated: 03:15:39pm            
* Ĵ
*     Arguments: hEdit                                                       
*  Return Value: Child_ID                                                   
*      See Also: GetId()                                                    
* 
	FUNCTION GetIDhEdit(hEdit)
		#ifdef DEBUG
		  //  Interresting to see the returns. Left for debugging purposes
		  local n
	  	  MessageBox(GetFocus(),"Passed hEdit "+str(hEdit),"",MB_OKCANCEL)
		  FOR n := 1 TO len(aEdit)
		   	MessageBox(GetFocus(),"hEdit "+STR(N)+"  "+str(aEdit[n]),"",MB_OKCANCEL)
		  NEXT
	   #endif

	RETURN(ASCAN(aEdit,hEdit))



*  Function Ŀ
*          Name: CloseEditAll          Docs: Wine Software Partners         
*   Description: Checks that all NotePads are saved before allowing EXIT    
*  Date created: 01-26-94              Date updated: 02-11-94              
*  Time created: 02:01:33pm            Time updated: 03:16:16pm            
* Ĵ
*     Arguments: None                                                       
*  Return Value: .T. if ok to exit                                          
*      See Also:                                                            
* 
FUNCTION CloseEditAll
	LOCAL aLenEdit :=len(aEdit)     	// Length of the array holding the hEdit
	LOCAL nCount := 1						// Counter
	LOCAL nSel 								// Return for dialog box
	LOCAL lReturn := .T.

	// Lets go thru the complete array to check that they are all saved
	FOR nCount := 1 TO  aLenEdit
		IF aEdit[nCount] != NIL
			IF EditGetModify (aEdit[nCount])
				setfocus(aChild[nCount])
				nSel := MessageBox(0, "The text in " + aFileNM[nCount] + " has changed." + ;
                   CR + "Do you want to save the changes?", ;
                   "Notepad", MB_YESNOCANCEL + MB_ICONEXCLAMATION)
				DO CASE
				CASE nSel == IDYES
					DoSave(,nCount)
					lReturn := .T.
				CASE nSel ==IDNO
					lReturn := .T.
				CASE nSel ==IDCANCEL
					lReturn := .F.
					EXIT              // Exit the loop
				ENDCASE
			ENDIF
		ENDIF
		IF lReturn .AND. aEdit[nCount] != NIL
			WinHelp(aChild[nCount],"Note.Hlp",HELP_QUIT,0)
			DestroyMenu(aMenu[nCount])
			DestroyWindow(aEdit[nCount])
			DestroyWindow(aChild[nCount])
			DelEditChild(nCount)
			IF nCount < aLenEdit
				IF aChild[nCount+1] != NIL
					SetFocus(aChild[nCount+1])
				ENDIF
			ENDIF


		ENDIF
	NEXT
	RETURN(lReturn)

   // end of file ChildArr.PRG

