*******************************************************************************
*
*  TEST.PRG
*
*  Program to test OverLay().
*
*  This test program and OverLay() .LIB file
*     Copyright (c) 1991-1993 by SofDesign International, Inc.
*
*  This simple test program demonstrates a small portion of the true power
*  of OverLay().  Once you've ran this test program yourself, try out some
*  of the other features of OverLay() like the O_Keyboard() function.
*
*******************************************************************************
PRIVATE Program, Memory, Pathname
PRIVATE IsExoSpace, UseExp, UseHIMEM, UseDOS2, CurrentID, NewDirectory, EnvVar

* Turn off Clipper's scoreboard display on line 0.
SET SCOREBOARD OFF

* Determine if ExoSpace is being used by seeing if O_UseExp is set to .T.
IsExoSpace = .NOT. O_UseExp()

DO ClearScreen
@ 04, 02 SAY "ͻ"
@ 05, 02 SAY "                                                                          "
@ 06, 02 SAY "  OverLay() grants Clipper programmers the ability to run LARGE programs  "
@ 07, 02 SAY "  from their Clipper applications.  OverLay() saves the memory used by a  "
@ 08, 02 SAY "  Clipper program to a disk file or expanded/extended memory, frees that  "
@ 09, 02 SAY "  memory for reuse, and then RUNs whatever program you have requested or  "
@ 10, 02 SAY "  even shells to DOS.  OverLay() can free up all but about 13-16K of the  "
@ 11, 02 SAY "  memory used by the current Clipper program for use by another program!  "
@ 12, 02 SAY "                                                                          "
@ 13, 02 SAY "  Run this test program to get a feel for how OverLay() works.            "
@ 14, 02 SAY "                                                                          "
@ 15, 02 SAY "  To really appreciate OverLay()'s capabilities, please read through the  "
@ 16, 02 SAY "  documentation and link OverLay() into your own applications.            "
@ 17, 02 SAY "                                                                          "
@ 18, 02 SAY "ͼ"
DO PressAKey

Program = SPACE(30)
Memory = 0
Pathname = SPACE(30)
CurrentID = SUBSTR( O_GetID(0) + SPACE(45), 1, 45 )
NewDirectory = SPACE(45)

DO WHILE .t.

  UseExp = O_UseExp()
  UseHIMEM = O_UseHIMEM()
  UseDOS2 = O_UseDOS2()

  DO ClearScreen
  @ 01, 02 SAY "ͻ"
  @ 02, 02 SAY "                    OverLay() Version     Test Program                   "
  @ 03, 02 SAY "͹"
  @ 04, 02 SAY "   Major Error Code of Last Test:     DOS Errorlevel of Last Test:       "
  @ 05, 02 SAY "Ķ"
  @ 06, 02 SAY "  Name of Program (Blank for DOS Shell):                                 "
  @ 07, 02 SAY "  Amount of Memory Required (0 for All):                                 "
  @ 08, 02 SAY "       Pathname to Store Temporary File:                                 "
  @ 09, 02 SAY "       (Blank for Current Directory. Use a semi-colon for two paths.)    "
  @ 10, 02 SAY "Ķ"
  @ 11, 02 SAY "    The following enviroment variables will be added by OverLay():       "
  @ 12, 02 SAY "    'PROMPT=Type EXIT to return...$_$P$G' + CHR(0) + 'OVERLAY()=...'     "
  @ 13, 02 SAY "Ķ"
  @ 14, 02 SAY "  Use Expanded Memory?    Use HIMEM.SYS?    Use DOS 2.x File Method?     "
  @ 15, 02 SAY "Ķ"
  @ 16, 02 SAY "   ID of Previous Shell:                                                 "
  @ 17, 02 SAY "   ID of Current  Shell:                                                 "
  @ 18, 02 SAY "Ķ"
  @ 19, 02 SAY "      Current Directory:                                                 "
  @ 20, 02 SAY "    Change to Directory:                                                 "
  @ 21, 02 SAY "͹"
  @ 22, 02 SAY "                           Press Escape To Exit                          "
  @ 23, 02 SAY "ͼ"

  @ 02, 41 SAY SUBSTR( O_Version(), 1, 3 )
  @ 04, 37 SAY O_ErrMajor() PICTURE "99"
  @ 04, 70 SAY O_ErrLevel() PICTURE "999"
  @ 06, 44 GET Program
  IF .NOT. IsExoSpace
    @ 07, 44 GET Memory PICTURE "999"
  ELSE
    @ 07, 44 SAY Memory PICTURE "999"
  ENDIF
  @ 08, 44 GET Pathname
  IF .NOT. IsExoSpace
    @ 14, 26 GET UseExp PICTURE "Y"
    @ 14, 44 GET UseHIMEM PICTURE "Y"
  ELSE
    @ 14, 26 SAY UseExp PICTURE "Y"
    @ 14, 44 SAY UseHIMEM PICTURE "Y"
  ENDIF
  @ 14, 72 GET UseDOS2 PICTURE "Y"
  @ 16, 28 SAY SUBSTR( O_GetID(1), 1, 45 )
  @ 17, 28 GET CurrentID VALID .not. EMPTY(CurrentID)
  @ 19, 28 SAY SUBSTR( O_CurPath(), 1, 45 )
  @ 20, 28 GET NewDirectory VALID O_DirExist(LTRIM(TRIM(NewDirectory)))
  READ
  IF LASTKEY() = 27
    EXIT
  ENDIF

  DO ClearScreen

  * Set user requested defaults.
  O_UseExp(UseExp)
  O_UseHIMEM(UseHIMEM)
  O_UseDOS2(UseDOS2)
  O_SetID(LTRIM(TRIM(CurrentID)))

  * Save the current path and change to the requested directory.
  IF .not. EMPTY(NewDirectory)
    CurrentPath = O_CurPath()
    O_CD(LTRIM(TRIM(NewDirectory)))
  ENDIF

  * Get ready to change the PROMPT during the OverLay() call.
  * Also, add a spurious comment about OverLay() to the DOS enviroment.
  EnvVar = "PROMPT=Type EXIT to return...$_$P$G" + CHR(0) + ;
           "OVERLAY()=A Great Library!"

  * Now to make that magical call to OverLay()  (Drum roll please...)
  *
  OverLay( LTRIM(TRIM(Program)), Memory, LTRIM(TRIM(Pathname)), EnvVar )
  *
  * Back in program!

  * Return to the original directory.
  IF .not. EMPTY(NewDirectory)
    O_CD(CurrentPath)
  ENDIF

  DO PressAKey

ENDDO

DO ClearScreen
@ 06, 20 SAY "ͻ"
@ 07, 20 SAY "                                    "
@ 08, 20 SAY "   For help contact:                "
@ 09, 20 SAY "                                    "
@ 10, 20 SAY "   SofDesign International, Inc.    "
@ 11, 20 SAY "   1303 Columbia Drive, Suite 209   "
@ 12, 20 SAY "   Richardson, Texas  75081         "
@ 13, 20 SAY "   (214) 644-8582                   "
@ 14, 20 SAY "                                    "
@ 15, 20 SAY "   CompuServe ID: 73130,2102        "
@ 16, 20 SAY "                                    "
@ 17, 20 SAY "ͼ"
@ 23, 00 SAY ""

RETURN


*********************
PROCEDURE ClearScreen
*********************
IF ISCOLOR()
  SET COLOR TO W/N
  CLEAR SCREEN
  SET COLOR TO W/B, B/W
ELSE
  SET COLOR TO W/N
  CLEAR SCREEN
  SET COLOR TO W/N, N/W
ENDIF
RETURN


*********************
PROCEDURE PressAKey
*********************
IF ISCOLOR()
  SET COLOR TO B/W
ELSE
  SET COLOR TO N/W
ENDIF
@ 24, 00
@ 24, 28 SAY "Press Any Key To Continue"
SET CURSOR OFF
INKEY(0)
SET CURSOR ON
RETURN


