*******************************************************************************
*
*  TEST.PRG
*
*  Program To Test The OverLay() Function
*
*  This test program and OverLay() .OBJ file(s)
*     Copyright (c) 1988-89
*     by GAMbit Software
*        Gregory A. Martin
*
*  None of this source code may be used in demos for other products.
*  (I know this statement sounds unusual, but I did have a competitor use
*   a previous demo I had created (he changed a few words) for a previous
*   product to demo his own competing product.)
*
*  Please feel free to upload this demo and associated documentation
*  to other BBSs or to give it to other Clipper developers.
*
*******************************************************************************

* Turn off Clipper's scoreboard display on line 0.
SET SCOREBOARD OFF

DO ClearScreen
@ 05, 03 SAY "ͻ"
@ 06, 03 SAY " OverLay() gives Clipper programmers the ability to run LARGE programs "
@ 07, 03 SAY " from their Clipper applications.  OverLay() saves memory used by your "
@ 08, 03 SAY " Clipper program to a disk file, frees that memory for reuse, and then "
@ 09, 03 SAY " RUNs whatever program you have requested or even shells to DOS.  With "
@ 10, 03 SAY " OverLay() you can free up all but about 10K of your memory for use by "
@ 11, 03 SAY " another program!                                                      "
@ 12, 03 SAY "                                                                       "
@ 13, 03 SAY " Run this test program to get a feel for how OverLay() works.          "
@ 14, 03 SAY "                                                                       "
@ 15, 03 SAY " To really appreciate what OverLay() can do for you, read through the  "
@ 16, 03 SAY " documentation and link OverLay() into your own applications.          "
@ 17, 03 SAY "ͼ"
DO PressAKey

Result     = 0
Program    = SPACE(30)     && The program can be up to 124 characters.
Memory     = 0             && 0 means to free up ALL possible memory.
Prompt     = SPACE(60)     && The prompt is limited to 60 characters.
Pathname   = SPACE(30)     && Defaults to the current drive:directory.
Filename   = SPACE(12)     && This parameter rarely needs to be used.
RestoreDir = .t.           && .t. will restore the drive/directory.
DO WHILE .t.
  DO ClearScreen
  @ 00, 05 SAY "ͻ"
  @ 01, 05 SAY "                       OverLay() Test Program                       "
  @ 02, 05 SAY "͹"
  @ 03, 05 SAY "         Return Value Of Last Test:                                 "
  @ 04, 05 SAY "Ķ"
  @ 05, 05 SAY "            Name Of Program To Run:                                 "
  @ 06, 05 SAY "           (Blank To Shell To DOS)                                  "
  @ 07, 05 SAY "Ķ"
  @ 08, 05 SAY "         Amount Of Memory Required:                                 "
  @ 09, 05 SAY "         (0 To Free All Available)                                  "
  @ 10, 05 SAY "Ķ"
  @ 11, 05 SAY "             New DOS Prompt String:                                 "
  @ 12, 05 SAY "        (Blank For Current String)  Use: Type EXIT to return$_$P$G  "
  @ 13, 05 SAY "Ķ"
  @ 14, 05 SAY "  Pathname To Store Temporary File:                                 "
  @ 15, 05 SAY "     (Blank For Current Directory)                                  "
  @ 16, 05 SAY "Ķ"
  @ 17, 05 SAY "        Filename To Save Memory To:                                 "
  @ 18, 05 SAY "        (Blank For Temporary File)                                  "
  @ 19, 05 SAY "Ķ"
  @ 20, 05 SAY "       Restore The Drive/Directory:                                 "
  @ 21, 05 SAY "͹"
  @ 22, 05 SAY "                        Press Escape To Exit                        "
  @ 23, 05 SAY "ͼ"
  @ 03, 42 SAY Result     PICTURE "@B"
  @ 05, 42 GET Program    PICTURE "@!" 
  @ 08, 42 GET Memory     PICTURE "999" 
  @ 11, 42 GET Prompt     PICTURE "@S30"
  @ 14, 42 GET Pathname   PICTURE "@!" 
  @ 17, 42 GET Filename   PICTURE "@!" 
  @ 20, 42 GET RestoreDir PICTURE "Y" 
  READ
  IF LASTKEY() = 27
    EXIT
  ENDIF

  *****************************************************************************
  *
  * The SaveInts() and RestInts() functions are used here ONLY for an example.
  * Interrupts 230 and 232 are not in any way special.  They are saved before
  * the call to OverLay() and restored after the call just to show you how to
  * use the functions.
  *
  Source = CHR(230) + CHR(232)  && Use CHR() to store numbers in a string.
  Dest   = SaveInts(Source)     && Current interrupt vectors are now saved.
  *
  *****************************************************************************

  DO ClearScreen

  * Now to make that magical call to OverLay()  (Drum roll please...)
  *
  Result = OverLay(LTRIM(TRIM(Program)), Memory, LTRIM(TRIM(Prompt)),;
                   LTRIM(TRIM(Pathname)), LTRIM(TRIM(Filename)), RestoreDir)
  *
  * Back in program!
  
  *****************************************************************************
  *
  * This function restores interrupts 230 and 232
  * Again, there is nothing special about these interrupts.  In fact, the vast
  * majority of Clipper applications won't need to use SaveInts and RestInts.
  * The rule is: If you don't understand what they do - DON'T use them.
  *
  RestInts(Dest)
  *
  ****************************************************************************

  DO PressAKey
ENDDO

DO ClearScreen
@ 07, 24 SAY "ͻ"
@ 08, 24 SAY "                               "
@ 09, 24 SAY "   To order contact:           "
@ 10, 24 SAY "                               "
@ 11, 24 SAY "   Market Service Associates   "
@ 12, 24 SAY "   PO Box 986                  "
@ 13, 24 SAY "   Coeur d'Alene, ID. 83814    "
@ 14, 24 SAY "   (208) 765-9439              "
@ 15, 24 SAY "                               "
@ 16, 24 SAY "ͼ"
@ 23, 00 SAY ""
RETURN


*********************
PROCEDURE ClearScreen
*********************
IF ISCOLOR()
  SET COLOR TO W/N
  CLEAR SCREEN
  SET COLOR TO W/B, B/W
ELSE
  SET COLOR TO W/N
  CLEAR SCREEN
  SET COLOR TO W/N, N/W
ENDIF
RETURN


*********************
PROCEDURE PressAKey
*********************
IF ISCOLOR()
  SET COLOR TO B/W
ELSE
  SET COLOR TO N/W
ENDIF
@ 24, 00
@ 24, 28 SAY "Press Any Key To Continue"
SET CURSOR OFF
INKEY(0)
SET CURSOR ON
RETURN

