*:*********************************************************************
*:
*:        Program: OUTJOIN.PRG
*:
*:        Author:  Kevin Bongiovanni
*:                 406 Apple Drive
*:                 Crestview, FL 32536
*:                 (904) 682-2961
*:*********************************************************************
* Program: Outer Join
* Purpose: To join two databases such that all records in the first
*          database will appear in the result even through there is no
*          record in the secnd database to match.
*
* Rights:  This module is released under the concept of beerware.
*          Please feel free to modify and use the program.  The only
*          compensation is to have a beer in my honor,
*
* Uses:    File1- First Database   (Section A)
*          File2- Second Database  (Section B)
*          File3- New Database
*          Key-   Predicate that links files 1 and 2.
*
* Example: do outjoin with "Employee","Timecard","Payroll","a->empno=b->empno"
*
PARAMETERS file1,file2,file3,KEY

CLOSE ALL
USE &file1
COPY STRU TO a011temp
USE &file2
COPY STRU TO a012temp
USE a012temp
SELECT 2
USE a011temp
JOIN WITH a012temp TO &file3 FOR &key

* Get the Data
CLOSE ALL
USE &file1
DECLARE acol[fcount()]
afile=AFIELDS(acol)
GOTO TOP
SELECT 2
USE &file2
DECLARE bcol[fcount()]
bfile=AFIELDS(bcol)
GOTO TOP
SELECT 3
USE &file3
SELECT 1
fnd=.F.
DO WHILE .NOT. EOF()
   SELECT 2
   DO WHILE .NOT. EOF()
      IF &key
         SELECT 3
         APPEND BLANK
         FOR R=1 TO afile
            t=acol[r]
            REPLACE c->&t WITH a->&t
         NEXT (r)
         FOR R=1 TO bfile
            t=bcol[r]
            REPLACE c->&t WITH b->&t
         NEXT (r)
         fnd=.T.
         SELECT 2
      ENDIF (&key)
      SKIP
   ENDDO
   * Finshed a pass through file2
   IF .NOT. fnd && No records matched
      SELECT 3
      APPEND BLANK
      FOR R=1 TO afile
         t=acol[r]
         REPLACE c->&t WITH a->&t
      NEXT (r)
      SELECT 2
   ENDIF (.not. fnd )
   fnd=.F.
   GOTO TOP
   SELECT 1
   SKIP
ENDDO
CLOSE ALL
ERASE a01*.dbf
RETURN
*: EOF: OUTJOIN.PRG
