;*******************
;*******************
;*
;*   Source File ... U_MouseA.ASM
;*
;*   Application ...
;*                   Copyright (c) 1989 Philip de Lisle Associates
;*                   All Rights Reserved
;*
;*   Author ........ Philip de Lisle
;*   Last Update ... 8 September 1989 at 12:18 AM
;*   Purpose ....... Low level mouse functions
;*
;*******************
;*******************


INCLUDE C:\CLIPPER5\INCLUDE\EXTENDA.INC

;CODESEG MOUSE
;DATASEG

CLpublic <M_FUNC0>
CLpublic <M_FUNC1>
CLpublic <M_FUNC2>
CLpublic <M_FUNC3B, M_FUNC3X, M_FUNC3Y>
CLpublic <M_FUNC4>
CLpublic <M_FUNC5B, M_FUNC5C, M_FUNC5X, M_FUNC5Y>
CLpublic <M_FUNC6B, M_FUNC6C, M_FUNC6X, M_FUNC6Y>
CLpublic <M_FUNC10>
CLpublic <M_FUNC11H, M_FUNC11V>

CLfunc int M_FUNC0
;  Reset Mouse
CLcode

    mov AX, 0
    int 33h
CLret AX                       ; M_FUNC0()


CLfunc void M_FUNC1
;  Show Mouse Cursor
CLcode

    mov AX, 1
    int 33h
CLret                          ; M_FUNC1()


CLfunc void M_FUNC2
;  Hide Mouse Cursor
CLcode

    mov AX, 2
    int 33h
CLret                          ; M_FUNC2()


CLfunc int M_FUNC3B
;  Get Which Button Pressed
CLcode

    mov AX, 3
    int 33h
CLret BX                       ; M_FUNC3B()


CLfunc int M_FUNC3X
;  Get X coordinate of Mouse
CLcode

    mov AX, 3
    int 33h
CLret CX                       ; M_FUNC3X()


CLfunc int M_FUNC3Y
;  Get Y coordinate of Mouse
CLcode

    mov AX, 3
    int 33h
CLret DX                       ; M_FUNC3Y()


CLfunc void M_FUNC4 <int M3, int M4>
;  Set Mouse Position
CLcode

    mov AX, 4
    mov BX, 0
    mov CX, M4
    mov DX, M3
    int 33h
CLret                          ; M_FUNC4()


CLfunc int M_FUNC5B <int M2>
;  Status of Button Pressed (0 = up, 1 = down)
CLcode

    mov AX, 5
    mov BX, M2
    int 33h
CLret AX                       ; M_FUNC5B()


CLfunc int M_FUNC5C <int M2>
;  No. of Presses of Button
CLcode

    mov AX, 5
    mov BX, M2
    int 33h
CLret BX                       ; M_FUNC5C()


CLfunc int M_FUNC5X <int M2>
;  Get X coordinate of Last Button Pressed
CLcode

    mov AX, 5
    mov BX, M2
    int 33h
CLret CX                       ; M_FUNC5X()


CLfunc int M_FUNC5Y <int M2>
;  Get Y coordinate of Last Button Pressed
CLcode

    mov AX, 5
    mov BX, M2
    int 33h
CLret DX                       ; M_FUNC5Y()


CLfunc int M_FUNC6B <int M2>
;  Status of Button Released (0 = up, 1 = down)
CLcode

    mov AX, 5
    mov BX, M2
    int 33h
CLret AX                       ; M_FUNC5C()


CLfunc int M_FUNC6C <int M2>
;  No. of Releases of Button
CLcode

    mov AX, 6
    mov BX, M2
    int 33h
CLret BX                       ; M_FUNC6C()


CLfunc int M_FUNC6X <int M2>
;  Get X coordinate of Last Button Released
CLcode

    mov AX, 6
    mov BX, M2
    int 33h
CLret CX                       ; M_FUNC6X()


CLfunc int M_FUNC6Y <int M2>
;  Get Y coordinate of Last Button Released
CLcode

    mov AX, 6
    mov BX, M2
    int 33h
CLret DX                       ; M_FUNC6Y()


CLfunc void M_FUNC10 <int M4>
;  Set Mouse Cursor Type
CLcode

    mov AX, 0Ah
    mov BX, 0
    mov CX, 0
    mov DX, M4
    int 33h
CLret                          ; M_FUNC10()


CLFUNC int M_FUNC11H
; Get Horizontal Direction of Mouse
CLcode
    mov AX, 0Bh
    int 33h
CLret CX                       ; M_FUNC11H()


CLFUNC int M_FUNC11V
; Get Vertical Direction of Mouse
CLcode
    mov AX, 0Bh
    int 33h
CLret DX                       ; M_FUNC11V()


END
