/****
*   File          : OPEN.CH
*
*   Authors       : Michael Abadjiev
*   Last Updated  : 06 May 1992
*
*   Language      : Clipper 5.01
*   Purpose       : Command Interface for Opening Databases
****/


// network database usage
#xcommand OPEN <(db)>                                               ;
                [ALIAS <a>]                                         ;
                [INDEX <indexes,...>                                ;
                    [KEY <keys,...>]                                ;
                    [UNIQUE <unique,...>]]                          ;
                [STRUCTURE <struct>]                                ;
                [<new: NEW>]                                        ;
                [<ex: EXCLUSIVE>]                                   ;
                [<sh: SHARED>]                                      ;
                [<ro: READONLY>]                                    ;
                [<quiet: QUIET>]                                    ;
                [RESULT <ok>]                                       ;
                                                                    ;
=> [<ok> := ]OpenDbf(<.new.>, <(db)>, <(a)>,                        ;
                    if(<.sh.> .or. <.ex.>, !<.ex.>, NIL),           ;
                    <.ro.>,                                         ;
                    {<(indexes)>}, {<(keys)>},                      ;
                    <struct>, <.quiet.>, {<(unique)>} )

#xcommand OPEN <(db)>                                               ;
                [ALIAS <a>]                                         ;
                [INDEXLIST <ntxlist>                                ;
                    [KEYLIST <keylist>]				             ;
                    [UNIQUELIST <uniquelist>]]                      ;
                [STRUCTURE <struct>]                                ;
                [<new: NEW>]                                        ;
                [<ex: EXCLUSIVE>]                                   ;
                [<sh: SHARED>]                                      ;
                [<ro: READONLY>]                                    ;
                [UNIQUELIST <uniquelist>]                           ;
                [<quiet: QUIET>]                                    ;
                [RESULT <ok>]                                       ;
                                                                    ;
=> [<ok> := ]OpenDbf(<.new.>, <(db)>, <(a)>,                        ;
                if(<.sh.> .or. <.ex.>, !<.ex.>, NIL),               ;
                <.ro.>, <ntxlist>, <keylist>,                       ;
                <struct>, <.quiet.>,  <uniquelist> )


**** open.ch
