 /*
   OPENLIST.PRG
   
   Author     : Phil Barnett 
   
   Credits    : Eric Givler added the handles.log and the name2hdl()
   
   Written    : 02/28/93
   
   Function   : Shows dbf and index usage.
   
   Purpose    : Typically only used in development and troubleshooting 
                of new apps. It will show you what files you have open, 
                and how many file handles are in use.
                
   Parameters : None
   
   Returns    : NIL
   
   Example    : #include "INKEY.CH"
                SET KEY K_ALT_F10 TO OPENLIST()
   
   Calls      : name2hdl() - ASM function.
   
   Warnings   : Does not include files opened with FOPEN() OR FCREATE()
   
   Modified   : E. Givler 3/15/93
   
   Released to Public Domain by author.
   
*/


#define  CRLF   chr( 13 ) + chr( 10 )

FUNCTION OPEN_LIST()

local x
local nIndxNum
local nHandles  := 0
local cTxt    := ''
local inarea := SELECT()
local inscr  := savescreen( 0, 0, 24, 79 )
local cidxname, nHand

    // Step through the work areas.
    FOR x := 1 TO 250

        IF ! empty( ALIAS( x ) )

            SELECT( x )
            cTxt += 'Area  : ' + STR( x, 3 ) + ;
                   IF( x==inarea, ' (Active) ', '' ) + CRLF
            cTxt += 'Alias : ' + ALIAS() + CRLF
            cTxt += 'Handle: ' + STR( name2hdl( PADR( alias(), 8) + 'DBF'), 3 ) + CRLF
            cTxt += replicate( CHR( 196 ), 25 ) + CRLF
            nHandles++
            nIndxNum := 1

            // List index keys for this area.
            DO WHILE ! EMPTY( OrdName( nIndxNum ) )
                cidxname := UPPER( PADR( OrdName( nIndxNum ),8) + RIGHT( OrdBagExt(), 3))
                cTxt += 'Index : ' + OrdName( nIndxNum ) + OrdBagExt() + CRLF
                cTxt += '  Key : ' + indexkey( nIndxNum ) + CRLF
                cTxt += 'Handle: ' + STR( name2hdl( cIdxname ), 3 ) + CRLF
                nIndxNum++
                nHandles++
            ENDDO
            cTxt += replicate( CHR( 205 ), 77 ) + CRLF
        ENDIF

    NEXT x
    
    cTxt += 'DBF/NTX Handles used = ' + STR( nHandles, 3 )

    dispbox( 0, 0, 24, 79 )
    memoedit( cTxt, 1, 1, 23, 78 )
    SELECT( inarea )
    restscreen( 0, 0, 24, 79, inscr )

    if ( nHand := fcreate( 'handles.log' ) ) != -1
         fwrite( nHand, cTxt )
         fclose( nHand )
    endif

RETURN NIL
