*
*
*
*  OpenDbf.Prg
*
*  Created by Drew Anderson and Ken Williams
*  For the Army Corps of Engineers.
*  Omaha District.
*  02/28/90
*
*
*  Purpose:  To open all databases and indexes.
*
*
*  Syntax:   D_OpenDbfs( [<CharExp>][,<LogExp>] )
*
*            Where <CharExp> is a database name containing all the names
*            of the databases to open with the corresponding indexes.
*            <LogExp>, if True will force creation of indexes.  If False,
*            indexes are only created if they do not exist.
*
*            All arguments are optional.  You must, however, pass a dummy
*            argument for any argument you wish to skip. (ie. '' )
*
*            Structure for the controlling database. (Default: DBFDATA)
*
*            Field Name  Type  Width  Description
*
*            DBFNAME      C      8    Name of Database to open.
*            DBFALIAS     C     10    Database Alias name.
*            EXCLUSIVE    L      1    Open database with exclusive On/Off.
*            NTXKEY       C     60    Index key.
*            NTXNAME      C      8    Index file name.
*            NTXDESC      C     25    Description of the index.
*            NTXORDER     N      1    Order indexes will be opened.
*
*
*  Usage:    IF D_OpenDbfs( 'MYDATA' )
*            *
*            *  Continue with program.
*            *
*            ELSE
*            *
*            *  Error: Can not find 'MYDATA.DBF'.
*            *         Databases NOT Opened.
*            *
*            ENDIF
*
*
*
*---------------------------------------------------------------------------*
                             FUNCTION D_OpenDbfs
*---------------------------------------------------------------------------*
PARAMETER D_Dbf, D_CreateIndex
PRIVATE D_Counter,     ; Counter. (n)
        D_DbfName,     ; Database Name. (c)
        D_DbfAlias,    ; Database Alias. (c)
        D_ReturnValue, ; Return value to calling program. (l)
        D_NtxName,     ; Index Name. (c)
        D_NtxKey,      ; Index Key. (c)
        D_StrVal,      ; Index Counter. (c)
        D_Ntx1,        ; Index file name. (c)
        D_Ntx2,        ; Index file name. (c)
        D_Ntx3,        ; Index file name. (c)
        D_Ntx4,        ; Index file name. (c)
        D_Ntx5,        ; Index file name. (c)
        D_Ntx6,        ; Index file name. (c)
        D_Ntx7,        ; Index file name. (c)
        D_Ntx8         ; Index file name. (c)

   D_ReturnValue = .F.
   BEGIN SEQUENCE
*****************************************************************************
*                                                                           *
*  Handles() is a Public Domain utility to modify the DOS enviroment        *
*  to handle as many open files as defined in Config.sys                    *
*  reguardless of which 3.x DOS Version is in use.                          *
*                                                                           *
*  Author:  Hugh Coomes                                                     *
*           Vericom Systems, Inc.                                           *
*           19 Old Mamaroneck Road                                          *
*           White Plains, NY 10605                                          *
*           Source ID: NAN891                                               *
*                                                                           *
*  Placed in the public domain by Vericom Systems, Inc. February 16, 1987   *
*                                                                           *
*  Requirements:  DOS 3.0, 3.1, or 3.2 and Clipper Summer 87.               *
*                                                                           *
*****************************************************************************
   Handles()
*
*  Set defaults.
*
   D_Dbf = IF(TYPE('D_Dbf') = 'C', IF( LEN(D_Dbf) > 0, D_Dbf, 'DBFDATA'), 'DBFDATA' )
   D_CreateIndex = IF(TYPE('D_CreateIndex') = 'L', D_CreateIndex, .F. )
*
*  Check for the dbfData database.
*
   IF !FILE( D_Dbf + '.DBF' )
      BREAK
   ENDIF
*
*  Open up the DBF and NTX database.
*
   SET EXCLUSIVE OFF
   SELECT 0
   USE &D_Dbf ALIAS &D_Dbf
   IF FILE( D_Dbf + '.NTX' )
      SET INDEX TO (D_Dbf)
   ELSE
      INDEX ON &D_Dbf->dbfName+str(&D_Dbf->ntxOrder,1) TO (D_Dbf)
   ENDIF
   DO WHILE !&D_Dbf->(EOF())
      D_DbfName = TRIM(&D_Dbf->dbfName)
      IF FILE( D_DbfName+'.DBF' )
*
*  If the alias is not defined the use the database name.
*
         D_DbfAlias = TRIM(&D_Dbf->dbfAlias)
         D_DbfAlias = IF( LEN(D_DbfAlias) > 0, D_DbfAlias, D_DbfName )

*
*  Open the database.
*
         IF &D_Dbf->Exclusive
            SET EXCLUSIVE ON
         ELSE
            SET EXCLUSIVE OFF
         ENDIF
         SELECT 0
         USE &D_DbfName ALIAS &D_DbfAlias
*
*  Open up the indexes, creating them if type do not exists.
*
         D_Counter = 0
         DO WHILE LEN(TRIM(&D_Dbf->ntxKey)) > 0 ;
          .AND. D_DbfName = TRIM(&D_Dbf->dbfName) ;
          .AND. D_Counter < 8
            D_NtxName = TRIM(&D_Dbf->ntxName)
            D_NtxKey  = TRIM(&D_Dbf->ntxKey)
            IF !FILE( D_NtxName+'.NTX' ) .OR. D_CreateIndex
               INDEX ON &D_NtxKey TO (D_NtxName)
            ENDIF
            D_Counter = D_Counter + 1
            D_StrVal = STR(D_Counter,1)
            D_Ntx&D_StrVal. = D_NtxName
            SKIP +1 ALIAS &D_Dbf
         ENDDO
         DO CASE
            CASE D_Counter = 1
                 SET INDEX TO &D_Ntx1
            CASE D_Counter = 2
                 SET INDEX TO &D_Ntx1, &D_Ntx2
            CASE D_Counter = 3
                 SET INDEX TO &D_Ntx1, &D_Ntx2, &D_Ntx3
            CASE D_Counter = 4
                 SET INDEX TO &D_Ntx1, &D_Ntx2, &D_Ntx3, &D_Ntx4
            CASE D_Counter = 5
                 SET INDEX TO &D_Ntx1, &D_Ntx2, &D_Ntx3, &D_Ntx4, &D_Ntx5
            CASE D_Counter = 6
                 SET INDEX TO &D_Ntx1, &D_Ntx2, &D_Ntx3, &D_Ntx4, &D_Ntx5, ;
                              &D_Ntx6
            CASE D_Counter = 7
                 SET INDEX TO &D_Ntx1, &D_Ntx2, &D_Ntx3, &D_Ntx4, &D_Ntx5, ;
                              &D_Ntx6, &D_Ntx7
            CASE D_Counter = 8
                 SET INDEX TO &D_Ntx1, &D_Ntx2, &D_Ntx3, &D_Ntx4, &D_Ntx5, ;
                              &D_Ntx6, &D_Ntx7, &D_Ntx8
         ENDCASE
      ENDIF
*
*  Goto the next database.
*
      IF D_DbfName = TRIM(&D_Dbf->dbfName)
         SKIP +1 ALIAS &D_Dbf
      ENDIF
   ENDDO
   D_ReturnValue = .T.
   END

RETURN(D_ReturnValue)

