/********
*
*          Header
*
*       File Name: EVNTMGR.CH
*          Author: Ashin S.Wimalajeewa   CompuServe : 100351,650
*
*    Date created: 12-08-94              Date updated: 12-08-94
*       Copyright: (c) 1994 by Virtual/Ash-Tec Development
*     Acknowledge: Transit Computer System Pty Ltd. (Australia)
*
*     Description: Event Manager System.
*
*
**/


#ifndef _EVNTMGR_CH
  #define _EVNTMGR_CH


#ifndef _CLASSY2_CH
  #include "Class(y).ch"
  #define _CLASSY2_CH
#endif



/****
*
*           Class
*
*            Name: TEvntMgr
*          Author: Ashin S.Wimalajeewa   CompuServe : 100351,650
*
*    Parent class: TObject
*        See Also: TObject for Screen IO
*
*     Description: This class is the Core of the Application Framework
*
**/

create class TEvntMgr FROM TObject
  hidden    :
    var     Col                   type integer   // Numeric
    var     Row                   type integer   // Numeric

    method  BoxCross                             // Logical
    method  Intersect                            // Logical
  protected :
    var     FormCount             type integer   // No of Forms on DeskTop
    var     FormStack             type array     // TForm Array
    var     HiddenCount           type integer   // TForm Array
    var     HiddenLst             type array     // TForm Array

    method  ArrangeForms                         // Integer
    method  Kill                                 // NIL
    method  ManageEvent                          // nPos
    method  ReDisplay                            // NIL
    method  SendMsg                              // NIL

  export    :

    method  Init                                 // Contructor

         // INTERNAL ( Needs to be exported but it won't be documented )
    method  DelHiddenForm                        // Self
    method  FrmCount                             // Numeric
    method  FrmStack                             // Numeric
    method  getHiddenForm                        // TForm Object

    var     Color                 type char      // Character
    var     Evnt                                 // TEvent Object
    var     oDC                                  // TDispCtxt Object
    var     oMD                                  // TMouse Object
    var     Quit                  type logical   // Logical

    method  ActiveForm                           // Numeric Active Form No.
    method  AddForm                              // TForm Object
    method  AppendForm                           // NIL
    method  DelForm                              // TForm Object
    method  Exec                                 // Self
    method  getForm                              // TForm Object
    method  InsForm                              // TForm Object
    method  Msg                                  // NIL
    method  Show                                 // NIL
    method  SrchForm                             // Numeric
end class

#endif
