/********
*
*          Header
*
*       File Name: CTRLOBJ.CH
*          Author: Ashin S.Wimalajeewa   CompuServe : 100351,650
*
*    Date created: 12-08-94              Date updated: 12-08-94
*       Copyright: (c) 1994 by Virtual/Ash-Tec Development
*     Acknowledge: Transit Computer System Pty Ltd. (Australia)
*
*     Description: Template Window Control class
*
*
**/




#ifndef _CTRLOBJ_CH
  #define _CTRLOBJ_CH


#ifndef _CLASSY2_CH
  #include "Class(y).ch"
  #define _CLASSY2_CH
#endif



/****
*
*           Class
*
*            Name: TCtrlObj
*          Author: Ashin S.Wimalajeewa   CompuServe : 100351,650
*
*    Parent class: TObject
*        See Also: TObject
*
*     Description: This class encompasses most of the properties inherent
*                  a Windows VB control.
*
**/

create class TCtrlObj from TObject
  hidden    :
    method  Add2FrmRLst                          // NIL

  protected :
    var     cCaption              type char      // Character
    var     lEnabled              type logical   // Logical
    var     lVisible              type logical   // Logical

    method  GetAltKey                            // Numeric
  export    :

    method  Init                                 // self

         // INTERNAL ( Needs to be exported but it won't be documented )
    var     RefreshLst            type array     // Array of Objects

    var     BackColor                            // ? ( refer Color )
    var     ForeColor                            // ? ( refer Color )
    var     Color                 type char      // Clipper Color
    var     HelpID                type integer   // Numeric
    var     HiPos                 type integer   // Numeric
    var     HotKey                type integer   // Numeric
    var     NameID                type integer   // Numeric Object's Primary ID
    var     Tag                                  // User Defined


    var     bClick                type block     // CodeBlock
    var     bDblClick             type block     // CodeBlock
    var     bDragDown             type block     // CodeBlock
    var     bKeyPress             type block     // CodeBlock

    method  Click                                // Self
    method  DblClick                             // Self
    method  DragDown                             // Self
    message GotFocus              is deferred    // Self
    method  KeyPress                             // Self
    message LostFocus             is deferred    // Self

    method  Caption                              // Character
    method  Enabled                              // Logical
    method  Move                                 // Self
    method  Show                                 // NIL
    message SetFocus              is deferred    // Logical
    method  Visible                              // Logical
end class

#endif
