/********
*
*         Program
*
*     Application: Generic Application
*       File Name: OBJECT.PRG
*          Author: Ashin S.Wimalajeewa   CompuServe : 100351,650
*
*    Date created: 12-08-94              Date updated: 12-08-94
*       Copyright: (c) 1994 by Virtual/Ash-Tec Development
*     Acknowledge: Transit Computer System Pty Ltd. (Australia)
*
*     Description: Definition of class methods
*
**/



#ifndef _CLASSY2_CH
  #include "Class(y).ch"
  #define _CLASSY2_CH
#endif

#ifndef _OBJECT_CH
  #include "Object.ch"
#endif


/**
*
*          Method
*
*            Name: Init()
*
*       Arguments: nTop    - Numeric Top    postion of Object
*                : nLeft   - Numeric Left   postion of Object
*                : nBottom - Numeric Bottom postion of Object
*                : nRight  - Numeric Right  postion of Object
*    Return Value: None
*
*     Description: Initial default object to full screen
**/

method Init( nTop, nLeft, nBottom, nRight )
  ::nTop       := iif( nTop    == NIL, 0, nTop                 )
  ::nLeft      := iif( nLeft   == NIL, 0, nLeft                )
  ::Width      := iif( nRight  == NIL,78, nRight  - ::nLeft + 1 )
  ::Height     := iif( nBottom == NIL,22, nBottom - ::nTop  + 1 )
return ( self )


/**
*
*          Method
*
*            Name: Top()
*
*       Arguments: nTop
*    Return Value: Numeric of the previous value
*        See Also: ::Bottom, ::Right(), ::Left()
*
*     Description: sets/gets the top position of an object.
**/

method Top( nTop )
  Local nPrevVal := ::nTop

  if ( nTop != NIL )
    ::nTop := nTop
  endif
return ( nPrevVal )


/**
*
*          Method
*
*            Name: myLeft()
*
*       Arguments: nLeft
*    Return Value: Numeric of the previous value
*        See Also: ::Top(), ::Right(), ::Bottom()
*
*     Description: sets/gets the left position of an object.
*
**/

method myLeft( nLeft )
  Local nPrevVal := ::nLeft

  if ( nLeft != NIL )
    ::nLeft := nLeft
  endif
return ( nPrevVal )


/**
*
*          Method
*
*            Name: Bottom()
*
*       Arguments: None
*    Return Value: Numeric Bottom pos of the Object
*        See Also: ::Top(), ::Left(), ::Right()
*
*     Description: return the bottom pos
*
**/

method Bottom()
return ( ::nTop + ::Height - 1 )


/**
*
*          Method
*
*            Name: myRight()
*
*       Arguments: Numeric Right pos of the Object
*    Return Value: ::Bottom(), ::Left(), ::Top()
*        See Also:
*
*     Description:
*
**/

method myRight()
return ( ::nLeft + ::Width - 1 )


/**
*
*          Method
*
*            Name: Hide
*
*    Return Value: self - Object of root/base type TObject
*        See Also: ::Show(), ::reFresh()
*
*     Description: Hide the current object off the screen
*
**/

method Hide
  Local lmCsrON := ::oMD:Set( .f. )
  ::oDC:RestScreen( ::Top(), ::Left(), ::Bottom(), ::Right(), ::Screen )
  ::oMD:Set( lmCsrON )
return ( self )


/**
*
*          Method
*
*            Name: reFresh()
*
*    Return Value: self - Object of root/base type TObject
*        See Also: ::Hide(), ::Show()
*
*     Description: Causes the object to be redrawn.
*
**/

method reFresh()
  ::Hide()
  ::Show()
return ( self )


/**
*
*          Method
*
*            Name: Show
*
*    Return Value: self - Object of root/base type TObject
*        See Also: ::Hide(), ::reFresh()
*
*     Description: Save the current screen before drawing the object
*
**/

method Show
  Local lmCsrON := ::oMD:Set( .f. )
  ::Screen := ::oDC:SaveScreen( ::Top(), ::Left(), ::Bottom(), ::Right() )
  ::oMD:Set( lmCsrON )
return ( self )
