/********
*
*         Program
*
*     Application: Generic Application
*       File Name: FORM.PRG
*          Author: Ashin S.Wimalajeewa   CompuServe : 100351,650
*
*    Date created: 08-11-94              Date updated: 08-11-94
*       Copyright: (c) 1994 by Virtual/Ash-Tec Development
*     Acknowledge: Transit Computer System Pty Ltd. (Australia)
*
*     Description: Definitions of Class Methods
*
**/


#ifndef _CLASSY2_CH
  #include "Class(y).ch"
  #define _CLASSY2_CH
#endif

#ifndef _BOX_CH
  #include "Box.ch"
#endif

#ifndef _INKEY_CH
  #define _INKEY_CH
  #include "Inkey.ch"
#endif

#ifndef _FORM_CH
  #include "Form.ch"
#endif


/**
*
*          Method
*
*            Name: Init()
*
*       Arguments: nNameID  - Unique Numeric Identifier
*                : nTop     - Forms Top Position
*                : nLeft    - Forms Left Position
*                : nBottom  - Forms Bottom Position
*                : nRight   - Forms Right Position
*                : cCaption - Forms Caption
*                : bLoad    - Forms Initial Loading Block
*                : bUnLoad  - Forms terminating UnLoading Block
*    Return Value: None
*        See Also: TCtrlObj:Init(), TObject:Init()
*
*     Description: Sets up default values for form
*
**/

method Init(nNameID, nTop, nLeft, nBottom, nRight, cCaption, bLoad, bUnLoad ), ( nTop, nLeft, nBottom, nRight )
  ::NameID        := iif( nNameID  == NIL, 0 , nNameID  )
  ::cCaption      := iif( cCaption == NIL, "", cCaption )
  ::bLoad         := iif( bLoad    == NIL, {|| .t. }, bLoad   )
  ::bUnLoad       := iif( bUnLoad  == NIL, {|| .t. }, bUnLoad )

  ::CtrlList      := {}
  ::CtrlCount     := 0
  ::Modal         := .f.
  ::BorderStyle   := B_SINGLE + " "
  ::ControlBox    := .f.
  ::ActiveControl := 1
  ::Load()
return ( self )


/**
*
*          Method  [EVENT]
*
*            Name: Click()
*
*       Arguments: oEvnt - Object of Root type TEvent
*    Return Value: ( self )
*        See Also: ::DblClick(), ::DragDown(), ::KeyPress()
*
*     Description: This method represents the forms behaviour when a form is
*                  given the message that a mouse click was pressed within
*                  this form.
**/

method Click( oEvnt )
  Local nCtrlCntr := 0
  Local oCtrlObj  := NIL

  if ( ::CtrlCount > 0 )
    oCtrlObj := ::CtrlList[ ::ActiveControl ]
    if ( oEvnt:nRow >= oCtrlObj:Top()  .and. oEvnt:nRow <= oCtrlObj:Bottom() .and. ;
         oEvnt:nCol >= oCtrlObj:Left() .and. oEvnt:nCol <= oCtrlObj:Right()        )
       if ( oCtrlObj:Visible .and. oCtrlObj:Enabled )
          oCtrlObj:Click( oEvnt )
       endif
    else
       for nCtrlCntr := 1 to ( ::CtrlCount )
           if ( nCtrlCntr == ::ActiveControl )
              Loop
           endif
           oCtrlObj := ::CtrlList[ nCtrlCntr ]
           if ( oEvnt:nRow >= oCtrlObj:Top()  .and. oEvnt:nRow <= oCtrlObj:Bottom() .and. ;
                oEvnt:nCol >= oCtrlObj:Left() .and. oEvnt:nCol <= oCtrlObj:Right()  .and. ;
                oCtrlObj:Visible              .and. oCtrlObj:Enabled                      )
              ::CtrlList[ ::ActiveControl ]:LostFocus()
              ::ActiveControl := nCtrlCntr
              oCtrlObj:SetFocus()
              oCtrlObj:GotFocus()
              oCtrlObj:Click( oEvnt )
              exit
           endif
       next
    endif
  endif
  ::TCtrlObj:Click( oEvnt )
return ( self )


/**
*
*          Method  [EVENT]
*
*            Name: DblClick()
*
*       Arguments: oEvnt - Object of Root type TEvent
*    Return Value: ( self )
*        See Also: ::Click(), ::KeyPress(), ::DragDown()
*
*     Description: This method represents the forms behaviour when a form is
*                  given the message that a mouse double click was pressed
*                  within this form.
**/

method DblClick( oEvnt )
  Local nCtrlCntr := 0
  Local oCtrlObj  := NIL

  if ( ::ControlBox .and. oEvnt:mRow == ::Top() .and. oEvnt:mCol >= ::Left() .and. oEvnt:mCol <= ::Left() + 3 )
     ::Kill()
     return ( self )
  endif

  if ( ::CtrlCount > 0 )
    oCtrlObj := ::CtrlList[ ::ActiveControl ]
    if ( oEvnt:nRow >= oCtrlObj:Top()  .and. oEvnt:nRow <= oCtrlObj:Bottom() .and. ;
         oEvnt:nCol >= oCtrlObj:Left() .and. oEvnt:nCol <= oCtrlObj:Right()        )
       if ( oCtrlObj:Visible .and. oCtrlObj:Enabled )
          oCtrlObj:DblClick( oEvnt )
       endif
    else
       for nCtrlCntr := 1 to ( ::CtrlCount )
           if ( nCtrlCntr == ::ActiveControl )
              Loop
           endif
           oCtrlObj := ::CtrlList[ nCtrlCntr ]
           if ( oEvnt:nRow >= oCtrlObj:Top()  .and. oEvnt:nRow <= oCtrlObj:Bottom() .and. ;
                oEvnt:nCol >= oCtrlObj:Left() .and. oEvnt:nCol <= oCtrlObj:Right()  .and. ;
                oCtrlObj:Visible              .and. oCtrlObj:Enabled                      )
              ::CtrlList[ ::ActiveControl ]:LostFocus()
              ::ActiveControl := nCtrlCntr
              oCtrlObj:SetFocus()
              oCtrlObj:GotFocus()
              oCtrlObj:DblClick( oEvnt )
              exit
           endif
       next
    endif
  endif
  ::TCtrlObj:DblClick( oEvnt )
return ( self )


/**
*
*          Method  [EVENT]
*
*            Name: DragDown()
*
*       Arguments: oEvnt - Object of Root type TEvent
*    Return Value: ( self )
*        See Also: ::Click(), ::DblClick(), ::KeyPress(), ::DragDown()
*
*     Description: This method represents the forms behaviour when a form is
*                  given the message that a mouse was dragged within this
*                  form.
**/

method DragDown( oEvnt )
  Local nCtrlCntr := 0
  Local oCtrlObj  := NIL

  if ( oEvnt:mRow == ::Top() .and. oEvnt:mCol >= ::Left() .and. oEvnt:mCol <= ::Right() )
     ::MouseMove( oEvnt )
     return ( self )
  endif

  if ( ::CtrlCount > 0 )
    oCtrlObj := ::CtrlList[ ::ActiveControl ]
    if ( oEvnt:nRow >= oCtrlObj:Top()  .and. oEvnt:nRow <= oCtrlObj:Bottom() .and. ;
         oEvnt:nCol >= oCtrlObj:Left() .and. oEvnt:nCol <= oCtrlObj:Right()        )
       if ( oCtrlObj:Visible .and. oCtrlObj:Enabled )
          oCtrlObj:DragDown( oEvnt )
       endif
    else
       for nCtrlCntr := 1 to ( ::CtrlCount )
           if ( nCtrlCntr == ::ActiveControl )
              Loop
           endif
           oCtrlObj := ::CtrlList[ nCtrlCntr ]
           if ( oEvnt:nRow >= oCtrlObj:Top()  .and. oEvnt:nRow <= oCtrlObj:Bottom() .and. ;
                oEvnt:nCol >= oCtrlObj:Left() .and. oEvnt:nCol <= oCtrlObj:Right()  .and. ;
                oCtrlObj:Visible              .and. oCtrlObj:Enabled                      )
              ::CtrlList[ ::ActiveControl ]:LostFocus()
              ::ActiveControl := nCtrlCntr
              oCtrlObj:SetFocus()
              oCtrlObj:GotFocus()
              oCtrlObj:DragDown( oEvnt )
              exit
           endif
       next
    endif
  endif
  ::TCtrlObj:DblClick( oEvnt )
return ( self )


/**
*
*          Method  [EVENT]
*
*            Name: GotFocus()
*
*    Return Value: ( self )
*        See Also: ::LostFocus(), ::SetFocus()
*
*     Description: This method is processed when a Form receives the message
*                  GotFocus Event.  SetFocus is usually processed before it.
**/

method GotFocus()
  Local nCntr   := 0
  Local nMaxLen := Len( ::reFreshLst )

  for nCntr := 1 to ( nMaxLen )
      ::reFreshLst[ nCntr ]:reFresh()
  next
  ::reFreshLst := {}
return ( self )


/**
*
*          Method  [EVENT]
*
*            Name: KeyPress()
*
*       Arguments: oEvnt - Object of Root type TEvent
*    Return Value: ( self )
*        See Also: ::Click(), ::DblClick(), ::DragDown(), ::KeyPress()
*
*     Description: This method represents the forms behaviour when a form is
*                  given the message that the keyboard was activated while
*                  this form was active.
**/

method KeyPress( oEvnt )
  Local nCntr    := 0
  Local nFound   := 0
  Local nKey     := oEvnt:Key
  Local oCtrlObj := NIL

  if ( ::CtrlCount > 0 )
     do case
        case ( nKey == K_ESC   .and. ::SetCancel != NIL )
             oCtrlObj := ::CtrlList[ ::SetCancel ]
             if ( oCtrlObj:Visible .and. oCtrlObj:Enabled )
                oCtrlObj:Click()
             endif

        case ( nKey == K_ENTER .and. ::SetDefault != NIL )
             oCtrlObj := ::CtrlList[ ::SetDefault ]
             if ( oCtrlObj:Visible .and. oCtrlObj:Enabled )
                oCtrlObj:Click()
             endif

        case ( nKey == K_TAB )
             for nCntr := ( ::ActiveControl + 1 ) to ( ::CtrlCount )
                 oCtrlObj := ::CtrlList[ nCntr ]
                 if ( oCtrlObj:Visible .and. oCtrlObj:Enabled )
                    nFound := nCntr
                    exit
                 endif
             next
             if ( nFound == 0 )
                for nCntr := 1 to ( ::ActiveControl - 1 )
                    oCtrlObj := ::CtrlList[ nCntr ]
                    if ( oCtrlObj:Visible .and. oCtrlObj:Enabled )
                       nFound := nCntr
                       exit
                    endif
                next
             endif

             if ( nFound > 0 )
                oCtrlObj := ::CtrlList[ ::ActiveControl ]
                oCtrlObj:LostFocus()
                ::ActiveControl := nFound
                ::CtrlList[ ::ActiveControl ]:SetFocus()
                ::CtrlList[ ::ActiveControl ]:GotFocus()
             endif

        case ( nKey == K_SH_TAB )
             for nCntr := ( ::ActiveControl - 1 ) to 1 step -1
                 oCtrlObj := ::CtrlList[ nCntr ]
                 if ( oCtrlObj:Visible .and. oCtrlObj:Enabled )
                    nFound := nCntr
                    exit
                 endif
             next
             if ( nFound == 0 )
                for nCntr := (::CtrlCount ) to ( ::ActiveControl + 1 ) step -1
                    oCtrlObj := ::CtrlList[ nCntr ]
                    if ( oCtrlObj:Visible .and. oCtrlObj:Enabled )
                       nFound := nCntr
                       exit
                    endif
                next
             endif

             if ( nFound > 0 )
                oCtrlObj := ::CtrlList[ ::ActiveControl ]
                oCtrlObj:LostFocus()
                ::ActiveControl := nFound
                ::CtrlList[ ::ActiveControl ]:SetFocus()
                ::CtrlList[ ::ActiveControl ]:GotFocus()
             endif

        otherwise
            if ( nKey >= K_ALT_Q .and. nKey <= K_ALT_M )
               nFound := ::ChkAltKeys( nKey )
               if ( nFound != ::ActiveControl )
                  if ( nFound > 0 )
                     oCtrlObj := ::CtrlList[ ::ActiveControl ]
                     oCtrlObj:LostFocus()
                     ::ActiveControl := nFound
                     ::CtrlList[ ::ActiveControl ]:SetFocus()
                     ::CtrlList[ ::ActiveControl ]:GotFocus()
                  endif
               endif
               ::CtrlList[ ::ActiveControl ]:KeyPress( oEvnt )
            endif
            if ( nFound == 0 )
               oCtrlObj := ::CtrlList[ ::ActiveControl ]
               if ( oCtrlObj:Enabled )
                  oCtrlObj:KeyPress( oEvnt )
               endif
            endif
     endcase
  endif
  ::TCtrlObj:KeyPress( oEvnt )
return ( self )


/**
*
*          Method  [EVENT]
*
*            Name: Load()
*
*    Return Value: ( self )
*        See Also: Instance Variable : ::bLoad, ::UnLoad(), ::bUnLoad
*
*     Description: This method has been implemented in more of a procedural
*                  manner as opposed to OOPs.  The OOPs approach is to have
*                  a new class which inherits from TForm but then redefines
*                  the Load method.  The OOPs approach is always available
*                  to the programmer who(of cource knows how to use Class(y))
*                  The other group of programmers are more strictly object
*                  assemblers (VB people).  They can manage with what they
*                  have got.  CA-Clipper's Code Block system is a dream come
*                  true for them.
**/

method Load()
  ::bLoad:Eval( ::Parent, self )
return ( self )


/**
*
*          Method  [EVENT]
*
*            Name: LostFocus()
*
*    Return Value: ( self )
*        See Also: ::GotFocus(), ::SetFocus()
*
*     Description: This method is processed when a Form receives the message
*                  LostFocus Event.  This method is triggered if either the
*                  form is killed or another form is made the active form.
**/

method LostFocus()
  Local cUnsClr := StrExtract(::Color, ",", 5)
  Local lmCsrON := ::oMD:Set( .f. )

  ::oDC:Print( ::Top(), ::Left()+ iif( ::ControlBox, 3, 0), PadC(::cCaption, ::Width - iif( ::ControlBox, 3, 0)), cUnsClr )
  if ( ::ControlBox )
     ::oDC:Print( ::Top(), ::Left()+ 3, "", cUnsClr )
  endif
  ::oMD:Set( lmCsrON )
return ( self )


/**
*
*          Method  [EVENT]
*
*            Name: SetFocus()
*
*    Return Value: ( self )
*        See Also: ::GotFocus(), ::LostFocus()
*
*     Description: This is the first message that is sent to a Form when the
*                  user has intended the new form get focus.
**/

method SetFocus()
  Local cEnhClr := StrExtract(::Color, ",", 2)
  Local lmCsrON := ::oMD:Set( .f. )

  ::oDC:Print( ::Top(), ::Left()+ iif( ::ControlBox, 3, 0), PadC(::cCaption, ::Width - iif( ::ControlBox, 3, 0)), cEnhClr )
  ::oMD:Set( lmCsrON )
return ( self )


/**
*
*          Method  [EVENT]
*
*            Name: UnLoad()
*
*    Return Value: ( self )
*        See Also: Instance Variable : ::bUnLoad, ::Load(), ::bLoad
*
*     Description: This method has been implemented in more of a procedural
*                  manner as opposed to OOPs.  The OOPs approach is to have
*                  a new class which inherits from TForm but then redefines
*                  the unLoad method.  The OOPs approach is always available
*                  to the programmer who(of cource knows how to use Class(y))
*                  The other group of programmers are more strictly object
*                  assemblers (VB people).  They can manage with what they
*                  have got.  CA-Clipper's Code Block system is a dream come
*                  true for them.
**/

method UnLoad()
  ::bUnLoad:Eval( ::Parent, self )
return ( self )



/**
*
*          Method
*
*            Name: AddControl()
*
*       Arguments: oCtrlObj - Object of root type TCtrlOjb
*    Return Value: oCtrlObj - Object of root type TCtrlOjb
*        See Also: ::DelControl()
*
*     Description: Add a control to a Form.
*
**/

method AddControl( oCtrlObj )
  oCtrlObj:Parent := self
  oCtrlObj:oDC    := ::oDC
  oCtrlObj:oMD    := ::oMD
  aAdd( ::CtrlList, oCtrlObj )
  ::CtrlCount++
return ( oCtrlObj )


/**
*
*          Method
*
*            Name: ChkHotKeys()
*
*       Arguments: nKey   - Key pressed ( inkey value )
*    Return Value: nFound - Position in ControlLst
*
*     Description: Determines whether a Valid hot key was pressed to move to
*                  another control in a form.
**/

method ChkHotKeys( nKey )
  Local nCntr    := 0
  Local nFound   := 0
  Local oCtrlObj := NIL

  for nCntr := ( ::ActiveControl ) to ( ::CtrlCount )
      oCtrlObj := ::CtrlList[ nCntr ]
      if ( oCtrlObj:Visible .and. oCtrlObj:Enabled .and. oCtrlObj:HotKey == nKey )
         nFound := nCntr
         exit
      endif
  next
  if ( nFound == 0 )
     for nCntr := 1 to ( ::ActiveControl - 1 )
         oCtrlObj := ::CtrlList[ nCntr ]
         if ( oCtrlObj:Visible .and. oCtrlObj:Enabled .and. oCtrlObj:HotKey == nKey )
            nFound := nCntr
            exit
         endif
     next
  endif
return ( nFound )


/**
*
*          Method
*
*            Name: DelControl()
*
*       Arguments: nCtrlIndex - Numeric position within the Control List
*    Return Value: oCtrlObj   - Object of root type TCtrlOjb
*        See Also: ::AddControl
*
*     Description: Deletes a control from a form.
**/

method DelControl( nCtrlIndex )
  Local oCtrlObj := ::CtrlList[ nCtrlIndex ]

  aDel ( ::CtrlList, nCtrlIndex )
  aSize( ::CtrlList, --::CtrlCount )
return ( oCtrlObj )


/**
*
*          Method
*
*            Name: Enabled()
*
*       Arguments: lState  - The state to change to.
*    Return Value: lStatus - The previous state of the Control
*        See Also: ::Visible()
*
*     Description: This method enables the user to switch between whether the
*                  the Controls active status.
**/

method Enabled( lState )
  Local lStatus := ::lEnabled

  if ( lState != NIL )
     if (::lEnabled != lState )
        ::lEnabled := lState
     endif
  endif
return ( lStatus )


/**
*
*          Method
*
*            Name: fShow()
*
*    Return Value: ( self )
*        See Also: ::Show()
*
*     Description: This is an INTERNAL method which is exported.  It is not
*                  intented for the users use.  I could have embedded the
*                  this code into ::Show() however I prefered to keep it
*                  independent.
**/

method fShow()
  Local lmCsrON := ::oMD:Set( .f. )

  if ( ::Visible )
     ::TCtrlObj:Show()
     ::DispForm()
     ::DispCtrls()
  endif

  ::oMD:Set( lmCsrON )
return ( self )


/**
*
*          Method
*
*            Name: getControl()
*
*       Arguments: nCtrlIndex - Numeric position within the Control List
*    Return Value: oCtrlObj   - Object of root type TCtrlOjb
*        See Also: ::AddControl(), ::DelControl()
*
*     Description: Returns the requested control given an Index
**/

method getControl( nCtrlIndex )
return ( ::CtrlList[ nCtrlIndex ] )


/**
*
*          Method
*
*            Name: Hide()
*
*    Return Value: ( self )
*        See Also: ::Show()
*
*     Description: Hide a control on the form.
**/

method Hide()
  if ( ::Visible )
     ::Parent:AddForm( self )                    // Adds to a Hidden List
     ::Parent:DelForm( NIL, NIL, self )          // Deletes it from an Active List
     ::Visible( .f. )
  endif
return ( self )


/**
*
*          Method
*
*            Name: InsControl()
*
*       Arguments: nPos
*                : oCtrlObj - Object of root type TCtrlOjb
*    Return Value: oCtrlObj - Object of root type TCtrlOjb
*        See Also: ::AddControl(), ::DelControl()
*
*     Description: Inserts a Control into the Control List at the given Pos.
**/

method InsControl( nPos, oCtrlObj )
  Local nLen     := ::CtrlList

  oCtrlObj:Parent := self
  aSize( ::CtrlList, ++::CtrlCount )
  aIns ( ::CtrlList, nPos )
  ::CtrlList[ nPos ] := oCtrlObj
return ( oCtrlObj )


/**
*
*          Method
*
*            Name: Kill()
*
*    Return Value: ( self )
*        See Also: ::DelForm()
*
*     Description: Kill the current Form,  This removes it from the FormStack
*                  and decrements the FormCount.
**/

method Kill()
  if ( ::Visible )
     ::Parent:DelForm( NIL, NIL, self )
     ::Visible( .f. )
  endif
return ( self )


/**
*
*          Method
*
*            Name: Move()
*
*       Arguments: nTop  - New Top  position of the Form
*                : nLeft - New Left position of the Form
*    Return Value: NIL
*        See Also: ::MouseMove()
*
*     Description: This method move the form the newly specified Top, Left
*                  position.
**/

method Move( nTop, nLeft )
  Local nCtrlCntr := 0
  Local nVDiff    := nTop  - ::Top
  Local nHDiff    := nLeft - ::Left
  Local oCtrl     := NIL

  ::TCtrlObj:Move( nTop, nLeft )
  for nCtrlCntr := 1 to ( ::CtrlCount )      // Update Control Pos's
      oCtrl      := ::CtrlList[ nCtrlCntr ]
      oCtrl:Top  += nVDiff
      oCtrl:Left += nHDiff
  next
return NIL


/**
*
*          Method
*
*            Name: PrintForm()
*
*    Return Value: ( self )
*
*     Description: It does nothing at the moment.  It should print the
*                  content of the current form to the printer.
**/

method PrintForm()
return ( self )


/**
*
*          Method
*
*            Name: Show()
*
*    Return Value: ( self )
*        See Also: ::fShow()
*
*     Description: This method shows the form on the screen even if currently
*                  inVisible.
**/

method Show()
  Local lmCsrON := ::oMD:Set( .f. )
  Local nActPos := ::Parent:SrchForm( ::NameID )

  if ( nActPos > 0 )                             // User wants to move a form
     ::Parent:ActiveForm( ::NameID )             // to the top of the Form Stack

  else                                           // Take it out of Hidden List
     if ( ::Parent:FrmCount > 0 )
        ::Parent:FrmStack[ ::Parent:FrmCount ]:LostFocus()
     endif

     ::Visible( .t. )
     ::fShow()                                   // Interal Show

     ::Parent:AppendForm( self )
     ::Parent:FrmStack[ ::Parent:FrmCount ]:SetFocus()
     ::Parent:FrmStack[ ::Parent:FrmCount ]:GotFocus()
  endif
  ::oMD:Set( lmCsrON )
return ( self )


/**
*
*          Method
*
*            Name: SrchControl()
*
*       Arguments: nNameID - Numeric ID of thr Control
*    Return Value: nPos    - The index position within the Control List
*        See Also: ::GetControl
*
*     Description: Search through the Control List for the NameID
*
**/

method SrchControl( nNameID )
  Local nCtrlCntr := 0
  Local nPos      := 0

  for nCtrlCntr := 1 to ( ::CtrlCount )
      if ( ::CtrlList[ nCtrlCntr ]:NameID == nNameID )
         nPos := nCtrlCntr
      endif
  next
return ( nPos )


/**
*
*          Method
*
*            Name: Visible()
*
*       Arguments: lState - Set/get the Visible state
*    Return Value: None
*        See Also: ::Enabled
*
*     Description: Sets or return the state of the forms Visible Status.
*
**/

method Visible( lState )
  Local lStatus := ::lVisible

  if ( lState != NIL )
     if (::lVisible != lState )
        ::lVisible := lState
     endif
  endif
return ( lStatus )


/***************************************************************************
*
*   PROTECTED METHODS
*
*/



/**
*
*          Method
*
*            Name: DispCtrls()
*
*    Return Value: NIL
*        See Also: ::DispForm()
*
*     Description: Displays all the visible controls in the control list
*                  to the form.
**/

method DispCtrls()
  Local nCtrlCntr := 0

  for nCtrlCntr := 1 to ( ::CtrlCount )
      ::CtrlList[ nCtrlCntr ]:Show()
  next
return NIL


/**
*
*          Method
*
*            Name: DispForm()
*
*    Return Value: NIL
*        See Also: ::DispCtrls()
*
*     Description: Displays the form box and caption to the screen.
**/

method DispForm()
  Local cStdClr := StrExtract(::Color, ",", 1)
  Local cUnsClr := StrExtract(::Color, ",", 5)
  Local lShadow := ::oDC:SetShadow( .F. )

  ::oDC:Box( ::Top(), ::Left(), ::Bottom(), ::Right(), ::BorderStyle, cStdClr )
  ::oDC:SetShadow( lShadow )
  ::oDC:Print( ::Top(), ::Left()+ iif( ::ControlBox, 3, 0), PadC(::cCaption, ::Width - iif( ::ControlBox, 3, 0)), cUnsClr )
  if ( ::ControlBox )
     // ::oDC:Print( ::Top(), ::Left(), "  ", "n/w" )
     ::oDC:Print( ::Top(), ::Left(), "  ", cUnsClr )
     ::oDC:Print( ::Top(), ::Left()+ 3, "", cUnsClr )
  endif
return NIL


/**
*
*          Method
*
*            Name: MouseMove()
*
*       Arguments: oEvnt - Object of Root type TEvent
*    Return Value: ( self )
*        See Also: ::Move()
*
*     Description: Enables the user to move the Window around the sreeen.
**/

method MouseMove( oEvnt )
  Local nTop     := ::Top()
  Local nLeft    := ::Left()

  Local mCol     := NIL
  Local mRow     := NIL
  Local nOldCol  := oEvnt:mCol
  Local nOldRow  := oEvnt:mRow

  Local cMveClr  := StrExtract(::Parent:Color, ",", 5)
  Local cScr     := NIL
  Local lShadow  := ::oDC:SetShadow()
  Local nButton  := oEvnt:Button
  Local mrTop    := 0
  Local mrLeft   := oEvnt:mCol - nLeft
  Local mrBottom := ::Parent:Bottom() - (nTop  + ::Height - 1) + oEvnt:mRow - 1
  Local mrRight  := ::Parent:Right()  - (nLeft + ::Width  - 1) + oEvnt:mCol
  Local lmCsrON  := ::oMD:Set( .f. )

  ::oMD:MaxCol( mrLeft, mrRight  )
  ::oMD:MaxRow( mrTop , mrBottom )

  cScr := ::oDC:SaveScreen( nTop, nLeft, nTop + ::Height - 1, nLeft + ::Width - 1 )
  ::oDC:Box( nTop, nLeft, nTop + ::Height - 1, nLeft + ::Width - 1, B_SINGLE, cMveClr )
  While ( ::oMD:isButton(nButton) )
        mCol := ::oMD:Col(); mRow  := ::oMD:Row()
        if ( mCol != nOldCol .or. mRow != nOldRow )
           nOldCol := mCol; nOldRow := mRow
           ::oDC:RestScreen( nTop, nLeft, nTop + ::Height - 1, nLeft + ::Width - 1, cScr )
           nTop := mRow   ; nLeft := mCol - mrLeft
           cScr := ::oDC:SaveScreen( nTop, nLeft, nTop + ::Height - 1, nLeft + ::Width - 1 )
           ::oDC:Box( nTop, nLeft, nTop + ::Height - 1, nLeft + ::Width - 1, B_SINGLE, cMveClr )
        endif
  enddo

  ::oMD:MaxCol( 0, ::Parent:Right() )
  ::oMD:MaxRow( 0, ::Parent:Bottom() )

  ::oDC:RestScreen( nTop, nLeft, nTop + ::Height - 1, nLeft + ::Width - 1, cScr )
  ::oDC:SetShadow( lShadow )
  ::Move( nTop, nLeft )
  ::oMD:Set( lmCsrON )
return ( self )


/**
*
*          Method
*
*            Name: KeyBrdMove()
*
*    Return Value: ( self )
*        See Also: ::MouseMove()
*
*     Description: Not Implemented.  Same as ::MouseMove() for KeyBoard
**/

method KeyBrdMove()
return ( self )
