/********
*
*         Program
*
*     Application: Sample Application
*       File Name: FKYVIDEO.PRG
*          Author: Ashin S.Wimalajeewa   CompuServe : 100351,650
*
*    Date created: 12-08-94              Date updated: 12-08-94
*       Make File: \AFlib\Source\Make\Test.RMK
*       Exec File: \AFlib\Source\Sample\Test.EXE
*       Copyright: (c) 1994 by Virtual/Ash-Tec Development
*     Acknowledge: Transit Computer System Pty Ltd. (Australia)
*
*     Description: Funcky's Video system.
*
**/


#ifndef _CLASSY2_CH
  #include "Class(y).ch"
  #define _CLASSY2_CH
#endif

#ifndef _FKYVIDEO_CH
  #include "FkyVIDEO.ch"
#endif



/**
*
*          Method
*
*            Name: myBox()
*
*       Arguments: nTop    - Top    (Numeric) position of the Box
*                : nLeft   - Left   (Numeric) position of the Box
*                : nBottom - Bottom (Numeric) position of the Box
*                : nRight  - Right  (Numeric) position of the Box
*                : cFrame  - Character string to draw frame
*                : cColor  - Clipper color string to Display the Box. eg "w+/r"
*    Return Value: NIL
*        See Also: FUNCky's Box()
*
*     Description: Draw a box on the screen
*
**/

method myBox( nTop, nLeft, nBottom, nRight, cFrame, cColor )
  Local nColor := aToAttr( cColor )
return ( Box(nTop, nLeft, nBottom, nRight, cFrame, nColor) )


/**
*
*          Method
*
*            Name: myPrint()
*
*       Arguments: nRow   - Row (Numeric) position of the Displayed output.
*                : nCol   - Col (Numeric) position of the Displayed output.
*                : cStr   - Character string to display
*                : cColor - Clipper Color String. eg "w+/r"
*    Return Value: NIL
*        See Also: FUNCky's print()
*
*     Description: Displays output to the screen in the desired pos and color
**/

method myPrint( nRow, nCol, cStr, cColor )
  Local nColor := aToAttr( cColor )
return ( print(nRow, nCol, cStr, nColor) )


/**
*
*          Method
*
*            Name: mySetAttr()
*          Author: Bill (William) Tinker of Transit Computer Systems.
*
*       Arguments: nTop    - Top    (Numeric) Position to repaint
*                : nLeft   - Left   (Numeric) Position to repaint
*                : nBottom - Bottom (Numeric) Position to repaint
*                : nRight  - Right  (Numeric) Position to repaint
*                : cColor  - Character string to replace it with
*    Return Value: NIL
*
*     Description: Resets the current video color for a selected pos.
**/

method mySetAttr( nTop, nLeft, nBottom, nRight, cColor )
  Local nColor  := aToAttr( cColor )
return ( SetAttr(nTop, nLeft, nBottom, nRight, nColor) )


/**
*
*          Method
*
*            Name: mySetShadow()
*
*       Arguments: lState
*    Return Value: ( .t. )
*
*     Description: Set/gets the Box Shadow State.
**/

method mySetShadow( lState )
return ( SetShadow(lState) )
