/********
*
*         Program
*
*     Application:
*       File Name: FKYMOUSE.PRG
*          Author: Ashin S.Wimalajeewa   CompuServe : 100351,650
*
*    Date created: 08-11-94              Date updated: 08-11-94
*       Make File: \AFlib\Source\Make\Test.RMK
*       Exec File: \AFlib\Source\Sample\Test.EXE
*       Copyright: (c) 1994 by Virtual/Ash-Tec Development
*     Acknowledge: Transit Computer System Pty Ltd. (Australia)
*
*     Description: Definition of All Class Methods
*
**/


#ifndef _CLASSY2_CH
  #include "Class(y).ch"
  #define _CLASSY2_CH
#endif

#ifndef _FKYMOUSE_CH
  #include "FkyMouse.ch"
#endif



/**
*
*          Method
*
*            Name: Init()
*          Author: Ashin S.Wimalajeewa
*
*       Arguments: None
*    Return Value: None
*        See Also: TMouseDevice : Init()
*
*     Description: Resets FUNCky's Mouse
*
**/

method Init()
  ::reset()
  ::lCursorState := .f.
return ( self )


/**
*
*          Method
*
*            Name: myButton()
*          Author: Ashin S.Wimalajeewa
*
*       Arguments: None
*    Return Value: Button()
*        See Also: ::isButton()
*
*     Description: Returns a NUMERIC :
*
*                  Return Value    - Meaning
*
*                  0               - No button, or no mouse present
*                  1               - Left button is pressed
*                  2               - Right button is pressed
*                  4               - Middle button is pressed
**/

method myButton()
return ( Button() )


/**
*
*          Method
*
*            Name: myCol()
*          Author: Ashin S.Wimalajeewa
*
*       Arguments: None
*    Return Value: m_Col()
*        See Also: ::Row()
*
*     Description: Returns a NUMERIC ( Mouse Column Position )
*
**/

method myCol()
return ( m_Col() )


/**
*
*          Method
*
*            Name: isButton()
*          Author: Ashin S.Wimalajeewa
*
*       Arguments: nButton
*    Return Value: _isButton(nButton)
*        See Also: ::Button()
*
*     Description: Returns a LOGICAL (.T. if the specified Mouse Btn Pressed)
*
**/

method isButton( nButton )
return ( _isButton(nButton) )


/**
*
*          Method
*
*            Name: myMaxCol()
*          Author: Ashin S.Wimalajeewa
*
*       Arguments: nc1 - Min Col boundary
*                : nc2 - Max Col boundary
*    Return Value: m_maxCol(nc1, nc2)
*        See Also: ::MaxRow()
*
*     Description: Refer FUNCky2c Norton Guide
*
**/

method myMaxCol( nc1, nc2 )
return ( m_maxCol(nc1, nc2) )


/**
*
*          Method
*
*            Name: myMaxRow()
*          Author: Ashin S.Wimalajeewa
*
*       Arguments: nr1 - Min Row boundary
*                : nr2 - Max Row boundary
*    Return Value: m_maxRow(nr1, nr2)
*        See Also: ::MaxCol()
*
*     Description: Refer FUNCky2c Norton Guide
*
**/

method myMaxRow( nr1, nr2 )
return ( m_maxRow(nr1, nr2) )


/**
*
*          Method
*
*            Name: Reset()
*          Author: Ashin S.Wimalajeewa
*
*       Arguments: None
*    Return Value: m_reset()
*        See Also: ::Set()
*
*     Description: Refer FUNCky2c Norton Guide
*
**/

method Reset()
return ( m_reset() )


/**
*
*          Method
*
*            Name: myRow()
*          Author: Ashin S.Wimalajeewa
*
*       Arguments: None
*    Return Value: m_Row()
*        See Also: ::Col()
*
*     Description: Returns a NUMERIC ( Mouse Row Position )
*
**/

method myRow()
return ( m_Row() )


/**
*
*          Method
*
*            Name: mySet()
*          Author: Ashin S.Wimalajeewa
*
*       Arguments: lStatus    - ON|OFF
*    Return Value: lCurrState - The previous state before setting
*        See Also: m_CsrON(), m_CsrOFF(), m_isCursor()
*
*     Description: Enables the user to set the mouse state
*
**/

method mySet( lStatus )
  local  lCurrState   := ::lCursorState
  local  lFUNCkyState := NIL

  if ( lStatus != NIL )
     lFUNCkyState := ::isCursor()
     if ( lStatus != lFUNCkyState )
        if ( lStatus )
           m_CsrON()
        else
           m_CsrOFF()
        endif
     endif
     ::lCursorState := lStatus
  endif
return ( lCurrState )


/***************************************************************************
*
*   PROTECTED METHODS
*
**/


/**
*
*          Method
*
*            Name: isCursor()
*          Author: Ashin S.Wimalajeewa
*
*       Arguments: None
*    Return Value: m_isCursor()
*
*     Description: Refer FUNCky2c Norton Guide
*
**/

method isCursor()
return ( m_isCursor() )
