/********
*
*          Header
*
*       File Name: FKYMOUSE.CH
*          Author: Ashin S.Wimalajeewa   CompuServe : 100351,650
*
*    Date created: 08-11-94              Date updated: 08-11-94
*       Copyright: (c) 1994 by Virtual/Ash-Tec Development
*     Acknowledge: Transit Computer System Pty Ltd. (Australia)
*
*     Description: FUNCky2<c|x> Mouse System.  These are the basic
*                  methods that are required by the framework.
**/


#ifndef _FKYMOUSE_CH
  #define _FKYMOUSE_CH


#ifndef _CLASSY2_CH
  #include "Class(y).ch"
  #define _CLASSY2_CH
#endif


/****
*
*           Class
*
*            Name: FUNCkyMouse
*          Author: Ashin S.Wimalajeewa
*
*    Parent class: TMouseDevice
*        See Also: Refer to FUNCky2c Norton Guides MOUSE Section
*
*     Description: This class was developed to enable a consistent interface
*                  to call mouse able routines.  Instead of having to direct-
*                  ly calls a particular libraries mouse system; we should be
*                  able to switch parts to another mouse system if need be.
*                  Thus by having this defined as a class then the same
*                  messages are being sent through the system but a different
*                  mouse system may be called.
*
**/

create class FUNCkyMouse from TMouseDevice
  hidden    :
    var     lCursorState          type logical   // Logical

  protected :
    method  isCursor                             // Logical

  export    :

    method  Init                                 // Self

    message Button   method myButton             // Integer
    message Col      method myCol                // Integer
    method  isButton                             // Logical
    message MaxCol   method myMaxCol             // Logical
    message MaxRow   method myMaxRow             // Logical
    method  Reset                                // Logical
    message Row      method myRow                // Integer
    message Set      method mySet                // Logical
end class


#endif
