/********
*
*         Program
*
*     Application: Generic Application
*       File Name: EVENT.PRG
*          Author: Ashin S.Wimalajeewa   CompuServe : 100351,650
*
*    Date created: 12-08-94              Date updated: 12-08-94
*       Make File: \AFlib\Source\Make\Test.RMK
*       Exec File: \AFlib\Source\Sample\Test.EXE
*       Copyright: (c) 1994 by Virtual/Ash-Tec Development
*     Acknowledge: Transit Computer System Pty Ltd. (Australia)
*
*     Description: Definition of class methods
*
**/


#ifndef _INKEY_CH
  #include "Inkey.ch"
  #define _INKEY_CH
#endif

#ifndef _CLASSY2_CH
  #include "Class(y).ch"
  #define _CLASSY2_CH
#endif

#ifndef _EVENT_CH
  #include "Event.ch"
#endif



/**
*
*          Method
*
*            Name: Init()
*
*       Arguments: nWait    - Numeric time delay to wait for a double click
*                : DblWait  - Numeric time delay after the DblClick event detected
*                : oMD      - Object of root type TMouseDevice
*    Return Value: None
*
*     Description: Initialises the delays to default if not specified
*
**/

method Init( nWait, DblWait, oMD )
  ::ClickWait := iif( nWait == NIL, nDEFAULT_WAIT_  , nWait    )
  ::DblWait   := iif( nWait == NIL, nDBLCLICK_DELAY_, DblWait  )
  ::oMD       := oMD
return ( self )


/**
*
*          Method
*
*            Name: Click()
*
*    Return Value: Logical
*        See Also: ::DblClick(), ::DragDown(), ::KeyPress()
*
*     Description: TRUE if a single click was detected.
*
**/

method Click()
return ( ::Clicks == 1 )


/**
*
*          Method
*
*            Name: DblClick()
*
*    Return Value: Logical
*        See Also: ::Click(), ::DragDown(), ::KeyPress()
*
*     Description: TRUE if a DblClick was detected
*
**/

method DblClick()
return ( ::Clicks == 2 )


/**
*
*          Method
*
*            Name: DragDown()
*
*    Return Value: Logical
*        See Also: ::Click(), ::DblClick(), ::KeyPress()
*
*     Description: TRUE if DragDown event was detected.
*
**/

method DragDown()
return ( ::Clicks >= 5 )


/**
*
*          Method
*
*            Name: KeyPress()
*
*    Return Value: Logical
*        See Also: ::Click(), ::DblClick(), ::DragDown()
*
*     Description: TRUE if Keypress event was detected
*
**/

method KeyPress()
return ( ::Key != 0 )


/**
*
*          Method
*
*            Name: Char()
*
*    Return Value: Char ( a single character )
*        See Also: Chr(), Inkey()
*
*     Description: return a single character of the Inkey value.
*
**/

method Char()
return ( Chr(::Key) )


/**
*
*          Method
*
*            Name: Exec()
*
*    Return Value: None
*
*     Description: Main Event Handler
*
**/

method Exec()
  ::Clicks := 0
  while ( .T. )
        if ( ::PutKey != NIL )
          ::Key    := ::PutKey
          ::PutKey := NIL
        else
          ::Key := InKey()
        endif
        ::BtnRelease()

        if ( ::Key + ::Button > 0 )
           exit
        endif
  enddo
  ::Col  := Col()  ; ::Row  := Row()
return ( Self )


/***************************************************************************
*
*   PROTECTED METHODS
*
*/


/**
*
*          Method
*
*            Name: BtnRelease()
*
*    Return Value: NIL
*
*     Description: Mouse Click Manager
*
**/

method BtnRelease()
  Local lButton   := .f.
  Local lReleased := .f.
  Local nWaitCntr := 0

  ::Button := ::oMD:Button()
  if ( ::Button > 0 )
     ::Clicks := 1
     ::mCol := ::oMD:Col(); ::mRow := ::oMD:Row()
     for nWaitCntr := 1 to ( ::ClickWait )
         lButton := ::oMD:isButton( ::Button )
         if ( lButton .and. lReleased )
            ::Clicks := 2
            delay( ::DblWait )
            exit
         elseif ( !lButton .and. !lReleased )
            lReleased := .t.
         endif
         delay( nINCRMENT_DELAY_ )
     next
     if ( !lReleased )
        ::Clicks := 5
     endif
  endif
return NIL
