/********
*
*         Program
*
*     Application: Generic Application
*       File Name: DISPCTXT.PRG
*          Author: Ashin S.Wimalajeewa   CompuServe : 100351,650
*
*    Date created: 12-08-94              Date updated: 12-08-94
*       Copyright: (c) 1994 by Virtual/Ash-Tec Development
*     Acknowledge: Transit Computer System Pty Ltd. (Australia)
*
*     Description: CA-Clipper Standard Display methods
*
**/


#ifndef _CLASSY2_CH
  #include "Class(y).ch"
  #define _CLASSY2_CH
#endif

#ifndef _DISPCTXT_CH
  #include "DispCtxt.ch"
#endif


/**
*
*          Method
*
*            Name: myBox()
*
*       Arguments: nTop    - Top    (Numeric) position of the Box
*                : nLeft   - Left   (Numeric) position of the Box
*                : nBottom - Bottom (Numeric) position of the Box
*                : nRight  - Right  (Numeric) position of the Box
*                : cFrame  - Character string to draw frame
*                : cColor  - Clipper color string to Display the Box. eg "w+/r"
*    Return Value: NIL
*        See Also: DispBox()
*
*     Description: Draw a box on the screen
*
**/

method myBox( nTop, nLeft, nBottom, nRight, cFrame, cColor )
return ( DispBox(nTop, nLeft, nBottom, nRight, cFrame, cColor) )


/**
*
*          Method
*
*            Name: myPrint()
*
*       Arguments: nRow   - Row (Numeric) position of the Displayed output.
*                : nCol   - Col (Numeric) position of the Displayed output.
*                : cStr   - Character string to display
*                : cColor - Clipper Color String. eg "w+/r"
*    Return Value: NIL
*        See Also: DispOut()
*
*     Description: Displays output to the screen in the desired pos and color
**/

method myPrint( nRow, nCol, cStr, cColor )
  Local nCurrRow := Row()
  Local nCurrCol := Col()

  SetPos( nRow, nCol )
  DispOUT( cStr, cColor )
  SetPos( nCurrRow, nCurrCol )
return NIL


/**
*
*          Method
*
*            Name: myRestScrn()
*
*       Arguments: nTop    - Top    (Numeric) Position to restore
*                : nLeft   - Left   (Numeric) Position to restore
*                : nBottom - Bottom (Numeric) Position to restore
*                : nRight  - Right  (Numeric) Position to restore
*                : cScreen - Character String of the Screen
*    Return Value: NIL
*        See Also: RestScreen()
*
*     Description: Restores the saved screen
**/

method myRestScrn( nTop, nLeft, nBottom, nRight, cScreen )
return ( RestScreen(nTop, nLeft, nBottom, nRight, cScreen) )


/**
*
*          Method
*
*            Name: mySaveScrn()
*
*       Arguments: nTop    - Top    (Numeric) Position to save
*                : nLeft   - Left   (Numeric) Position to save
*                : nBottom - Bottom (Numeric) Position to save
*                : nRight  - Right  (Numeric) Position to save
*    Return Value: Character String of the Screen
*        See Also: SaveScreen()
*
*     Description: Saves the screen to a variable.
**/

method mySaveScrn( nTop, nLeft, nBottom, nRight )
return ( SaveScreen(nTop, nLeft, nBottom, nRight) )


/**
*
*          Method
*
*            Name: mySetAttr()
*          Author: Bill (William) Tinker of Transit Computer Systems.
*
*       Arguments: nTop    - Top    (Numeric) Position to repaint
*                : nLeft   - Left   (Numeric) Position to repaint
*                : nBottom - Bottom (Numeric) Position to repaint
*                : nRight  - Right  (Numeric) Position to repaint
*                : cColor  - Character string to replace it with
*    Return Value: NIL
*
*     Description: Resets the current video color for a selected pos.
**/

method mySetAttr( nTop, nLeft, nBottom, nRight, cColor )
  Local cScreen := NIL
  Local cText   := ""
  Local lColor  := .F.
  Local nChars  := (nRight - nLeft + 1) * 2
  Local nCntr   := 0
  Local nLine   := 0

  for nLine := nTop to nBottom
      cScreen := ::SaveScreen( nLine, nLeft, nLine, nRight )
      cText   := ""
      for nCntr = 1 to nChars
          cText += iif(lColor,"",substr( cScreen, nCntr, 1))
          lColor := !lColor
      next
      ::Print( nLine, nLeft, cText, cColor )
  next
return NIL


/**
*
*          Method
*
*            Name: mySetShadow()
*
*       Arguments: lState
*    Return Value: ( .t. )
*
*     Description: Set/gets the Box Shadow State.
**/

method mySetShadow( lState )
return ( .t. )
